/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.ChangeEvent;
import org.openmetadata.client.model.CreateSearchIndex;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.RestoreEntity;
import org.openmetadata.client.model.SearchIndex;
import org.openmetadata.client.model.SearchIndexList;
import org.openmetadata.client.model.SearchIndexSampleData;
import org.openmetadata.client.model.VoteRequest;

public interface SearchIndexApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/searchIndexes/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent addFollower6(@Param(value="id") @Nonnull UUID var1, @Nullable UUID var2);

    @RequestLine(value="PUT /v1/searchIndexes/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> addFollower6WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable UUID var2);

    @RequestLine(value="PUT /v1/searchIndexes/{id}/sampleData")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public SearchIndex addSampleData1(@Param(value="id") @Nonnull UUID var1, @Nullable SearchIndexSampleData var2);

    @RequestLine(value="PUT /v1/searchIndexes/{id}/sampleData")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<SearchIndex> addSampleData1WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable SearchIndexSampleData var2);

    @RequestLine(value="PUT /v1/searchIndexes")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public SearchIndex createOrUpdateSearchIndex(@Nullable CreateSearchIndex var1);

    @RequestLine(value="PUT /v1/searchIndexes")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<SearchIndex> createOrUpdateSearchIndexWithHttpInfo(@Nullable CreateSearchIndex var1);

    @RequestLine(value="POST /v1/searchIndexes")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public SearchIndex createSearchIndex(@Nullable CreateSearchIndex var1);

    @RequestLine(value="POST /v1/searchIndexes")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<SearchIndex> createSearchIndexWithHttpInfo(@Nullable CreateSearchIndex var1);

    @RequestLine(value="DELETE /v1/searchIndexes/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ChangeEvent deleteFollower9(@Param(value="id") @Nonnull UUID var1, @Param(value="userId") @Nonnull String var2);

    @RequestLine(value="DELETE /v1/searchIndexes/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ChangeEvent> deleteFollower9WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="userId") @Nonnull String var2);

    @RequestLine(value="DELETE /v1/searchIndexes/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteSearchIndex(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2, @Param(value="recursive") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/searchIndexes/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteSearchIndexWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2, @Param(value="recursive") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/searchIndexes/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteSearchIndex(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteSearchIndexQueryParams var2);

    @RequestLine(value="DELETE /v1/searchIndexes/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteSearchIndexWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteSearchIndexQueryParams var2);

    @RequestLine(value="DELETE /v1/searchIndexes/async/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteSearchIndexAsync(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2, @Param(value="recursive") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/searchIndexes/async/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteSearchIndexAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2, @Param(value="recursive") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/searchIndexes/async/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteSearchIndexAsync(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteSearchIndexAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/searchIndexes/async/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteSearchIndexAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteSearchIndexAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/searchIndexes/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteSearchIndexByFQN(@Param(value="fqn") @Nonnull String var1, @Param(value="hardDelete") @Nullable Boolean var2, @Param(value="recursive") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/searchIndexes/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteSearchIndexByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Param(value="hardDelete") @Nullable Boolean var2, @Param(value="recursive") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/searchIndexes/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteSearchIndexByFQN(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) DeleteSearchIndexByFQNQueryParams var2);

    @RequestLine(value="DELETE /v1/searchIndexes/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteSearchIndexByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) DeleteSearchIndexByFQNQueryParams var2);

    @RequestLine(value="GET /v1/searchIndexes/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public SearchIndex get6(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/searchIndexes/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SearchIndex> get6WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/searchIndexes/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public SearchIndex get6(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) Get6QueryParams var2);

    @RequestLine(value="GET /v1/searchIndexes/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SearchIndex> get6WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) Get6QueryParams var2);

    @RequestLine(value="GET /v1/searchIndexes/{id}/sampleData")
    @Headers(value={"Accept: application/json"})
    public SearchIndex getSampleData1(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/searchIndexes/{id}/sampleData")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SearchIndex> getSampleData1WithHttpInfo(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/searchIndexes/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public SearchIndex getSearchIndexByFQN(@Param(value="fqn") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/searchIndexes/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SearchIndex> getSearchIndexByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/searchIndexes/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public SearchIndex getSearchIndexByFQN(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) GetSearchIndexByFQNQueryParams var2);

    @RequestLine(value="GET /v1/searchIndexes/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SearchIndex> getSearchIndexByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) GetSearchIndexByFQNQueryParams var2);

    @RequestLine(value="GET /v1/searchIndexes/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public SearchIndex getSpecificSearchIndexVersion(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/searchIndexes/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SearchIndex> getSpecificSearchIndexVersionWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/searchIndexes/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllSearchIndexVersion(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/searchIndexes/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllSearchIndexVersionWithHttpInfo(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/searchIndexes?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public SearchIndexList listSearchIndexes(@Param(value="fields") @Nullable String var1, @Param(value="service") @Nullable String var2, @Param(value="limit") @Nullable Integer var3, @Param(value="before") @Nullable String var4, @Param(value="after") @Nullable String var5, @Param(value="include") @Nullable String var6);

    @RequestLine(value="GET /v1/searchIndexes?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SearchIndexList> listSearchIndexesWithHttpInfo(@Param(value="fields") @Nullable String var1, @Param(value="service") @Nullable String var2, @Param(value="limit") @Nullable Integer var3, @Param(value="before") @Nullable String var4, @Param(value="after") @Nullable String var5, @Param(value="include") @Nullable String var6);

    @RequestLine(value="GET /v1/searchIndexes?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public SearchIndexList listSearchIndexes(@QueryMap(encoded=true) ListSearchIndexesQueryParams var1);

    @RequestLine(value="GET /v1/searchIndexes?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SearchIndexList> listSearchIndexesWithHttpInfo(@QueryMap(encoded=true) ListSearchIndexesQueryParams var1);

    @RequestLine(value="PATCH /v1/searchIndexes/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchSearchIndex(@Param(value="fqn") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/searchIndexes/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchSearchIndexWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/searchIndexes/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchSearchIndex1(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/searchIndexes/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchSearchIndex1WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PUT /v1/searchIndexes/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public SearchIndex restore25(@Nullable RestoreEntity var1);

    @RequestLine(value="PUT /v1/searchIndexes/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<SearchIndex> restore25WithHttpInfo(@Nullable RestoreEntity var1);

    @RequestLine(value="PUT /v1/searchIndexes/{id}/vote")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent updateVoteForEntity13(@Param(value="id") @Nonnull UUID var1, @Nullable VoteRequest var2);

    @RequestLine(value="PUT /v1/searchIndexes/{id}/vote")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> updateVoteForEntity13WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable VoteRequest var2);

    public static class ListSearchIndexesQueryParams
    extends HashMap<String, Object> {
        public ListSearchIndexesQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListSearchIndexesQueryParams service(@Nullable String value) {
            this.put("service", EncodingUtils.encode(value));
            return this;
        }

        public ListSearchIndexesQueryParams limit(@Nullable Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListSearchIndexesQueryParams before(@Nullable String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListSearchIndexesQueryParams after(@Nullable String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListSearchIndexesQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetSearchIndexByFQNQueryParams
    extends HashMap<String, Object> {
        public GetSearchIndexByFQNQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetSearchIndexByFQNQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class Get6QueryParams
    extends HashMap<String, Object> {
        public Get6QueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public Get6QueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteSearchIndexByFQNQueryParams
    extends HashMap<String, Object> {
        public DeleteSearchIndexByFQNQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }

        public DeleteSearchIndexByFQNQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteSearchIndexAsyncQueryParams
    extends HashMap<String, Object> {
        public DeleteSearchIndexAsyncQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }

        public DeleteSearchIndexAsyncQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteSearchIndexQueryParams
    extends HashMap<String, Object> {
        public DeleteSearchIndexQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }

        public DeleteSearchIndexQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }
    }
}

