/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.AuthenticationMechanism;
import org.openmetadata.client.model.CSVExportResponse;
import org.openmetadata.client.model.ChangePasswordRequest;
import org.openmetadata.client.model.CreatePersonalToken;
import org.openmetadata.client.model.CreateUser;
import org.openmetadata.client.model.CsvImportResult;
import org.openmetadata.client.model.EmailRequest;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.EntityReference;
import org.openmetadata.client.model.GenerateTokenRequest;
import org.openmetadata.client.model.JWTAuthMechanism;
import org.openmetadata.client.model.JwtResponse;
import org.openmetadata.client.model.LoginRequest;
import org.openmetadata.client.model.LogoutRequest;
import org.openmetadata.client.model.PasswordResetRequest;
import org.openmetadata.client.model.PersonalAccessToken;
import org.openmetadata.client.model.PersonalAccessTokenList;
import org.openmetadata.client.model.RegistrationRequest;
import org.openmetadata.client.model.RestoreEntity;
import org.openmetadata.client.model.RevokePersonalTokenRequest;
import org.openmetadata.client.model.RevokeTokenRequest;
import org.openmetadata.client.model.TokenRefreshRequest;
import org.openmetadata.client.model.User;
import org.openmetadata.client.model.UserList;

public interface UsersApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/users/changePassword")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public User changeUserPassword(@Nullable ChangePasswordRequest var1);

    @RequestLine(value="PUT /v1/users/changePassword")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<User> changeUserPasswordWithHttpInfo(@Nullable ChangePasswordRequest var1);

    @RequestLine(value="POST /v1/users/checkEmailVerified")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Boolean checkEmailIsVerified(@Nullable EmailRequest var1);

    @RequestLine(value="POST /v1/users/checkEmailVerified")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Boolean> checkEmailIsVerifiedWithHttpInfo(@Nullable EmailRequest var1);

    @RequestLine(value="PUT /v1/users/registrationConfirmation?token={token}")
    @Headers(value={"Accept: application/json"})
    public void confirmUserEmail(@Param(value="token") @Nullable String var1);

    @RequestLine(value="PUT /v1/users/registrationConfirmation?token={token}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> confirmUserEmailWithHttpInfo(@Param(value="token") @Nullable String var1);

    @RequestLine(value="PUT /v1/users/registrationConfirmation?token={token}")
    @Headers(value={"Accept: application/json"})
    public void confirmUserEmail(@QueryMap(encoded=true) ConfirmUserEmailQueryParams var1);

    @RequestLine(value="PUT /v1/users/registrationConfirmation?token={token}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> confirmUserEmailWithHttpInfo(@QueryMap(encoded=true) ConfirmUserEmailQueryParams var1);

    @RequestLine(value="PUT /v1/users")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public CreateUser createOrUpdateUser(@Nullable CreateUser var1);

    @RequestLine(value="PUT /v1/users")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<CreateUser> createOrUpdateUserWithHttpInfo(@Nullable CreateUser var1);

    @RequestLine(value="PUT /v1/users/security/token")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public PersonalAccessToken createPersonalAccessToken(@Nullable CreatePersonalToken var1);

    @RequestLine(value="PUT /v1/users/security/token")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<PersonalAccessToken> createPersonalAccessTokenWithHttpInfo(@Nullable CreatePersonalToken var1);

    @RequestLine(value="POST /v1/users")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public User createUser(@Nullable CreateUser var1);

    @RequestLine(value="POST /v1/users")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<User> createUserWithHttpInfo(@Nullable CreateUser var1);

    @RequestLine(value="DELETE /v1/users/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteUser(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/users/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteUserWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/users/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteUser(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteUserQueryParams var2);

    @RequestLine(value="DELETE /v1/users/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteUserWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteUserQueryParams var2);

    @RequestLine(value="DELETE /v1/users/async/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteUserAsync(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/users/async/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteUserAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/users/async/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteUserAsync(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteUserAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/users/async/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteUserAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteUserAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/users/name/{name}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteUserByName(@Param(value="name") @Nonnull String var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/users/name/{name}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteUserByNameWithHttpInfo(@Param(value="name") @Nonnull String var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/users/name/{name}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteUserByName(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) DeleteUserByNameQueryParams var2);

    @RequestLine(value="DELETE /v1/users/name/{name}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteUserByNameWithHttpInfo(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) DeleteUserByNameQueryParams var2);

    @RequestLine(value="GET /v1/users/export?team={team}")
    @Headers(value={"Accept: application/json"})
    public String exportUsers(@Param(value="team") @Nonnull String var1);

    @RequestLine(value="GET /v1/users/export?team={team}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<String> exportUsersWithHttpInfo(@Param(value="team") @Nonnull String var1);

    @RequestLine(value="GET /v1/users/export?team={team}")
    @Headers(value={"Accept: application/json"})
    public String exportUsers(@QueryMap(encoded=true) ExportUsersQueryParams var1);

    @RequestLine(value="GET /v1/users/export?team={team}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<String> exportUsersWithHttpInfo(@QueryMap(encoded=true) ExportUsersQueryParams var1);

    @RequestLine(value="GET /v1/users/exportAsync?team={team}")
    @Headers(value={"Accept: application/json"})
    public CSVExportResponse exportUsers1(@Param(value="team") @Nonnull String var1);

    @RequestLine(value="GET /v1/users/exportAsync?team={team}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<CSVExportResponse> exportUsers1WithHttpInfo(@Param(value="team") @Nonnull String var1);

    @RequestLine(value="GET /v1/users/exportAsync?team={team}")
    @Headers(value={"Accept: application/json"})
    public CSVExportResponse exportUsers1(@QueryMap(encoded=true) ExportUsers1QueryParams var1);

    @RequestLine(value="GET /v1/users/exportAsync?team={team}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<CSVExportResponse> exportUsers1WithHttpInfo(@QueryMap(encoded=true) ExportUsers1QueryParams var1);

    @RequestLine(value="PUT /v1/users/generateToken/{id}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public String generateJWTTokenForBotUser(@Param(value="id") @Nonnull UUID var1, @Nullable GenerateTokenRequest var2);

    @RequestLine(value="PUT /v1/users/generateToken/{id}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<String> generateJWTTokenForBotUserWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable GenerateTokenRequest var2);

    @RequestLine(value="POST /v1/users/generatePasswordResetLink")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public void generatePasswordResetLink(@Nullable EmailRequest var1);

    @RequestLine(value="POST /v1/users/generatePasswordResetLink")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Void> generatePasswordResetLinkWithHttpInfo(@Nullable EmailRequest var1);

    @RequestLine(value="GET /v1/users/generateRandomPwd")
    @Headers(value={"Accept: application/json"})
    public void generateRandomPwd();

    @RequestLine(value="GET /v1/users/generateRandomPwd")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> generateRandomPwdWithHttpInfo();

    @RequestLine(value="GET /v1/users/auth-mechanism/{id}")
    @Headers(value={"Accept: application/json"})
    public AuthenticationMechanism getAuthenticationMechanismBotUser(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/users/auth-mechanism/{id}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<AuthenticationMechanism> getAuthenticationMechanismBotUserWithHttpInfo(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/users/documentation/csv")
    @Headers(value={"Accept: application/json"})
    public String getCsvDocumentation2();

    @RequestLine(value="GET /v1/users/documentation/csv")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<String> getCsvDocumentation2WithHttpInfo();

    @RequestLine(value="GET /v1/users/loggedInUser?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public User getCurrentLoggedInUser(@Param(value="fields") @Nullable String var1);

    @RequestLine(value="GET /v1/users/loggedInUser?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<User> getCurrentLoggedInUserWithHttpInfo(@Param(value="fields") @Nullable String var1);

    @RequestLine(value="GET /v1/users/loggedInUser?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public User getCurrentLoggedInUser(@QueryMap(encoded=true) GetCurrentLoggedInUserQueryParams var1);

    @RequestLine(value="GET /v1/users/loggedInUser?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<User> getCurrentLoggedInUserWithHttpInfo(@QueryMap(encoded=true) GetCurrentLoggedInUserQueryParams var1);

    @RequestLine(value="GET /v1/users/loggedInUser/groupTeams")
    @Headers(value={"Accept: application/json"})
    public List<EntityReference> getCurrentLoggedInUserGroupTeams();

    @RequestLine(value="GET /v1/users/loggedInUser/groupTeams")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<List<EntityReference>> getCurrentLoggedInUserGroupTeamsWithHttpInfo();

    @RequestLine(value="GET /v1/users/token/{id}")
    @Headers(value={"Accept: application/json"})
    public JWTAuthMechanism getJWTTokenForBotUser(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/users/token/{id}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<JWTAuthMechanism> getJWTTokenForBotUserWithHttpInfo(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/users/security/token?username={username}")
    @Headers(value={"Accept: application/json"})
    public PersonalAccessTokenList getPersonalAccessToken(@Param(value="username") @Nullable String var1);

    @RequestLine(value="GET /v1/users/security/token?username={username}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<PersonalAccessTokenList> getPersonalAccessTokenWithHttpInfo(@Param(value="username") @Nullable String var1);

    @RequestLine(value="GET /v1/users/security/token?username={username}")
    @Headers(value={"Accept: application/json"})
    public PersonalAccessTokenList getPersonalAccessToken(@QueryMap(encoded=true) GetPersonalAccessTokenQueryParams var1);

    @RequestLine(value="GET /v1/users/security/token?username={username}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<PersonalAccessTokenList> getPersonalAccessTokenWithHttpInfo(@QueryMap(encoded=true) GetPersonalAccessTokenQueryParams var1);

    @RequestLine(value="GET /v1/users/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public User getSpecificUserVersion(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/users/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<User> getSpecificUserVersionWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/users/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public User getUserByFQN(@Param(value="name") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/users/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<User> getUserByFQNWithHttpInfo(@Param(value="name") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/users/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public User getUserByFQN(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) GetUserByFQNQueryParams var2);

    @RequestLine(value="GET /v1/users/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<User> getUserByFQNWithHttpInfo(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) GetUserByFQNQueryParams var2);

    @RequestLine(value="GET /v1/users/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public User getUserByID(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/users/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<User> getUserByIDWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/users/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public User getUserByID(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetUserByIDQueryParams var2);

    @RequestLine(value="GET /v1/users/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<User> getUserByIDWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetUserByIDQueryParams var2);

    @RequestLine(value="PUT /v1/users/import?team={team}&dryRun={dryRun}")
    @Headers(value={"Content-Type: text/plain", "Accept: application/json"})
    public CsvImportResult importTeams1(@Param(value="team") @Nonnull String var1, @Param(value="dryRun") @Nullable Boolean var2, @Nullable String var3);

    @RequestLine(value="PUT /v1/users/import?team={team}&dryRun={dryRun}")
    @Headers(value={"Content-Type: text/plain", "Accept: application/json"})
    public ApiResponse<CsvImportResult> importTeams1WithHttpInfo(@Param(value="team") @Nonnull String var1, @Param(value="dryRun") @Nullable Boolean var2, @Nullable String var3);

    @RequestLine(value="PUT /v1/users/import?team={team}&dryRun={dryRun}")
    @Headers(value={"Content-Type: text/plain", "Accept: application/json"})
    public CsvImportResult importTeams1(@Nullable String var1, @QueryMap(encoded=true) ImportTeams1QueryParams var2);

    @RequestLine(value="PUT /v1/users/import?team={team}&dryRun={dryRun}")
    @Headers(value={"Content-Type: text/plain", "Accept: application/json"})
    public ApiResponse<CsvImportResult> importTeams1WithHttpInfo(@Nullable String var1, @QueryMap(encoded=true) ImportTeams1QueryParams var2);

    @RequestLine(value="PUT /v1/users/importAsync?team={team}&dryRun={dryRun}")
    @Headers(value={"Content-Type: text/plain", "Accept: application/json"})
    public CsvImportResult importTeamsAsync1(@Param(value="team") @Nonnull String var1, @Param(value="dryRun") @Nullable Boolean var2, @Nullable String var3);

    @RequestLine(value="PUT /v1/users/importAsync?team={team}&dryRun={dryRun}")
    @Headers(value={"Content-Type: text/plain", "Accept: application/json"})
    public ApiResponse<CsvImportResult> importTeamsAsync1WithHttpInfo(@Param(value="team") @Nonnull String var1, @Param(value="dryRun") @Nullable Boolean var2, @Nullable String var3);

    @RequestLine(value="PUT /v1/users/importAsync?team={team}&dryRun={dryRun}")
    @Headers(value={"Content-Type: text/plain", "Accept: application/json"})
    public CsvImportResult importTeamsAsync1(@Nullable String var1, @QueryMap(encoded=true) ImportTeamsAsync1QueryParams var2);

    @RequestLine(value="PUT /v1/users/importAsync?team={team}&dryRun={dryRun}")
    @Headers(value={"Content-Type: text/plain", "Accept: application/json"})
    public ApiResponse<CsvImportResult> importTeamsAsync1WithHttpInfo(@Nullable String var1, @QueryMap(encoded=true) ImportTeamsAsync1QueryParams var2);

    @RequestLine(value="GET /v1/users/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllUserVersion(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/users/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllUserVersionWithHttpInfo(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/users/online?timeWindow={timeWindow}&fields={fields}&limit={limit}&before={before}&after={after}")
    @Headers(value={"Accept: application/json"})
    public UserList listOnlineUsers(@Param(value="timeWindow") @Nullable Long var1, @Param(value="fields") @Nullable String var2, @Param(value="limit") @Nullable Integer var3, @Param(value="before") @Nullable String var4, @Param(value="after") @Nullable String var5);

    @RequestLine(value="GET /v1/users/online?timeWindow={timeWindow}&fields={fields}&limit={limit}&before={before}&after={after}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<UserList> listOnlineUsersWithHttpInfo(@Param(value="timeWindow") @Nullable Long var1, @Param(value="fields") @Nullable String var2, @Param(value="limit") @Nullable Integer var3, @Param(value="before") @Nullable String var4, @Param(value="after") @Nullable String var5);

    @RequestLine(value="GET /v1/users/online?timeWindow={timeWindow}&fields={fields}&limit={limit}&before={before}&after={after}")
    @Headers(value={"Accept: application/json"})
    public UserList listOnlineUsers(@QueryMap(encoded=true) ListOnlineUsersQueryParams var1);

    @RequestLine(value="GET /v1/users/online?timeWindow={timeWindow}&fields={fields}&limit={limit}&before={before}&after={after}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<UserList> listOnlineUsersWithHttpInfo(@QueryMap(encoded=true) ListOnlineUsersQueryParams var1);

    @RequestLine(value="GET /v1/users/{id}/assets?limit={limit}&offset={offset}")
    @Headers(value={"Accept: application/json"})
    public EntityReference listUserAssets(@Param(value="id") @Nonnull UUID var1, @Param(value="limit") @Nullable Integer var2, @Param(value="offset") @Nullable Integer var3);

    @RequestLine(value="GET /v1/users/{id}/assets?limit={limit}&offset={offset}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityReference> listUserAssetsWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="limit") @Nullable Integer var2, @Param(value="offset") @Nullable Integer var3);

    @RequestLine(value="GET /v1/users/{id}/assets?limit={limit}&offset={offset}")
    @Headers(value={"Accept: application/json"})
    public EntityReference listUserAssets(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) ListUserAssetsQueryParams var2);

    @RequestLine(value="GET /v1/users/{id}/assets?limit={limit}&offset={offset}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityReference> listUserAssetsWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) ListUserAssetsQueryParams var2);

    @RequestLine(value="GET /v1/users/name/{name}/assets?limit={limit}&offset={offset}")
    @Headers(value={"Accept: application/json"})
    public EntityReference listUserAssetsByName(@Param(value="name") @Nonnull String var1, @Param(value="limit") @Nullable Integer var2, @Param(value="offset") @Nullable Integer var3);

    @RequestLine(value="GET /v1/users/name/{name}/assets?limit={limit}&offset={offset}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityReference> listUserAssetsByNameWithHttpInfo(@Param(value="name") @Nonnull String var1, @Param(value="limit") @Nullable Integer var2, @Param(value="offset") @Nullable Integer var3);

    @RequestLine(value="GET /v1/users/name/{name}/assets?limit={limit}&offset={offset}")
    @Headers(value={"Accept: application/json"})
    public EntityReference listUserAssetsByName(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) ListUserAssetsByNameQueryParams var2);

    @RequestLine(value="GET /v1/users/name/{name}/assets?limit={limit}&offset={offset}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityReference> listUserAssetsByNameWithHttpInfo(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) ListUserAssetsByNameQueryParams var2);

    @RequestLine(value="GET /v1/users?fields={fields}&team={team}&limit={limit}&before={before}&after={after}&isAdmin={isAdmin}&isBot={isBot}&include={include}")
    @Headers(value={"Accept: application/json"})
    public UserList listUsers(@Param(value="fields") @Nullable String var1, @Param(value="team") @Nullable String var2, @Param(value="limit") @Nullable Integer var3, @Param(value="before") @Nullable String var4, @Param(value="after") @Nullable String var5, @Param(value="isAdmin") @Nullable Boolean var6, @Param(value="isBot") @Nullable Boolean var7, @Param(value="include") @Nullable String var8);

    @RequestLine(value="GET /v1/users?fields={fields}&team={team}&limit={limit}&before={before}&after={after}&isAdmin={isAdmin}&isBot={isBot}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<UserList> listUsersWithHttpInfo(@Param(value="fields") @Nullable String var1, @Param(value="team") @Nullable String var2, @Param(value="limit") @Nullable Integer var3, @Param(value="before") @Nullable String var4, @Param(value="after") @Nullable String var5, @Param(value="isAdmin") @Nullable Boolean var6, @Param(value="isBot") @Nullable Boolean var7, @Param(value="include") @Nullable String var8);

    @RequestLine(value="GET /v1/users?fields={fields}&team={team}&limit={limit}&before={before}&after={after}&isAdmin={isAdmin}&isBot={isBot}&include={include}")
    @Headers(value={"Accept: application/json"})
    public UserList listUsers(@QueryMap(encoded=true) ListUsersQueryParams var1);

    @RequestLine(value="GET /v1/users?fields={fields}&team={team}&limit={limit}&before={before}&after={after}&isAdmin={isAdmin}&isBot={isBot}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<UserList> listUsersWithHttpInfo(@QueryMap(encoded=true) ListUsersQueryParams var1);

    @RequestLine(value="POST /v1/users/login")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public JwtResponse loginUserWithPwd(@Nullable LoginRequest var1);

    @RequestLine(value="POST /v1/users/login")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<JwtResponse> loginUserWithPwdWithHttpInfo(@Nullable LoginRequest var1);

    @RequestLine(value="POST /v1/users/logout")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public void logoutUser(@Nullable LogoutRequest var1);

    @RequestLine(value="POST /v1/users/logout")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Void> logoutUserWithHttpInfo(@Nullable LogoutRequest var1);

    @RequestLine(value="PATCH /v1/users/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchUser(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/users/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchUserWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="POST /v1/users/refresh")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public JwtResponse refreshToken(@Nullable TokenRefreshRequest var1);

    @RequestLine(value="POST /v1/users/refresh")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<JwtResponse> refreshTokenWithHttpInfo(@Nullable TokenRefreshRequest var1);

    @RequestLine(value="POST /v1/users/signup")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public void registerUser(@Nullable RegistrationRequest var1);

    @RequestLine(value="POST /v1/users/signup")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Void> registerUserWithHttpInfo(@Nullable RegistrationRequest var1);

    @RequestLine(value="PUT /v1/users/resendRegistrationToken?user={user}")
    @Headers(value={"Accept: application/json"})
    public void resendRegistrationToken(@Param(value="user") @Nullable String var1);

    @RequestLine(value="PUT /v1/users/resendRegistrationToken?user={user}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> resendRegistrationTokenWithHttpInfo(@Param(value="user") @Nullable String var1);

    @RequestLine(value="PUT /v1/users/resendRegistrationToken?user={user}")
    @Headers(value={"Accept: application/json"})
    public void resendRegistrationToken(@QueryMap(encoded=true) ResendRegistrationTokenQueryParams var1);

    @RequestLine(value="PUT /v1/users/resendRegistrationToken?user={user}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> resendRegistrationTokenWithHttpInfo(@QueryMap(encoded=true) ResendRegistrationTokenQueryParams var1);

    @RequestLine(value="POST /v1/users/password/reset")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public User resetUserPassword(@Nullable PasswordResetRequest var1);

    @RequestLine(value="POST /v1/users/password/reset")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<User> resetUserPasswordWithHttpInfo(@Nullable PasswordResetRequest var1);

    @RequestLine(value="PUT /v1/users/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public User restore41(@Nullable RestoreEntity var1);

    @RequestLine(value="PUT /v1/users/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<User> restore41WithHttpInfo(@Nullable RestoreEntity var1);

    @RequestLine(value="PUT /v1/users/revokeToken")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public JWTAuthMechanism revokeJWTTokenForBotUser(@Nullable RevokeTokenRequest var1);

    @RequestLine(value="PUT /v1/users/revokeToken")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<JWTAuthMechanism> revokeJWTTokenForBotUserWithHttpInfo(@Nullable RevokeTokenRequest var1);

    @RequestLine(value="PUT /v1/users/security/token/revoke?username={username}&removeAll={removeAll}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public PersonalAccessTokenList revokePersonalAccessToken(@Param(value="username") @Nullable String var1, @Param(value="removeAll") @Nullable Boolean var2, @Nullable RevokePersonalTokenRequest var3);

    @RequestLine(value="PUT /v1/users/security/token/revoke?username={username}&removeAll={removeAll}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<PersonalAccessTokenList> revokePersonalAccessTokenWithHttpInfo(@Param(value="username") @Nullable String var1, @Param(value="removeAll") @Nullable Boolean var2, @Nullable RevokePersonalTokenRequest var3);

    @RequestLine(value="PUT /v1/users/security/token/revoke?username={username}&removeAll={removeAll}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public PersonalAccessTokenList revokePersonalAccessToken(@Nullable RevokePersonalTokenRequest var1, @QueryMap(encoded=true) RevokePersonalAccessTokenQueryParams var2);

    @RequestLine(value="PUT /v1/users/security/token/revoke?username={username}&removeAll={removeAll}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<PersonalAccessTokenList> revokePersonalAccessTokenWithHttpInfo(@Nullable RevokePersonalTokenRequest var1, @QueryMap(encoded=true) RevokePersonalAccessTokenQueryParams var2);

    public static class RevokePersonalAccessTokenQueryParams
    extends HashMap<String, Object> {
        public RevokePersonalAccessTokenQueryParams username(@Nullable String value) {
            this.put("username", EncodingUtils.encode(value));
            return this;
        }

        public RevokePersonalAccessTokenQueryParams removeAll(@Nullable Boolean value) {
            this.put("removeAll", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ResendRegistrationTokenQueryParams
    extends HashMap<String, Object> {
        public ResendRegistrationTokenQueryParams user(@Nullable String value) {
            this.put("user", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ListUsersQueryParams
    extends HashMap<String, Object> {
        public ListUsersQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListUsersQueryParams team(@Nullable String value) {
            this.put("team", EncodingUtils.encode(value));
            return this;
        }

        public ListUsersQueryParams limit(@Nullable Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListUsersQueryParams before(@Nullable String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListUsersQueryParams after(@Nullable String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListUsersQueryParams isAdmin(@Nullable Boolean value) {
            this.put("isAdmin", EncodingUtils.encode(value));
            return this;
        }

        public ListUsersQueryParams isBot(@Nullable Boolean value) {
            this.put("isBot", EncodingUtils.encode(value));
            return this;
        }

        public ListUsersQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ListUserAssetsByNameQueryParams
    extends HashMap<String, Object> {
        public ListUserAssetsByNameQueryParams limit(@Nullable Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListUserAssetsByNameQueryParams offset(@Nullable Integer value) {
            this.put("offset", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ListUserAssetsQueryParams
    extends HashMap<String, Object> {
        public ListUserAssetsQueryParams limit(@Nullable Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListUserAssetsQueryParams offset(@Nullable Integer value) {
            this.put("offset", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ListOnlineUsersQueryParams
    extends HashMap<String, Object> {
        public ListOnlineUsersQueryParams timeWindow(@Nullable Long value) {
            this.put("timeWindow", EncodingUtils.encode(value));
            return this;
        }

        public ListOnlineUsersQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListOnlineUsersQueryParams limit(@Nullable Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListOnlineUsersQueryParams before(@Nullable String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListOnlineUsersQueryParams after(@Nullable String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ImportTeamsAsync1QueryParams
    extends HashMap<String, Object> {
        public ImportTeamsAsync1QueryParams team(@Nonnull String value) {
            this.put("team", EncodingUtils.encode(value));
            return this;
        }

        public ImportTeamsAsync1QueryParams dryRun(@Nullable Boolean value) {
            this.put("dryRun", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ImportTeams1QueryParams
    extends HashMap<String, Object> {
        public ImportTeams1QueryParams team(@Nonnull String value) {
            this.put("team", EncodingUtils.encode(value));
            return this;
        }

        public ImportTeams1QueryParams dryRun(@Nullable Boolean value) {
            this.put("dryRun", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetUserByIDQueryParams
    extends HashMap<String, Object> {
        public GetUserByIDQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetUserByIDQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetUserByFQNQueryParams
    extends HashMap<String, Object> {
        public GetUserByFQNQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetUserByFQNQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetPersonalAccessTokenQueryParams
    extends HashMap<String, Object> {
        public GetPersonalAccessTokenQueryParams username(@Nullable String value) {
            this.put("username", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetCurrentLoggedInUserQueryParams
    extends HashMap<String, Object> {
        public GetCurrentLoggedInUserQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ExportUsers1QueryParams
    extends HashMap<String, Object> {
        public ExportUsers1QueryParams team(@Nonnull String value) {
            this.put("team", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ExportUsersQueryParams
    extends HashMap<String, Object> {
        public ExportUsersQueryParams team(@Nonnull String value) {
            this.put("team", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteUserByNameQueryParams
    extends HashMap<String, Object> {
        public DeleteUserByNameQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteUserAsyncQueryParams
    extends HashMap<String, Object> {
        public DeleteUserAsyncQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteUserQueryParams
    extends HashMap<String, Object> {
        public DeleteUserQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ConfirmUserEmailQueryParams
    extends HashMap<String, Object> {
        public ConfirmUserEmailQueryParams token(@Nullable String value) {
            this.put("token", EncodingUtils.encode(value));
            return this;
        }
    }
}

