/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"compressionType", "segmentColumns", "orderColumns", "compressionLevel"})
public class CompressionStrategy {
    public static final String JSON_PROPERTY_COMPRESSION_TYPE = "compressionType";
    @Nullable
    private CompressionTypeEnum compressionType;
    public static final String JSON_PROPERTY_SEGMENT_COLUMNS = "segmentColumns";
    @Nullable
    private List<String> segmentColumns = new ArrayList<String>();
    public static final String JSON_PROPERTY_ORDER_COLUMNS = "orderColumns";
    @Nullable
    private List<String> orderColumns = new ArrayList<String>();
    public static final String JSON_PROPERTY_COMPRESSION_LEVEL = "compressionLevel";
    @Nullable
    private Integer compressionLevel;

    public CompressionStrategy compressionType(@Nullable CompressionTypeEnum compressionType) {
        this.compressionType = compressionType;
        return this;
    }

    @Nullable
    @JsonProperty(value="compressionType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CompressionTypeEnum getCompressionType() {
        return this.compressionType;
    }

    @JsonProperty(value="compressionType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCompressionType(@Nullable CompressionTypeEnum compressionType) {
        this.compressionType = compressionType;
    }

    public CompressionStrategy segmentColumns(@Nullable List<String> segmentColumns) {
        this.segmentColumns = segmentColumns;
        return this;
    }

    public CompressionStrategy addSegmentColumnsItem(String segmentColumnsItem) {
        if (this.segmentColumns == null) {
            this.segmentColumns = new ArrayList<String>();
        }
        this.segmentColumns.add(segmentColumnsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="segmentColumns")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getSegmentColumns() {
        return this.segmentColumns;
    }

    @JsonProperty(value="segmentColumns")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSegmentColumns(@Nullable List<String> segmentColumns) {
        this.segmentColumns = segmentColumns;
    }

    public CompressionStrategy orderColumns(@Nullable List<String> orderColumns) {
        this.orderColumns = orderColumns;
        return this;
    }

    public CompressionStrategy addOrderColumnsItem(String orderColumnsItem) {
        if (this.orderColumns == null) {
            this.orderColumns = new ArrayList<String>();
        }
        this.orderColumns.add(orderColumnsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="orderColumns")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getOrderColumns() {
        return this.orderColumns;
    }

    @JsonProperty(value="orderColumns")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOrderColumns(@Nullable List<String> orderColumns) {
        this.orderColumns = orderColumns;
    }

    public CompressionStrategy compressionLevel(@Nullable Integer compressionLevel) {
        this.compressionLevel = compressionLevel;
        return this;
    }

    @Nullable
    @JsonProperty(value="compressionLevel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getCompressionLevel() {
        return this.compressionLevel;
    }

    @JsonProperty(value="compressionLevel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCompressionLevel(@Nullable Integer compressionLevel) {
        this.compressionLevel = compressionLevel;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompressionStrategy compressionStrategy = (CompressionStrategy)o;
        return Objects.equals((Object)this.compressionType, (Object)compressionStrategy.compressionType) && Objects.equals(this.segmentColumns, compressionStrategy.segmentColumns) && Objects.equals(this.orderColumns, compressionStrategy.orderColumns) && Objects.equals(this.compressionLevel, compressionStrategy.compressionLevel);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.compressionType, this.segmentColumns, this.orderColumns, this.compressionLevel});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CompressionStrategy {\n");
        sb.append("    compressionType: ").append(this.toIndentedString((Object)this.compressionType)).append("\n");
        sb.append("    segmentColumns: ").append(this.toIndentedString(this.segmentColumns)).append("\n");
        sb.append("    orderColumns: ").append(this.toIndentedString(this.orderColumns)).append("\n");
        sb.append("    compressionLevel: ").append(this.toIndentedString(this.compressionLevel)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum CompressionTypeEnum {
        AUTOMATIC(String.valueOf("AUTOMATIC")),
        MANUAL(String.valueOf("MANUAL")),
        POLICY_BASED(String.valueOf("POLICY_BASED"));

        private String value;

        private CompressionTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CompressionTypeEnum fromValue(String value) {
            for (CompressionTypeEnum b : CompressionTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

