/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.model.Assignees;

@JsonPropertyOrder(value={"assignees", "approvalThreshold", "rejectionThreshold"})
public class Config {
    public static final String JSON_PROPERTY_ASSIGNEES = "assignees";
    @Nonnull
    private Assignees assignees;
    public static final String JSON_PROPERTY_APPROVAL_THRESHOLD = "approvalThreshold";
    @Nullable
    private Integer approvalThreshold;
    public static final String JSON_PROPERTY_REJECTION_THRESHOLD = "rejectionThreshold";
    @Nullable
    private Integer rejectionThreshold;

    public Config assignees(@Nonnull Assignees assignees) {
        this.assignees = assignees;
        return this;
    }

    @Nonnull
    @JsonProperty(value="assignees")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Assignees getAssignees() {
        return this.assignees;
    }

    @JsonProperty(value="assignees")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAssignees(@Nonnull Assignees assignees) {
        this.assignees = assignees;
    }

    public Config approvalThreshold(@Nullable Integer approvalThreshold) {
        this.approvalThreshold = approvalThreshold;
        return this;
    }

    @Nullable
    @JsonProperty(value="approvalThreshold")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getApprovalThreshold() {
        return this.approvalThreshold;
    }

    @JsonProperty(value="approvalThreshold")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setApprovalThreshold(@Nullable Integer approvalThreshold) {
        this.approvalThreshold = approvalThreshold;
    }

    public Config rejectionThreshold(@Nullable Integer rejectionThreshold) {
        this.rejectionThreshold = rejectionThreshold;
        return this;
    }

    @Nullable
    @JsonProperty(value="rejectionThreshold")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getRejectionThreshold() {
        return this.rejectionThreshold;
    }

    @JsonProperty(value="rejectionThreshold")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRejectionThreshold(@Nullable Integer rejectionThreshold) {
        this.rejectionThreshold = rejectionThreshold;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Config config = (Config)o;
        return Objects.equals(this.assignees, config.assignees) && Objects.equals(this.approvalThreshold, config.approvalThreshold) && Objects.equals(this.rejectionThreshold, config.rejectionThreshold);
    }

    public int hashCode() {
        return Objects.hash(this.assignees, this.approvalThreshold, this.rejectionThreshold);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Config {\n");
        sb.append("    assignees: ").append(this.toIndentedString(this.assignees)).append("\n");
        sb.append("    approvalThreshold: ").append(this.toIndentedString(this.approvalThreshold)).append("\n");
        sb.append("    rejectionThreshold: ").append(this.toIndentedString(this.rejectionThreshold)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

