/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.model.EntityReference;

@JsonPropertyOrder(value={"type", "assignees", "oldValue", "suggestion"})
public class CreateTaskDetails {
    public static final String JSON_PROPERTY_TYPE = "type";
    @Nonnull
    private TypeEnum type;
    public static final String JSON_PROPERTY_ASSIGNEES = "assignees";
    @Nonnull
    private List<EntityReference> assignees = new ArrayList<EntityReference>();
    public static final String JSON_PROPERTY_OLD_VALUE = "oldValue";
    @Nullable
    private String oldValue;
    public static final String JSON_PROPERTY_SUGGESTION = "suggestion";
    @Nullable
    private String suggestion;

    public CreateTaskDetails type(@Nonnull TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(@Nonnull TypeEnum type) {
        this.type = type;
    }

    public CreateTaskDetails assignees(@Nonnull List<EntityReference> assignees) {
        this.assignees = assignees;
        return this;
    }

    public CreateTaskDetails addAssigneesItem(EntityReference assigneesItem) {
        if (this.assignees == null) {
            this.assignees = new ArrayList<EntityReference>();
        }
        this.assignees.add(assigneesItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="assignees")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<EntityReference> getAssignees() {
        return this.assignees;
    }

    @JsonProperty(value="assignees")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAssignees(@Nonnull List<EntityReference> assignees) {
        this.assignees = assignees;
    }

    public CreateTaskDetails oldValue(@Nullable String oldValue) {
        this.oldValue = oldValue;
        return this;
    }

    @Nullable
    @JsonProperty(value="oldValue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOldValue() {
        return this.oldValue;
    }

    @JsonProperty(value="oldValue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOldValue(@Nullable String oldValue) {
        this.oldValue = oldValue;
    }

    public CreateTaskDetails suggestion(@Nullable String suggestion) {
        this.suggestion = suggestion;
        return this;
    }

    @Nullable
    @JsonProperty(value="suggestion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSuggestion() {
        return this.suggestion;
    }

    @JsonProperty(value="suggestion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSuggestion(@Nullable String suggestion) {
        this.suggestion = suggestion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateTaskDetails createTaskDetails = (CreateTaskDetails)o;
        return Objects.equals((Object)this.type, (Object)createTaskDetails.type) && Objects.equals(this.assignees, createTaskDetails.assignees) && Objects.equals(this.oldValue, createTaskDetails.oldValue) && Objects.equals(this.suggestion, createTaskDetails.suggestion);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.assignees, this.oldValue, this.suggestion});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateTaskDetails {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    assignees: ").append(this.toIndentedString(this.assignees)).append("\n");
        sb.append("    oldValue: ").append(this.toIndentedString(this.oldValue)).append("\n");
        sb.append("    suggestion: ").append(this.toIndentedString(this.suggestion)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        REQUEST_DESCRIPTION(String.valueOf("RequestDescription")),
        UPDATE_DESCRIPTION(String.valueOf("UpdateDescription")),
        REQUEST_TAG(String.valueOf("RequestTag")),
        UPDATE_TAG(String.valueOf("UpdateTag")),
        REQUEST_APPROVAL(String.valueOf("RequestApproval")),
        REQUEST_TEST_CASE_FAILURE_RESOLUTION(String.valueOf("RequestTestCaseFailureResolution")),
        GENERIC(String.valueOf("Generic"));

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

