/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.model.EntityReference;
import org.openmetadata.client.model.LifeCycle;
import org.openmetadata.client.model.TagLabel;

@JsonPropertyOrder(value={"name", "displayName", "description", "nameSpace", "category", "schema", "domains", "lifeCycle", "reviewers", "owners", "extension", "tags", "dataProducts"})
public class CreateType {
    public static final String JSON_PROPERTY_NAME = "name";
    @Nonnull
    private String name;
    public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
    @Nullable
    private String displayName;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    @Nonnull
    private String description;
    public static final String JSON_PROPERTY_NAME_SPACE = "nameSpace";
    @Nonnull
    private String nameSpace;
    public static final String JSON_PROPERTY_CATEGORY = "category";
    @Nullable
    private CategoryEnum category;
    public static final String JSON_PROPERTY_SCHEMA = "schema";
    @Nonnull
    private String schema;
    public static final String JSON_PROPERTY_DOMAINS = "domains";
    @Nullable
    private List<String> domains = new ArrayList<String>();
    public static final String JSON_PROPERTY_LIFE_CYCLE = "lifeCycle";
    @Nullable
    private LifeCycle lifeCycle;
    public static final String JSON_PROPERTY_REVIEWERS = "reviewers";
    @Nullable
    private List<EntityReference> reviewers = new ArrayList<EntityReference>();
    public static final String JSON_PROPERTY_OWNERS = "owners";
    @Nullable
    private List<EntityReference> owners = new ArrayList<EntityReference>();
    public static final String JSON_PROPERTY_EXTENSION = "extension";
    @Nullable
    private Object extension;
    public static final String JSON_PROPERTY_TAGS = "tags";
    @Nullable
    private List<TagLabel> tags = new ArrayList<TagLabel>();
    public static final String JSON_PROPERTY_DATA_PRODUCTS = "dataProducts";
    @Nullable
    private List<String> dataProducts = new ArrayList<String>();

    public CreateType name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public CreateType displayName(@Nullable String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Nullable
    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDisplayName(@Nullable String displayName) {
        this.displayName = displayName;
    }

    public CreateType description(@Nonnull String description) {
        this.description = description;
        return this;
    }

    @Nonnull
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDescription(@Nonnull String description) {
        this.description = description;
    }

    public CreateType nameSpace(@Nonnull String nameSpace) {
        this.nameSpace = nameSpace;
        return this;
    }

    @Nonnull
    @JsonProperty(value="nameSpace")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getNameSpace() {
        return this.nameSpace;
    }

    @JsonProperty(value="nameSpace")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setNameSpace(@Nonnull String nameSpace) {
        this.nameSpace = nameSpace;
    }

    public CreateType category(@Nullable CategoryEnum category) {
        this.category = category;
        return this;
    }

    @Nullable
    @JsonProperty(value="category")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CategoryEnum getCategory() {
        return this.category;
    }

    @JsonProperty(value="category")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCategory(@Nullable CategoryEnum category) {
        this.category = category;
    }

    public CreateType schema(@Nonnull String schema) {
        this.schema = schema;
        return this;
    }

    @Nonnull
    @JsonProperty(value="schema")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSchema() {
        return this.schema;
    }

    @JsonProperty(value="schema")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSchema(@Nonnull String schema) {
        this.schema = schema;
    }

    public CreateType domains(@Nullable List<String> domains) {
        this.domains = domains;
        return this;
    }

    public CreateType addDomainsItem(String domainsItem) {
        if (this.domains == null) {
            this.domains = new ArrayList<String>();
        }
        this.domains.add(domainsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="domains")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getDomains() {
        return this.domains;
    }

    @JsonProperty(value="domains")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDomains(@Nullable List<String> domains) {
        this.domains = domains;
    }

    public CreateType lifeCycle(@Nullable LifeCycle lifeCycle) {
        this.lifeCycle = lifeCycle;
        return this;
    }

    @Nullable
    @JsonProperty(value="lifeCycle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LifeCycle getLifeCycle() {
        return this.lifeCycle;
    }

    @JsonProperty(value="lifeCycle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLifeCycle(@Nullable LifeCycle lifeCycle) {
        this.lifeCycle = lifeCycle;
    }

    public CreateType reviewers(@Nullable List<EntityReference> reviewers) {
        this.reviewers = reviewers;
        return this;
    }

    public CreateType addReviewersItem(EntityReference reviewersItem) {
        if (this.reviewers == null) {
            this.reviewers = new ArrayList<EntityReference>();
        }
        this.reviewers.add(reviewersItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="reviewers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getReviewers() {
        return this.reviewers;
    }

    @JsonProperty(value="reviewers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReviewers(@Nullable List<EntityReference> reviewers) {
        this.reviewers = reviewers;
    }

    public CreateType owners(@Nullable List<EntityReference> owners) {
        this.owners = owners;
        return this;
    }

    public CreateType addOwnersItem(EntityReference ownersItem) {
        if (this.owners == null) {
            this.owners = new ArrayList<EntityReference>();
        }
        this.owners.add(ownersItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="owners")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getOwners() {
        return this.owners;
    }

    @JsonProperty(value="owners")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOwners(@Nullable List<EntityReference> owners) {
        this.owners = owners;
    }

    public CreateType extension(@Nullable Object extension) {
        this.extension = extension;
        return this;
    }

    @Nullable
    @JsonProperty(value="extension")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getExtension() {
        return this.extension;
    }

    @JsonProperty(value="extension")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExtension(@Nullable Object extension) {
        this.extension = extension;
    }

    public CreateType tags(@Nullable List<TagLabel> tags) {
        this.tags = tags;
        return this;
    }

    public CreateType addTagsItem(TagLabel tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<TagLabel>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TagLabel> getTags() {
        return this.tags;
    }

    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTags(@Nullable List<TagLabel> tags) {
        this.tags = tags;
    }

    public CreateType dataProducts(@Nullable List<String> dataProducts) {
        this.dataProducts = dataProducts;
        return this;
    }

    public CreateType addDataProductsItem(String dataProductsItem) {
        if (this.dataProducts == null) {
            this.dataProducts = new ArrayList<String>();
        }
        this.dataProducts.add(dataProductsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="dataProducts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getDataProducts() {
        return this.dataProducts;
    }

    @JsonProperty(value="dataProducts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDataProducts(@Nullable List<String> dataProducts) {
        this.dataProducts = dataProducts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateType createType = (CreateType)o;
        return Objects.equals(this.name, createType.name) && Objects.equals(this.displayName, createType.displayName) && Objects.equals(this.description, createType.description) && Objects.equals(this.nameSpace, createType.nameSpace) && Objects.equals((Object)this.category, (Object)createType.category) && Objects.equals(this.schema, createType.schema) && Objects.equals(this.domains, createType.domains) && Objects.equals(this.lifeCycle, createType.lifeCycle) && Objects.equals(this.reviewers, createType.reviewers) && Objects.equals(this.owners, createType.owners) && Objects.equals(this.extension, createType.extension) && Objects.equals(this.tags, createType.tags) && Objects.equals(this.dataProducts, createType.dataProducts);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.displayName, this.description, this.nameSpace, this.category, this.schema, this.domains, this.lifeCycle, this.reviewers, this.owners, this.extension, this.tags, this.dataProducts});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateType {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    nameSpace: ").append(this.toIndentedString(this.nameSpace)).append("\n");
        sb.append("    category: ").append(this.toIndentedString((Object)this.category)).append("\n");
        sb.append("    schema: ").append(this.toIndentedString(this.schema)).append("\n");
        sb.append("    domains: ").append(this.toIndentedString(this.domains)).append("\n");
        sb.append("    lifeCycle: ").append(this.toIndentedString(this.lifeCycle)).append("\n");
        sb.append("    reviewers: ").append(this.toIndentedString(this.reviewers)).append("\n");
        sb.append("    owners: ").append(this.toIndentedString(this.owners)).append("\n");
        sb.append("    extension: ").append(this.toIndentedString(this.extension)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    dataProducts: ").append(this.toIndentedString(this.dataProducts)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum CategoryEnum {
        FIELD(String.valueOf("field")),
        ENTITY(String.valueOf("entity"));

        private String value;

        private CategoryEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CategoryEnum fromValue(String value) {
            for (CategoryEnum b : CategoryEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

