/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.model.Column;
import org.openmetadata.client.model.EntityReference;
import org.openmetadata.client.model.TagLabel;

@JsonPropertyOrder(value={"modelType", "resourceType", "dbtSourceProject", "description", "path", "rawSql", "sql", "upstream", "owners", "tags", "columns", "generatedAt"})
public class DataModel {
    public static final String JSON_PROPERTY_MODEL_TYPE = "modelType";
    @Nonnull
    private ModelTypeEnum modelType;
    public static final String JSON_PROPERTY_RESOURCE_TYPE = "resourceType";
    @Nullable
    private String resourceType;
    public static final String JSON_PROPERTY_DBT_SOURCE_PROJECT = "dbtSourceProject";
    @Nullable
    private String dbtSourceProject;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    @Nullable
    private String description;
    public static final String JSON_PROPERTY_PATH = "path";
    @Nullable
    private String path;
    public static final String JSON_PROPERTY_RAW_SQL = "rawSql";
    @Nullable
    private String rawSql;
    public static final String JSON_PROPERTY_SQL = "sql";
    @Nullable
    private String sql;
    public static final String JSON_PROPERTY_UPSTREAM = "upstream";
    @Nullable
    private List<String> upstream = new ArrayList<String>();
    public static final String JSON_PROPERTY_OWNERS = "owners";
    @Nullable
    private List<EntityReference> owners = new ArrayList<EntityReference>();
    public static final String JSON_PROPERTY_TAGS = "tags";
    @Nullable
    private List<TagLabel> tags = new ArrayList<TagLabel>();
    public static final String JSON_PROPERTY_COLUMNS = "columns";
    @Nullable
    private List<Column> columns = new ArrayList<Column>();
    public static final String JSON_PROPERTY_GENERATED_AT = "generatedAt";
    @Nullable
    private OffsetDateTime generatedAt;

    public DataModel modelType(@Nonnull ModelTypeEnum modelType) {
        this.modelType = modelType;
        return this;
    }

    @Nonnull
    @JsonProperty(value="modelType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ModelTypeEnum getModelType() {
        return this.modelType;
    }

    @JsonProperty(value="modelType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setModelType(@Nonnull ModelTypeEnum modelType) {
        this.modelType = modelType;
    }

    public DataModel resourceType(@Nullable String resourceType) {
        this.resourceType = resourceType;
        return this;
    }

    @Nullable
    @JsonProperty(value="resourceType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getResourceType() {
        return this.resourceType;
    }

    @JsonProperty(value="resourceType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResourceType(@Nullable String resourceType) {
        this.resourceType = resourceType;
    }

    public DataModel dbtSourceProject(@Nullable String dbtSourceProject) {
        this.dbtSourceProject = dbtSourceProject;
        return this;
    }

    @Nullable
    @JsonProperty(value="dbtSourceProject")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDbtSourceProject() {
        return this.dbtSourceProject;
    }

    @JsonProperty(value="dbtSourceProject")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDbtSourceProject(@Nullable String dbtSourceProject) {
        this.dbtSourceProject = dbtSourceProject;
    }

    public DataModel description(@Nullable String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    public DataModel path(@Nullable String path) {
        this.path = path;
        return this;
    }

    @Nullable
    @JsonProperty(value="path")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPath() {
        return this.path;
    }

    @JsonProperty(value="path")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPath(@Nullable String path) {
        this.path = path;
    }

    public DataModel rawSql(@Nullable String rawSql) {
        this.rawSql = rawSql;
        return this;
    }

    @Nullable
    @JsonProperty(value="rawSql")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRawSql() {
        return this.rawSql;
    }

    @JsonProperty(value="rawSql")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRawSql(@Nullable String rawSql) {
        this.rawSql = rawSql;
    }

    public DataModel sql(@Nullable String sql) {
        this.sql = sql;
        return this;
    }

    @Nullable
    @JsonProperty(value="sql")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSql() {
        return this.sql;
    }

    @JsonProperty(value="sql")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSql(@Nullable String sql) {
        this.sql = sql;
    }

    public DataModel upstream(@Nullable List<String> upstream) {
        this.upstream = upstream;
        return this;
    }

    public DataModel addUpstreamItem(String upstreamItem) {
        if (this.upstream == null) {
            this.upstream = new ArrayList<String>();
        }
        this.upstream.add(upstreamItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="upstream")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getUpstream() {
        return this.upstream;
    }

    @JsonProperty(value="upstream")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUpstream(@Nullable List<String> upstream) {
        this.upstream = upstream;
    }

    public DataModel owners(@Nullable List<EntityReference> owners) {
        this.owners = owners;
        return this;
    }

    public DataModel addOwnersItem(EntityReference ownersItem) {
        if (this.owners == null) {
            this.owners = new ArrayList<EntityReference>();
        }
        this.owners.add(ownersItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="owners")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getOwners() {
        return this.owners;
    }

    @JsonProperty(value="owners")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOwners(@Nullable List<EntityReference> owners) {
        this.owners = owners;
    }

    public DataModel tags(@Nullable List<TagLabel> tags) {
        this.tags = tags;
        return this;
    }

    public DataModel addTagsItem(TagLabel tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<TagLabel>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TagLabel> getTags() {
        return this.tags;
    }

    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTags(@Nullable List<TagLabel> tags) {
        this.tags = tags;
    }

    public DataModel columns(@Nullable List<Column> columns) {
        this.columns = columns;
        return this;
    }

    public DataModel addColumnsItem(Column columnsItem) {
        if (this.columns == null) {
            this.columns = new ArrayList<Column>();
        }
        this.columns.add(columnsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="columns")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Column> getColumns() {
        return this.columns;
    }

    @JsonProperty(value="columns")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setColumns(@Nullable List<Column> columns) {
        this.columns = columns;
    }

    public DataModel generatedAt(@Nullable OffsetDateTime generatedAt) {
        this.generatedAt = generatedAt;
        return this;
    }

    @Nullable
    @JsonProperty(value="generatedAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getGeneratedAt() {
        return this.generatedAt;
    }

    @JsonProperty(value="generatedAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGeneratedAt(@Nullable OffsetDateTime generatedAt) {
        this.generatedAt = generatedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataModel dataModel = (DataModel)o;
        return Objects.equals((Object)this.modelType, (Object)dataModel.modelType) && Objects.equals(this.resourceType, dataModel.resourceType) && Objects.equals(this.dbtSourceProject, dataModel.dbtSourceProject) && Objects.equals(this.description, dataModel.description) && Objects.equals(this.path, dataModel.path) && Objects.equals(this.rawSql, dataModel.rawSql) && Objects.equals(this.sql, dataModel.sql) && Objects.equals(this.upstream, dataModel.upstream) && Objects.equals(this.owners, dataModel.owners) && Objects.equals(this.tags, dataModel.tags) && Objects.equals(this.columns, dataModel.columns) && Objects.equals(this.generatedAt, dataModel.generatedAt);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.modelType, this.resourceType, this.dbtSourceProject, this.description, this.path, this.rawSql, this.sql, this.upstream, this.owners, this.tags, this.columns, this.generatedAt});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DataModel {\n");
        sb.append("    modelType: ").append(this.toIndentedString((Object)this.modelType)).append("\n");
        sb.append("    resourceType: ").append(this.toIndentedString(this.resourceType)).append("\n");
        sb.append("    dbtSourceProject: ").append(this.toIndentedString(this.dbtSourceProject)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    rawSql: ").append(this.toIndentedString(this.rawSql)).append("\n");
        sb.append("    sql: ").append(this.toIndentedString(this.sql)).append("\n");
        sb.append("    upstream: ").append(this.toIndentedString(this.upstream)).append("\n");
        sb.append("    owners: ").append(this.toIndentedString(this.owners)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    columns: ").append(this.toIndentedString(this.columns)).append("\n");
        sb.append("    generatedAt: ").append(this.toIndentedString(this.generatedAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ModelTypeEnum {
        DBT(String.valueOf("DBT")),
        DDL(String.valueOf("DDL"));

        private String value;

        private ModelTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ModelTypeEnum fromValue(String value) {
            for (ModelTypeEnum b : ModelTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

