/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.model.AssetCertification;
import org.openmetadata.client.model.ChangeDescription;
import org.openmetadata.client.model.DataProductPort;
import org.openmetadata.client.model.EntityReference;
import org.openmetadata.client.model.LifeCycle;
import org.openmetadata.client.model.SlaDefinition;
import org.openmetadata.client.model.Style;
import org.openmetadata.client.model.TagLabel;
import org.openmetadata.client.model.UsageDetails;
import org.openmetadata.client.model.Votes;

@JsonPropertyOrder(value={"id", "name", "fullyQualifiedName", "displayName", "description", "style", "version", "updatedAt", "updatedBy", "href", "owners", "experts", "reviewers", "domains", "assets", "inputPorts", "outputPorts", "lifecycleStage", "sla", "consumesFrom", "providesTo", "tags", "changeDescription", "incrementalChangeDescription", "extension", "followers", "entityStatus", "deleted", "dataProducts", "votes", "lifeCycle", "certification", "usageSummary", "provider", "children", "service"})
public class DataProduct {
    public static final String JSON_PROPERTY_ID = "id";
    @Nonnull
    private UUID id;
    public static final String JSON_PROPERTY_NAME = "name";
    @Nonnull
    private String name;
    public static final String JSON_PROPERTY_FULLY_QUALIFIED_NAME = "fullyQualifiedName";
    @Nullable
    private String fullyQualifiedName;
    public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
    @Nullable
    private String displayName;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    @Nonnull
    private String description;
    public static final String JSON_PROPERTY_STYLE = "style";
    @Nullable
    private Style style;
    public static final String JSON_PROPERTY_VERSION = "version";
    @Nullable
    private Double version;
    public static final String JSON_PROPERTY_UPDATED_AT = "updatedAt";
    @Nullable
    private Long updatedAt;
    public static final String JSON_PROPERTY_UPDATED_BY = "updatedBy";
    @Nullable
    private String updatedBy;
    public static final String JSON_PROPERTY_HREF = "href";
    @Nullable
    private URI href;
    public static final String JSON_PROPERTY_OWNERS = "owners";
    @Nullable
    private List<EntityReference> owners = new ArrayList<EntityReference>();
    public static final String JSON_PROPERTY_EXPERTS = "experts";
    @Nullable
    private List<EntityReference> experts = new ArrayList<EntityReference>();
    public static final String JSON_PROPERTY_REVIEWERS = "reviewers";
    @Nullable
    private List<EntityReference> reviewers = new ArrayList<EntityReference>();
    public static final String JSON_PROPERTY_DOMAINS = "domains";
    @Nullable
    private List<EntityReference> domains = new ArrayList<EntityReference>();
    public static final String JSON_PROPERTY_ASSETS = "assets";
    @Nullable
    private List<EntityReference> assets = new ArrayList<EntityReference>();
    public static final String JSON_PROPERTY_INPUT_PORTS = "inputPorts";
    @Nullable
    private List<DataProductPort> inputPorts = new ArrayList<DataProductPort>();
    public static final String JSON_PROPERTY_OUTPUT_PORTS = "outputPorts";
    @Nullable
    private List<DataProductPort> outputPorts = new ArrayList<DataProductPort>();
    public static final String JSON_PROPERTY_LIFECYCLE_STAGE = "lifecycleStage";
    @Nullable
    private LifecycleStageEnum lifecycleStage;
    public static final String JSON_PROPERTY_SLA = "sla";
    @Nullable
    private SlaDefinition sla;
    public static final String JSON_PROPERTY_CONSUMES_FROM = "consumesFrom";
    @Nullable
    private List<EntityReference> consumesFrom = new ArrayList<EntityReference>();
    public static final String JSON_PROPERTY_PROVIDES_TO = "providesTo";
    @Nullable
    private List<EntityReference> providesTo = new ArrayList<EntityReference>();
    public static final String JSON_PROPERTY_TAGS = "tags";
    @Nullable
    private List<TagLabel> tags = new ArrayList<TagLabel>();
    public static final String JSON_PROPERTY_CHANGE_DESCRIPTION = "changeDescription";
    @Nullable
    private ChangeDescription changeDescription;
    public static final String JSON_PROPERTY_INCREMENTAL_CHANGE_DESCRIPTION = "incrementalChangeDescription";
    @Nullable
    private ChangeDescription incrementalChangeDescription;
    public static final String JSON_PROPERTY_EXTENSION = "extension";
    @Nullable
    private Object extension;
    public static final String JSON_PROPERTY_FOLLOWERS = "followers";
    @Nullable
    private List<EntityReference> followers = new ArrayList<EntityReference>();
    public static final String JSON_PROPERTY_ENTITY_STATUS = "entityStatus";
    @Nullable
    private EntityStatusEnum entityStatus;
    public static final String JSON_PROPERTY_DELETED = "deleted";
    @Nullable
    private Boolean deleted;
    public static final String JSON_PROPERTY_DATA_PRODUCTS = "dataProducts";
    @Nullable
    private List<EntityReference> dataProducts = new ArrayList<EntityReference>();
    public static final String JSON_PROPERTY_VOTES = "votes";
    @Nullable
    private Votes votes;
    public static final String JSON_PROPERTY_LIFE_CYCLE = "lifeCycle";
    @Nullable
    private LifeCycle lifeCycle;
    public static final String JSON_PROPERTY_CERTIFICATION = "certification";
    @Nullable
    private AssetCertification certification;
    public static final String JSON_PROPERTY_USAGE_SUMMARY = "usageSummary";
    @Nullable
    private UsageDetails usageSummary;
    public static final String JSON_PROPERTY_PROVIDER = "provider";
    @Nullable
    private ProviderEnum provider;
    public static final String JSON_PROPERTY_CHILDREN = "children";
    @Nullable
    private List<EntityReference> children = new ArrayList<EntityReference>();
    public static final String JSON_PROPERTY_SERVICE = "service";
    @Nullable
    private EntityReference service;

    public DataProduct id(@Nonnull UUID id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setId(@Nonnull UUID id) {
        this.id = id;
    }

    public DataProduct name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public DataProduct fullyQualifiedName(@Nullable String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
        return this;
    }

    @Nullable
    @JsonProperty(value="fullyQualifiedName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    @JsonProperty(value="fullyQualifiedName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFullyQualifiedName(@Nullable String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
    }

    public DataProduct displayName(@Nullable String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Nullable
    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDisplayName(@Nullable String displayName) {
        this.displayName = displayName;
    }

    public DataProduct description(@Nonnull String description) {
        this.description = description;
        return this;
    }

    @Nonnull
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDescription(@Nonnull String description) {
        this.description = description;
    }

    public DataProduct style(@Nullable Style style) {
        this.style = style;
        return this;
    }

    @Nullable
    @JsonProperty(value="style")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Style getStyle() {
        return this.style;
    }

    @JsonProperty(value="style")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStyle(@Nullable Style style) {
        this.style = style;
    }

    public DataProduct version(@Nullable Double version) {
        this.version = version;
        return this;
    }

    @Nullable
    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVersion(@Nullable Double version) {
        this.version = version;
    }

    public DataProduct updatedAt(@Nullable Long updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Nullable
    @JsonProperty(value="updatedAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="updatedAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUpdatedAt(@Nullable Long updatedAt) {
        this.updatedAt = updatedAt;
    }

    public DataProduct updatedBy(@Nullable String updatedBy) {
        this.updatedBy = updatedBy;
        return this;
    }

    @Nullable
    @JsonProperty(value="updatedBy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUpdatedBy() {
        return this.updatedBy;
    }

    @JsonProperty(value="updatedBy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUpdatedBy(@Nullable String updatedBy) {
        this.updatedBy = updatedBy;
    }

    public DataProduct href(@Nullable URI href) {
        this.href = href;
        return this;
    }

    @Nullable
    @JsonProperty(value="href")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public URI getHref() {
        return this.href;
    }

    @JsonProperty(value="href")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHref(@Nullable URI href) {
        this.href = href;
    }

    public DataProduct owners(@Nullable List<EntityReference> owners) {
        this.owners = owners;
        return this;
    }

    public DataProduct addOwnersItem(EntityReference ownersItem) {
        if (this.owners == null) {
            this.owners = new ArrayList<EntityReference>();
        }
        this.owners.add(ownersItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="owners")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getOwners() {
        return this.owners;
    }

    @JsonProperty(value="owners")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOwners(@Nullable List<EntityReference> owners) {
        this.owners = owners;
    }

    public DataProduct experts(@Nullable List<EntityReference> experts) {
        this.experts = experts;
        return this;
    }

    public DataProduct addExpertsItem(EntityReference expertsItem) {
        if (this.experts == null) {
            this.experts = new ArrayList<EntityReference>();
        }
        this.experts.add(expertsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="experts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getExperts() {
        return this.experts;
    }

    @JsonProperty(value="experts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExperts(@Nullable List<EntityReference> experts) {
        this.experts = experts;
    }

    public DataProduct reviewers(@Nullable List<EntityReference> reviewers) {
        this.reviewers = reviewers;
        return this;
    }

    public DataProduct addReviewersItem(EntityReference reviewersItem) {
        if (this.reviewers == null) {
            this.reviewers = new ArrayList<EntityReference>();
        }
        this.reviewers.add(reviewersItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="reviewers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getReviewers() {
        return this.reviewers;
    }

    @JsonProperty(value="reviewers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReviewers(@Nullable List<EntityReference> reviewers) {
        this.reviewers = reviewers;
    }

    public DataProduct domains(@Nullable List<EntityReference> domains) {
        this.domains = domains;
        return this;
    }

    public DataProduct addDomainsItem(EntityReference domainsItem) {
        if (this.domains == null) {
            this.domains = new ArrayList<EntityReference>();
        }
        this.domains.add(domainsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="domains")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getDomains() {
        return this.domains;
    }

    @JsonProperty(value="domains")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDomains(@Nullable List<EntityReference> domains) {
        this.domains = domains;
    }

    public DataProduct assets(@Nullable List<EntityReference> assets) {
        this.assets = assets;
        return this;
    }

    public DataProduct addAssetsItem(EntityReference assetsItem) {
        if (this.assets == null) {
            this.assets = new ArrayList<EntityReference>();
        }
        this.assets.add(assetsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="assets")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getAssets() {
        return this.assets;
    }

    @JsonProperty(value="assets")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAssets(@Nullable List<EntityReference> assets) {
        this.assets = assets;
    }

    public DataProduct inputPorts(@Nullable List<DataProductPort> inputPorts) {
        this.inputPorts = inputPorts;
        return this;
    }

    public DataProduct addInputPortsItem(DataProductPort inputPortsItem) {
        if (this.inputPorts == null) {
            this.inputPorts = new ArrayList<DataProductPort>();
        }
        this.inputPorts.add(inputPortsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="inputPorts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<DataProductPort> getInputPorts() {
        return this.inputPorts;
    }

    @JsonProperty(value="inputPorts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInputPorts(@Nullable List<DataProductPort> inputPorts) {
        this.inputPorts = inputPorts;
    }

    public DataProduct outputPorts(@Nullable List<DataProductPort> outputPorts) {
        this.outputPorts = outputPorts;
        return this;
    }

    public DataProduct addOutputPortsItem(DataProductPort outputPortsItem) {
        if (this.outputPorts == null) {
            this.outputPorts = new ArrayList<DataProductPort>();
        }
        this.outputPorts.add(outputPortsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="outputPorts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<DataProductPort> getOutputPorts() {
        return this.outputPorts;
    }

    @JsonProperty(value="outputPorts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOutputPorts(@Nullable List<DataProductPort> outputPorts) {
        this.outputPorts = outputPorts;
    }

    public DataProduct lifecycleStage(@Nullable LifecycleStageEnum lifecycleStage) {
        this.lifecycleStage = lifecycleStage;
        return this;
    }

    @Nullable
    @JsonProperty(value="lifecycleStage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LifecycleStageEnum getLifecycleStage() {
        return this.lifecycleStage;
    }

    @JsonProperty(value="lifecycleStage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLifecycleStage(@Nullable LifecycleStageEnum lifecycleStage) {
        this.lifecycleStage = lifecycleStage;
    }

    public DataProduct sla(@Nullable SlaDefinition sla) {
        this.sla = sla;
        return this;
    }

    @Nullable
    @JsonProperty(value="sla")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SlaDefinition getSla() {
        return this.sla;
    }

    @JsonProperty(value="sla")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSla(@Nullable SlaDefinition sla) {
        this.sla = sla;
    }

    public DataProduct consumesFrom(@Nullable List<EntityReference> consumesFrom) {
        this.consumesFrom = consumesFrom;
        return this;
    }

    public DataProduct addConsumesFromItem(EntityReference consumesFromItem) {
        if (this.consumesFrom == null) {
            this.consumesFrom = new ArrayList<EntityReference>();
        }
        this.consumesFrom.add(consumesFromItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="consumesFrom")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getConsumesFrom() {
        return this.consumesFrom;
    }

    @JsonProperty(value="consumesFrom")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setConsumesFrom(@Nullable List<EntityReference> consumesFrom) {
        this.consumesFrom = consumesFrom;
    }

    public DataProduct providesTo(@Nullable List<EntityReference> providesTo) {
        this.providesTo = providesTo;
        return this;
    }

    public DataProduct addProvidesToItem(EntityReference providesToItem) {
        if (this.providesTo == null) {
            this.providesTo = new ArrayList<EntityReference>();
        }
        this.providesTo.add(providesToItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="providesTo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getProvidesTo() {
        return this.providesTo;
    }

    @JsonProperty(value="providesTo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProvidesTo(@Nullable List<EntityReference> providesTo) {
        this.providesTo = providesTo;
    }

    public DataProduct tags(@Nullable List<TagLabel> tags) {
        this.tags = tags;
        return this;
    }

    public DataProduct addTagsItem(TagLabel tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<TagLabel>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TagLabel> getTags() {
        return this.tags;
    }

    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTags(@Nullable List<TagLabel> tags) {
        this.tags = tags;
    }

    public DataProduct changeDescription(@Nullable ChangeDescription changeDescription) {
        this.changeDescription = changeDescription;
        return this;
    }

    @Nullable
    @JsonProperty(value="changeDescription")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ChangeDescription getChangeDescription() {
        return this.changeDescription;
    }

    @JsonProperty(value="changeDescription")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChangeDescription(@Nullable ChangeDescription changeDescription) {
        this.changeDescription = changeDescription;
    }

    public DataProduct incrementalChangeDescription(@Nullable ChangeDescription incrementalChangeDescription) {
        this.incrementalChangeDescription = incrementalChangeDescription;
        return this;
    }

    @Nullable
    @JsonProperty(value="incrementalChangeDescription")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ChangeDescription getIncrementalChangeDescription() {
        return this.incrementalChangeDescription;
    }

    @JsonProperty(value="incrementalChangeDescription")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIncrementalChangeDescription(@Nullable ChangeDescription incrementalChangeDescription) {
        this.incrementalChangeDescription = incrementalChangeDescription;
    }

    public DataProduct extension(@Nullable Object extension) {
        this.extension = extension;
        return this;
    }

    @Nullable
    @JsonProperty(value="extension")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getExtension() {
        return this.extension;
    }

    @JsonProperty(value="extension")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExtension(@Nullable Object extension) {
        this.extension = extension;
    }

    public DataProduct followers(@Nullable List<EntityReference> followers) {
        this.followers = followers;
        return this;
    }

    public DataProduct addFollowersItem(EntityReference followersItem) {
        if (this.followers == null) {
            this.followers = new ArrayList<EntityReference>();
        }
        this.followers.add(followersItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="followers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getFollowers() {
        return this.followers;
    }

    @JsonProperty(value="followers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFollowers(@Nullable List<EntityReference> followers) {
        this.followers = followers;
    }

    public DataProduct entityStatus(@Nullable EntityStatusEnum entityStatus) {
        this.entityStatus = entityStatus;
        return this;
    }

    @Nullable
    @JsonProperty(value="entityStatus")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EntityStatusEnum getEntityStatus() {
        return this.entityStatus;
    }

    @JsonProperty(value="entityStatus")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEntityStatus(@Nullable EntityStatusEnum entityStatus) {
        this.entityStatus = entityStatus;
    }

    public DataProduct deleted(@Nullable Boolean deleted) {
        this.deleted = deleted;
        return this;
    }

    @Nullable
    @JsonProperty(value="deleted")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getDeleted() {
        return this.deleted;
    }

    @JsonProperty(value="deleted")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeleted(@Nullable Boolean deleted) {
        this.deleted = deleted;
    }

    public DataProduct dataProducts(@Nullable List<EntityReference> dataProducts) {
        this.dataProducts = dataProducts;
        return this;
    }

    public DataProduct addDataProductsItem(EntityReference dataProductsItem) {
        if (this.dataProducts == null) {
            this.dataProducts = new ArrayList<EntityReference>();
        }
        this.dataProducts.add(dataProductsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="dataProducts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getDataProducts() {
        return this.dataProducts;
    }

    @JsonProperty(value="dataProducts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDataProducts(@Nullable List<EntityReference> dataProducts) {
        this.dataProducts = dataProducts;
    }

    public DataProduct votes(@Nullable Votes votes) {
        this.votes = votes;
        return this;
    }

    @Nullable
    @JsonProperty(value="votes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Votes getVotes() {
        return this.votes;
    }

    @JsonProperty(value="votes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVotes(@Nullable Votes votes) {
        this.votes = votes;
    }

    public DataProduct lifeCycle(@Nullable LifeCycle lifeCycle) {
        this.lifeCycle = lifeCycle;
        return this;
    }

    @Nullable
    @JsonProperty(value="lifeCycle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LifeCycle getLifeCycle() {
        return this.lifeCycle;
    }

    @JsonProperty(value="lifeCycle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLifeCycle(@Nullable LifeCycle lifeCycle) {
        this.lifeCycle = lifeCycle;
    }

    public DataProduct certification(@Nullable AssetCertification certification) {
        this.certification = certification;
        return this;
    }

    @Nullable
    @JsonProperty(value="certification")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AssetCertification getCertification() {
        return this.certification;
    }

    @JsonProperty(value="certification")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCertification(@Nullable AssetCertification certification) {
        this.certification = certification;
    }

    public DataProduct usageSummary(@Nullable UsageDetails usageSummary) {
        this.usageSummary = usageSummary;
        return this;
    }

    @Nullable
    @JsonProperty(value="usageSummary")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UsageDetails getUsageSummary() {
        return this.usageSummary;
    }

    @JsonProperty(value="usageSummary")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUsageSummary(@Nullable UsageDetails usageSummary) {
        this.usageSummary = usageSummary;
    }

    public DataProduct provider(@Nullable ProviderEnum provider) {
        this.provider = provider;
        return this;
    }

    @Nullable
    @JsonProperty(value="provider")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ProviderEnum getProvider() {
        return this.provider;
    }

    @JsonProperty(value="provider")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProvider(@Nullable ProviderEnum provider) {
        this.provider = provider;
    }

    public DataProduct children(@Nullable List<EntityReference> children) {
        this.children = children;
        return this;
    }

    public DataProduct addChildrenItem(EntityReference childrenItem) {
        if (this.children == null) {
            this.children = new ArrayList<EntityReference>();
        }
        this.children.add(childrenItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="children")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getChildren() {
        return this.children;
    }

    @JsonProperty(value="children")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChildren(@Nullable List<EntityReference> children) {
        this.children = children;
    }

    public DataProduct service(@Nullable EntityReference service) {
        this.service = service;
        return this;
    }

    @Nullable
    @JsonProperty(value="service")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EntityReference getService() {
        return this.service;
    }

    @JsonProperty(value="service")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setService(@Nullable EntityReference service) {
        this.service = service;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataProduct dataProduct = (DataProduct)o;
        return Objects.equals(this.id, dataProduct.id) && Objects.equals(this.name, dataProduct.name) && Objects.equals(this.fullyQualifiedName, dataProduct.fullyQualifiedName) && Objects.equals(this.displayName, dataProduct.displayName) && Objects.equals(this.description, dataProduct.description) && Objects.equals(this.style, dataProduct.style) && Objects.equals(this.version, dataProduct.version) && Objects.equals(this.updatedAt, dataProduct.updatedAt) && Objects.equals(this.updatedBy, dataProduct.updatedBy) && Objects.equals(this.href, dataProduct.href) && Objects.equals(this.owners, dataProduct.owners) && Objects.equals(this.experts, dataProduct.experts) && Objects.equals(this.reviewers, dataProduct.reviewers) && Objects.equals(this.domains, dataProduct.domains) && Objects.equals(this.assets, dataProduct.assets) && Objects.equals(this.inputPorts, dataProduct.inputPorts) && Objects.equals(this.outputPorts, dataProduct.outputPorts) && Objects.equals((Object)this.lifecycleStage, (Object)dataProduct.lifecycleStage) && Objects.equals(this.sla, dataProduct.sla) && Objects.equals(this.consumesFrom, dataProduct.consumesFrom) && Objects.equals(this.providesTo, dataProduct.providesTo) && Objects.equals(this.tags, dataProduct.tags) && Objects.equals(this.changeDescription, dataProduct.changeDescription) && Objects.equals(this.incrementalChangeDescription, dataProduct.incrementalChangeDescription) && Objects.equals(this.extension, dataProduct.extension) && Objects.equals(this.followers, dataProduct.followers) && Objects.equals((Object)this.entityStatus, (Object)dataProduct.entityStatus) && Objects.equals(this.deleted, dataProduct.deleted) && Objects.equals(this.dataProducts, dataProduct.dataProducts) && Objects.equals(this.votes, dataProduct.votes) && Objects.equals(this.lifeCycle, dataProduct.lifeCycle) && Objects.equals(this.certification, dataProduct.certification) && Objects.equals(this.usageSummary, dataProduct.usageSummary) && Objects.equals((Object)this.provider, (Object)dataProduct.provider) && Objects.equals(this.children, dataProduct.children) && Objects.equals(this.service, dataProduct.service);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.fullyQualifiedName, this.displayName, this.description, this.style, this.version, this.updatedAt, this.updatedBy, this.href, this.owners, this.experts, this.reviewers, this.domains, this.assets, this.inputPorts, this.outputPorts, this.lifecycleStage, this.sla, this.consumesFrom, this.providesTo, this.tags, this.changeDescription, this.incrementalChangeDescription, this.extension, this.followers, this.entityStatus, this.deleted, this.dataProducts, this.votes, this.lifeCycle, this.certification, this.usageSummary, this.provider, this.children, this.service});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DataProduct {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    fullyQualifiedName: ").append(this.toIndentedString(this.fullyQualifiedName)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    style: ").append(this.toIndentedString(this.style)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    updatedBy: ").append(this.toIndentedString(this.updatedBy)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    owners: ").append(this.toIndentedString(this.owners)).append("\n");
        sb.append("    experts: ").append(this.toIndentedString(this.experts)).append("\n");
        sb.append("    reviewers: ").append(this.toIndentedString(this.reviewers)).append("\n");
        sb.append("    domains: ").append(this.toIndentedString(this.domains)).append("\n");
        sb.append("    assets: ").append(this.toIndentedString(this.assets)).append("\n");
        sb.append("    inputPorts: ").append(this.toIndentedString(this.inputPorts)).append("\n");
        sb.append("    outputPorts: ").append(this.toIndentedString(this.outputPorts)).append("\n");
        sb.append("    lifecycleStage: ").append(this.toIndentedString((Object)this.lifecycleStage)).append("\n");
        sb.append("    sla: ").append(this.toIndentedString(this.sla)).append("\n");
        sb.append("    consumesFrom: ").append(this.toIndentedString(this.consumesFrom)).append("\n");
        sb.append("    providesTo: ").append(this.toIndentedString(this.providesTo)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    changeDescription: ").append(this.toIndentedString(this.changeDescription)).append("\n");
        sb.append("    incrementalChangeDescription: ").append(this.toIndentedString(this.incrementalChangeDescription)).append("\n");
        sb.append("    extension: ").append(this.toIndentedString(this.extension)).append("\n");
        sb.append("    followers: ").append(this.toIndentedString(this.followers)).append("\n");
        sb.append("    entityStatus: ").append(this.toIndentedString((Object)this.entityStatus)).append("\n");
        sb.append("    deleted: ").append(this.toIndentedString(this.deleted)).append("\n");
        sb.append("    dataProducts: ").append(this.toIndentedString(this.dataProducts)).append("\n");
        sb.append("    votes: ").append(this.toIndentedString(this.votes)).append("\n");
        sb.append("    lifeCycle: ").append(this.toIndentedString(this.lifeCycle)).append("\n");
        sb.append("    certification: ").append(this.toIndentedString(this.certification)).append("\n");
        sb.append("    usageSummary: ").append(this.toIndentedString(this.usageSummary)).append("\n");
        sb.append("    provider: ").append(this.toIndentedString((Object)this.provider)).append("\n");
        sb.append("    children: ").append(this.toIndentedString(this.children)).append("\n");
        sb.append("    service: ").append(this.toIndentedString(this.service)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum LifecycleStageEnum {
        IDEATION(String.valueOf("IDEATION")),
        DESIGN(String.valueOf("DESIGN")),
        DEVELOPMENT(String.valueOf("DEVELOPMENT")),
        TESTING(String.valueOf("TESTING")),
        PRODUCTION(String.valueOf("PRODUCTION")),
        DEPRECATED(String.valueOf("DEPRECATED")),
        RETIRED(String.valueOf("RETIRED"));

        private String value;

        private LifecycleStageEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static LifecycleStageEnum fromValue(String value) {
            for (LifecycleStageEnum b : LifecycleStageEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum EntityStatusEnum {
        DRAFT(String.valueOf("Draft")),
        IN_REVIEW(String.valueOf("In Review")),
        APPROVED(String.valueOf("Approved")),
        DEPRECATED(String.valueOf("Deprecated")),
        REJECTED(String.valueOf("Rejected")),
        UNPROCESSED(String.valueOf("Unprocessed"));

        private String value;

        private EntityStatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static EntityStatusEnum fromValue(String value) {
            for (EntityStatusEnum b : EntityStatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ProviderEnum {
        SYSTEM(String.valueOf("system")),
        USER(String.valueOf("user")),
        AUTOMATION(String.valueOf("automation"));

        private String value;

        private ProviderEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ProviderEnum fromValue(String value) {
            for (ProviderEnum b : ProviderEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

