/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.model.EntityReference;

@JsonPropertyOrder(value={"name", "displayName", "description", "portType", "protocol", "format", "endpoint", "dataAsset"})
public class DataProductPort {
    public static final String JSON_PROPERTY_NAME = "name";
    @Nonnull
    private String name;
    public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
    @Nullable
    private String displayName;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    @Nullable
    private String description;
    public static final String JSON_PROPERTY_PORT_TYPE = "portType";
    @Nonnull
    private PortTypeEnum portType;
    public static final String JSON_PROPERTY_PROTOCOL = "protocol";
    @Nullable
    private ProtocolEnum protocol;
    public static final String JSON_PROPERTY_FORMAT = "format";
    @Nullable
    private FormatEnum format;
    public static final String JSON_PROPERTY_ENDPOINT = "endpoint";
    @Nullable
    private String endpoint;
    public static final String JSON_PROPERTY_DATA_ASSET = "dataAsset";
    @Nullable
    private EntityReference dataAsset;

    public DataProductPort name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public DataProductPort displayName(@Nullable String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Nullable
    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDisplayName(@Nullable String displayName) {
        this.displayName = displayName;
    }

    public DataProductPort description(@Nullable String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    public DataProductPort portType(@Nonnull PortTypeEnum portType) {
        this.portType = portType;
        return this;
    }

    @Nonnull
    @JsonProperty(value="portType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public PortTypeEnum getPortType() {
        return this.portType;
    }

    @JsonProperty(value="portType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPortType(@Nonnull PortTypeEnum portType) {
        this.portType = portType;
    }

    public DataProductPort protocol(@Nullable ProtocolEnum protocol) {
        this.protocol = protocol;
        return this;
    }

    @Nullable
    @JsonProperty(value="protocol")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ProtocolEnum getProtocol() {
        return this.protocol;
    }

    @JsonProperty(value="protocol")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProtocol(@Nullable ProtocolEnum protocol) {
        this.protocol = protocol;
    }

    public DataProductPort format(@Nullable FormatEnum format) {
        this.format = format;
        return this;
    }

    @Nullable
    @JsonProperty(value="format")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FormatEnum getFormat() {
        return this.format;
    }

    @JsonProperty(value="format")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFormat(@Nullable FormatEnum format) {
        this.format = format;
    }

    public DataProductPort endpoint(@Nullable String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    @Nullable
    @JsonProperty(value="endpoint")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEndpoint() {
        return this.endpoint;
    }

    @JsonProperty(value="endpoint")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEndpoint(@Nullable String endpoint) {
        this.endpoint = endpoint;
    }

    public DataProductPort dataAsset(@Nullable EntityReference dataAsset) {
        this.dataAsset = dataAsset;
        return this;
    }

    @Nullable
    @JsonProperty(value="dataAsset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EntityReference getDataAsset() {
        return this.dataAsset;
    }

    @JsonProperty(value="dataAsset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDataAsset(@Nullable EntityReference dataAsset) {
        this.dataAsset = dataAsset;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataProductPort dataProductPort = (DataProductPort)o;
        return Objects.equals(this.name, dataProductPort.name) && Objects.equals(this.displayName, dataProductPort.displayName) && Objects.equals(this.description, dataProductPort.description) && Objects.equals((Object)this.portType, (Object)dataProductPort.portType) && Objects.equals((Object)this.protocol, (Object)dataProductPort.protocol) && Objects.equals((Object)this.format, (Object)dataProductPort.format) && Objects.equals(this.endpoint, dataProductPort.endpoint) && Objects.equals(this.dataAsset, dataProductPort.dataAsset);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.displayName, this.description, this.portType, this.protocol, this.format, this.endpoint, this.dataAsset});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DataProductPort {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    portType: ").append(this.toIndentedString((Object)this.portType)).append("\n");
        sb.append("    protocol: ").append(this.toIndentedString((Object)this.protocol)).append("\n");
        sb.append("    format: ").append(this.toIndentedString((Object)this.format)).append("\n");
        sb.append("    endpoint: ").append(this.toIndentedString(this.endpoint)).append("\n");
        sb.append("    dataAsset: ").append(this.toIndentedString(this.dataAsset)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PortTypeEnum {
        INPUT(String.valueOf("INPUT")),
        OUTPUT(String.valueOf("OUTPUT"));

        private String value;

        private PortTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PortTypeEnum fromValue(String value) {
            for (PortTypeEnum b : PortTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ProtocolEnum {
        REST(String.valueOf("REST")),
        GRPC(String.valueOf("GRPC")),
        GRAPHQL(String.valueOf("GRAPHQL")),
        JDBC(String.valueOf("JDBC")),
        KAFKA(String.valueOf("KAFKA")),
        FILE(String.valueOf("FILE")),
        S3(String.valueOf("S3")),
        AZURE_BLOB(String.valueOf("AZURE_BLOB")),
        GCS(String.valueOf("GCS")),
        WEBHOOK(String.valueOf("WEBHOOK")),
        CUSTOM(String.valueOf("CUSTOM"));

        private String value;

        private ProtocolEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ProtocolEnum fromValue(String value) {
            for (ProtocolEnum b : ProtocolEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum FormatEnum {
        JSON(String.valueOf("JSON")),
        CSV(String.valueOf("CSV")),
        PARQUET(String.valueOf("PARQUET")),
        AVRO(String.valueOf("AVRO")),
        ORC(String.valueOf("ORC")),
        XML(String.valueOf("XML")),
        PROTOBUF(String.valueOf("PROTOBUF")),
        DELTA(String.valueOf("DELTA")),
        ICEBERG(String.valueOf("ICEBERG")),
        CUSTOM(String.valueOf("CUSTOM"));

        private String value;

        private FormatEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FormatEnum fromValue(String value) {
            for (FormatEnum b : FormatEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

