/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"datasetFQN", "columns", "rowCount", "sizeBytes", "mode", "partitions", "version"})
public class DatasetGeneration {
    public static final String JSON_PROPERTY_DATASET_F_Q_N = "datasetFQN";
    @Nonnull
    private String datasetFQN;
    public static final String JSON_PROPERTY_COLUMNS = "columns";
    @Nullable
    private List<String> columns = new ArrayList<String>();
    public static final String JSON_PROPERTY_ROW_COUNT = "rowCount";
    @Nullable
    private Integer rowCount;
    public static final String JSON_PROPERTY_SIZE_BYTES = "sizeBytes";
    @Nullable
    private Integer sizeBytes;
    public static final String JSON_PROPERTY_MODE = "mode";
    @Nullable
    private ModeEnum mode;
    public static final String JSON_PROPERTY_PARTITIONS = "partitions";
    @Nullable
    private List<String> partitions = new ArrayList<String>();
    public static final String JSON_PROPERTY_VERSION = "version";
    @Nullable
    private String version;

    public DatasetGeneration datasetFQN(@Nonnull String datasetFQN) {
        this.datasetFQN = datasetFQN;
        return this;
    }

    @Nonnull
    @JsonProperty(value="datasetFQN")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDatasetFQN() {
        return this.datasetFQN;
    }

    @JsonProperty(value="datasetFQN")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDatasetFQN(@Nonnull String datasetFQN) {
        this.datasetFQN = datasetFQN;
    }

    public DatasetGeneration columns(@Nullable List<String> columns) {
        this.columns = columns;
        return this;
    }

    public DatasetGeneration addColumnsItem(String columnsItem) {
        if (this.columns == null) {
            this.columns = new ArrayList<String>();
        }
        this.columns.add(columnsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="columns")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getColumns() {
        return this.columns;
    }

    @JsonProperty(value="columns")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setColumns(@Nullable List<String> columns) {
        this.columns = columns;
    }

    public DatasetGeneration rowCount(@Nullable Integer rowCount) {
        this.rowCount = rowCount;
        return this;
    }

    @Nullable
    @JsonProperty(value="rowCount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getRowCount() {
        return this.rowCount;
    }

    @JsonProperty(value="rowCount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRowCount(@Nullable Integer rowCount) {
        this.rowCount = rowCount;
    }

    public DatasetGeneration sizeBytes(@Nullable Integer sizeBytes) {
        this.sizeBytes = sizeBytes;
        return this;
    }

    @Nullable
    @JsonProperty(value="sizeBytes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getSizeBytes() {
        return this.sizeBytes;
    }

    @JsonProperty(value="sizeBytes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSizeBytes(@Nullable Integer sizeBytes) {
        this.sizeBytes = sizeBytes;
    }

    public DatasetGeneration mode(@Nullable ModeEnum mode) {
        this.mode = mode;
        return this;
    }

    @Nullable
    @JsonProperty(value="mode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ModeEnum getMode() {
        return this.mode;
    }

    @JsonProperty(value="mode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMode(@Nullable ModeEnum mode) {
        this.mode = mode;
    }

    public DatasetGeneration partitions(@Nullable List<String> partitions) {
        this.partitions = partitions;
        return this;
    }

    public DatasetGeneration addPartitionsItem(String partitionsItem) {
        if (this.partitions == null) {
            this.partitions = new ArrayList<String>();
        }
        this.partitions.add(partitionsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="partitions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getPartitions() {
        return this.partitions;
    }

    @JsonProperty(value="partitions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPartitions(@Nullable List<String> partitions) {
        this.partitions = partitions;
    }

    public DatasetGeneration version(@Nullable String version) {
        this.version = version;
        return this;
    }

    @Nullable
    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVersion(@Nullable String version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatasetGeneration datasetGeneration = (DatasetGeneration)o;
        return Objects.equals(this.datasetFQN, datasetGeneration.datasetFQN) && Objects.equals(this.columns, datasetGeneration.columns) && Objects.equals(this.rowCount, datasetGeneration.rowCount) && Objects.equals(this.sizeBytes, datasetGeneration.sizeBytes) && Objects.equals((Object)this.mode, (Object)datasetGeneration.mode) && Objects.equals(this.partitions, datasetGeneration.partitions) && Objects.equals(this.version, datasetGeneration.version);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.datasetFQN, this.columns, this.rowCount, this.sizeBytes, this.mode, this.partitions, this.version});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DatasetGeneration {\n");
        sb.append("    datasetFQN: ").append(this.toIndentedString(this.datasetFQN)).append("\n");
        sb.append("    columns: ").append(this.toIndentedString(this.columns)).append("\n");
        sb.append("    rowCount: ").append(this.toIndentedString(this.rowCount)).append("\n");
        sb.append("    sizeBytes: ").append(this.toIndentedString(this.sizeBytes)).append("\n");
        sb.append("    mode: ").append(this.toIndentedString((Object)this.mode)).append("\n");
        sb.append("    partitions: ").append(this.toIndentedString(this.partitions)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ModeEnum {
        OVERWRITE(String.valueOf("overwrite")),
        APPEND(String.valueOf("append")),
        MERGE(String.valueOf("merge")),
        UPSERT(String.valueOf("upsert"));

        private String value;

        private ModeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ModeEnum fromValue(String value) {
            for (ModeEnum b : ModeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

