/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"datasetFQN", "columns", "rowCount", "sizeBytes", "filter", "version"})
public class DatasetUsage {
    public static final String JSON_PROPERTY_DATASET_F_Q_N = "datasetFQN";
    @Nonnull
    private String datasetFQN;
    public static final String JSON_PROPERTY_COLUMNS = "columns";
    @Nullable
    private List<String> columns = new ArrayList<String>();
    public static final String JSON_PROPERTY_ROW_COUNT = "rowCount";
    @Nullable
    private Integer rowCount;
    public static final String JSON_PROPERTY_SIZE_BYTES = "sizeBytes";
    @Nullable
    private Integer sizeBytes;
    public static final String JSON_PROPERTY_FILTER = "filter";
    @Nullable
    private String filter;
    public static final String JSON_PROPERTY_VERSION = "version";
    @Nullable
    private String version;

    public DatasetUsage datasetFQN(@Nonnull String datasetFQN) {
        this.datasetFQN = datasetFQN;
        return this;
    }

    @Nonnull
    @JsonProperty(value="datasetFQN")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDatasetFQN() {
        return this.datasetFQN;
    }

    @JsonProperty(value="datasetFQN")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDatasetFQN(@Nonnull String datasetFQN) {
        this.datasetFQN = datasetFQN;
    }

    public DatasetUsage columns(@Nullable List<String> columns) {
        this.columns = columns;
        return this;
    }

    public DatasetUsage addColumnsItem(String columnsItem) {
        if (this.columns == null) {
            this.columns = new ArrayList<String>();
        }
        this.columns.add(columnsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="columns")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getColumns() {
        return this.columns;
    }

    @JsonProperty(value="columns")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setColumns(@Nullable List<String> columns) {
        this.columns = columns;
    }

    public DatasetUsage rowCount(@Nullable Integer rowCount) {
        this.rowCount = rowCount;
        return this;
    }

    @Nullable
    @JsonProperty(value="rowCount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getRowCount() {
        return this.rowCount;
    }

    @JsonProperty(value="rowCount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRowCount(@Nullable Integer rowCount) {
        this.rowCount = rowCount;
    }

    public DatasetUsage sizeBytes(@Nullable Integer sizeBytes) {
        this.sizeBytes = sizeBytes;
        return this;
    }

    @Nullable
    @JsonProperty(value="sizeBytes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getSizeBytes() {
        return this.sizeBytes;
    }

    @JsonProperty(value="sizeBytes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSizeBytes(@Nullable Integer sizeBytes) {
        this.sizeBytes = sizeBytes;
    }

    public DatasetUsage filter(@Nullable String filter) {
        this.filter = filter;
        return this;
    }

    @Nullable
    @JsonProperty(value="filter")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFilter() {
        return this.filter;
    }

    @JsonProperty(value="filter")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFilter(@Nullable String filter) {
        this.filter = filter;
    }

    public DatasetUsage version(@Nullable String version) {
        this.version = version;
        return this;
    }

    @Nullable
    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVersion(@Nullable String version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatasetUsage datasetUsage = (DatasetUsage)o;
        return Objects.equals(this.datasetFQN, datasetUsage.datasetFQN) && Objects.equals(this.columns, datasetUsage.columns) && Objects.equals(this.rowCount, datasetUsage.rowCount) && Objects.equals(this.sizeBytes, datasetUsage.sizeBytes) && Objects.equals(this.filter, datasetUsage.filter) && Objects.equals(this.version, datasetUsage.version);
    }

    public int hashCode() {
        return Objects.hash(this.datasetFQN, this.columns, this.rowCount, this.sizeBytes, this.filter, this.version);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DatasetUsage {\n");
        sb.append("    datasetFQN: ").append(this.toIndentedString(this.datasetFQN)).append("\n");
        sb.append("    columns: ").append(this.toIndentedString(this.columns)).append("\n");
        sb.append("    rowCount: ").append(this.toIndentedString(this.rowCount)).append("\n");
        sb.append("    sizeBytes: ").append(this.toIndentedString(this.sizeBytes)).append("\n");
        sb.append("    filter: ").append(this.toIndentedString(this.filter)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

