/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openmetadata.client.model.EntityReference;
import org.openmetadata.client.model.PolicyInfo;

@JsonPropertyOrder(value={"role", "policies", "source"})
public class DirectRolePermission {
    public static final String JSON_PROPERTY_ROLE = "role";
    @Nullable
    private EntityReference role;
    public static final String JSON_PROPERTY_POLICIES = "policies";
    @Nullable
    private List<PolicyInfo> policies = new ArrayList<PolicyInfo>();
    public static final String JSON_PROPERTY_SOURCE = "source";
    @Nullable
    private String source;

    public DirectRolePermission role(@Nullable EntityReference role) {
        this.role = role;
        return this;
    }

    @Nullable
    @JsonProperty(value="role")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EntityReference getRole() {
        return this.role;
    }

    @JsonProperty(value="role")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRole(@Nullable EntityReference role) {
        this.role = role;
    }

    public DirectRolePermission policies(@Nullable List<PolicyInfo> policies) {
        this.policies = policies;
        return this;
    }

    public DirectRolePermission addPoliciesItem(PolicyInfo policiesItem) {
        if (this.policies == null) {
            this.policies = new ArrayList<PolicyInfo>();
        }
        this.policies.add(policiesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="policies")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<PolicyInfo> getPolicies() {
        return this.policies;
    }

    @JsonProperty(value="policies")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPolicies(@Nullable List<PolicyInfo> policies) {
        this.policies = policies;
    }

    public DirectRolePermission source(@Nullable String source) {
        this.source = source;
        return this;
    }

    @Nullable
    @JsonProperty(value="source")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSource() {
        return this.source;
    }

    @JsonProperty(value="source")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSource(@Nullable String source) {
        this.source = source;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DirectRolePermission directRolePermission = (DirectRolePermission)o;
        return Objects.equals(this.role, directRolePermission.role) && Objects.equals(this.policies, directRolePermission.policies) && Objects.equals(this.source, directRolePermission.source);
    }

    public int hashCode() {
        return Objects.hash(this.role, this.policies, this.source);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DirectRolePermission {\n");
        sb.append("    role: ").append(this.toIndentedString(this.role)).append("\n");
        sb.append("    policies: ").append(this.toIndentedString(this.policies)).append("\n");
        sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

