/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.model.Edge;
import org.openmetadata.client.model.EntityReference;

@JsonPropertyOrder(value={"entity", "nodes", "upstreamEdges", "downstreamEdges"})
public class EntityLineage {
    public static final String JSON_PROPERTY_ENTITY = "entity";
    @Nonnull
    private EntityReference entity;
    public static final String JSON_PROPERTY_NODES = "nodes";
    @Nullable
    private List<EntityReference> nodes = new ArrayList<EntityReference>();
    public static final String JSON_PROPERTY_UPSTREAM_EDGES = "upstreamEdges";
    @Nullable
    private List<Edge> upstreamEdges = new ArrayList<Edge>();
    public static final String JSON_PROPERTY_DOWNSTREAM_EDGES = "downstreamEdges";
    @Nullable
    private List<Edge> downstreamEdges = new ArrayList<Edge>();

    public EntityLineage entity(@Nonnull EntityReference entity) {
        this.entity = entity;
        return this;
    }

    @Nonnull
    @JsonProperty(value="entity")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public EntityReference getEntity() {
        return this.entity;
    }

    @JsonProperty(value="entity")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEntity(@Nonnull EntityReference entity) {
        this.entity = entity;
    }

    public EntityLineage nodes(@Nullable List<EntityReference> nodes) {
        this.nodes = nodes;
        return this;
    }

    public EntityLineage addNodesItem(EntityReference nodesItem) {
        if (this.nodes == null) {
            this.nodes = new ArrayList<EntityReference>();
        }
        this.nodes.add(nodesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="nodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getNodes() {
        return this.nodes;
    }

    @JsonProperty(value="nodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNodes(@Nullable List<EntityReference> nodes) {
        this.nodes = nodes;
    }

    public EntityLineage upstreamEdges(@Nullable List<Edge> upstreamEdges) {
        this.upstreamEdges = upstreamEdges;
        return this;
    }

    public EntityLineage addUpstreamEdgesItem(Edge upstreamEdgesItem) {
        if (this.upstreamEdges == null) {
            this.upstreamEdges = new ArrayList<Edge>();
        }
        this.upstreamEdges.add(upstreamEdgesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="upstreamEdges")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Edge> getUpstreamEdges() {
        return this.upstreamEdges;
    }

    @JsonProperty(value="upstreamEdges")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUpstreamEdges(@Nullable List<Edge> upstreamEdges) {
        this.upstreamEdges = upstreamEdges;
    }

    public EntityLineage downstreamEdges(@Nullable List<Edge> downstreamEdges) {
        this.downstreamEdges = downstreamEdges;
        return this;
    }

    public EntityLineage addDownstreamEdgesItem(Edge downstreamEdgesItem) {
        if (this.downstreamEdges == null) {
            this.downstreamEdges = new ArrayList<Edge>();
        }
        this.downstreamEdges.add(downstreamEdgesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="downstreamEdges")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Edge> getDownstreamEdges() {
        return this.downstreamEdges;
    }

    @JsonProperty(value="downstreamEdges")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDownstreamEdges(@Nullable List<Edge> downstreamEdges) {
        this.downstreamEdges = downstreamEdges;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityLineage entityLineage = (EntityLineage)o;
        return Objects.equals(this.entity, entityLineage.entity) && Objects.equals(this.nodes, entityLineage.nodes) && Objects.equals(this.upstreamEdges, entityLineage.upstreamEdges) && Objects.equals(this.downstreamEdges, entityLineage.downstreamEdges);
    }

    public int hashCode() {
        return Objects.hash(this.entity, this.nodes, this.upstreamEdges, this.downstreamEdges);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EntityLineage {\n");
        sb.append("    entity: ").append(this.toIndentedString(this.entity)).append("\n");
        sb.append("    nodes: ").append(this.toIndentedString(this.nodes)).append("\n");
        sb.append("    upstreamEdges: ").append(this.toIndentedString(this.upstreamEdges)).append("\n");
        sb.append("    downstreamEdges: ").append(this.toIndentedString(this.downstreamEdges)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

