/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"totalPoliciesEvaluated", "totalRulesEvaluated", "matchingRules", "denyRules", "allowRules", "appliedPolicies", "reasonsForDecision", "evaluationTimeMs"})
public class EvaluationSummary {
    public static final String JSON_PROPERTY_TOTAL_POLICIES_EVALUATED = "totalPoliciesEvaluated";
    @Nullable
    private Integer totalPoliciesEvaluated;
    public static final String JSON_PROPERTY_TOTAL_RULES_EVALUATED = "totalRulesEvaluated";
    @Nullable
    private Integer totalRulesEvaluated;
    public static final String JSON_PROPERTY_MATCHING_RULES = "matchingRules";
    @Nullable
    private Integer matchingRules;
    public static final String JSON_PROPERTY_DENY_RULES = "denyRules";
    @Nullable
    private Integer denyRules;
    public static final String JSON_PROPERTY_ALLOW_RULES = "allowRules";
    @Nullable
    private Integer allowRules;
    public static final String JSON_PROPERTY_APPLIED_POLICIES = "appliedPolicies";
    @Nullable
    private List<String> appliedPolicies = new ArrayList<String>();
    public static final String JSON_PROPERTY_REASONS_FOR_DECISION = "reasonsForDecision";
    @Nullable
    private List<String> reasonsForDecision = new ArrayList<String>();
    public static final String JSON_PROPERTY_EVALUATION_TIME_MS = "evaluationTimeMs";
    @Nullable
    private Long evaluationTimeMs;

    public EvaluationSummary totalPoliciesEvaluated(@Nullable Integer totalPoliciesEvaluated) {
        this.totalPoliciesEvaluated = totalPoliciesEvaluated;
        return this;
    }

    @Nullable
    @JsonProperty(value="totalPoliciesEvaluated")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getTotalPoliciesEvaluated() {
        return this.totalPoliciesEvaluated;
    }

    @JsonProperty(value="totalPoliciesEvaluated")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalPoliciesEvaluated(@Nullable Integer totalPoliciesEvaluated) {
        this.totalPoliciesEvaluated = totalPoliciesEvaluated;
    }

    public EvaluationSummary totalRulesEvaluated(@Nullable Integer totalRulesEvaluated) {
        this.totalRulesEvaluated = totalRulesEvaluated;
        return this;
    }

    @Nullable
    @JsonProperty(value="totalRulesEvaluated")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getTotalRulesEvaluated() {
        return this.totalRulesEvaluated;
    }

    @JsonProperty(value="totalRulesEvaluated")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalRulesEvaluated(@Nullable Integer totalRulesEvaluated) {
        this.totalRulesEvaluated = totalRulesEvaluated;
    }

    public EvaluationSummary matchingRules(@Nullable Integer matchingRules) {
        this.matchingRules = matchingRules;
        return this;
    }

    @Nullable
    @JsonProperty(value="matchingRules")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getMatchingRules() {
        return this.matchingRules;
    }

    @JsonProperty(value="matchingRules")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMatchingRules(@Nullable Integer matchingRules) {
        this.matchingRules = matchingRules;
    }

    public EvaluationSummary denyRules(@Nullable Integer denyRules) {
        this.denyRules = denyRules;
        return this;
    }

    @Nullable
    @JsonProperty(value="denyRules")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getDenyRules() {
        return this.denyRules;
    }

    @JsonProperty(value="denyRules")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDenyRules(@Nullable Integer denyRules) {
        this.denyRules = denyRules;
    }

    public EvaluationSummary allowRules(@Nullable Integer allowRules) {
        this.allowRules = allowRules;
        return this;
    }

    @Nullable
    @JsonProperty(value="allowRules")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getAllowRules() {
        return this.allowRules;
    }

    @JsonProperty(value="allowRules")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAllowRules(@Nullable Integer allowRules) {
        this.allowRules = allowRules;
    }

    public EvaluationSummary appliedPolicies(@Nullable List<String> appliedPolicies) {
        this.appliedPolicies = appliedPolicies;
        return this;
    }

    public EvaluationSummary addAppliedPoliciesItem(String appliedPoliciesItem) {
        if (this.appliedPolicies == null) {
            this.appliedPolicies = new ArrayList<String>();
        }
        this.appliedPolicies.add(appliedPoliciesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="appliedPolicies")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getAppliedPolicies() {
        return this.appliedPolicies;
    }

    @JsonProperty(value="appliedPolicies")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAppliedPolicies(@Nullable List<String> appliedPolicies) {
        this.appliedPolicies = appliedPolicies;
    }

    public EvaluationSummary reasonsForDecision(@Nullable List<String> reasonsForDecision) {
        this.reasonsForDecision = reasonsForDecision;
        return this;
    }

    public EvaluationSummary addReasonsForDecisionItem(String reasonsForDecisionItem) {
        if (this.reasonsForDecision == null) {
            this.reasonsForDecision = new ArrayList<String>();
        }
        this.reasonsForDecision.add(reasonsForDecisionItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="reasonsForDecision")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getReasonsForDecision() {
        return this.reasonsForDecision;
    }

    @JsonProperty(value="reasonsForDecision")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReasonsForDecision(@Nullable List<String> reasonsForDecision) {
        this.reasonsForDecision = reasonsForDecision;
    }

    public EvaluationSummary evaluationTimeMs(@Nullable Long evaluationTimeMs) {
        this.evaluationTimeMs = evaluationTimeMs;
        return this;
    }

    @Nullable
    @JsonProperty(value="evaluationTimeMs")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getEvaluationTimeMs() {
        return this.evaluationTimeMs;
    }

    @JsonProperty(value="evaluationTimeMs")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEvaluationTimeMs(@Nullable Long evaluationTimeMs) {
        this.evaluationTimeMs = evaluationTimeMs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EvaluationSummary evaluationSummary = (EvaluationSummary)o;
        return Objects.equals(this.totalPoliciesEvaluated, evaluationSummary.totalPoliciesEvaluated) && Objects.equals(this.totalRulesEvaluated, evaluationSummary.totalRulesEvaluated) && Objects.equals(this.matchingRules, evaluationSummary.matchingRules) && Objects.equals(this.denyRules, evaluationSummary.denyRules) && Objects.equals(this.allowRules, evaluationSummary.allowRules) && Objects.equals(this.appliedPolicies, evaluationSummary.appliedPolicies) && Objects.equals(this.reasonsForDecision, evaluationSummary.reasonsForDecision) && Objects.equals(this.evaluationTimeMs, evaluationSummary.evaluationTimeMs);
    }

    public int hashCode() {
        return Objects.hash(this.totalPoliciesEvaluated, this.totalRulesEvaluated, this.matchingRules, this.denyRules, this.allowRules, this.appliedPolicies, this.reasonsForDecision, this.evaluationTimeMs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EvaluationSummary {\n");
        sb.append("    totalPoliciesEvaluated: ").append(this.toIndentedString(this.totalPoliciesEvaluated)).append("\n");
        sb.append("    totalRulesEvaluated: ").append(this.toIndentedString(this.totalRulesEvaluated)).append("\n");
        sb.append("    matchingRules: ").append(this.toIndentedString(this.matchingRules)).append("\n");
        sb.append("    denyRules: ").append(this.toIndentedString(this.denyRules)).append("\n");
        sb.append("    allowRules: ").append(this.toIndentedString(this.allowRules)).append("\n");
        sb.append("    appliedPolicies: ").append(this.toIndentedString(this.appliedPolicies)).append("\n");
        sb.append("    reasonsForDecision: ").append(this.toIndentedString(this.reasonsForDecision)).append("\n");
        sb.append("    evaluationTimeMs: ").append(this.toIndentedString(this.evaluationTimeMs)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

