/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.model.AssetCertification;
import org.openmetadata.client.model.ChangeDescription;
import org.openmetadata.client.model.EntityReference;
import org.openmetadata.client.model.LifeCycle;
import org.openmetadata.client.model.Style;
import org.openmetadata.client.model.TagLabel;
import org.openmetadata.client.model.UsageDetails;
import org.openmetadata.client.model.Votes;

@JsonPropertyOrder(value={"id", "name", "fullyQualifiedName", "displayName", "description", "service", "serviceType", "directory", "fileType", "mimeType", "fileExtension", "path", "size", "checksum", "webViewLink", "downloadLink", "isShared", "fileVersion", "createdTime", "modifiedTime", "lastModifiedBy", "sourceUrl", "href", "owners", "followers", "tags", "version", "updatedAt", "updatedBy", "changeDescription", "incrementalChangeDescription", "deleted", "domains", "dataProducts", "lifeCycle", "sourceHash", "extension", "votes", "certification", "usageSummary", "entityStatus", "reviewers", "experts", "style", "provider", "children"})
public class File {
    public static final String JSON_PROPERTY_ID = "id";
    @Nonnull
    private UUID id;
    public static final String JSON_PROPERTY_NAME = "name";
    @Nonnull
    private String name;
    public static final String JSON_PROPERTY_FULLY_QUALIFIED_NAME = "fullyQualifiedName";
    @Nullable
    private String fullyQualifiedName;
    public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
    @Nullable
    private String displayName;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    @Nullable
    private String description;
    public static final String JSON_PROPERTY_SERVICE = "service";
    @Nonnull
    private EntityReference service;
    public static final String JSON_PROPERTY_SERVICE_TYPE = "serviceType";
    @Nullable
    private ServiceTypeEnum serviceType;
    public static final String JSON_PROPERTY_DIRECTORY = "directory";
    @Nullable
    private EntityReference directory;
    public static final String JSON_PROPERTY_FILE_TYPE = "fileType";
    @Nullable
    private FileTypeEnum fileType;
    public static final String JSON_PROPERTY_MIME_TYPE = "mimeType";
    @Nullable
    private String mimeType;
    public static final String JSON_PROPERTY_FILE_EXTENSION = "fileExtension";
    @Nullable
    private String fileExtension;
    public static final String JSON_PROPERTY_PATH = "path";
    @Nullable
    private String path;
    public static final String JSON_PROPERTY_SIZE = "size";
    @Nullable
    private Integer size;
    public static final String JSON_PROPERTY_CHECKSUM = "checksum";
    @Nullable
    private String checksum;
    public static final String JSON_PROPERTY_WEB_VIEW_LINK = "webViewLink";
    @Nullable
    private URI webViewLink;
    public static final String JSON_PROPERTY_DOWNLOAD_LINK = "downloadLink";
    @Nullable
    private URI downloadLink;
    public static final String JSON_PROPERTY_IS_SHARED = "isShared";
    @Nullable
    private Boolean isShared;
    public static final String JSON_PROPERTY_FILE_VERSION = "fileVersion";
    @Nullable
    private String fileVersion;
    public static final String JSON_PROPERTY_CREATED_TIME = "createdTime";
    @Nullable
    private Long createdTime;
    public static final String JSON_PROPERTY_MODIFIED_TIME = "modifiedTime";
    @Nullable
    private Long modifiedTime;
    public static final String JSON_PROPERTY_LAST_MODIFIED_BY = "lastModifiedBy";
    @Nullable
    private EntityReference lastModifiedBy;
    public static final String JSON_PROPERTY_SOURCE_URL = "sourceUrl";
    @Nullable
    private String sourceUrl;
    public static final String JSON_PROPERTY_HREF = "href";
    @Nullable
    private URI href;
    public static final String JSON_PROPERTY_OWNERS = "owners";
    @Nullable
    private List<EntityReference> owners = new ArrayList<EntityReference>();
    public static final String JSON_PROPERTY_FOLLOWERS = "followers";
    @Nullable
    private List<EntityReference> followers = new ArrayList<EntityReference>();
    public static final String JSON_PROPERTY_TAGS = "tags";
    @Nullable
    private List<TagLabel> tags = new ArrayList<TagLabel>();
    public static final String JSON_PROPERTY_VERSION = "version";
    @Nullable
    private Double version;
    public static final String JSON_PROPERTY_UPDATED_AT = "updatedAt";
    @Nullable
    private Long updatedAt;
    public static final String JSON_PROPERTY_UPDATED_BY = "updatedBy";
    @Nullable
    private String updatedBy;
    public static final String JSON_PROPERTY_CHANGE_DESCRIPTION = "changeDescription";
    @Nullable
    private ChangeDescription changeDescription;
    public static final String JSON_PROPERTY_INCREMENTAL_CHANGE_DESCRIPTION = "incrementalChangeDescription";
    @Nullable
    private ChangeDescription incrementalChangeDescription;
    public static final String JSON_PROPERTY_DELETED = "deleted";
    @Nullable
    private Boolean deleted;
    public static final String JSON_PROPERTY_DOMAINS = "domains";
    @Nullable
    private List<EntityReference> domains = new ArrayList<EntityReference>();
    public static final String JSON_PROPERTY_DATA_PRODUCTS = "dataProducts";
    @Nullable
    private List<EntityReference> dataProducts = new ArrayList<EntityReference>();
    public static final String JSON_PROPERTY_LIFE_CYCLE = "lifeCycle";
    @Nullable
    private LifeCycle lifeCycle;
    public static final String JSON_PROPERTY_SOURCE_HASH = "sourceHash";
    @Nullable
    private String sourceHash;
    public static final String JSON_PROPERTY_EXTENSION = "extension";
    @Nullable
    private Object extension;
    public static final String JSON_PROPERTY_VOTES = "votes";
    @Nullable
    private Votes votes;
    public static final String JSON_PROPERTY_CERTIFICATION = "certification";
    @Nullable
    private AssetCertification certification;
    public static final String JSON_PROPERTY_USAGE_SUMMARY = "usageSummary";
    @Nullable
    private UsageDetails usageSummary;
    public static final String JSON_PROPERTY_ENTITY_STATUS = "entityStatus";
    @Nullable
    private EntityStatusEnum entityStatus;
    public static final String JSON_PROPERTY_REVIEWERS = "reviewers";
    @Nullable
    private List<EntityReference> reviewers = new ArrayList<EntityReference>();
    public static final String JSON_PROPERTY_EXPERTS = "experts";
    @Nullable
    private List<EntityReference> experts = new ArrayList<EntityReference>();
    public static final String JSON_PROPERTY_STYLE = "style";
    @Nullable
    private Style style;
    public static final String JSON_PROPERTY_PROVIDER = "provider";
    @Nullable
    private ProviderEnum provider;
    public static final String JSON_PROPERTY_CHILDREN = "children";
    @Nullable
    private List<EntityReference> children = new ArrayList<EntityReference>();

    public File id(@Nonnull UUID id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setId(@Nonnull UUID id) {
        this.id = id;
    }

    public File name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public File fullyQualifiedName(@Nullable String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
        return this;
    }

    @Nullable
    @JsonProperty(value="fullyQualifiedName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    @JsonProperty(value="fullyQualifiedName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFullyQualifiedName(@Nullable String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
    }

    public File displayName(@Nullable String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Nullable
    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDisplayName(@Nullable String displayName) {
        this.displayName = displayName;
    }

    public File description(@Nullable String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    public File service(@Nonnull EntityReference service) {
        this.service = service;
        return this;
    }

    @Nonnull
    @JsonProperty(value="service")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public EntityReference getService() {
        return this.service;
    }

    @JsonProperty(value="service")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setService(@Nonnull EntityReference service) {
        this.service = service;
    }

    public File serviceType(@Nullable ServiceTypeEnum serviceType) {
        this.serviceType = serviceType;
        return this;
    }

    @Nullable
    @JsonProperty(value="serviceType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ServiceTypeEnum getServiceType() {
        return this.serviceType;
    }

    @JsonProperty(value="serviceType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setServiceType(@Nullable ServiceTypeEnum serviceType) {
        this.serviceType = serviceType;
    }

    public File directory(@Nullable EntityReference directory) {
        this.directory = directory;
        return this;
    }

    @Nullable
    @JsonProperty(value="directory")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EntityReference getDirectory() {
        return this.directory;
    }

    @JsonProperty(value="directory")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDirectory(@Nullable EntityReference directory) {
        this.directory = directory;
    }

    public File fileType(@Nullable FileTypeEnum fileType) {
        this.fileType = fileType;
        return this;
    }

    @Nullable
    @JsonProperty(value="fileType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FileTypeEnum getFileType() {
        return this.fileType;
    }

    @JsonProperty(value="fileType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFileType(@Nullable FileTypeEnum fileType) {
        this.fileType = fileType;
    }

    public File mimeType(@Nullable String mimeType) {
        this.mimeType = mimeType;
        return this;
    }

    @Nullable
    @JsonProperty(value="mimeType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMimeType() {
        return this.mimeType;
    }

    @JsonProperty(value="mimeType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMimeType(@Nullable String mimeType) {
        this.mimeType = mimeType;
    }

    public File fileExtension(@Nullable String fileExtension) {
        this.fileExtension = fileExtension;
        return this;
    }

    @Nullable
    @JsonProperty(value="fileExtension")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFileExtension() {
        return this.fileExtension;
    }

    @JsonProperty(value="fileExtension")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFileExtension(@Nullable String fileExtension) {
        this.fileExtension = fileExtension;
    }

    public File path(@Nullable String path) {
        this.path = path;
        return this;
    }

    @Nullable
    @JsonProperty(value="path")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPath() {
        return this.path;
    }

    @JsonProperty(value="path")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPath(@Nullable String path) {
        this.path = path;
    }

    public File size(@Nullable Integer size) {
        this.size = size;
        return this;
    }

    @Nullable
    @JsonProperty(value="size")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getSize() {
        return this.size;
    }

    @JsonProperty(value="size")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSize(@Nullable Integer size) {
        this.size = size;
    }

    public File checksum(@Nullable String checksum) {
        this.checksum = checksum;
        return this;
    }

    @Nullable
    @JsonProperty(value="checksum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getChecksum() {
        return this.checksum;
    }

    @JsonProperty(value="checksum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChecksum(@Nullable String checksum) {
        this.checksum = checksum;
    }

    public File webViewLink(@Nullable URI webViewLink) {
        this.webViewLink = webViewLink;
        return this;
    }

    @Nullable
    @JsonProperty(value="webViewLink")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public URI getWebViewLink() {
        return this.webViewLink;
    }

    @JsonProperty(value="webViewLink")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWebViewLink(@Nullable URI webViewLink) {
        this.webViewLink = webViewLink;
    }

    public File downloadLink(@Nullable URI downloadLink) {
        this.downloadLink = downloadLink;
        return this;
    }

    @Nullable
    @JsonProperty(value="downloadLink")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public URI getDownloadLink() {
        return this.downloadLink;
    }

    @JsonProperty(value="downloadLink")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDownloadLink(@Nullable URI downloadLink) {
        this.downloadLink = downloadLink;
    }

    public File isShared(@Nullable Boolean isShared) {
        this.isShared = isShared;
        return this;
    }

    @Nullable
    @JsonProperty(value="isShared")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsShared() {
        return this.isShared;
    }

    @JsonProperty(value="isShared")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIsShared(@Nullable Boolean isShared) {
        this.isShared = isShared;
    }

    public File fileVersion(@Nullable String fileVersion) {
        this.fileVersion = fileVersion;
        return this;
    }

    @Nullable
    @JsonProperty(value="fileVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFileVersion() {
        return this.fileVersion;
    }

    @JsonProperty(value="fileVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFileVersion(@Nullable String fileVersion) {
        this.fileVersion = fileVersion;
    }

    public File createdTime(@Nullable Long createdTime) {
        this.createdTime = createdTime;
        return this;
    }

    @Nullable
    @JsonProperty(value="createdTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getCreatedTime() {
        return this.createdTime;
    }

    @JsonProperty(value="createdTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedTime(@Nullable Long createdTime) {
        this.createdTime = createdTime;
    }

    public File modifiedTime(@Nullable Long modifiedTime) {
        this.modifiedTime = modifiedTime;
        return this;
    }

    @Nullable
    @JsonProperty(value="modifiedTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getModifiedTime() {
        return this.modifiedTime;
    }

    @JsonProperty(value="modifiedTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setModifiedTime(@Nullable Long modifiedTime) {
        this.modifiedTime = modifiedTime;
    }

    public File lastModifiedBy(@Nullable EntityReference lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
        return this;
    }

    @Nullable
    @JsonProperty(value="lastModifiedBy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EntityReference getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    @JsonProperty(value="lastModifiedBy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLastModifiedBy(@Nullable EntityReference lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
    }

    public File sourceUrl(@Nullable String sourceUrl) {
        this.sourceUrl = sourceUrl;
        return this;
    }

    @Nullable
    @JsonProperty(value="sourceUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSourceUrl() {
        return this.sourceUrl;
    }

    @JsonProperty(value="sourceUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSourceUrl(@Nullable String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    public File href(@Nullable URI href) {
        this.href = href;
        return this;
    }

    @Nullable
    @JsonProperty(value="href")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public URI getHref() {
        return this.href;
    }

    @JsonProperty(value="href")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHref(@Nullable URI href) {
        this.href = href;
    }

    public File owners(@Nullable List<EntityReference> owners) {
        this.owners = owners;
        return this;
    }

    public File addOwnersItem(EntityReference ownersItem) {
        if (this.owners == null) {
            this.owners = new ArrayList<EntityReference>();
        }
        this.owners.add(ownersItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="owners")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getOwners() {
        return this.owners;
    }

    @JsonProperty(value="owners")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOwners(@Nullable List<EntityReference> owners) {
        this.owners = owners;
    }

    public File followers(@Nullable List<EntityReference> followers) {
        this.followers = followers;
        return this;
    }

    public File addFollowersItem(EntityReference followersItem) {
        if (this.followers == null) {
            this.followers = new ArrayList<EntityReference>();
        }
        this.followers.add(followersItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="followers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getFollowers() {
        return this.followers;
    }

    @JsonProperty(value="followers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFollowers(@Nullable List<EntityReference> followers) {
        this.followers = followers;
    }

    public File tags(@Nullable List<TagLabel> tags) {
        this.tags = tags;
        return this;
    }

    public File addTagsItem(TagLabel tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<TagLabel>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TagLabel> getTags() {
        return this.tags;
    }

    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTags(@Nullable List<TagLabel> tags) {
        this.tags = tags;
    }

    public File version(@Nullable Double version) {
        this.version = version;
        return this;
    }

    @Nullable
    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVersion(@Nullable Double version) {
        this.version = version;
    }

    public File updatedAt(@Nullable Long updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Nullable
    @JsonProperty(value="updatedAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="updatedAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUpdatedAt(@Nullable Long updatedAt) {
        this.updatedAt = updatedAt;
    }

    public File updatedBy(@Nullable String updatedBy) {
        this.updatedBy = updatedBy;
        return this;
    }

    @Nullable
    @JsonProperty(value="updatedBy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUpdatedBy() {
        return this.updatedBy;
    }

    @JsonProperty(value="updatedBy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUpdatedBy(@Nullable String updatedBy) {
        this.updatedBy = updatedBy;
    }

    public File changeDescription(@Nullable ChangeDescription changeDescription) {
        this.changeDescription = changeDescription;
        return this;
    }

    @Nullable
    @JsonProperty(value="changeDescription")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ChangeDescription getChangeDescription() {
        return this.changeDescription;
    }

    @JsonProperty(value="changeDescription")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChangeDescription(@Nullable ChangeDescription changeDescription) {
        this.changeDescription = changeDescription;
    }

    public File incrementalChangeDescription(@Nullable ChangeDescription incrementalChangeDescription) {
        this.incrementalChangeDescription = incrementalChangeDescription;
        return this;
    }

    @Nullable
    @JsonProperty(value="incrementalChangeDescription")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ChangeDescription getIncrementalChangeDescription() {
        return this.incrementalChangeDescription;
    }

    @JsonProperty(value="incrementalChangeDescription")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIncrementalChangeDescription(@Nullable ChangeDescription incrementalChangeDescription) {
        this.incrementalChangeDescription = incrementalChangeDescription;
    }

    public File deleted(@Nullable Boolean deleted) {
        this.deleted = deleted;
        return this;
    }

    @Nullable
    @JsonProperty(value="deleted")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getDeleted() {
        return this.deleted;
    }

    @JsonProperty(value="deleted")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeleted(@Nullable Boolean deleted) {
        this.deleted = deleted;
    }

    public File domains(@Nullable List<EntityReference> domains) {
        this.domains = domains;
        return this;
    }

    public File addDomainsItem(EntityReference domainsItem) {
        if (this.domains == null) {
            this.domains = new ArrayList<EntityReference>();
        }
        this.domains.add(domainsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="domains")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getDomains() {
        return this.domains;
    }

    @JsonProperty(value="domains")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDomains(@Nullable List<EntityReference> domains) {
        this.domains = domains;
    }

    public File dataProducts(@Nullable List<EntityReference> dataProducts) {
        this.dataProducts = dataProducts;
        return this;
    }

    public File addDataProductsItem(EntityReference dataProductsItem) {
        if (this.dataProducts == null) {
            this.dataProducts = new ArrayList<EntityReference>();
        }
        this.dataProducts.add(dataProductsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="dataProducts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getDataProducts() {
        return this.dataProducts;
    }

    @JsonProperty(value="dataProducts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDataProducts(@Nullable List<EntityReference> dataProducts) {
        this.dataProducts = dataProducts;
    }

    public File lifeCycle(@Nullable LifeCycle lifeCycle) {
        this.lifeCycle = lifeCycle;
        return this;
    }

    @Nullable
    @JsonProperty(value="lifeCycle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LifeCycle getLifeCycle() {
        return this.lifeCycle;
    }

    @JsonProperty(value="lifeCycle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLifeCycle(@Nullable LifeCycle lifeCycle) {
        this.lifeCycle = lifeCycle;
    }

    public File sourceHash(@Nullable String sourceHash) {
        this.sourceHash = sourceHash;
        return this;
    }

    @Nullable
    @JsonProperty(value="sourceHash")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSourceHash() {
        return this.sourceHash;
    }

    @JsonProperty(value="sourceHash")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSourceHash(@Nullable String sourceHash) {
        this.sourceHash = sourceHash;
    }

    public File extension(@Nullable Object extension) {
        this.extension = extension;
        return this;
    }

    @Nullable
    @JsonProperty(value="extension")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getExtension() {
        return this.extension;
    }

    @JsonProperty(value="extension")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExtension(@Nullable Object extension) {
        this.extension = extension;
    }

    public File votes(@Nullable Votes votes) {
        this.votes = votes;
        return this;
    }

    @Nullable
    @JsonProperty(value="votes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Votes getVotes() {
        return this.votes;
    }

    @JsonProperty(value="votes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVotes(@Nullable Votes votes) {
        this.votes = votes;
    }

    public File certification(@Nullable AssetCertification certification) {
        this.certification = certification;
        return this;
    }

    @Nullable
    @JsonProperty(value="certification")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AssetCertification getCertification() {
        return this.certification;
    }

    @JsonProperty(value="certification")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCertification(@Nullable AssetCertification certification) {
        this.certification = certification;
    }

    public File usageSummary(@Nullable UsageDetails usageSummary) {
        this.usageSummary = usageSummary;
        return this;
    }

    @Nullable
    @JsonProperty(value="usageSummary")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UsageDetails getUsageSummary() {
        return this.usageSummary;
    }

    @JsonProperty(value="usageSummary")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUsageSummary(@Nullable UsageDetails usageSummary) {
        this.usageSummary = usageSummary;
    }

    public File entityStatus(@Nullable EntityStatusEnum entityStatus) {
        this.entityStatus = entityStatus;
        return this;
    }

    @Nullable
    @JsonProperty(value="entityStatus")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EntityStatusEnum getEntityStatus() {
        return this.entityStatus;
    }

    @JsonProperty(value="entityStatus")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEntityStatus(@Nullable EntityStatusEnum entityStatus) {
        this.entityStatus = entityStatus;
    }

    public File reviewers(@Nullable List<EntityReference> reviewers) {
        this.reviewers = reviewers;
        return this;
    }

    public File addReviewersItem(EntityReference reviewersItem) {
        if (this.reviewers == null) {
            this.reviewers = new ArrayList<EntityReference>();
        }
        this.reviewers.add(reviewersItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="reviewers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getReviewers() {
        return this.reviewers;
    }

    @JsonProperty(value="reviewers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReviewers(@Nullable List<EntityReference> reviewers) {
        this.reviewers = reviewers;
    }

    public File experts(@Nullable List<EntityReference> experts) {
        this.experts = experts;
        return this;
    }

    public File addExpertsItem(EntityReference expertsItem) {
        if (this.experts == null) {
            this.experts = new ArrayList<EntityReference>();
        }
        this.experts.add(expertsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="experts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getExperts() {
        return this.experts;
    }

    @JsonProperty(value="experts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExperts(@Nullable List<EntityReference> experts) {
        this.experts = experts;
    }

    public File style(@Nullable Style style) {
        this.style = style;
        return this;
    }

    @Nullable
    @JsonProperty(value="style")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Style getStyle() {
        return this.style;
    }

    @JsonProperty(value="style")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStyle(@Nullable Style style) {
        this.style = style;
    }

    public File provider(@Nullable ProviderEnum provider) {
        this.provider = provider;
        return this;
    }

    @Nullable
    @JsonProperty(value="provider")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ProviderEnum getProvider() {
        return this.provider;
    }

    @JsonProperty(value="provider")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProvider(@Nullable ProviderEnum provider) {
        this.provider = provider;
    }

    public File children(@Nullable List<EntityReference> children) {
        this.children = children;
        return this;
    }

    public File addChildrenItem(EntityReference childrenItem) {
        if (this.children == null) {
            this.children = new ArrayList<EntityReference>();
        }
        this.children.add(childrenItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="children")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getChildren() {
        return this.children;
    }

    @JsonProperty(value="children")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChildren(@Nullable List<EntityReference> children) {
        this.children = children;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        File file = (File)o;
        return Objects.equals(this.id, file.id) && Objects.equals(this.name, file.name) && Objects.equals(this.fullyQualifiedName, file.fullyQualifiedName) && Objects.equals(this.displayName, file.displayName) && Objects.equals(this.description, file.description) && Objects.equals(this.service, file.service) && Objects.equals((Object)this.serviceType, (Object)file.serviceType) && Objects.equals(this.directory, file.directory) && Objects.equals((Object)this.fileType, (Object)file.fileType) && Objects.equals(this.mimeType, file.mimeType) && Objects.equals(this.fileExtension, file.fileExtension) && Objects.equals(this.path, file.path) && Objects.equals(this.size, file.size) && Objects.equals(this.checksum, file.checksum) && Objects.equals(this.webViewLink, file.webViewLink) && Objects.equals(this.downloadLink, file.downloadLink) && Objects.equals(this.isShared, file.isShared) && Objects.equals(this.fileVersion, file.fileVersion) && Objects.equals(this.createdTime, file.createdTime) && Objects.equals(this.modifiedTime, file.modifiedTime) && Objects.equals(this.lastModifiedBy, file.lastModifiedBy) && Objects.equals(this.sourceUrl, file.sourceUrl) && Objects.equals(this.href, file.href) && Objects.equals(this.owners, file.owners) && Objects.equals(this.followers, file.followers) && Objects.equals(this.tags, file.tags) && Objects.equals(this.version, file.version) && Objects.equals(this.updatedAt, file.updatedAt) && Objects.equals(this.updatedBy, file.updatedBy) && Objects.equals(this.changeDescription, file.changeDescription) && Objects.equals(this.incrementalChangeDescription, file.incrementalChangeDescription) && Objects.equals(this.deleted, file.deleted) && Objects.equals(this.domains, file.domains) && Objects.equals(this.dataProducts, file.dataProducts) && Objects.equals(this.lifeCycle, file.lifeCycle) && Objects.equals(this.sourceHash, file.sourceHash) && Objects.equals(this.extension, file.extension) && Objects.equals(this.votes, file.votes) && Objects.equals(this.certification, file.certification) && Objects.equals(this.usageSummary, file.usageSummary) && Objects.equals((Object)this.entityStatus, (Object)file.entityStatus) && Objects.equals(this.reviewers, file.reviewers) && Objects.equals(this.experts, file.experts) && Objects.equals(this.style, file.style) && Objects.equals((Object)this.provider, (Object)file.provider) && Objects.equals(this.children, file.children);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.fullyQualifiedName, this.displayName, this.description, this.service, this.serviceType, this.directory, this.fileType, this.mimeType, this.fileExtension, this.path, this.size, this.checksum, this.webViewLink, this.downloadLink, this.isShared, this.fileVersion, this.createdTime, this.modifiedTime, this.lastModifiedBy, this.sourceUrl, this.href, this.owners, this.followers, this.tags, this.version, this.updatedAt, this.updatedBy, this.changeDescription, this.incrementalChangeDescription, this.deleted, this.domains, this.dataProducts, this.lifeCycle, this.sourceHash, this.extension, this.votes, this.certification, this.usageSummary, this.entityStatus, this.reviewers, this.experts, this.style, this.provider, this.children});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class File {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    fullyQualifiedName: ").append(this.toIndentedString(this.fullyQualifiedName)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    service: ").append(this.toIndentedString(this.service)).append("\n");
        sb.append("    serviceType: ").append(this.toIndentedString((Object)this.serviceType)).append("\n");
        sb.append("    directory: ").append(this.toIndentedString(this.directory)).append("\n");
        sb.append("    fileType: ").append(this.toIndentedString((Object)this.fileType)).append("\n");
        sb.append("    mimeType: ").append(this.toIndentedString(this.mimeType)).append("\n");
        sb.append("    fileExtension: ").append(this.toIndentedString(this.fileExtension)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    checksum: ").append(this.toIndentedString(this.checksum)).append("\n");
        sb.append("    webViewLink: ").append(this.toIndentedString(this.webViewLink)).append("\n");
        sb.append("    downloadLink: ").append(this.toIndentedString(this.downloadLink)).append("\n");
        sb.append("    isShared: ").append(this.toIndentedString(this.isShared)).append("\n");
        sb.append("    fileVersion: ").append(this.toIndentedString(this.fileVersion)).append("\n");
        sb.append("    createdTime: ").append(this.toIndentedString(this.createdTime)).append("\n");
        sb.append("    modifiedTime: ").append(this.toIndentedString(this.modifiedTime)).append("\n");
        sb.append("    lastModifiedBy: ").append(this.toIndentedString(this.lastModifiedBy)).append("\n");
        sb.append("    sourceUrl: ").append(this.toIndentedString(this.sourceUrl)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    owners: ").append(this.toIndentedString(this.owners)).append("\n");
        sb.append("    followers: ").append(this.toIndentedString(this.followers)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    updatedBy: ").append(this.toIndentedString(this.updatedBy)).append("\n");
        sb.append("    changeDescription: ").append(this.toIndentedString(this.changeDescription)).append("\n");
        sb.append("    incrementalChangeDescription: ").append(this.toIndentedString(this.incrementalChangeDescription)).append("\n");
        sb.append("    deleted: ").append(this.toIndentedString(this.deleted)).append("\n");
        sb.append("    domains: ").append(this.toIndentedString(this.domains)).append("\n");
        sb.append("    dataProducts: ").append(this.toIndentedString(this.dataProducts)).append("\n");
        sb.append("    lifeCycle: ").append(this.toIndentedString(this.lifeCycle)).append("\n");
        sb.append("    sourceHash: ").append(this.toIndentedString(this.sourceHash)).append("\n");
        sb.append("    extension: ").append(this.toIndentedString(this.extension)).append("\n");
        sb.append("    votes: ").append(this.toIndentedString(this.votes)).append("\n");
        sb.append("    certification: ").append(this.toIndentedString(this.certification)).append("\n");
        sb.append("    usageSummary: ").append(this.toIndentedString(this.usageSummary)).append("\n");
        sb.append("    entityStatus: ").append(this.toIndentedString((Object)this.entityStatus)).append("\n");
        sb.append("    reviewers: ").append(this.toIndentedString(this.reviewers)).append("\n");
        sb.append("    experts: ").append(this.toIndentedString(this.experts)).append("\n");
        sb.append("    style: ").append(this.toIndentedString(this.style)).append("\n");
        sb.append("    provider: ").append(this.toIndentedString((Object)this.provider)).append("\n");
        sb.append("    children: ").append(this.toIndentedString(this.children)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ServiceTypeEnum {
        GOOGLE_DRIVE(String.valueOf("GoogleDrive")),
        SHARE_POINT(String.valueOf("SharePoint")),
        CUSTOM_DRIVE(String.valueOf("CustomDrive"));

        private String value;

        private ServiceTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ServiceTypeEnum fromValue(String value) {
            for (ServiceTypeEnum b : ServiceTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum FileTypeEnum {
        DOCUMENT(String.valueOf("Document")),
        SPREADSHEET(String.valueOf("Spreadsheet")),
        PRESENTATION(String.valueOf("Presentation")),
        IMAGE(String.valueOf("Image")),
        VIDEO(String.valueOf("Video")),
        AUDIO(String.valueOf("Audio")),
        PDF(String.valueOf("PDF")),
        ARCHIVE(String.valueOf("Archive")),
        CODE(String.valueOf("Code")),
        DATA(String.valueOf("Data")),
        CSV(String.valueOf("CSV")),
        TEXT(String.valueOf("Text")),
        OTHER(String.valueOf("Other"));

        private String value;

        private FileTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FileTypeEnum fromValue(String value) {
            for (FileTypeEnum b : FileTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum EntityStatusEnum {
        DRAFT(String.valueOf("Draft")),
        IN_REVIEW(String.valueOf("In Review")),
        APPROVED(String.valueOf("Approved")),
        DEPRECATED(String.valueOf("Deprecated")),
        REJECTED(String.valueOf("Rejected")),
        UNPROCESSED(String.valueOf("Unprocessed"));

        private String value;

        private EntityStatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static EntityStatusEnum fromValue(String value) {
            for (EntityStatusEnum b : EntityStatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ProviderEnum {
        SYSTEM(String.valueOf("system")),
        USER(String.valueOf("user")),
        AUTOMATION(String.valueOf("automation"));

        private String value;

        private ProviderEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ProviderEnum fromValue(String value) {
            for (ProviderEnum b : ProviderEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

