/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openmetadata.client.model.ParamAdditionalContext;

@JsonPropertyOrder(value={"name", "input", "description", "examples", "parameterInputType", "paramAdditionalContext"})
public class Function {
    public static final String JSON_PROPERTY_NAME = "name";
    @Nullable
    private String name;
    public static final String JSON_PROPERTY_INPUT = "input";
    @Nullable
    private String input;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    @Nullable
    private String description;
    public static final String JSON_PROPERTY_EXAMPLES = "examples";
    @Nullable
    private List<Object> examples = new ArrayList<Object>();
    public static final String JSON_PROPERTY_PARAMETER_INPUT_TYPE = "parameterInputType";
    @Nullable
    private ParameterInputTypeEnum parameterInputType;
    public static final String JSON_PROPERTY_PARAM_ADDITIONAL_CONTEXT = "paramAdditionalContext";
    @Nullable
    private ParamAdditionalContext paramAdditionalContext;

    public Function name(@Nullable String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(@Nullable String name) {
        this.name = name;
    }

    public Function input(@Nullable String input) {
        this.input = input;
        return this;
    }

    @Nullable
    @JsonProperty(value="input")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getInput() {
        return this.input;
    }

    @JsonProperty(value="input")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInput(@Nullable String input) {
        this.input = input;
    }

    public Function description(@Nullable String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    public Function examples(@Nullable List<Object> examples) {
        this.examples = examples;
        return this;
    }

    public Function addExamplesItem(Object examplesItem) {
        if (this.examples == null) {
            this.examples = new ArrayList<Object>();
        }
        this.examples.add(examplesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="examples")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Object> getExamples() {
        return this.examples;
    }

    @JsonProperty(value="examples")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExamples(@Nullable List<Object> examples) {
        this.examples = examples;
    }

    public Function parameterInputType(@Nullable ParameterInputTypeEnum parameterInputType) {
        this.parameterInputType = parameterInputType;
        return this;
    }

    @Nullable
    @JsonProperty(value="parameterInputType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ParameterInputTypeEnum getParameterInputType() {
        return this.parameterInputType;
    }

    @JsonProperty(value="parameterInputType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setParameterInputType(@Nullable ParameterInputTypeEnum parameterInputType) {
        this.parameterInputType = parameterInputType;
    }

    public Function paramAdditionalContext(@Nullable ParamAdditionalContext paramAdditionalContext) {
        this.paramAdditionalContext = paramAdditionalContext;
        return this;
    }

    @Nullable
    @JsonProperty(value="paramAdditionalContext")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ParamAdditionalContext getParamAdditionalContext() {
        return this.paramAdditionalContext;
    }

    @JsonProperty(value="paramAdditionalContext")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setParamAdditionalContext(@Nullable ParamAdditionalContext paramAdditionalContext) {
        this.paramAdditionalContext = paramAdditionalContext;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Function function = (Function)o;
        return Objects.equals(this.name, function.name) && Objects.equals(this.input, function.input) && Objects.equals(this.description, function.description) && Objects.equals(this.examples, function.examples) && Objects.equals((Object)this.parameterInputType, (Object)function.parameterInputType) && Objects.equals(this.paramAdditionalContext, function.paramAdditionalContext);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.input, this.description, this.examples, this.parameterInputType, this.paramAdditionalContext});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Function {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    input: ").append(this.toIndentedString(this.input)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    examples: ").append(this.toIndentedString(this.examples)).append("\n");
        sb.append("    parameterInputType: ").append(this.toIndentedString((Object)this.parameterInputType)).append("\n");
        sb.append("    paramAdditionalContext: ").append(this.toIndentedString(this.paramAdditionalContext)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ParameterInputTypeEnum {
        NOT_REQUIRED(String.valueOf("NotRequired")),
        ALL_INDEX_ELASTIC_SEARCH(String.valueOf("AllIndexElasticSearch")),
        SPECIFIC_INDEX_ELASTIC_SEARCH(String.valueOf("SpecificIndexElasticSearch")),
        READ_FROM_PARAM_CONTEXT(String.valueOf("ReadFromParamContext")),
        READ_FROM_PARAM_CONTEXT_PER_ENTITY(String.valueOf("ReadFromParamContextPerEntity"));

        private String value;

        private ParameterInputTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ParameterInputTypeEnum fromValue(String value) {
            for (ParameterInputTypeEnum b : ParameterInputTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

