/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openmetadata.client.model.Rule;

@JsonPropertyOrder(value={"operation", "access", "rule", "policy", "role"})
public class Permission {
    public static final String JSON_PROPERTY_OPERATION = "operation";
    @Nullable
    private OperationEnum operation;
    public static final String JSON_PROPERTY_ACCESS = "access";
    @Nullable
    private AccessEnum access;
    public static final String JSON_PROPERTY_RULE = "rule";
    @Nullable
    private Rule rule;
    public static final String JSON_PROPERTY_POLICY = "policy";
    @Nullable
    private String policy;
    public static final String JSON_PROPERTY_ROLE = "role";
    @Nullable
    private String role;

    public Permission operation(@Nullable OperationEnum operation) {
        this.operation = operation;
        return this;
    }

    @Nullable
    @JsonProperty(value="operation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OperationEnum getOperation() {
        return this.operation;
    }

    @JsonProperty(value="operation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOperation(@Nullable OperationEnum operation) {
        this.operation = operation;
    }

    public Permission access(@Nullable AccessEnum access) {
        this.access = access;
        return this;
    }

    @Nullable
    @JsonProperty(value="access")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AccessEnum getAccess() {
        return this.access;
    }

    @JsonProperty(value="access")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccess(@Nullable AccessEnum access) {
        this.access = access;
    }

    public Permission rule(@Nullable Rule rule) {
        this.rule = rule;
        return this;
    }

    @Nullable
    @JsonProperty(value="rule")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Rule getRule() {
        return this.rule;
    }

    @JsonProperty(value="rule")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRule(@Nullable Rule rule) {
        this.rule = rule;
    }

    public Permission policy(@Nullable String policy) {
        this.policy = policy;
        return this;
    }

    @Nullable
    @JsonProperty(value="policy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPolicy() {
        return this.policy;
    }

    @JsonProperty(value="policy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPolicy(@Nullable String policy) {
        this.policy = policy;
    }

    public Permission role(@Nullable String role) {
        this.role = role;
        return this;
    }

    @Nullable
    @JsonProperty(value="role")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRole() {
        return this.role;
    }

    @JsonProperty(value="role")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRole(@Nullable String role) {
        this.role = role;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Permission permission = (Permission)o;
        return Objects.equals((Object)this.operation, (Object)permission.operation) && Objects.equals((Object)this.access, (Object)permission.access) && Objects.equals(this.rule, permission.rule) && Objects.equals(this.policy, permission.policy) && Objects.equals(this.role, permission.role);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.operation, this.access, this.rule, this.policy, this.role});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Permission {\n");
        sb.append("    operation: ").append(this.toIndentedString((Object)this.operation)).append("\n");
        sb.append("    access: ").append(this.toIndentedString((Object)this.access)).append("\n");
        sb.append("    rule: ").append(this.toIndentedString(this.rule)).append("\n");
        sb.append("    policy: ").append(this.toIndentedString(this.policy)).append("\n");
        sb.append("    role: ").append(this.toIndentedString(this.role)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum OperationEnum {
        ALL(String.valueOf("All")),
        CREATE(String.valueOf("Create")),
        CREATE_INGESTION_PIPELINE_AUTOMATOR(String.valueOf("CreateIngestionPipelineAutomator")),
        DELETE(String.valueOf("Delete")),
        VIEW_ALL(String.valueOf("ViewAll")),
        VIEW_BASIC(String.valueOf("ViewBasic")),
        VIEW_USAGE(String.valueOf("ViewUsage")),
        VIEW_TESTS(String.valueOf("ViewTests")),
        VIEW_QUERIES(String.valueOf("ViewQueries")),
        VIEW_DATA_PROFILE(String.valueOf("ViewDataProfile")),
        VIEW_PROFILER_GLOBAL_CONFIGURATION(String.valueOf("ViewProfilerGlobalConfiguration")),
        VIEW_SAMPLE_DATA(String.valueOf("ViewSampleData")),
        VIEW_TEST_CASE_FAILED_ROWS_SAMPLE(String.valueOf("ViewTestCaseFailedRowsSample")),
        EDIT_ALL(String.valueOf("EditAll")),
        EDIT_CUSTOM_FIELDS(String.valueOf("EditCustomFields")),
        EDIT_DATA_PROFILE(String.valueOf("EditDataProfile")),
        EDIT_DESCRIPTION(String.valueOf("EditDescription")),
        EDIT_DISPLAY_NAME(String.valueOf("EditDisplayName")),
        EDIT_LINEAGE(String.valueOf("EditLineage")),
        EDIT_ENTITY_RELATIONSHIP(String.valueOf("EditEntityRelationship")),
        EDIT_POLICY(String.valueOf("EditPolicy")),
        EDIT_OWNERS(String.valueOf("EditOwners")),
        EDIT_QUERIES(String.valueOf("EditQueries")),
        EDIT_REVIEWERS(String.valueOf("EditReviewers")),
        EDIT_ROLE(String.valueOf("EditRole")),
        EDIT_SAMPLE_DATA(String.valueOf("EditSampleData")),
        EDIT_STATUS(String.valueOf("EditStatus")),
        EDIT_TAGS(String.valueOf("EditTags")),
        EDIT_GLOSSARY_TERMS(String.valueOf("EditGlossaryTerms")),
        EDIT_TEAMS(String.valueOf("EditTeams")),
        EDIT_TIER(String.valueOf("EditTier")),
        EDIT_CERTIFICATION(String.valueOf("EditCertification")),
        EDIT_TESTS(String.valueOf("EditTests")),
        EDIT_USAGE(String.valueOf("EditUsage")),
        EDIT_USERS(String.valueOf("EditUsers")),
        EDIT_LIFE_CYCLE(String.valueOf("EditLifeCycle")),
        EDIT_KNOWLEDGE_PANEL(String.valueOf("EditKnowledgePanel")),
        EDIT_PAGE(String.valueOf("EditPage")),
        EDIT_INGESTION_PIPELINE_STATUS(String.valueOf("EditIngestionPipelineStatus")),
        DELETE_TEST_CASE_FAILED_ROWS_SAMPLE(String.valueOf("DeleteTestCaseFailedRowsSample")),
        DEPLOY(String.valueOf("Deploy")),
        TRIGGER(String.valueOf("Trigger")),
        KILL(String.valueOf("Kill")),
        GENERATE_TOKEN(String.valueOf("GenerateToken")),
        EDIT_SCIM(String.valueOf("EditScim")),
        CREATE_SCIM(String.valueOf("CreateScim")),
        DELETE_SCIM(String.valueOf("DeleteScim")),
        VIEW_SCIM(String.valueOf("ViewScim"));

        private String value;

        private OperationEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static OperationEnum fromValue(String value) {
            for (OperationEnum b : OperationEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum AccessEnum {
        DENY(String.valueOf("deny")),
        ALLOW(String.valueOf("allow")),
        CONDITIONAL_DENY(String.valueOf("conditionalDeny")),
        CONDITIONAL_ALLOW(String.valueOf("conditionalAllow")),
        NOT_ALLOW(String.valueOf("notAllow"));

        private String value;

        private AccessEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AccessEnum fromValue(String value) {
            for (AccessEnum b : AccessEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

