/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openmetadata.client.model.DirectRolePermission;
import org.openmetadata.client.model.EntityReference;
import org.openmetadata.client.model.InheritedPermission;
import org.openmetadata.client.model.PermissionSummary;
import org.openmetadata.client.model.TeamPermission;

@JsonPropertyOrder(value={"user", "directRoles", "teamPermissions", "inheritedPermissions", "summary"})
public class PermissionDebugInfo {
    public static final String JSON_PROPERTY_USER = "user";
    @Nullable
    private EntityReference user;
    public static final String JSON_PROPERTY_DIRECT_ROLES = "directRoles";
    @Nullable
    private List<DirectRolePermission> directRoles = new ArrayList<DirectRolePermission>();
    public static final String JSON_PROPERTY_TEAM_PERMISSIONS = "teamPermissions";
    @Nullable
    private List<TeamPermission> teamPermissions = new ArrayList<TeamPermission>();
    public static final String JSON_PROPERTY_INHERITED_PERMISSIONS = "inheritedPermissions";
    @Nullable
    private List<InheritedPermission> inheritedPermissions = new ArrayList<InheritedPermission>();
    public static final String JSON_PROPERTY_SUMMARY = "summary";
    @Nullable
    private PermissionSummary summary;

    public PermissionDebugInfo user(@Nullable EntityReference user) {
        this.user = user;
        return this;
    }

    @Nullable
    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EntityReference getUser() {
        return this.user;
    }

    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUser(@Nullable EntityReference user) {
        this.user = user;
    }

    public PermissionDebugInfo directRoles(@Nullable List<DirectRolePermission> directRoles) {
        this.directRoles = directRoles;
        return this;
    }

    public PermissionDebugInfo addDirectRolesItem(DirectRolePermission directRolesItem) {
        if (this.directRoles == null) {
            this.directRoles = new ArrayList<DirectRolePermission>();
        }
        this.directRoles.add(directRolesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="directRoles")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<DirectRolePermission> getDirectRoles() {
        return this.directRoles;
    }

    @JsonProperty(value="directRoles")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDirectRoles(@Nullable List<DirectRolePermission> directRoles) {
        this.directRoles = directRoles;
    }

    public PermissionDebugInfo teamPermissions(@Nullable List<TeamPermission> teamPermissions) {
        this.teamPermissions = teamPermissions;
        return this;
    }

    public PermissionDebugInfo addTeamPermissionsItem(TeamPermission teamPermissionsItem) {
        if (this.teamPermissions == null) {
            this.teamPermissions = new ArrayList<TeamPermission>();
        }
        this.teamPermissions.add(teamPermissionsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="teamPermissions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TeamPermission> getTeamPermissions() {
        return this.teamPermissions;
    }

    @JsonProperty(value="teamPermissions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTeamPermissions(@Nullable List<TeamPermission> teamPermissions) {
        this.teamPermissions = teamPermissions;
    }

    public PermissionDebugInfo inheritedPermissions(@Nullable List<InheritedPermission> inheritedPermissions) {
        this.inheritedPermissions = inheritedPermissions;
        return this;
    }

    public PermissionDebugInfo addInheritedPermissionsItem(InheritedPermission inheritedPermissionsItem) {
        if (this.inheritedPermissions == null) {
            this.inheritedPermissions = new ArrayList<InheritedPermission>();
        }
        this.inheritedPermissions.add(inheritedPermissionsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="inheritedPermissions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<InheritedPermission> getInheritedPermissions() {
        return this.inheritedPermissions;
    }

    @JsonProperty(value="inheritedPermissions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInheritedPermissions(@Nullable List<InheritedPermission> inheritedPermissions) {
        this.inheritedPermissions = inheritedPermissions;
    }

    public PermissionDebugInfo summary(@Nullable PermissionSummary summary) {
        this.summary = summary;
        return this;
    }

    @Nullable
    @JsonProperty(value="summary")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PermissionSummary getSummary() {
        return this.summary;
    }

    @JsonProperty(value="summary")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSummary(@Nullable PermissionSummary summary) {
        this.summary = summary;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PermissionDebugInfo permissionDebugInfo = (PermissionDebugInfo)o;
        return Objects.equals(this.user, permissionDebugInfo.user) && Objects.equals(this.directRoles, permissionDebugInfo.directRoles) && Objects.equals(this.teamPermissions, permissionDebugInfo.teamPermissions) && Objects.equals(this.inheritedPermissions, permissionDebugInfo.inheritedPermissions) && Objects.equals(this.summary, permissionDebugInfo.summary);
    }

    public int hashCode() {
        return Objects.hash(this.user, this.directRoles, this.teamPermissions, this.inheritedPermissions, this.summary);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PermissionDebugInfo {\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    directRoles: ").append(this.toIndentedString(this.directRoles)).append("\n");
        sb.append("    teamPermissions: ").append(this.toIndentedString(this.teamPermissions)).append("\n");
        sb.append("    inheritedPermissions: ").append(this.toIndentedString(this.inheritedPermissions)).append("\n");
        sb.append("    summary: ").append(this.toIndentedString(this.summary)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

