/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.model.AssetCertification;
import org.openmetadata.client.model.ChangeDescription;
import org.openmetadata.client.model.EntityReference;
import org.openmetadata.client.model.LifeCycle;
import org.openmetadata.client.model.PipelineConnection;
import org.openmetadata.client.model.Style;
import org.openmetadata.client.model.TagLabel;
import org.openmetadata.client.model.TestConnectionResult;
import org.openmetadata.client.model.UsageDetails;
import org.openmetadata.client.model.Votes;

@JsonPropertyOrder(value={"id", "name", "fullyQualifiedName", "serviceType", "description", "displayName", "version", "updatedAt", "updatedBy", "testConnectionResult", "tags", "pipelines", "connection", "owners", "href", "changeDescription", "incrementalChangeDescription", "deleted", "dataProducts", "followers", "domains", "ingestionRunner", "votes", "lifeCycle", "certification", "entityStatus", "usageSummary", "reviewers", "experts", "style", "provider", "extension", "children", "service"})
public class PipelineService {
    public static final String JSON_PROPERTY_ID = "id";
    @Nonnull
    private UUID id;
    public static final String JSON_PROPERTY_NAME = "name";
    @Nonnull
    private String name;
    public static final String JSON_PROPERTY_FULLY_QUALIFIED_NAME = "fullyQualifiedName";
    @Nullable
    private String fullyQualifiedName;
    public static final String JSON_PROPERTY_SERVICE_TYPE = "serviceType";
    @Nonnull
    private ServiceTypeEnum serviceType;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    @Nullable
    private String description;
    public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
    @Nullable
    private String displayName;
    public static final String JSON_PROPERTY_VERSION = "version";
    @Nullable
    private Double version;
    public static final String JSON_PROPERTY_UPDATED_AT = "updatedAt";
    @Nullable
    private Long updatedAt;
    public static final String JSON_PROPERTY_UPDATED_BY = "updatedBy";
    @Nullable
    private String updatedBy;
    public static final String JSON_PROPERTY_TEST_CONNECTION_RESULT = "testConnectionResult";
    @Nullable
    private TestConnectionResult testConnectionResult;
    public static final String JSON_PROPERTY_TAGS = "tags";
    @Nullable
    private List<TagLabel> tags = new ArrayList<TagLabel>();
    public static final String JSON_PROPERTY_PIPELINES = "pipelines";
    @Nullable
    private List<EntityReference> pipelines = new ArrayList<EntityReference>();
    public static final String JSON_PROPERTY_CONNECTION = "connection";
    @Nullable
    private PipelineConnection connection;
    public static final String JSON_PROPERTY_OWNERS = "owners";
    @Nullable
    private List<EntityReference> owners = new ArrayList<EntityReference>();
    public static final String JSON_PROPERTY_HREF = "href";
    @Nullable
    private URI href;
    public static final String JSON_PROPERTY_CHANGE_DESCRIPTION = "changeDescription";
    @Nullable
    private ChangeDescription changeDescription;
    public static final String JSON_PROPERTY_INCREMENTAL_CHANGE_DESCRIPTION = "incrementalChangeDescription";
    @Nullable
    private ChangeDescription incrementalChangeDescription;
    public static final String JSON_PROPERTY_DELETED = "deleted";
    @Nullable
    private Boolean deleted;
    public static final String JSON_PROPERTY_DATA_PRODUCTS = "dataProducts";
    @Nullable
    private List<EntityReference> dataProducts = new ArrayList<EntityReference>();
    public static final String JSON_PROPERTY_FOLLOWERS = "followers";
    @Nullable
    private List<EntityReference> followers = new ArrayList<EntityReference>();
    public static final String JSON_PROPERTY_DOMAINS = "domains";
    @Nullable
    private List<EntityReference> domains = new ArrayList<EntityReference>();
    public static final String JSON_PROPERTY_INGESTION_RUNNER = "ingestionRunner";
    @Nullable
    private EntityReference ingestionRunner;
    public static final String JSON_PROPERTY_VOTES = "votes";
    @Nullable
    private Votes votes;
    public static final String JSON_PROPERTY_LIFE_CYCLE = "lifeCycle";
    @Nullable
    private LifeCycle lifeCycle;
    public static final String JSON_PROPERTY_CERTIFICATION = "certification";
    @Nullable
    private AssetCertification certification;
    public static final String JSON_PROPERTY_ENTITY_STATUS = "entityStatus";
    @Nullable
    private EntityStatusEnum entityStatus;
    public static final String JSON_PROPERTY_USAGE_SUMMARY = "usageSummary";
    @Nullable
    private UsageDetails usageSummary;
    public static final String JSON_PROPERTY_REVIEWERS = "reviewers";
    @Nullable
    private List<EntityReference> reviewers = new ArrayList<EntityReference>();
    public static final String JSON_PROPERTY_EXPERTS = "experts";
    @Nullable
    private List<EntityReference> experts = new ArrayList<EntityReference>();
    public static final String JSON_PROPERTY_STYLE = "style";
    @Nullable
    private Style style;
    public static final String JSON_PROPERTY_PROVIDER = "provider";
    @Nullable
    private ProviderEnum provider;
    public static final String JSON_PROPERTY_EXTENSION = "extension";
    @Nullable
    private Object extension;
    public static final String JSON_PROPERTY_CHILDREN = "children";
    @Nullable
    private List<EntityReference> children = new ArrayList<EntityReference>();
    public static final String JSON_PROPERTY_SERVICE = "service";
    @Nullable
    private EntityReference service;

    public PipelineService id(@Nonnull UUID id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setId(@Nonnull UUID id) {
        this.id = id;
    }

    public PipelineService name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public PipelineService fullyQualifiedName(@Nullable String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
        return this;
    }

    @Nullable
    @JsonProperty(value="fullyQualifiedName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    @JsonProperty(value="fullyQualifiedName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFullyQualifiedName(@Nullable String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
    }

    public PipelineService serviceType(@Nonnull ServiceTypeEnum serviceType) {
        this.serviceType = serviceType;
        return this;
    }

    @Nonnull
    @JsonProperty(value="serviceType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ServiceTypeEnum getServiceType() {
        return this.serviceType;
    }

    @JsonProperty(value="serviceType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setServiceType(@Nonnull ServiceTypeEnum serviceType) {
        this.serviceType = serviceType;
    }

    public PipelineService description(@Nullable String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    public PipelineService displayName(@Nullable String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Nullable
    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDisplayName(@Nullable String displayName) {
        this.displayName = displayName;
    }

    public PipelineService version(@Nullable Double version) {
        this.version = version;
        return this;
    }

    @Nullable
    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVersion(@Nullable Double version) {
        this.version = version;
    }

    public PipelineService updatedAt(@Nullable Long updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Nullable
    @JsonProperty(value="updatedAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="updatedAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUpdatedAt(@Nullable Long updatedAt) {
        this.updatedAt = updatedAt;
    }

    public PipelineService updatedBy(@Nullable String updatedBy) {
        this.updatedBy = updatedBy;
        return this;
    }

    @Nullable
    @JsonProperty(value="updatedBy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUpdatedBy() {
        return this.updatedBy;
    }

    @JsonProperty(value="updatedBy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUpdatedBy(@Nullable String updatedBy) {
        this.updatedBy = updatedBy;
    }

    public PipelineService testConnectionResult(@Nullable TestConnectionResult testConnectionResult) {
        this.testConnectionResult = testConnectionResult;
        return this;
    }

    @Nullable
    @JsonProperty(value="testConnectionResult")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TestConnectionResult getTestConnectionResult() {
        return this.testConnectionResult;
    }

    @JsonProperty(value="testConnectionResult")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTestConnectionResult(@Nullable TestConnectionResult testConnectionResult) {
        this.testConnectionResult = testConnectionResult;
    }

    public PipelineService tags(@Nullable List<TagLabel> tags) {
        this.tags = tags;
        return this;
    }

    public PipelineService addTagsItem(TagLabel tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<TagLabel>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TagLabel> getTags() {
        return this.tags;
    }

    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTags(@Nullable List<TagLabel> tags) {
        this.tags = tags;
    }

    public PipelineService pipelines(@Nullable List<EntityReference> pipelines) {
        this.pipelines = pipelines;
        return this;
    }

    public PipelineService addPipelinesItem(EntityReference pipelinesItem) {
        if (this.pipelines == null) {
            this.pipelines = new ArrayList<EntityReference>();
        }
        this.pipelines.add(pipelinesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="pipelines")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getPipelines() {
        return this.pipelines;
    }

    @JsonProperty(value="pipelines")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPipelines(@Nullable List<EntityReference> pipelines) {
        this.pipelines = pipelines;
    }

    public PipelineService connection(@Nullable PipelineConnection connection) {
        this.connection = connection;
        return this;
    }

    @Nullable
    @JsonProperty(value="connection")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PipelineConnection getConnection() {
        return this.connection;
    }

    @JsonProperty(value="connection")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setConnection(@Nullable PipelineConnection connection) {
        this.connection = connection;
    }

    public PipelineService owners(@Nullable List<EntityReference> owners) {
        this.owners = owners;
        return this;
    }

    public PipelineService addOwnersItem(EntityReference ownersItem) {
        if (this.owners == null) {
            this.owners = new ArrayList<EntityReference>();
        }
        this.owners.add(ownersItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="owners")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getOwners() {
        return this.owners;
    }

    @JsonProperty(value="owners")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOwners(@Nullable List<EntityReference> owners) {
        this.owners = owners;
    }

    public PipelineService href(@Nullable URI href) {
        this.href = href;
        return this;
    }

    @Nullable
    @JsonProperty(value="href")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public URI getHref() {
        return this.href;
    }

    @JsonProperty(value="href")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHref(@Nullable URI href) {
        this.href = href;
    }

    public PipelineService changeDescription(@Nullable ChangeDescription changeDescription) {
        this.changeDescription = changeDescription;
        return this;
    }

    @Nullable
    @JsonProperty(value="changeDescription")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ChangeDescription getChangeDescription() {
        return this.changeDescription;
    }

    @JsonProperty(value="changeDescription")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChangeDescription(@Nullable ChangeDescription changeDescription) {
        this.changeDescription = changeDescription;
    }

    public PipelineService incrementalChangeDescription(@Nullable ChangeDescription incrementalChangeDescription) {
        this.incrementalChangeDescription = incrementalChangeDescription;
        return this;
    }

    @Nullable
    @JsonProperty(value="incrementalChangeDescription")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ChangeDescription getIncrementalChangeDescription() {
        return this.incrementalChangeDescription;
    }

    @JsonProperty(value="incrementalChangeDescription")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIncrementalChangeDescription(@Nullable ChangeDescription incrementalChangeDescription) {
        this.incrementalChangeDescription = incrementalChangeDescription;
    }

    public PipelineService deleted(@Nullable Boolean deleted) {
        this.deleted = deleted;
        return this;
    }

    @Nullable
    @JsonProperty(value="deleted")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getDeleted() {
        return this.deleted;
    }

    @JsonProperty(value="deleted")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeleted(@Nullable Boolean deleted) {
        this.deleted = deleted;
    }

    public PipelineService dataProducts(@Nullable List<EntityReference> dataProducts) {
        this.dataProducts = dataProducts;
        return this;
    }

    public PipelineService addDataProductsItem(EntityReference dataProductsItem) {
        if (this.dataProducts == null) {
            this.dataProducts = new ArrayList<EntityReference>();
        }
        this.dataProducts.add(dataProductsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="dataProducts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getDataProducts() {
        return this.dataProducts;
    }

    @JsonProperty(value="dataProducts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDataProducts(@Nullable List<EntityReference> dataProducts) {
        this.dataProducts = dataProducts;
    }

    public PipelineService followers(@Nullable List<EntityReference> followers) {
        this.followers = followers;
        return this;
    }

    public PipelineService addFollowersItem(EntityReference followersItem) {
        if (this.followers == null) {
            this.followers = new ArrayList<EntityReference>();
        }
        this.followers.add(followersItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="followers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getFollowers() {
        return this.followers;
    }

    @JsonProperty(value="followers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFollowers(@Nullable List<EntityReference> followers) {
        this.followers = followers;
    }

    public PipelineService domains(@Nullable List<EntityReference> domains) {
        this.domains = domains;
        return this;
    }

    public PipelineService addDomainsItem(EntityReference domainsItem) {
        if (this.domains == null) {
            this.domains = new ArrayList<EntityReference>();
        }
        this.domains.add(domainsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="domains")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getDomains() {
        return this.domains;
    }

    @JsonProperty(value="domains")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDomains(@Nullable List<EntityReference> domains) {
        this.domains = domains;
    }

    public PipelineService ingestionRunner(@Nullable EntityReference ingestionRunner) {
        this.ingestionRunner = ingestionRunner;
        return this;
    }

    @Nullable
    @JsonProperty(value="ingestionRunner")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EntityReference getIngestionRunner() {
        return this.ingestionRunner;
    }

    @JsonProperty(value="ingestionRunner")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIngestionRunner(@Nullable EntityReference ingestionRunner) {
        this.ingestionRunner = ingestionRunner;
    }

    public PipelineService votes(@Nullable Votes votes) {
        this.votes = votes;
        return this;
    }

    @Nullable
    @JsonProperty(value="votes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Votes getVotes() {
        return this.votes;
    }

    @JsonProperty(value="votes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVotes(@Nullable Votes votes) {
        this.votes = votes;
    }

    public PipelineService lifeCycle(@Nullable LifeCycle lifeCycle) {
        this.lifeCycle = lifeCycle;
        return this;
    }

    @Nullable
    @JsonProperty(value="lifeCycle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LifeCycle getLifeCycle() {
        return this.lifeCycle;
    }

    @JsonProperty(value="lifeCycle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLifeCycle(@Nullable LifeCycle lifeCycle) {
        this.lifeCycle = lifeCycle;
    }

    public PipelineService certification(@Nullable AssetCertification certification) {
        this.certification = certification;
        return this;
    }

    @Nullable
    @JsonProperty(value="certification")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AssetCertification getCertification() {
        return this.certification;
    }

    @JsonProperty(value="certification")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCertification(@Nullable AssetCertification certification) {
        this.certification = certification;
    }

    public PipelineService entityStatus(@Nullable EntityStatusEnum entityStatus) {
        this.entityStatus = entityStatus;
        return this;
    }

    @Nullable
    @JsonProperty(value="entityStatus")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EntityStatusEnum getEntityStatus() {
        return this.entityStatus;
    }

    @JsonProperty(value="entityStatus")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEntityStatus(@Nullable EntityStatusEnum entityStatus) {
        this.entityStatus = entityStatus;
    }

    public PipelineService usageSummary(@Nullable UsageDetails usageSummary) {
        this.usageSummary = usageSummary;
        return this;
    }

    @Nullable
    @JsonProperty(value="usageSummary")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UsageDetails getUsageSummary() {
        return this.usageSummary;
    }

    @JsonProperty(value="usageSummary")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUsageSummary(@Nullable UsageDetails usageSummary) {
        this.usageSummary = usageSummary;
    }

    public PipelineService reviewers(@Nullable List<EntityReference> reviewers) {
        this.reviewers = reviewers;
        return this;
    }

    public PipelineService addReviewersItem(EntityReference reviewersItem) {
        if (this.reviewers == null) {
            this.reviewers = new ArrayList<EntityReference>();
        }
        this.reviewers.add(reviewersItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="reviewers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getReviewers() {
        return this.reviewers;
    }

    @JsonProperty(value="reviewers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReviewers(@Nullable List<EntityReference> reviewers) {
        this.reviewers = reviewers;
    }

    public PipelineService experts(@Nullable List<EntityReference> experts) {
        this.experts = experts;
        return this;
    }

    public PipelineService addExpertsItem(EntityReference expertsItem) {
        if (this.experts == null) {
            this.experts = new ArrayList<EntityReference>();
        }
        this.experts.add(expertsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="experts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getExperts() {
        return this.experts;
    }

    @JsonProperty(value="experts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExperts(@Nullable List<EntityReference> experts) {
        this.experts = experts;
    }

    public PipelineService style(@Nullable Style style) {
        this.style = style;
        return this;
    }

    @Nullable
    @JsonProperty(value="style")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Style getStyle() {
        return this.style;
    }

    @JsonProperty(value="style")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStyle(@Nullable Style style) {
        this.style = style;
    }

    public PipelineService provider(@Nullable ProviderEnum provider) {
        this.provider = provider;
        return this;
    }

    @Nullable
    @JsonProperty(value="provider")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ProviderEnum getProvider() {
        return this.provider;
    }

    @JsonProperty(value="provider")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProvider(@Nullable ProviderEnum provider) {
        this.provider = provider;
    }

    public PipelineService extension(@Nullable Object extension) {
        this.extension = extension;
        return this;
    }

    @Nullable
    @JsonProperty(value="extension")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getExtension() {
        return this.extension;
    }

    @JsonProperty(value="extension")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExtension(@Nullable Object extension) {
        this.extension = extension;
    }

    public PipelineService children(@Nullable List<EntityReference> children) {
        this.children = children;
        return this;
    }

    public PipelineService addChildrenItem(EntityReference childrenItem) {
        if (this.children == null) {
            this.children = new ArrayList<EntityReference>();
        }
        this.children.add(childrenItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="children")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getChildren() {
        return this.children;
    }

    @JsonProperty(value="children")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChildren(@Nullable List<EntityReference> children) {
        this.children = children;
    }

    public PipelineService service(@Nullable EntityReference service) {
        this.service = service;
        return this;
    }

    @Nullable
    @JsonProperty(value="service")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EntityReference getService() {
        return this.service;
    }

    @JsonProperty(value="service")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setService(@Nullable EntityReference service) {
        this.service = service;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PipelineService pipelineService = (PipelineService)o;
        return Objects.equals(this.id, pipelineService.id) && Objects.equals(this.name, pipelineService.name) && Objects.equals(this.fullyQualifiedName, pipelineService.fullyQualifiedName) && Objects.equals((Object)this.serviceType, (Object)pipelineService.serviceType) && Objects.equals(this.description, pipelineService.description) && Objects.equals(this.displayName, pipelineService.displayName) && Objects.equals(this.version, pipelineService.version) && Objects.equals(this.updatedAt, pipelineService.updatedAt) && Objects.equals(this.updatedBy, pipelineService.updatedBy) && Objects.equals(this.testConnectionResult, pipelineService.testConnectionResult) && Objects.equals(this.tags, pipelineService.tags) && Objects.equals(this.pipelines, pipelineService.pipelines) && Objects.equals(this.connection, pipelineService.connection) && Objects.equals(this.owners, pipelineService.owners) && Objects.equals(this.href, pipelineService.href) && Objects.equals(this.changeDescription, pipelineService.changeDescription) && Objects.equals(this.incrementalChangeDescription, pipelineService.incrementalChangeDescription) && Objects.equals(this.deleted, pipelineService.deleted) && Objects.equals(this.dataProducts, pipelineService.dataProducts) && Objects.equals(this.followers, pipelineService.followers) && Objects.equals(this.domains, pipelineService.domains) && Objects.equals(this.ingestionRunner, pipelineService.ingestionRunner) && Objects.equals(this.votes, pipelineService.votes) && Objects.equals(this.lifeCycle, pipelineService.lifeCycle) && Objects.equals(this.certification, pipelineService.certification) && Objects.equals((Object)this.entityStatus, (Object)pipelineService.entityStatus) && Objects.equals(this.usageSummary, pipelineService.usageSummary) && Objects.equals(this.reviewers, pipelineService.reviewers) && Objects.equals(this.experts, pipelineService.experts) && Objects.equals(this.style, pipelineService.style) && Objects.equals((Object)this.provider, (Object)pipelineService.provider) && Objects.equals(this.extension, pipelineService.extension) && Objects.equals(this.children, pipelineService.children) && Objects.equals(this.service, pipelineService.service);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.fullyQualifiedName, this.serviceType, this.description, this.displayName, this.version, this.updatedAt, this.updatedBy, this.testConnectionResult, this.tags, this.pipelines, this.connection, this.owners, this.href, this.changeDescription, this.incrementalChangeDescription, this.deleted, this.dataProducts, this.followers, this.domains, this.ingestionRunner, this.votes, this.lifeCycle, this.certification, this.entityStatus, this.usageSummary, this.reviewers, this.experts, this.style, this.provider, this.extension, this.children, this.service});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PipelineService {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    fullyQualifiedName: ").append(this.toIndentedString(this.fullyQualifiedName)).append("\n");
        sb.append("    serviceType: ").append(this.toIndentedString((Object)this.serviceType)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    updatedBy: ").append(this.toIndentedString(this.updatedBy)).append("\n");
        sb.append("    testConnectionResult: ").append(this.toIndentedString(this.testConnectionResult)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    pipelines: ").append(this.toIndentedString(this.pipelines)).append("\n");
        sb.append("    connection: ").append(this.toIndentedString(this.connection)).append("\n");
        sb.append("    owners: ").append(this.toIndentedString(this.owners)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    changeDescription: ").append(this.toIndentedString(this.changeDescription)).append("\n");
        sb.append("    incrementalChangeDescription: ").append(this.toIndentedString(this.incrementalChangeDescription)).append("\n");
        sb.append("    deleted: ").append(this.toIndentedString(this.deleted)).append("\n");
        sb.append("    dataProducts: ").append(this.toIndentedString(this.dataProducts)).append("\n");
        sb.append("    followers: ").append(this.toIndentedString(this.followers)).append("\n");
        sb.append("    domains: ").append(this.toIndentedString(this.domains)).append("\n");
        sb.append("    ingestionRunner: ").append(this.toIndentedString(this.ingestionRunner)).append("\n");
        sb.append("    votes: ").append(this.toIndentedString(this.votes)).append("\n");
        sb.append("    lifeCycle: ").append(this.toIndentedString(this.lifeCycle)).append("\n");
        sb.append("    certification: ").append(this.toIndentedString(this.certification)).append("\n");
        sb.append("    entityStatus: ").append(this.toIndentedString((Object)this.entityStatus)).append("\n");
        sb.append("    usageSummary: ").append(this.toIndentedString(this.usageSummary)).append("\n");
        sb.append("    reviewers: ").append(this.toIndentedString(this.reviewers)).append("\n");
        sb.append("    experts: ").append(this.toIndentedString(this.experts)).append("\n");
        sb.append("    style: ").append(this.toIndentedString(this.style)).append("\n");
        sb.append("    provider: ").append(this.toIndentedString((Object)this.provider)).append("\n");
        sb.append("    extension: ").append(this.toIndentedString(this.extension)).append("\n");
        sb.append("    children: ").append(this.toIndentedString(this.children)).append("\n");
        sb.append("    service: ").append(this.toIndentedString(this.service)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ServiceTypeEnum {
        AIRFLOW(String.valueOf("Airflow")),
        GLUE_PIPELINE(String.valueOf("GluePipeline")),
        KINESIS_FIREHOSE(String.valueOf("KinesisFirehose")),
        AIRBYTE(String.valueOf("Airbyte")),
        FIVETRAN(String.valueOf("Fivetran")),
        FLINK(String.valueOf("Flink")),
        DAGSTER(String.valueOf("Dagster")),
        NIFI(String.valueOf("Nifi")),
        DOMO_PIPELINE(String.valueOf("DomoPipeline")),
        CUSTOM_PIPELINE(String.valueOf("CustomPipeline")),
        DATABRICKS_PIPELINE(String.valueOf("DatabricksPipeline")),
        SPLINE(String.valueOf("Spline")),
        SPARK(String.valueOf("Spark")),
        OPEN_LINEAGE(String.valueOf("OpenLineage")),
        KAFKA_CONNECT(String.valueOf("KafkaConnect")),
        DBT_CLOUD(String.valueOf("DBTCloud")),
        MATILLION(String.valueOf("Matillion")),
        STITCH(String.valueOf("Stitch")),
        DATA_FACTORY(String.valueOf("DataFactory")),
        WHERESCAPE(String.valueOf("Wherescape")),
        SSIS(String.valueOf("SSIS")),
        SNOWPLOW(String.valueOf("Snowplow"));

        private String value;

        private ServiceTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ServiceTypeEnum fromValue(String value) {
            for (ServiceTypeEnum b : ServiceTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum EntityStatusEnum {
        DRAFT(String.valueOf("Draft")),
        IN_REVIEW(String.valueOf("In Review")),
        APPROVED(String.valueOf("Approved")),
        DEPRECATED(String.valueOf("Deprecated")),
        REJECTED(String.valueOf("Rejected")),
        UNPROCESSED(String.valueOf("Unprocessed"));

        private String value;

        private EntityStatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static EntityStatusEnum fromValue(String value) {
            for (EntityStatusEnum b : EntityStatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ProviderEnum {
        SYSTEM(String.valueOf("system")),
        USER(String.valueOf("user")),
        AUTOMATION(String.valueOf("automation"));

        private String value;

        private ProviderEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ProviderEnum fromValue(String value) {
            for (ProviderEnum b : ProviderEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

