/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openmetadata.client.model.Suggestion;

@JsonPropertyOrder(value={"entity", "status", "changeType"})
public class PutResponseListSuggestion {
    public static final String JSON_PROPERTY_ENTITY = "entity";
    @Nullable
    private List<Suggestion> entity = new ArrayList<Suggestion>();
    public static final String JSON_PROPERTY_STATUS = "status";
    @Nullable
    private StatusEnum status;
    public static final String JSON_PROPERTY_CHANGE_TYPE = "changeType";
    @Nullable
    private ChangeTypeEnum changeType;

    public PutResponseListSuggestion entity(@Nullable List<Suggestion> entity) {
        this.entity = entity;
        return this;
    }

    public PutResponseListSuggestion addEntityItem(Suggestion entityItem) {
        if (this.entity == null) {
            this.entity = new ArrayList<Suggestion>();
        }
        this.entity.add(entityItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="entity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Suggestion> getEntity() {
        return this.entity;
    }

    @JsonProperty(value="entity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEntity(@Nullable List<Suggestion> entity) {
        this.entity = entity;
    }

    public PutResponseListSuggestion status(@Nullable StatusEnum status) {
        this.status = status;
        return this;
    }

    @Nullable
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(@Nullable StatusEnum status) {
        this.status = status;
    }

    public PutResponseListSuggestion changeType(@Nullable ChangeTypeEnum changeType) {
        this.changeType = changeType;
        return this;
    }

    @Nullable
    @JsonProperty(value="changeType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ChangeTypeEnum getChangeType() {
        return this.changeType;
    }

    @JsonProperty(value="changeType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChangeType(@Nullable ChangeTypeEnum changeType) {
        this.changeType = changeType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PutResponseListSuggestion putResponseListSuggestion = (PutResponseListSuggestion)o;
        return Objects.equals(this.entity, putResponseListSuggestion.entity) && Objects.equals((Object)this.status, (Object)putResponseListSuggestion.status) && Objects.equals((Object)this.changeType, (Object)putResponseListSuggestion.changeType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.entity, this.status, this.changeType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PutResponseListSuggestion {\n");
        sb.append("    entity: ").append(this.toIndentedString(this.entity)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    changeType: ").append(this.toIndentedString((Object)this.changeType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        OK(String.valueOf("OK")),
        CREATED(String.valueOf("Created")),
        ACCEPTED(String.valueOf("Accepted")),
        NO_CONTENT(String.valueOf("No Content")),
        RESET_CONTENT(String.valueOf("Reset Content")),
        PARTIAL_CONTENT(String.valueOf("Partial Content")),
        MULTIPLE_CHOICES(String.valueOf("Multiple Choices")),
        MOVED_PERMANENTLY(String.valueOf("Moved Permanently")),
        FOUND(String.valueOf("Found")),
        SEE_OTHER(String.valueOf("See Other")),
        NOT_MODIFIED(String.valueOf("Not Modified")),
        USE_PROXY(String.valueOf("Use Proxy")),
        TEMPORARY_REDIRECT(String.valueOf("Temporary Redirect")),
        PERMANENT_REDIRECT(String.valueOf("Permanent Redirect")),
        BAD_REQUEST(String.valueOf("Bad Request")),
        UNAUTHORIZED(String.valueOf("Unauthorized")),
        PAYMENT_REQUIRED(String.valueOf("Payment Required")),
        FORBIDDEN(String.valueOf("Forbidden")),
        NOT_FOUND(String.valueOf("Not Found")),
        METHOD_NOT_ALLOWED(String.valueOf("Method Not Allowed")),
        NOT_ACCEPTABLE(String.valueOf("Not Acceptable")),
        PROXY_AUTHENTICATION_REQUIRED(String.valueOf("Proxy Authentication Required")),
        REQUEST_TIMEOUT(String.valueOf("Request Timeout")),
        CONFLICT(String.valueOf("Conflict")),
        GONE(String.valueOf("Gone")),
        LENGTH_REQUIRED(String.valueOf("Length Required")),
        PRECONDITION_FAILED(String.valueOf("Precondition Failed")),
        REQUEST_ENTITY_TOO_LARGE(String.valueOf("Request Entity Too Large")),
        REQUEST_URI_TOO_LONG(String.valueOf("Request-URI Too Long")),
        UNSUPPORTED_MEDIA_TYPE(String.valueOf("Unsupported Media Type")),
        REQUESTED_RANGE_NOT_SATISFIABLE(String.valueOf("Requested Range Not Satisfiable")),
        EXPECTATION_FAILED(String.valueOf("Expectation Failed")),
        PRECONDITION_REQUIRED(String.valueOf("Precondition Required")),
        TOO_MANY_REQUESTS(String.valueOf("Too Many Requests")),
        REQUEST_HEADER_FIELDS_TOO_LARGE(String.valueOf("Request Header Fields Too Large")),
        UNAVAILABLE_FOR_LEGAL_REASONS(String.valueOf("Unavailable For Legal Reasons")),
        INTERNAL_SERVER_ERROR(String.valueOf("Internal Server Error")),
        NOT_IMPLEMENTED(String.valueOf("Not Implemented")),
        BAD_GATEWAY(String.valueOf("Bad Gateway")),
        SERVICE_UNAVAILABLE(String.valueOf("Service Unavailable")),
        GATEWAY_TIMEOUT(String.valueOf("Gateway Timeout")),
        HTTP_VERSION_NOT_SUPPORTED(String.valueOf("HTTP Version Not Supported")),
        NETWORK_AUTHENTICATION_REQUIRED(String.valueOf("Network Authentication Required"));

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ChangeTypeEnum {
        ENTITY_CREATED(String.valueOf("entityCreated")),
        ENTITY_UPDATED(String.valueOf("entityUpdated")),
        ENTITY_FIELDS_CHANGED(String.valueOf("entityFieldsChanged")),
        ENTITY_NO_CHANGE(String.valueOf("entityNoChange")),
        ENTITY_SOFT_DELETED(String.valueOf("entitySoftDeleted")),
        ENTITY_DELETED(String.valueOf("entityDeleted")),
        ENTITY_RESTORED(String.valueOf("entityRestored")),
        THREAD_CREATED(String.valueOf("threadCreated")),
        THREAD_UPDATED(String.valueOf("threadUpdated")),
        POST_CREATED(String.valueOf("postCreated")),
        POST_UPDATED(String.valueOf("postUpdated")),
        TASK_RESOLVED(String.valueOf("taskResolved")),
        TASK_CLOSED(String.valueOf("taskClosed")),
        LOGICAL_TEST_CASE_ADDED(String.valueOf("logicalTestCaseAdded")),
        SUGGESTION_CREATED(String.valueOf("suggestionCreated")),
        SUGGESTION_UPDATED(String.valueOf("suggestionUpdated")),
        SUGGESTION_ACCEPTED(String.valueOf("suggestionAccepted")),
        SUGGESTION_REJECTED(String.valueOf("suggestionRejected")),
        SUGGESTION_DELETED(String.valueOf("suggestionDeleted"));

        private String value;

        private ChangeTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ChangeTypeEnum fromValue(String value) {
            for (ChangeTypeEnum b : ChangeTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

