/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.model.EntityReference;
import org.openmetadata.client.model.RecognizerInfo;
import org.openmetadata.client.model.Resolution;

@JsonPropertyOrder(value={"id", "entityLink", "tagFQN", "feedbackType", "userReason", "userComments", "suggestedTag", "sampleValues", "recognizerInfo", "createdBy", "createdAt", "status", "resolution"})
public class RecognizerFeedback {
    public static final String JSON_PROPERTY_ID = "id";
    @Nullable
    private UUID id;
    public static final String JSON_PROPERTY_ENTITY_LINK = "entityLink";
    @Nonnull
    private String entityLink;
    public static final String JSON_PROPERTY_TAG_F_Q_N = "tagFQN";
    @Nonnull
    private String tagFQN;
    public static final String JSON_PROPERTY_FEEDBACK_TYPE = "feedbackType";
    @Nonnull
    private FeedbackTypeEnum feedbackType;
    public static final String JSON_PROPERTY_USER_REASON = "userReason";
    @Nullable
    private UserReasonEnum userReason;
    public static final String JSON_PROPERTY_USER_COMMENTS = "userComments";
    @Nullable
    private String userComments;
    public static final String JSON_PROPERTY_SUGGESTED_TAG = "suggestedTag";
    @Nullable
    private String suggestedTag;
    public static final String JSON_PROPERTY_SAMPLE_VALUES = "sampleValues";
    @Nullable
    private List<String> sampleValues = new ArrayList<String>();
    public static final String JSON_PROPERTY_RECOGNIZER_INFO = "recognizerInfo";
    @Nullable
    private RecognizerInfo recognizerInfo;
    public static final String JSON_PROPERTY_CREATED_BY = "createdBy";
    @Nullable
    private EntityReference createdBy;
    public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
    @Nullable
    private Long createdAt;
    public static final String JSON_PROPERTY_STATUS = "status";
    @Nullable
    private StatusEnum status;
    public static final String JSON_PROPERTY_RESOLUTION = "resolution";
    @Nullable
    private Resolution resolution;

    public RecognizerFeedback id(@Nullable UUID id) {
        this.id = id;
        return this;
    }

    @Nullable
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(@Nullable UUID id) {
        this.id = id;
    }

    public RecognizerFeedback entityLink(@Nonnull String entityLink) {
        this.entityLink = entityLink;
        return this;
    }

    @Nonnull
    @JsonProperty(value="entityLink")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getEntityLink() {
        return this.entityLink;
    }

    @JsonProperty(value="entityLink")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEntityLink(@Nonnull String entityLink) {
        this.entityLink = entityLink;
    }

    public RecognizerFeedback tagFQN(@Nonnull String tagFQN) {
        this.tagFQN = tagFQN;
        return this;
    }

    @Nonnull
    @JsonProperty(value="tagFQN")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getTagFQN() {
        return this.tagFQN;
    }

    @JsonProperty(value="tagFQN")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTagFQN(@Nonnull String tagFQN) {
        this.tagFQN = tagFQN;
    }

    public RecognizerFeedback feedbackType(@Nonnull FeedbackTypeEnum feedbackType) {
        this.feedbackType = feedbackType;
        return this;
    }

    @Nonnull
    @JsonProperty(value="feedbackType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public FeedbackTypeEnum getFeedbackType() {
        return this.feedbackType;
    }

    @JsonProperty(value="feedbackType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setFeedbackType(@Nonnull FeedbackTypeEnum feedbackType) {
        this.feedbackType = feedbackType;
    }

    public RecognizerFeedback userReason(@Nullable UserReasonEnum userReason) {
        this.userReason = userReason;
        return this;
    }

    @Nullable
    @JsonProperty(value="userReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UserReasonEnum getUserReason() {
        return this.userReason;
    }

    @JsonProperty(value="userReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserReason(@Nullable UserReasonEnum userReason) {
        this.userReason = userReason;
    }

    public RecognizerFeedback userComments(@Nullable String userComments) {
        this.userComments = userComments;
        return this;
    }

    @Nullable
    @JsonProperty(value="userComments")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUserComments() {
        return this.userComments;
    }

    @JsonProperty(value="userComments")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserComments(@Nullable String userComments) {
        this.userComments = userComments;
    }

    public RecognizerFeedback suggestedTag(@Nullable String suggestedTag) {
        this.suggestedTag = suggestedTag;
        return this;
    }

    @Nullable
    @JsonProperty(value="suggestedTag")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSuggestedTag() {
        return this.suggestedTag;
    }

    @JsonProperty(value="suggestedTag")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSuggestedTag(@Nullable String suggestedTag) {
        this.suggestedTag = suggestedTag;
    }

    public RecognizerFeedback sampleValues(@Nullable List<String> sampleValues) {
        this.sampleValues = sampleValues;
        return this;
    }

    public RecognizerFeedback addSampleValuesItem(String sampleValuesItem) {
        if (this.sampleValues == null) {
            this.sampleValues = new ArrayList<String>();
        }
        this.sampleValues.add(sampleValuesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="sampleValues")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getSampleValues() {
        return this.sampleValues;
    }

    @JsonProperty(value="sampleValues")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSampleValues(@Nullable List<String> sampleValues) {
        this.sampleValues = sampleValues;
    }

    public RecognizerFeedback recognizerInfo(@Nullable RecognizerInfo recognizerInfo) {
        this.recognizerInfo = recognizerInfo;
        return this;
    }

    @Nullable
    @JsonProperty(value="recognizerInfo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RecognizerInfo getRecognizerInfo() {
        return this.recognizerInfo;
    }

    @JsonProperty(value="recognizerInfo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRecognizerInfo(@Nullable RecognizerInfo recognizerInfo) {
        this.recognizerInfo = recognizerInfo;
    }

    public RecognizerFeedback createdBy(@Nullable EntityReference createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @Nullable
    @JsonProperty(value="createdBy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EntityReference getCreatedBy() {
        return this.createdBy;
    }

    @JsonProperty(value="createdBy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedBy(@Nullable EntityReference createdBy) {
        this.createdBy = createdBy;
    }

    public RecognizerFeedback createdAt(@Nullable Long createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    @JsonProperty(value="createdAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="createdAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedAt(@Nullable Long createdAt) {
        this.createdAt = createdAt;
    }

    public RecognizerFeedback status(@Nullable StatusEnum status) {
        this.status = status;
        return this;
    }

    @Nullable
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(@Nullable StatusEnum status) {
        this.status = status;
    }

    public RecognizerFeedback resolution(@Nullable Resolution resolution) {
        this.resolution = resolution;
        return this;
    }

    @Nullable
    @JsonProperty(value="resolution")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Resolution getResolution() {
        return this.resolution;
    }

    @JsonProperty(value="resolution")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResolution(@Nullable Resolution resolution) {
        this.resolution = resolution;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecognizerFeedback recognizerFeedback = (RecognizerFeedback)o;
        return Objects.equals(this.id, recognizerFeedback.id) && Objects.equals(this.entityLink, recognizerFeedback.entityLink) && Objects.equals(this.tagFQN, recognizerFeedback.tagFQN) && Objects.equals((Object)this.feedbackType, (Object)recognizerFeedback.feedbackType) && Objects.equals((Object)this.userReason, (Object)recognizerFeedback.userReason) && Objects.equals(this.userComments, recognizerFeedback.userComments) && Objects.equals(this.suggestedTag, recognizerFeedback.suggestedTag) && Objects.equals(this.sampleValues, recognizerFeedback.sampleValues) && Objects.equals(this.recognizerInfo, recognizerFeedback.recognizerInfo) && Objects.equals(this.createdBy, recognizerFeedback.createdBy) && Objects.equals(this.createdAt, recognizerFeedback.createdAt) && Objects.equals((Object)this.status, (Object)recognizerFeedback.status) && Objects.equals(this.resolution, recognizerFeedback.resolution);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.entityLink, this.tagFQN, this.feedbackType, this.userReason, this.userComments, this.suggestedTag, this.sampleValues, this.recognizerInfo, this.createdBy, this.createdAt, this.status, this.resolution});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RecognizerFeedback {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    entityLink: ").append(this.toIndentedString(this.entityLink)).append("\n");
        sb.append("    tagFQN: ").append(this.toIndentedString(this.tagFQN)).append("\n");
        sb.append("    feedbackType: ").append(this.toIndentedString((Object)this.feedbackType)).append("\n");
        sb.append("    userReason: ").append(this.toIndentedString((Object)this.userReason)).append("\n");
        sb.append("    userComments: ").append(this.toIndentedString(this.userComments)).append("\n");
        sb.append("    suggestedTag: ").append(this.toIndentedString(this.suggestedTag)).append("\n");
        sb.append("    sampleValues: ").append(this.toIndentedString(this.sampleValues)).append("\n");
        sb.append("    recognizerInfo: ").append(this.toIndentedString(this.recognizerInfo)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    resolution: ").append(this.toIndentedString(this.resolution)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum FeedbackTypeEnum {
        FALSE_POSITIVE(String.valueOf("FALSE_POSITIVE")),
        INCORRECT_CLASSIFICATION(String.valueOf("INCORRECT_CLASSIFICATION")),
        OVERLY_BROAD(String.valueOf("OVERLY_BROAD")),
        CONTEXT_SPECIFIC(String.valueOf("CONTEXT_SPECIFIC"));

        private String value;

        private FeedbackTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FeedbackTypeEnum fromValue(String value) {
            for (FeedbackTypeEnum b : FeedbackTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum UserReasonEnum {
        NOT_SENSITIVE_DATA(String.valueOf("NOT_SENSITIVE_DATA")),
        WRONG_DATA_TYPE(String.valueOf("WRONG_DATA_TYPE")),
        INTERNAL_IDENTIFIER(String.valueOf("INTERNAL_IDENTIFIER")),
        PUBLIC_INFORMATION(String.valueOf("PUBLIC_INFORMATION")),
        TEST_DATA(String.valueOf("TEST_DATA")),
        ENCRYPTED_DATA(String.valueOf("ENCRYPTED_DATA")),
        OTHER(String.valueOf("OTHER"));

        private String value;

        private UserReasonEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static UserReasonEnum fromValue(String value) {
            for (UserReasonEnum b : UserReasonEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum StatusEnum {
        PENDING(String.valueOf("PENDING")),
        REVIEWED(String.valueOf("REVIEWED")),
        APPLIED(String.valueOf("APPLIED")),
        REJECTED(String.valueOf("REJECTED"));

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

