/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openmetadata.client.model.EntityReference;

@JsonPropertyOrder(value={"action", "resolvedBy", "resolvedAt", "resolutionNotes"})
public class Resolution {
    public static final String JSON_PROPERTY_ACTION = "action";
    @Nullable
    private ActionEnum action;
    public static final String JSON_PROPERTY_RESOLVED_BY = "resolvedBy";
    @Nullable
    private EntityReference resolvedBy;
    public static final String JSON_PROPERTY_RESOLVED_AT = "resolvedAt";
    @Nullable
    private Long resolvedAt;
    public static final String JSON_PROPERTY_RESOLUTION_NOTES = "resolutionNotes";
    @Nullable
    private String resolutionNotes;

    public Resolution action(@Nullable ActionEnum action) {
        this.action = action;
        return this;
    }

    @Nullable
    @JsonProperty(value="action")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ActionEnum getAction() {
        return this.action;
    }

    @JsonProperty(value="action")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAction(@Nullable ActionEnum action) {
        this.action = action;
    }

    public Resolution resolvedBy(@Nullable EntityReference resolvedBy) {
        this.resolvedBy = resolvedBy;
        return this;
    }

    @Nullable
    @JsonProperty(value="resolvedBy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EntityReference getResolvedBy() {
        return this.resolvedBy;
    }

    @JsonProperty(value="resolvedBy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResolvedBy(@Nullable EntityReference resolvedBy) {
        this.resolvedBy = resolvedBy;
    }

    public Resolution resolvedAt(@Nullable Long resolvedAt) {
        this.resolvedAt = resolvedAt;
        return this;
    }

    @Nullable
    @JsonProperty(value="resolvedAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getResolvedAt() {
        return this.resolvedAt;
    }

    @JsonProperty(value="resolvedAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResolvedAt(@Nullable Long resolvedAt) {
        this.resolvedAt = resolvedAt;
    }

    public Resolution resolutionNotes(@Nullable String resolutionNotes) {
        this.resolutionNotes = resolutionNotes;
        return this;
    }

    @Nullable
    @JsonProperty(value="resolutionNotes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getResolutionNotes() {
        return this.resolutionNotes;
    }

    @JsonProperty(value="resolutionNotes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResolutionNotes(@Nullable String resolutionNotes) {
        this.resolutionNotes = resolutionNotes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Resolution resolution = (Resolution)o;
        return Objects.equals((Object)this.action, (Object)resolution.action) && Objects.equals(this.resolvedBy, resolution.resolvedBy) && Objects.equals(this.resolvedAt, resolution.resolvedAt) && Objects.equals(this.resolutionNotes, resolution.resolutionNotes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.action, this.resolvedBy, this.resolvedAt, this.resolutionNotes});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Resolution {\n");
        sb.append("    action: ").append(this.toIndentedString((Object)this.action)).append("\n");
        sb.append("    resolvedBy: ").append(this.toIndentedString(this.resolvedBy)).append("\n");
        sb.append("    resolvedAt: ").append(this.toIndentedString(this.resolvedAt)).append("\n");
        sb.append("    resolutionNotes: ").append(this.toIndentedString(this.resolutionNotes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ActionEnum {
        ADDED_TO_EXCEPTION_LIST(String.valueOf("ADDED_TO_EXCEPTION_LIST")),
        PATTERN_ADJUSTED(String.valueOf("PATTERN_ADJUSTED")),
        THRESHOLD_INCREASED(String.valueOf("THRESHOLD_INCREASED")),
        RECOGNIZER_DISABLED_FOR_ENTITY(String.valueOf("RECOGNIZER_DISABLED_FOR_ENTITY")),
        NO_ACTION_NEEDED(String.valueOf("NO_ACTION_NEEDED"));

        private String value;

        private ActionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ActionEnum fromValue(String value) {
            for (ActionEnum b : ActionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

