/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.model.EntityError;
import org.openmetadata.client.model.Paging;
import org.openmetadata.client.model.SearchService;

@JsonPropertyOrder(value={"data", "paging", "errors"})
public class SearchServiceList {
    public static final String JSON_PROPERTY_DATA = "data";
    @Nonnull
    private List<SearchService> data = new ArrayList<SearchService>();
    public static final String JSON_PROPERTY_PAGING = "paging";
    @Nullable
    private Paging paging;
    public static final String JSON_PROPERTY_ERRORS = "errors";
    @Nullable
    private List<EntityError> errors = new ArrayList<EntityError>();

    public SearchServiceList data(@Nonnull List<SearchService> data) {
        this.data = data;
        return this;
    }

    public SearchServiceList addDataItem(SearchService dataItem) {
        if (this.data == null) {
            this.data = new ArrayList<SearchService>();
        }
        this.data.add(dataItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<SearchService> getData() {
        return this.data;
    }

    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setData(@Nonnull List<SearchService> data) {
        this.data = data;
    }

    public SearchServiceList paging(@Nullable Paging paging) {
        this.paging = paging;
        return this;
    }

    @Nullable
    @JsonProperty(value="paging")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Paging getPaging() {
        return this.paging;
    }

    @JsonProperty(value="paging")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaging(@Nullable Paging paging) {
        this.paging = paging;
    }

    public SearchServiceList errors(@Nullable List<EntityError> errors) {
        this.errors = errors;
        return this;
    }

    public SearchServiceList addErrorsItem(EntityError errorsItem) {
        if (this.errors == null) {
            this.errors = new ArrayList<EntityError>();
        }
        this.errors.add(errorsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="errors")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityError> getErrors() {
        return this.errors;
    }

    @JsonProperty(value="errors")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setErrors(@Nullable List<EntityError> errors) {
        this.errors = errors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchServiceList searchServiceList = (SearchServiceList)o;
        return Objects.equals(this.data, searchServiceList.data) && Objects.equals(this.paging, searchServiceList.paging) && Objects.equals(this.errors, searchServiceList.errors);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.paging, this.errors);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SearchServiceList {\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    paging: ").append(this.toIndentedString(this.paging)).append("\n");
        sb.append("    errors: ").append(this.toIndentedString(this.errors)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

