/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"query", "format", "timeout", "defaultGraphUri", "namedGraphUri", "inference"})
public class SparqlQuery {
    public static final String JSON_PROPERTY_QUERY = "query";
    @Nonnull
    private String query;
    public static final String JSON_PROPERTY_FORMAT = "format";
    @Nullable
    private FormatEnum format;
    public static final String JSON_PROPERTY_TIMEOUT = "timeout";
    @Nullable
    private Integer timeout;
    public static final String JSON_PROPERTY_DEFAULT_GRAPH_URI = "defaultGraphUri";
    @Nullable
    private URI defaultGraphUri;
    public static final String JSON_PROPERTY_NAMED_GRAPH_URI = "namedGraphUri";
    @Nullable
    private List<URI> namedGraphUri = new ArrayList<URI>();
    public static final String JSON_PROPERTY_INFERENCE = "inference";
    @Nullable
    private InferenceEnum inference;

    public SparqlQuery query(@Nonnull String query) {
        this.query = query;
        return this;
    }

    @Nonnull
    @JsonProperty(value="query")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getQuery() {
        return this.query;
    }

    @JsonProperty(value="query")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setQuery(@Nonnull String query) {
        this.query = query;
    }

    public SparqlQuery format(@Nullable FormatEnum format) {
        this.format = format;
        return this;
    }

    @Nullable
    @JsonProperty(value="format")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FormatEnum getFormat() {
        return this.format;
    }

    @JsonProperty(value="format")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFormat(@Nullable FormatEnum format) {
        this.format = format;
    }

    public SparqlQuery timeout(@Nullable Integer timeout) {
        this.timeout = timeout;
        return this;
    }

    @Nullable
    @JsonProperty(value="timeout")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getTimeout() {
        return this.timeout;
    }

    @JsonProperty(value="timeout")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTimeout(@Nullable Integer timeout) {
        this.timeout = timeout;
    }

    public SparqlQuery defaultGraphUri(@Nullable URI defaultGraphUri) {
        this.defaultGraphUri = defaultGraphUri;
        return this;
    }

    @Nullable
    @JsonProperty(value="defaultGraphUri")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public URI getDefaultGraphUri() {
        return this.defaultGraphUri;
    }

    @JsonProperty(value="defaultGraphUri")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDefaultGraphUri(@Nullable URI defaultGraphUri) {
        this.defaultGraphUri = defaultGraphUri;
    }

    public SparqlQuery namedGraphUri(@Nullable List<URI> namedGraphUri) {
        this.namedGraphUri = namedGraphUri;
        return this;
    }

    public SparqlQuery addNamedGraphUriItem(URI namedGraphUriItem) {
        if (this.namedGraphUri == null) {
            this.namedGraphUri = new ArrayList<URI>();
        }
        this.namedGraphUri.add(namedGraphUriItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="namedGraphUri")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<URI> getNamedGraphUri() {
        return this.namedGraphUri;
    }

    @JsonProperty(value="namedGraphUri")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNamedGraphUri(@Nullable List<URI> namedGraphUri) {
        this.namedGraphUri = namedGraphUri;
    }

    public SparqlQuery inference(@Nullable InferenceEnum inference) {
        this.inference = inference;
        return this;
    }

    @Nullable
    @JsonProperty(value="inference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public InferenceEnum getInference() {
        return this.inference;
    }

    @JsonProperty(value="inference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInference(@Nullable InferenceEnum inference) {
        this.inference = inference;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SparqlQuery sparqlQuery = (SparqlQuery)o;
        return Objects.equals(this.query, sparqlQuery.query) && Objects.equals((Object)this.format, (Object)sparqlQuery.format) && Objects.equals(this.timeout, sparqlQuery.timeout) && Objects.equals(this.defaultGraphUri, sparqlQuery.defaultGraphUri) && Objects.equals(this.namedGraphUri, sparqlQuery.namedGraphUri) && Objects.equals((Object)this.inference, (Object)sparqlQuery.inference);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.query, this.format, this.timeout, this.defaultGraphUri, this.namedGraphUri, this.inference});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SparqlQuery {\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    format: ").append(this.toIndentedString((Object)this.format)).append("\n");
        sb.append("    timeout: ").append(this.toIndentedString(this.timeout)).append("\n");
        sb.append("    defaultGraphUri: ").append(this.toIndentedString(this.defaultGraphUri)).append("\n");
        sb.append("    namedGraphUri: ").append(this.toIndentedString(this.namedGraphUri)).append("\n");
        sb.append("    inference: ").append(this.toIndentedString((Object)this.inference)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum FormatEnum {
        JSON(String.valueOf("json")),
        XML(String.valueOf("xml")),
        CSV(String.valueOf("csv")),
        TSV(String.valueOf("tsv")),
        TURTLE(String.valueOf("turtle")),
        RDFXML(String.valueOf("rdfxml")),
        NTRIPLES(String.valueOf("ntriples")),
        JSONLD(String.valueOf("jsonld"));

        private String value;

        private FormatEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FormatEnum fromValue(String value) {
            for (FormatEnum b : FormatEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum InferenceEnum {
        NONE(String.valueOf("none")),
        RDFS(String.valueOf("rdfs")),
        OWL(String.valueOf("owl")),
        CUSTOM(String.valueOf("custom"));

        private String value;

        private InferenceEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static InferenceEnum fromValue(String value) {
            for (InferenceEnum b : InferenceEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

