/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.model.DatasetGeneration;
import org.openmetadata.client.model.DatasetUsage;
import org.openmetadata.client.model.TaskMetrics;

@JsonPropertyOrder(value={"name", "executionStatus", "startTime", "endTime", "logLink", "taskId", "transformationType", "transformationLogic", "inputs", "outputs", "metrics"})
public class Status {
    public static final String JSON_PROPERTY_NAME = "name";
    @Nonnull
    private String name;
    public static final String JSON_PROPERTY_EXECUTION_STATUS = "executionStatus";
    @Nonnull
    private ExecutionStatusEnum executionStatus;
    public static final String JSON_PROPERTY_START_TIME = "startTime";
    @Nullable
    private Long startTime;
    public static final String JSON_PROPERTY_END_TIME = "endTime";
    @Nullable
    private Long endTime;
    public static final String JSON_PROPERTY_LOG_LINK = "logLink";
    @Nullable
    private URI logLink;
    public static final String JSON_PROPERTY_TASK_ID = "taskId";
    @Nullable
    private String taskId;
    public static final String JSON_PROPERTY_TRANSFORMATION_TYPE = "transformationType";
    @Nullable
    private TransformationTypeEnum transformationType;
    public static final String JSON_PROPERTY_TRANSFORMATION_LOGIC = "transformationLogic";
    @Nullable
    private String transformationLogic;
    public static final String JSON_PROPERTY_INPUTS = "inputs";
    @Nullable
    private List<DatasetUsage> inputs = new ArrayList<DatasetUsage>();
    public static final String JSON_PROPERTY_OUTPUTS = "outputs";
    @Nullable
    private List<DatasetGeneration> outputs = new ArrayList<DatasetGeneration>();
    public static final String JSON_PROPERTY_METRICS = "metrics";
    @Nullable
    private TaskMetrics metrics;

    public Status name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public Status executionStatus(@Nonnull ExecutionStatusEnum executionStatus) {
        this.executionStatus = executionStatus;
        return this;
    }

    @Nonnull
    @JsonProperty(value="executionStatus")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ExecutionStatusEnum getExecutionStatus() {
        return this.executionStatus;
    }

    @JsonProperty(value="executionStatus")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setExecutionStatus(@Nonnull ExecutionStatusEnum executionStatus) {
        this.executionStatus = executionStatus;
    }

    public Status startTime(@Nullable Long startTime) {
        this.startTime = startTime;
        return this;
    }

    @Nullable
    @JsonProperty(value="startTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getStartTime() {
        return this.startTime;
    }

    @JsonProperty(value="startTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStartTime(@Nullable Long startTime) {
        this.startTime = startTime;
    }

    public Status endTime(@Nullable Long endTime) {
        this.endTime = endTime;
        return this;
    }

    @Nullable
    @JsonProperty(value="endTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getEndTime() {
        return this.endTime;
    }

    @JsonProperty(value="endTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEndTime(@Nullable Long endTime) {
        this.endTime = endTime;
    }

    public Status logLink(@Nullable URI logLink) {
        this.logLink = logLink;
        return this;
    }

    @Nullable
    @JsonProperty(value="logLink")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public URI getLogLink() {
        return this.logLink;
    }

    @JsonProperty(value="logLink")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLogLink(@Nullable URI logLink) {
        this.logLink = logLink;
    }

    public Status taskId(@Nullable String taskId) {
        this.taskId = taskId;
        return this;
    }

    @Nullable
    @JsonProperty(value="taskId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTaskId() {
        return this.taskId;
    }

    @JsonProperty(value="taskId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTaskId(@Nullable String taskId) {
        this.taskId = taskId;
    }

    public Status transformationType(@Nullable TransformationTypeEnum transformationType) {
        this.transformationType = transformationType;
        return this;
    }

    @Nullable
    @JsonProperty(value="transformationType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TransformationTypeEnum getTransformationType() {
        return this.transformationType;
    }

    @JsonProperty(value="transformationType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTransformationType(@Nullable TransformationTypeEnum transformationType) {
        this.transformationType = transformationType;
    }

    public Status transformationLogic(@Nullable String transformationLogic) {
        this.transformationLogic = transformationLogic;
        return this;
    }

    @Nullable
    @JsonProperty(value="transformationLogic")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTransformationLogic() {
        return this.transformationLogic;
    }

    @JsonProperty(value="transformationLogic")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTransformationLogic(@Nullable String transformationLogic) {
        this.transformationLogic = transformationLogic;
    }

    public Status inputs(@Nullable List<DatasetUsage> inputs) {
        this.inputs = inputs;
        return this;
    }

    public Status addInputsItem(DatasetUsage inputsItem) {
        if (this.inputs == null) {
            this.inputs = new ArrayList<DatasetUsage>();
        }
        this.inputs.add(inputsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="inputs")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<DatasetUsage> getInputs() {
        return this.inputs;
    }

    @JsonProperty(value="inputs")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInputs(@Nullable List<DatasetUsage> inputs) {
        this.inputs = inputs;
    }

    public Status outputs(@Nullable List<DatasetGeneration> outputs) {
        this.outputs = outputs;
        return this;
    }

    public Status addOutputsItem(DatasetGeneration outputsItem) {
        if (this.outputs == null) {
            this.outputs = new ArrayList<DatasetGeneration>();
        }
        this.outputs.add(outputsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="outputs")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<DatasetGeneration> getOutputs() {
        return this.outputs;
    }

    @JsonProperty(value="outputs")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOutputs(@Nullable List<DatasetGeneration> outputs) {
        this.outputs = outputs;
    }

    public Status metrics(@Nullable TaskMetrics metrics) {
        this.metrics = metrics;
        return this;
    }

    @Nullable
    @JsonProperty(value="metrics")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TaskMetrics getMetrics() {
        return this.metrics;
    }

    @JsonProperty(value="metrics")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMetrics(@Nullable TaskMetrics metrics) {
        this.metrics = metrics;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Status status = (Status)o;
        return Objects.equals(this.name, status.name) && Objects.equals((Object)this.executionStatus, (Object)status.executionStatus) && Objects.equals(this.startTime, status.startTime) && Objects.equals(this.endTime, status.endTime) && Objects.equals(this.logLink, status.logLink) && Objects.equals(this.taskId, status.taskId) && Objects.equals((Object)this.transformationType, (Object)status.transformationType) && Objects.equals(this.transformationLogic, status.transformationLogic) && Objects.equals(this.inputs, status.inputs) && Objects.equals(this.outputs, status.outputs) && Objects.equals(this.metrics, status.metrics);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.executionStatus, this.startTime, this.endTime, this.logLink, this.taskId, this.transformationType, this.transformationLogic, this.inputs, this.outputs, this.metrics});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Status {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    executionStatus: ").append(this.toIndentedString((Object)this.executionStatus)).append("\n");
        sb.append("    startTime: ").append(this.toIndentedString(this.startTime)).append("\n");
        sb.append("    endTime: ").append(this.toIndentedString(this.endTime)).append("\n");
        sb.append("    logLink: ").append(this.toIndentedString(this.logLink)).append("\n");
        sb.append("    taskId: ").append(this.toIndentedString(this.taskId)).append("\n");
        sb.append("    transformationType: ").append(this.toIndentedString((Object)this.transformationType)).append("\n");
        sb.append("    transformationLogic: ").append(this.toIndentedString(this.transformationLogic)).append("\n");
        sb.append("    inputs: ").append(this.toIndentedString(this.inputs)).append("\n");
        sb.append("    outputs: ").append(this.toIndentedString(this.outputs)).append("\n");
        sb.append("    metrics: ").append(this.toIndentedString(this.metrics)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ExecutionStatusEnum {
        SUCCESSFUL(String.valueOf("Successful")),
        FAILED(String.valueOf("Failed")),
        PENDING(String.valueOf("Pending")),
        SKIPPED(String.valueOf("Skipped"));

        private String value;

        private ExecutionStatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ExecutionStatusEnum fromValue(String value) {
            for (ExecutionStatusEnum b : ExecutionStatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TransformationTypeEnum {
        FILTER(String.valueOf("filter")),
        AGGREGATE(String.valueOf("aggregate")),
        JOIN(String.valueOf("join")),
        PIVOT(String.valueOf("pivot")),
        CUSTOM(String.valueOf("custom")),
        EXTRACT(String.valueOf("extract")),
        LOAD(String.valueOf("load"));

        private String value;

        private TransformationTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TransformationTypeEnum fromValue(String value) {
            for (TransformationTypeEnum b : TransformationTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

