/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.model.CustomMetricProfile;

@JsonPropertyOrder(value={"timestamp", "profileSample", "profileSampleType", "samplingMethodType", "columnCount", "rowCount", "sizeInByte", "createDateTime", "customMetrics"})
public class TableProfile {
    public static final String JSON_PROPERTY_TIMESTAMP = "timestamp";
    @Nonnull
    private Long timestamp;
    public static final String JSON_PROPERTY_PROFILE_SAMPLE = "profileSample";
    @Nullable
    private Double profileSample;
    public static final String JSON_PROPERTY_PROFILE_SAMPLE_TYPE = "profileSampleType";
    @Nullable
    private ProfileSampleTypeEnum profileSampleType;
    public static final String JSON_PROPERTY_SAMPLING_METHOD_TYPE = "samplingMethodType";
    @Nullable
    private SamplingMethodTypeEnum samplingMethodType;
    public static final String JSON_PROPERTY_COLUMN_COUNT = "columnCount";
    @Nullable
    private Double columnCount;
    public static final String JSON_PROPERTY_ROW_COUNT = "rowCount";
    @Nullable
    private Double rowCount;
    public static final String JSON_PROPERTY_SIZE_IN_BYTE = "sizeInByte";
    @Nullable
    private Double sizeInByte;
    public static final String JSON_PROPERTY_CREATE_DATE_TIME = "createDateTime";
    @Nullable
    private OffsetDateTime createDateTime;
    public static final String JSON_PROPERTY_CUSTOM_METRICS = "customMetrics";
    @Nullable
    private List<CustomMetricProfile> customMetrics = new ArrayList<CustomMetricProfile>();

    public TableProfile timestamp(@Nonnull Long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @Nonnull
    @JsonProperty(value="timestamp")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Long getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty(value="timestamp")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTimestamp(@Nonnull Long timestamp) {
        this.timestamp = timestamp;
    }

    public TableProfile profileSample(@Nullable Double profileSample) {
        this.profileSample = profileSample;
        return this;
    }

    @Nullable
    @JsonProperty(value="profileSample")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getProfileSample() {
        return this.profileSample;
    }

    @JsonProperty(value="profileSample")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProfileSample(@Nullable Double profileSample) {
        this.profileSample = profileSample;
    }

    public TableProfile profileSampleType(@Nullable ProfileSampleTypeEnum profileSampleType) {
        this.profileSampleType = profileSampleType;
        return this;
    }

    @Nullable
    @JsonProperty(value="profileSampleType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ProfileSampleTypeEnum getProfileSampleType() {
        return this.profileSampleType;
    }

    @JsonProperty(value="profileSampleType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProfileSampleType(@Nullable ProfileSampleTypeEnum profileSampleType) {
        this.profileSampleType = profileSampleType;
    }

    public TableProfile samplingMethodType(@Nullable SamplingMethodTypeEnum samplingMethodType) {
        this.samplingMethodType = samplingMethodType;
        return this;
    }

    @Nullable
    @JsonProperty(value="samplingMethodType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SamplingMethodTypeEnum getSamplingMethodType() {
        return this.samplingMethodType;
    }

    @JsonProperty(value="samplingMethodType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSamplingMethodType(@Nullable SamplingMethodTypeEnum samplingMethodType) {
        this.samplingMethodType = samplingMethodType;
    }

    public TableProfile columnCount(@Nullable Double columnCount) {
        this.columnCount = columnCount;
        return this;
    }

    @Nullable
    @JsonProperty(value="columnCount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getColumnCount() {
        return this.columnCount;
    }

    @JsonProperty(value="columnCount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setColumnCount(@Nullable Double columnCount) {
        this.columnCount = columnCount;
    }

    public TableProfile rowCount(@Nullable Double rowCount) {
        this.rowCount = rowCount;
        return this;
    }

    @Nullable
    @JsonProperty(value="rowCount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getRowCount() {
        return this.rowCount;
    }

    @JsonProperty(value="rowCount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRowCount(@Nullable Double rowCount) {
        this.rowCount = rowCount;
    }

    public TableProfile sizeInByte(@Nullable Double sizeInByte) {
        this.sizeInByte = sizeInByte;
        return this;
    }

    @Nullable
    @JsonProperty(value="sizeInByte")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getSizeInByte() {
        return this.sizeInByte;
    }

    @JsonProperty(value="sizeInByte")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSizeInByte(@Nullable Double sizeInByte) {
        this.sizeInByte = sizeInByte;
    }

    public TableProfile createDateTime(@Nullable OffsetDateTime createDateTime) {
        this.createDateTime = createDateTime;
        return this;
    }

    @Nullable
    @JsonProperty(value="createDateTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreateDateTime() {
        return this.createDateTime;
    }

    @JsonProperty(value="createDateTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreateDateTime(@Nullable OffsetDateTime createDateTime) {
        this.createDateTime = createDateTime;
    }

    public TableProfile customMetrics(@Nullable List<CustomMetricProfile> customMetrics) {
        this.customMetrics = customMetrics;
        return this;
    }

    public TableProfile addCustomMetricsItem(CustomMetricProfile customMetricsItem) {
        if (this.customMetrics == null) {
            this.customMetrics = new ArrayList<CustomMetricProfile>();
        }
        this.customMetrics.add(customMetricsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="customMetrics")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<CustomMetricProfile> getCustomMetrics() {
        return this.customMetrics;
    }

    @JsonProperty(value="customMetrics")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCustomMetrics(@Nullable List<CustomMetricProfile> customMetrics) {
        this.customMetrics = customMetrics;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableProfile tableProfile = (TableProfile)o;
        return Objects.equals(this.timestamp, tableProfile.timestamp) && Objects.equals(this.profileSample, tableProfile.profileSample) && Objects.equals((Object)this.profileSampleType, (Object)tableProfile.profileSampleType) && Objects.equals((Object)this.samplingMethodType, (Object)tableProfile.samplingMethodType) && Objects.equals(this.columnCount, tableProfile.columnCount) && Objects.equals(this.rowCount, tableProfile.rowCount) && Objects.equals(this.sizeInByte, tableProfile.sizeInByte) && Objects.equals(this.createDateTime, tableProfile.createDateTime) && Objects.equals(this.customMetrics, tableProfile.customMetrics);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.timestamp, this.profileSample, this.profileSampleType, this.samplingMethodType, this.columnCount, this.rowCount, this.sizeInByte, this.createDateTime, this.customMetrics});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TableProfile {\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("    profileSample: ").append(this.toIndentedString(this.profileSample)).append("\n");
        sb.append("    profileSampleType: ").append(this.toIndentedString((Object)this.profileSampleType)).append("\n");
        sb.append("    samplingMethodType: ").append(this.toIndentedString((Object)this.samplingMethodType)).append("\n");
        sb.append("    columnCount: ").append(this.toIndentedString(this.columnCount)).append("\n");
        sb.append("    rowCount: ").append(this.toIndentedString(this.rowCount)).append("\n");
        sb.append("    sizeInByte: ").append(this.toIndentedString(this.sizeInByte)).append("\n");
        sb.append("    createDateTime: ").append(this.toIndentedString(this.createDateTime)).append("\n");
        sb.append("    customMetrics: ").append(this.toIndentedString(this.customMetrics)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ProfileSampleTypeEnum {
        PERCENTAGE(String.valueOf("PERCENTAGE")),
        ROWS(String.valueOf("ROWS"));

        private String value;

        private ProfileSampleTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ProfileSampleTypeEnum fromValue(String value) {
            for (ProfileSampleTypeEnum b : ProfileSampleTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum SamplingMethodTypeEnum {
        BERNOULLI(String.valueOf("BERNOULLI")),
        SYSTEM(String.valueOf("SYSTEM"));

        private String value;

        private SamplingMethodTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SamplingMethodTypeEnum fromValue(String value) {
            for (SamplingMethodTypeEnum b : SamplingMethodTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

