/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.model.EntityReference;

@JsonPropertyOrder(value={"id", "type", "assignees", "status", "closedBy", "closedAt", "oldValue", "suggestion", "newValue", "testCaseResolutionStatusId"})
public class TaskDetails {
    public static final String JSON_PROPERTY_ID = "id";
    @Nonnull
    private Integer id;
    public static final String JSON_PROPERTY_TYPE = "type";
    @Nonnull
    private TypeEnum type;
    public static final String JSON_PROPERTY_ASSIGNEES = "assignees";
    @Nonnull
    private List<EntityReference> assignees = new ArrayList<EntityReference>();
    public static final String JSON_PROPERTY_STATUS = "status";
    @Nullable
    private StatusEnum status;
    public static final String JSON_PROPERTY_CLOSED_BY = "closedBy";
    @Nullable
    private String closedBy;
    public static final String JSON_PROPERTY_CLOSED_AT = "closedAt";
    @Nullable
    private Long closedAt;
    public static final String JSON_PROPERTY_OLD_VALUE = "oldValue";
    @Nullable
    private String oldValue;
    public static final String JSON_PROPERTY_SUGGESTION = "suggestion";
    @Nullable
    private String suggestion;
    public static final String JSON_PROPERTY_NEW_VALUE = "newValue";
    @Nullable
    private String newValue;
    public static final String JSON_PROPERTY_TEST_CASE_RESOLUTION_STATUS_ID = "testCaseResolutionStatusId";
    @Nullable
    private UUID testCaseResolutionStatusId;

    public TaskDetails id(@Nonnull Integer id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setId(@Nonnull Integer id) {
        this.id = id;
    }

    public TaskDetails type(@Nonnull TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(@Nonnull TypeEnum type) {
        this.type = type;
    }

    public TaskDetails assignees(@Nonnull List<EntityReference> assignees) {
        this.assignees = assignees;
        return this;
    }

    public TaskDetails addAssigneesItem(EntityReference assigneesItem) {
        if (this.assignees == null) {
            this.assignees = new ArrayList<EntityReference>();
        }
        this.assignees.add(assigneesItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="assignees")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<EntityReference> getAssignees() {
        return this.assignees;
    }

    @JsonProperty(value="assignees")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAssignees(@Nonnull List<EntityReference> assignees) {
        this.assignees = assignees;
    }

    public TaskDetails status(@Nullable StatusEnum status) {
        this.status = status;
        return this;
    }

    @Nullable
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(@Nullable StatusEnum status) {
        this.status = status;
    }

    public TaskDetails closedBy(@Nullable String closedBy) {
        this.closedBy = closedBy;
        return this;
    }

    @Nullable
    @JsonProperty(value="closedBy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getClosedBy() {
        return this.closedBy;
    }

    @JsonProperty(value="closedBy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setClosedBy(@Nullable String closedBy) {
        this.closedBy = closedBy;
    }

    public TaskDetails closedAt(@Nullable Long closedAt) {
        this.closedAt = closedAt;
        return this;
    }

    @Nullable
    @JsonProperty(value="closedAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getClosedAt() {
        return this.closedAt;
    }

    @JsonProperty(value="closedAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setClosedAt(@Nullable Long closedAt) {
        this.closedAt = closedAt;
    }

    public TaskDetails oldValue(@Nullable String oldValue) {
        this.oldValue = oldValue;
        return this;
    }

    @Nullable
    @JsonProperty(value="oldValue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOldValue() {
        return this.oldValue;
    }

    @JsonProperty(value="oldValue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOldValue(@Nullable String oldValue) {
        this.oldValue = oldValue;
    }

    public TaskDetails suggestion(@Nullable String suggestion) {
        this.suggestion = suggestion;
        return this;
    }

    @Nullable
    @JsonProperty(value="suggestion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSuggestion() {
        return this.suggestion;
    }

    @JsonProperty(value="suggestion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSuggestion(@Nullable String suggestion) {
        this.suggestion = suggestion;
    }

    public TaskDetails newValue(@Nullable String newValue) {
        this.newValue = newValue;
        return this;
    }

    @Nullable
    @JsonProperty(value="newValue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getNewValue() {
        return this.newValue;
    }

    @JsonProperty(value="newValue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNewValue(@Nullable String newValue) {
        this.newValue = newValue;
    }

    public TaskDetails testCaseResolutionStatusId(@Nullable UUID testCaseResolutionStatusId) {
        this.testCaseResolutionStatusId = testCaseResolutionStatusId;
        return this;
    }

    @Nullable
    @JsonProperty(value="testCaseResolutionStatusId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getTestCaseResolutionStatusId() {
        return this.testCaseResolutionStatusId;
    }

    @JsonProperty(value="testCaseResolutionStatusId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTestCaseResolutionStatusId(@Nullable UUID testCaseResolutionStatusId) {
        this.testCaseResolutionStatusId = testCaseResolutionStatusId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskDetails taskDetails = (TaskDetails)o;
        return Objects.equals(this.id, taskDetails.id) && Objects.equals((Object)this.type, (Object)taskDetails.type) && Objects.equals(this.assignees, taskDetails.assignees) && Objects.equals((Object)this.status, (Object)taskDetails.status) && Objects.equals(this.closedBy, taskDetails.closedBy) && Objects.equals(this.closedAt, taskDetails.closedAt) && Objects.equals(this.oldValue, taskDetails.oldValue) && Objects.equals(this.suggestion, taskDetails.suggestion) && Objects.equals(this.newValue, taskDetails.newValue) && Objects.equals(this.testCaseResolutionStatusId, taskDetails.testCaseResolutionStatusId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.type, this.assignees, this.status, this.closedBy, this.closedAt, this.oldValue, this.suggestion, this.newValue, this.testCaseResolutionStatusId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TaskDetails {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    assignees: ").append(this.toIndentedString(this.assignees)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    closedBy: ").append(this.toIndentedString(this.closedBy)).append("\n");
        sb.append("    closedAt: ").append(this.toIndentedString(this.closedAt)).append("\n");
        sb.append("    oldValue: ").append(this.toIndentedString(this.oldValue)).append("\n");
        sb.append("    suggestion: ").append(this.toIndentedString(this.suggestion)).append("\n");
        sb.append("    newValue: ").append(this.toIndentedString(this.newValue)).append("\n");
        sb.append("    testCaseResolutionStatusId: ").append(this.toIndentedString(this.testCaseResolutionStatusId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        REQUEST_DESCRIPTION(String.valueOf("RequestDescription")),
        UPDATE_DESCRIPTION(String.valueOf("UpdateDescription")),
        REQUEST_TAG(String.valueOf("RequestTag")),
        UPDATE_TAG(String.valueOf("UpdateTag")),
        REQUEST_APPROVAL(String.valueOf("RequestApproval")),
        REQUEST_TEST_CASE_FAILURE_RESOLUTION(String.valueOf("RequestTestCaseFailureResolution")),
        GENERIC(String.valueOf("Generic"));

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum StatusEnum {
        OPEN(String.valueOf("Open")),
        CLOSED(String.valueOf("Closed"));

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

