/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openmetadata.client.model.EntityReference;
import org.openmetadata.client.model.PolicyInfo;
import org.openmetadata.client.model.RolePermission;

@JsonPropertyOrder(value={"team", "teamHierarchy", "rolePermissions", "directPolicies", "teamType", "hierarchyLevel"})
public class TeamPermission {
    public static final String JSON_PROPERTY_TEAM = "team";
    @Nullable
    private EntityReference team;
    public static final String JSON_PROPERTY_TEAM_HIERARCHY = "teamHierarchy";
    @Nullable
    private List<EntityReference> teamHierarchy = new ArrayList<EntityReference>();
    public static final String JSON_PROPERTY_ROLE_PERMISSIONS = "rolePermissions";
    @Nullable
    private List<RolePermission> rolePermissions = new ArrayList<RolePermission>();
    public static final String JSON_PROPERTY_DIRECT_POLICIES = "directPolicies";
    @Nullable
    private List<PolicyInfo> directPolicies = new ArrayList<PolicyInfo>();
    public static final String JSON_PROPERTY_TEAM_TYPE = "teamType";
    @Nullable
    private String teamType;
    public static final String JSON_PROPERTY_HIERARCHY_LEVEL = "hierarchyLevel";
    @Nullable
    private Integer hierarchyLevel;

    public TeamPermission team(@Nullable EntityReference team) {
        this.team = team;
        return this;
    }

    @Nullable
    @JsonProperty(value="team")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EntityReference getTeam() {
        return this.team;
    }

    @JsonProperty(value="team")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTeam(@Nullable EntityReference team) {
        this.team = team;
    }

    public TeamPermission teamHierarchy(@Nullable List<EntityReference> teamHierarchy) {
        this.teamHierarchy = teamHierarchy;
        return this;
    }

    public TeamPermission addTeamHierarchyItem(EntityReference teamHierarchyItem) {
        if (this.teamHierarchy == null) {
            this.teamHierarchy = new ArrayList<EntityReference>();
        }
        this.teamHierarchy.add(teamHierarchyItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="teamHierarchy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getTeamHierarchy() {
        return this.teamHierarchy;
    }

    @JsonProperty(value="teamHierarchy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTeamHierarchy(@Nullable List<EntityReference> teamHierarchy) {
        this.teamHierarchy = teamHierarchy;
    }

    public TeamPermission rolePermissions(@Nullable List<RolePermission> rolePermissions) {
        this.rolePermissions = rolePermissions;
        return this;
    }

    public TeamPermission addRolePermissionsItem(RolePermission rolePermissionsItem) {
        if (this.rolePermissions == null) {
            this.rolePermissions = new ArrayList<RolePermission>();
        }
        this.rolePermissions.add(rolePermissionsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="rolePermissions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<RolePermission> getRolePermissions() {
        return this.rolePermissions;
    }

    @JsonProperty(value="rolePermissions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRolePermissions(@Nullable List<RolePermission> rolePermissions) {
        this.rolePermissions = rolePermissions;
    }

    public TeamPermission directPolicies(@Nullable List<PolicyInfo> directPolicies) {
        this.directPolicies = directPolicies;
        return this;
    }

    public TeamPermission addDirectPoliciesItem(PolicyInfo directPoliciesItem) {
        if (this.directPolicies == null) {
            this.directPolicies = new ArrayList<PolicyInfo>();
        }
        this.directPolicies.add(directPoliciesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="directPolicies")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<PolicyInfo> getDirectPolicies() {
        return this.directPolicies;
    }

    @JsonProperty(value="directPolicies")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDirectPolicies(@Nullable List<PolicyInfo> directPolicies) {
        this.directPolicies = directPolicies;
    }

    public TeamPermission teamType(@Nullable String teamType) {
        this.teamType = teamType;
        return this;
    }

    @Nullable
    @JsonProperty(value="teamType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTeamType() {
        return this.teamType;
    }

    @JsonProperty(value="teamType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTeamType(@Nullable String teamType) {
        this.teamType = teamType;
    }

    public TeamPermission hierarchyLevel(@Nullable Integer hierarchyLevel) {
        this.hierarchyLevel = hierarchyLevel;
        return this;
    }

    @Nullable
    @JsonProperty(value="hierarchyLevel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getHierarchyLevel() {
        return this.hierarchyLevel;
    }

    @JsonProperty(value="hierarchyLevel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHierarchyLevel(@Nullable Integer hierarchyLevel) {
        this.hierarchyLevel = hierarchyLevel;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TeamPermission teamPermission = (TeamPermission)o;
        return Objects.equals(this.team, teamPermission.team) && Objects.equals(this.teamHierarchy, teamPermission.teamHierarchy) && Objects.equals(this.rolePermissions, teamPermission.rolePermissions) && Objects.equals(this.directPolicies, teamPermission.directPolicies) && Objects.equals(this.teamType, teamPermission.teamType) && Objects.equals(this.hierarchyLevel, teamPermission.hierarchyLevel);
    }

    public int hashCode() {
        return Objects.hash(this.team, this.teamHierarchy, this.rolePermissions, this.directPolicies, this.teamType, this.hierarchyLevel);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TeamPermission {\n");
        sb.append("    team: ").append(this.toIndentedString(this.team)).append("\n");
        sb.append("    teamHierarchy: ").append(this.toIndentedString(this.teamHierarchy)).append("\n");
        sb.append("    rolePermissions: ").append(this.toIndentedString(this.rolePermissions)).append("\n");
        sb.append("    directPolicies: ").append(this.toIndentedString(this.directPolicies)).append("\n");
        sb.append("    teamType: ").append(this.toIndentedString(this.teamType)).append("\n");
        sb.append("    hierarchyLevel: ").append(this.toIndentedString(this.hierarchyLevel)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

