/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.net.URI;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"receivers", "endpoint", "secretKey", "headers", "queryParams", "httpMethod", "sendToAdmins", "sendToOwners", "sendToFollowers"})
public class Webhook {
    public static final String JSON_PROPERTY_RECEIVERS = "receivers";
    @Nullable
    private Set<String> receivers = new LinkedHashSet<String>();
    public static final String JSON_PROPERTY_ENDPOINT = "endpoint";
    @Nullable
    private URI endpoint;
    public static final String JSON_PROPERTY_SECRET_KEY = "secretKey";
    @Nullable
    private String secretKey;
    public static final String JSON_PROPERTY_HEADERS = "headers";
    @Nullable
    private Map<String, String> headers = new HashMap<String, String>();
    public static final String JSON_PROPERTY_QUERY_PARAMS = "queryParams";
    @Nullable
    private Map<String, String> queryParams = new HashMap<String, String>();
    public static final String JSON_PROPERTY_HTTP_METHOD = "httpMethod";
    @Nullable
    private HttpMethodEnum httpMethod;
    public static final String JSON_PROPERTY_SEND_TO_ADMINS = "sendToAdmins";
    @Nullable
    private Boolean sendToAdmins;
    public static final String JSON_PROPERTY_SEND_TO_OWNERS = "sendToOwners";
    @Nullable
    private Boolean sendToOwners;
    public static final String JSON_PROPERTY_SEND_TO_FOLLOWERS = "sendToFollowers";
    @Nullable
    private Boolean sendToFollowers;

    public Webhook receivers(@Nullable Set<String> receivers) {
        this.receivers = receivers;
        return this;
    }

    public Webhook addReceiversItem(String receiversItem) {
        if (this.receivers == null) {
            this.receivers = new LinkedHashSet<String>();
        }
        this.receivers.add(receiversItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="receivers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Set<String> getReceivers() {
        return this.receivers;
    }

    @JsonDeserialize(as=LinkedHashSet.class)
    @JsonProperty(value="receivers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReceivers(@Nullable Set<String> receivers) {
        this.receivers = receivers;
    }

    public Webhook endpoint(@Nullable URI endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    @Nullable
    @JsonProperty(value="endpoint")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public URI getEndpoint() {
        return this.endpoint;
    }

    @JsonProperty(value="endpoint")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEndpoint(@Nullable URI endpoint) {
        this.endpoint = endpoint;
    }

    public Webhook secretKey(@Nullable String secretKey) {
        this.secretKey = secretKey;
        return this;
    }

    @Nullable
    @JsonProperty(value="secretKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSecretKey() {
        return this.secretKey;
    }

    @JsonProperty(value="secretKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSecretKey(@Nullable String secretKey) {
        this.secretKey = secretKey;
    }

    public Webhook headers(@Nullable Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public Webhook putHeadersItem(String key, String headersItem) {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        this.headers.put(key, headersItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="headers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @JsonProperty(value="headers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHeaders(@Nullable Map<String, String> headers) {
        this.headers = headers;
    }

    public Webhook queryParams(@Nullable Map<String, String> queryParams) {
        this.queryParams = queryParams;
        return this;
    }

    public Webhook putQueryParamsItem(String key, String queryParamsItem) {
        if (this.queryParams == null) {
            this.queryParams = new HashMap<String, String>();
        }
        this.queryParams.put(key, queryParamsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="queryParams")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getQueryParams() {
        return this.queryParams;
    }

    @JsonProperty(value="queryParams")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setQueryParams(@Nullable Map<String, String> queryParams) {
        this.queryParams = queryParams;
    }

    public Webhook httpMethod(@Nullable HttpMethodEnum httpMethod) {
        this.httpMethod = httpMethod;
        return this;
    }

    @Nullable
    @JsonProperty(value="httpMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public HttpMethodEnum getHttpMethod() {
        return this.httpMethod;
    }

    @JsonProperty(value="httpMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHttpMethod(@Nullable HttpMethodEnum httpMethod) {
        this.httpMethod = httpMethod;
    }

    public Webhook sendToAdmins(@Nullable Boolean sendToAdmins) {
        this.sendToAdmins = sendToAdmins;
        return this;
    }

    @Nullable
    @JsonProperty(value="sendToAdmins")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSendToAdmins() {
        return this.sendToAdmins;
    }

    @JsonProperty(value="sendToAdmins")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSendToAdmins(@Nullable Boolean sendToAdmins) {
        this.sendToAdmins = sendToAdmins;
    }

    public Webhook sendToOwners(@Nullable Boolean sendToOwners) {
        this.sendToOwners = sendToOwners;
        return this;
    }

    @Nullable
    @JsonProperty(value="sendToOwners")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSendToOwners() {
        return this.sendToOwners;
    }

    @JsonProperty(value="sendToOwners")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSendToOwners(@Nullable Boolean sendToOwners) {
        this.sendToOwners = sendToOwners;
    }

    public Webhook sendToFollowers(@Nullable Boolean sendToFollowers) {
        this.sendToFollowers = sendToFollowers;
        return this;
    }

    @Nullable
    @JsonProperty(value="sendToFollowers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSendToFollowers() {
        return this.sendToFollowers;
    }

    @JsonProperty(value="sendToFollowers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSendToFollowers(@Nullable Boolean sendToFollowers) {
        this.sendToFollowers = sendToFollowers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Webhook webhook = (Webhook)o;
        return Objects.equals(this.receivers, webhook.receivers) && Objects.equals(this.endpoint, webhook.endpoint) && Objects.equals(this.secretKey, webhook.secretKey) && Objects.equals(this.headers, webhook.headers) && Objects.equals(this.queryParams, webhook.queryParams) && Objects.equals((Object)this.httpMethod, (Object)webhook.httpMethod) && Objects.equals(this.sendToAdmins, webhook.sendToAdmins) && Objects.equals(this.sendToOwners, webhook.sendToOwners) && Objects.equals(this.sendToFollowers, webhook.sendToFollowers);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.receivers, this.endpoint, this.secretKey, this.headers, this.queryParams, this.httpMethod, this.sendToAdmins, this.sendToOwners, this.sendToFollowers});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Webhook {\n");
        sb.append("    receivers: ").append(this.toIndentedString(this.receivers)).append("\n");
        sb.append("    endpoint: ").append(this.toIndentedString(this.endpoint)).append("\n");
        sb.append("    secretKey: ").append(this.toIndentedString(this.secretKey)).append("\n");
        sb.append("    headers: ").append(this.toIndentedString(this.headers)).append("\n");
        sb.append("    queryParams: ").append(this.toIndentedString(this.queryParams)).append("\n");
        sb.append("    httpMethod: ").append(this.toIndentedString((Object)this.httpMethod)).append("\n");
        sb.append("    sendToAdmins: ").append(this.toIndentedString(this.sendToAdmins)).append("\n");
        sb.append("    sendToOwners: ").append(this.toIndentedString(this.sendToOwners)).append("\n");
        sb.append("    sendToFollowers: ").append(this.toIndentedString(this.sendToFollowers)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum HttpMethodEnum {
        POST(String.valueOf("POST")),
        PUT(String.valueOf("PUT"));

        private String value;

        private HttpMethodEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static HttpMethodEnum fromValue(String value) {
            for (HttpMethodEnum b : HttpMethodEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

