package org.openmetadata.client.api;

import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;

import org.openmetadata.client.model.SearchResponse;
import org.openmetadata.client.model.Suggest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import feign.*;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-20T11:35:38.398944261Z[Etc/UTC]")
public interface SearchApi extends ApiClient.Api {


  /**
   * Get aggregated fields
   * Get aggregated fields from entities.
   * @param q Search Query Text, Pass *text* for substring match; Pass without wildcards for exact match. &lt;br/&gt; 1. For listing all tables or topics pass q&#x3D;* &lt;br/&gt;2. For search tables or topics pass q&#x3D;*search_term* &lt;br/&gt;3. For searching field names such as search by column_name pass q&#x3D;column_names:address &lt;br/&gt;4. For searching by tag names pass q&#x3D;tags:user.email &lt;br/&gt;5. When user selects a filter pass q&#x3D;query_text AND tags:user.email AND platform:MYSQL &lt;br/&gt;6. Search with multiple values of same filter q&#x3D;tags:user.email AND tags:user.address &lt;br/&gt; logic operators such as AND and OR must be in uppercase  (required)
   * @param index  (optional, default to table_search_index)
   * @param field Field in an entity. (optional)
   * @param value value for searching in aggregation (optional, default to )
   * @param size Size field to limit the no.of results returned, defaults to 10 (optional, default to 10)
   * @param deleted  (optional, default to false)
   * @return Suggest
   */
  @RequestLine("GET /v1/search/aggregate?index={index}&field={field}&value={value}&q={q}&size={size}&deleted={deleted}")
  @Headers({
    "Accept: application/json",
  })
  Suggest getAggregateFields(@Param("q") String q, @Param("index") String index, @Param("field") String field, @Param("value") String value, @Param("size") Integer size, @Param("deleted") String deleted);

  /**
   * Get aggregated fields
   * Similar to <code>getAggregateFields</code> but it also returns the http response headers .
   * Get aggregated fields from entities.
   * @param q Search Query Text, Pass *text* for substring match; Pass without wildcards for exact match. &lt;br/&gt; 1. For listing all tables or topics pass q&#x3D;* &lt;br/&gt;2. For search tables or topics pass q&#x3D;*search_term* &lt;br/&gt;3. For searching field names such as search by column_name pass q&#x3D;column_names:address &lt;br/&gt;4. For searching by tag names pass q&#x3D;tags:user.email &lt;br/&gt;5. When user selects a filter pass q&#x3D;query_text AND tags:user.email AND platform:MYSQL &lt;br/&gt;6. Search with multiple values of same filter q&#x3D;tags:user.email AND tags:user.address &lt;br/&gt; logic operators such as AND and OR must be in uppercase  (required)
   * @param index  (optional, default to table_search_index)
   * @param field Field in an entity. (optional)
   * @param value value for searching in aggregation (optional, default to )
   * @param size Size field to limit the no.of results returned, defaults to 10 (optional, default to 10)
   * @param deleted  (optional, default to false)
   * @return A ApiResponse that wraps the response boyd and the http headers.
   */
  @RequestLine("GET /v1/search/aggregate?index={index}&field={field}&value={value}&q={q}&size={size}&deleted={deleted}")
  @Headers({
    "Accept: application/json",
  })
  ApiResponse<Suggest> getAggregateFieldsWithHttpInfo(@Param("q") String q, @Param("index") String index, @Param("field") String field, @Param("value") String value, @Param("size") Integer size, @Param("deleted") String deleted);


  /**
   * Get aggregated fields
   * Get aggregated fields from entities.
   * Note, this is equivalent to the other <code>getAggregateFields</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link GetAggregateFieldsQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>index -  (optional, default to table_search_index)</li>
   *   <li>field - Field in an entity. (optional)</li>
   *   <li>value - value for searching in aggregation (optional, default to )</li>
   *   <li>q - Search Query Text, Pass *text* for substring match; Pass without wildcards for exact match. &lt;br/&gt; 1. For listing all tables or topics pass q&#x3D;* &lt;br/&gt;2. For search tables or topics pass q&#x3D;*search_term* &lt;br/&gt;3. For searching field names such as search by column_name pass q&#x3D;column_names:address &lt;br/&gt;4. For searching by tag names pass q&#x3D;tags:user.email &lt;br/&gt;5. When user selects a filter pass q&#x3D;query_text AND tags:user.email AND platform:MYSQL &lt;br/&gt;6. Search with multiple values of same filter q&#x3D;tags:user.email AND tags:user.address &lt;br/&gt; logic operators such as AND and OR must be in uppercase  (required)</li>
   *   <li>size - Size field to limit the no.of results returned, defaults to 10 (optional, default to 10)</li>
   *   <li>deleted -  (optional, default to false)</li>
   *   </ul>
   * @return Suggest
   */
  @RequestLine("GET /v1/search/aggregate?index={index}&field={field}&value={value}&q={q}&size={size}&deleted={deleted}")
  @Headers({
  "Accept: application/json",
  })
  Suggest getAggregateFields(@QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
  * Get aggregated fields
  * Get aggregated fields from entities.
  * Note, this is equivalent to the other <code>getAggregateFields</code> that receives the query parameters as a map,
  * but this one also exposes the Http response headers
      * @param queryParams Map of query parameters as name-value pairs
      *   <p>The following elements may be specified in the query map:</p>
      *   <ul>
          *   <li>index -  (optional, default to table_search_index)</li>
          *   <li>field - Field in an entity. (optional)</li>
          *   <li>value - value for searching in aggregation (optional, default to )</li>
          *   <li>q - Search Query Text, Pass *text* for substring match; Pass without wildcards for exact match. &lt;br/&gt; 1. For listing all tables or topics pass q&#x3D;* &lt;br/&gt;2. For search tables or topics pass q&#x3D;*search_term* &lt;br/&gt;3. For searching field names such as search by column_name pass q&#x3D;column_names:address &lt;br/&gt;4. For searching by tag names pass q&#x3D;tags:user.email &lt;br/&gt;5. When user selects a filter pass q&#x3D;query_text AND tags:user.email AND platform:MYSQL &lt;br/&gt;6. Search with multiple values of same filter q&#x3D;tags:user.email AND tags:user.address &lt;br/&gt; logic operators such as AND and OR must be in uppercase  (required)</li>
          *   <li>size - Size field to limit the no.of results returned, defaults to 10 (optional, default to 10)</li>
          *   <li>deleted -  (optional, default to false)</li>
      *   </ul>
          * @return Suggest
      */
      @RequestLine("GET /v1/search/aggregate?index={index}&field={field}&value={value}&q={q}&size={size}&deleted={deleted}")
      @Headers({
    "Accept: application/json",
      })
   ApiResponse<Suggest> getAggregateFieldsWithHttpInfo(@QueryMap(encoded=true) Map<String, Object> queryParams);


   /**
   * A convenience class for generating query parameters for the
   * <code>getAggregateFields</code> method in a fluent style.
   */
  public static class GetAggregateFieldsQueryParams extends HashMap<String, Object> {
    public GetAggregateFieldsQueryParams index(final String value) {
      put("index", EncodingUtils.encode(value));
      return this;
    }
    public GetAggregateFieldsQueryParams field(final String value) {
      put("field", EncodingUtils.encode(value));
      return this;
    }
    public GetAggregateFieldsQueryParams value(final String value) {
      put("value", EncodingUtils.encode(value));
      return this;
    }
    public GetAggregateFieldsQueryParams q(final String value) {
      put("q", EncodingUtils.encode(value));
      return this;
    }
    public GetAggregateFieldsQueryParams size(final Integer value) {
      put("size", EncodingUtils.encode(value));
      return this;
    }
    public GetAggregateFieldsQueryParams deleted(final String value) {
      put("deleted", EncodingUtils.encode(value));
      return this;
    }
  }

  /**
   * Get Stream Job Latest Status
   * Stream Job Status
   */
  @RequestLine("GET /v1/search/reindex/stream/status")
  @Headers({
    "Accept: application/json",
  })
  void getStreamJobStatus();

  /**
   * Get Stream Job Latest Status
   * Similar to <code>getStreamJobStatus</code> but it also returns the http response headers .
   * Stream Job Status
   */
  @RequestLine("GET /v1/search/reindex/stream/status")
  @Headers({
    "Accept: application/json",
  })
  ApiResponse<Void> getStreamJobStatusWithHttpInfo();



  /**
   * Suggest entities
   * Get suggested entities used for auto-completion.
   * @param q Suggest API can be used to auto-fill the entities name while use is typing search text &lt;br/&gt; 1. To get suggest results pass q&#x3D;us or q&#x3D;user etc.. &lt;br/&gt; 2. Do not add any wild-cards such as * like in search api &lt;br/&gt; 3. suggest api is a prefix suggestion &lt;br/&gt; (required)
   * @param index  (optional, default to table_search_index)
   * @param field Field in object containing valid suggestions. Defaults to &#39;suggest&#x60;. All indices has a &#x60;suggest&#x60; field, only some indices have other &#x60;suggest_*&#x60; fields. (optional, default to suggest)
   * @param size Size field to limit the no.of results returned, defaults to 10 (optional, default to 10)
   * @param fetchSource Get document body for each hit (optional, default to true)
   * @param includeSourceFields Get only selected fields of the document body for each hit. Empty value will return all fields (optional)
   * @param deleted  (optional, default to false)
   * @return Suggest
   */
  @RequestLine("GET /v1/search/suggest?q={q}&index={index}&field={field}&size={size}&fetch_source={fetchSource}&include_source_fields={includeSourceFields}&deleted={deleted}")
  @Headers({
    "Accept: application/json",
  })
  Suggest getSuggestedEntities(@Param("q") String q, @Param("index") String index, @Param("field") String field, @Param("size") Integer size, @Param("fetchSource") Boolean fetchSource, @Param("includeSourceFields") List<String> includeSourceFields, @Param("deleted") Boolean deleted);

  /**
   * Suggest entities
   * Similar to <code>getSuggestedEntities</code> but it also returns the http response headers .
   * Get suggested entities used for auto-completion.
   * @param q Suggest API can be used to auto-fill the entities name while use is typing search text &lt;br/&gt; 1. To get suggest results pass q&#x3D;us or q&#x3D;user etc.. &lt;br/&gt; 2. Do not add any wild-cards such as * like in search api &lt;br/&gt; 3. suggest api is a prefix suggestion &lt;br/&gt; (required)
   * @param index  (optional, default to table_search_index)
   * @param field Field in object containing valid suggestions. Defaults to &#39;suggest&#x60;. All indices has a &#x60;suggest&#x60; field, only some indices have other &#x60;suggest_*&#x60; fields. (optional, default to suggest)
   * @param size Size field to limit the no.of results returned, defaults to 10 (optional, default to 10)
   * @param fetchSource Get document body for each hit (optional, default to true)
   * @param includeSourceFields Get only selected fields of the document body for each hit. Empty value will return all fields (optional)
   * @param deleted  (optional, default to false)
   * @return A ApiResponse that wraps the response boyd and the http headers.
   */
  @RequestLine("GET /v1/search/suggest?q={q}&index={index}&field={field}&size={size}&fetch_source={fetchSource}&include_source_fields={includeSourceFields}&deleted={deleted}")
  @Headers({
    "Accept: application/json",
  })
  ApiResponse<Suggest> getSuggestedEntitiesWithHttpInfo(@Param("q") String q, @Param("index") String index, @Param("field") String field, @Param("size") Integer size, @Param("fetchSource") Boolean fetchSource, @Param("includeSourceFields") List<String> includeSourceFields, @Param("deleted") Boolean deleted);


  /**
   * Suggest entities
   * Get suggested entities used for auto-completion.
   * Note, this is equivalent to the other <code>getSuggestedEntities</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link GetSuggestedEntitiesQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>q - Suggest API can be used to auto-fill the entities name while use is typing search text &lt;br/&gt; 1. To get suggest results pass q&#x3D;us or q&#x3D;user etc.. &lt;br/&gt; 2. Do not add any wild-cards such as * like in search api &lt;br/&gt; 3. suggest api is a prefix suggestion &lt;br/&gt; (required)</li>
   *   <li>index -  (optional, default to table_search_index)</li>
   *   <li>field - Field in object containing valid suggestions. Defaults to &#39;suggest&#x60;. All indices has a &#x60;suggest&#x60; field, only some indices have other &#x60;suggest_*&#x60; fields. (optional, default to suggest)</li>
   *   <li>size - Size field to limit the no.of results returned, defaults to 10 (optional, default to 10)</li>
   *   <li>fetchSource - Get document body for each hit (optional, default to true)</li>
   *   <li>includeSourceFields - Get only selected fields of the document body for each hit. Empty value will return all fields (optional)</li>
   *   <li>deleted -  (optional, default to false)</li>
   *   </ul>
   * @return Suggest
   */
  @RequestLine("GET /v1/search/suggest?q={q}&index={index}&field={field}&size={size}&fetch_source={fetchSource}&include_source_fields={includeSourceFields}&deleted={deleted}")
  @Headers({
  "Accept: application/json",
  })
  Suggest getSuggestedEntities(@QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
  * Suggest entities
  * Get suggested entities used for auto-completion.
  * Note, this is equivalent to the other <code>getSuggestedEntities</code> that receives the query parameters as a map,
  * but this one also exposes the Http response headers
      * @param queryParams Map of query parameters as name-value pairs
      *   <p>The following elements may be specified in the query map:</p>
      *   <ul>
          *   <li>q - Suggest API can be used to auto-fill the entities name while use is typing search text &lt;br/&gt; 1. To get suggest results pass q&#x3D;us or q&#x3D;user etc.. &lt;br/&gt; 2. Do not add any wild-cards such as * like in search api &lt;br/&gt; 3. suggest api is a prefix suggestion &lt;br/&gt; (required)</li>
          *   <li>index -  (optional, default to table_search_index)</li>
          *   <li>field - Field in object containing valid suggestions. Defaults to &#39;suggest&#x60;. All indices has a &#x60;suggest&#x60; field, only some indices have other &#x60;suggest_*&#x60; fields. (optional, default to suggest)</li>
          *   <li>size - Size field to limit the no.of results returned, defaults to 10 (optional, default to 10)</li>
          *   <li>fetchSource - Get document body for each hit (optional, default to true)</li>
          *   <li>includeSourceFields - Get only selected fields of the document body for each hit. Empty value will return all fields (optional)</li>
          *   <li>deleted -  (optional, default to false)</li>
      *   </ul>
          * @return Suggest
      */
      @RequestLine("GET /v1/search/suggest?q={q}&index={index}&field={field}&size={size}&fetch_source={fetchSource}&include_source_fields={includeSourceFields}&deleted={deleted}")
      @Headers({
    "Accept: application/json",
      })
   ApiResponse<Suggest> getSuggestedEntitiesWithHttpInfo(@QueryMap(encoded=true) Map<String, Object> queryParams);


   /**
   * A convenience class for generating query parameters for the
   * <code>getSuggestedEntities</code> method in a fluent style.
   */
  public static class GetSuggestedEntitiesQueryParams extends HashMap<String, Object> {
    public GetSuggestedEntitiesQueryParams q(final String value) {
      put("q", EncodingUtils.encode(value));
      return this;
    }
    public GetSuggestedEntitiesQueryParams index(final String value) {
      put("index", EncodingUtils.encode(value));
      return this;
    }
    public GetSuggestedEntitiesQueryParams field(final String value) {
      put("field", EncodingUtils.encode(value));
      return this;
    }
    public GetSuggestedEntitiesQueryParams size(final Integer value) {
      put("size", EncodingUtils.encode(value));
      return this;
    }
    public GetSuggestedEntitiesQueryParams fetchSource(final Boolean value) {
      put("fetch_source", EncodingUtils.encode(value));
      return this;
    }
    public GetSuggestedEntitiesQueryParams includeSourceFields(final List<String> value) {
      put("include_source_fields", EncodingUtils.encodeCollection(value, "multi"));
      return this;
    }
    public GetSuggestedEntitiesQueryParams deleted(final Boolean value) {
      put("deleted", EncodingUtils.encode(value));
      return this;
    }
  }

  /**
   * Search entities
   * Search entities using query test. Use query params &#x60;from&#x60; and &#x60;size&#x60; for pagination. Use &#x60;sort_field&#x60; to sort the results in &#x60;sort_order&#x60;.
   * @param q Search Query Text, Pass *text* for substring match; Pass without wildcards for exact match. &lt;br/&gt; 1. For listing all tables or topics pass q&#x3D;* &lt;br/&gt;2. For search tables or topics pass q&#x3D;*search_term* &lt;br/&gt;3. For searching field names such as search by column_name pass q&#x3D;column_names:address &lt;br/&gt;4. For searching by tag names pass q&#x3D;tags:user.email &lt;br/&gt;5. When user selects a filter pass q&#x3D;query_text AND tags:user.email AND platform:MYSQL &lt;br/&gt;6. Search with multiple values of same filter q&#x3D;tags:user.email AND tags:user.address &lt;br/&gt; logic operators such as AND and OR must be in uppercase  (required)
   * @param index ElasticSearch Index name, defaults to table_search_index (optional, default to table_search_index)
   * @param deleted Filter documents by deleted param. By default deleted is false (optional, default to false)
   * @param from From field to paginate the results, defaults to 0 (optional, default to 0)
   * @param size Size field to limit the no.of results returned, defaults to 10 (optional, default to 10)
   * @param sortField Sort the search results by field, available fields to sort weekly_stats , daily_stats, monthly_stats, last_updated_timestamp (optional, default to _score)
   * @param sortOrder Sort order asc for ascending or desc for descending, defaults to desc (optional, default to desc)
   * @param trackTotalHits Track Total Hits (optional, default to false)
   * @param queryFilter Elasticsearch query that will be combined with the query_string query generator from the &#x60;query&#x60; argument (optional)
   * @param postFilter Elasticsearch query that will be used as a post_filter (optional)
   * @param fetchSource Get document body for each hit (optional, default to true)
   * @param includeSourceFields Get only selected fields of the document body for each hit. Empty value will return all fields (optional)
   * @return SearchResponse
   */
  @RequestLine("GET /v1/search/query?q={q}&index={index}&deleted={deleted}&from={from}&size={size}&sort_field={sortField}&sort_order={sortOrder}&track_total_hits={trackTotalHits}&query_filter={queryFilter}&post_filter={postFilter}&fetch_source={fetchSource}&include_source_fields={includeSourceFields}")
  @Headers({
    "Accept: application/json",
  })
  SearchResponse searchEntitiesWithQuery(@Param("q") String q, @Param("index") String index, @Param("deleted") Boolean deleted, @Param("from") Integer from, @Param("size") Integer size, @Param("sortField") String sortField, @Param("sortOrder") String sortOrder, @Param("trackTotalHits") Boolean trackTotalHits, @Param("queryFilter") String queryFilter, @Param("postFilter") String postFilter, @Param("fetchSource") Boolean fetchSource, @Param("includeSourceFields") List<String> includeSourceFields);

  /**
   * Search entities
   * Similar to <code>searchEntitiesWithQuery</code> but it also returns the http response headers .
   * Search entities using query test. Use query params &#x60;from&#x60; and &#x60;size&#x60; for pagination. Use &#x60;sort_field&#x60; to sort the results in &#x60;sort_order&#x60;.
   * @param q Search Query Text, Pass *text* for substring match; Pass without wildcards for exact match. &lt;br/&gt; 1. For listing all tables or topics pass q&#x3D;* &lt;br/&gt;2. For search tables or topics pass q&#x3D;*search_term* &lt;br/&gt;3. For searching field names such as search by column_name pass q&#x3D;column_names:address &lt;br/&gt;4. For searching by tag names pass q&#x3D;tags:user.email &lt;br/&gt;5. When user selects a filter pass q&#x3D;query_text AND tags:user.email AND platform:MYSQL &lt;br/&gt;6. Search with multiple values of same filter q&#x3D;tags:user.email AND tags:user.address &lt;br/&gt; logic operators such as AND and OR must be in uppercase  (required)
   * @param index ElasticSearch Index name, defaults to table_search_index (optional, default to table_search_index)
   * @param deleted Filter documents by deleted param. By default deleted is false (optional, default to false)
   * @param from From field to paginate the results, defaults to 0 (optional, default to 0)
   * @param size Size field to limit the no.of results returned, defaults to 10 (optional, default to 10)
   * @param sortField Sort the search results by field, available fields to sort weekly_stats , daily_stats, monthly_stats, last_updated_timestamp (optional, default to _score)
   * @param sortOrder Sort order asc for ascending or desc for descending, defaults to desc (optional, default to desc)
   * @param trackTotalHits Track Total Hits (optional, default to false)
   * @param queryFilter Elasticsearch query that will be combined with the query_string query generator from the &#x60;query&#x60; argument (optional)
   * @param postFilter Elasticsearch query that will be used as a post_filter (optional)
   * @param fetchSource Get document body for each hit (optional, default to true)
   * @param includeSourceFields Get only selected fields of the document body for each hit. Empty value will return all fields (optional)
   * @return A ApiResponse that wraps the response boyd and the http headers.
   */
  @RequestLine("GET /v1/search/query?q={q}&index={index}&deleted={deleted}&from={from}&size={size}&sort_field={sortField}&sort_order={sortOrder}&track_total_hits={trackTotalHits}&query_filter={queryFilter}&post_filter={postFilter}&fetch_source={fetchSource}&include_source_fields={includeSourceFields}")
  @Headers({
    "Accept: application/json",
  })
  ApiResponse<SearchResponse> searchEntitiesWithQueryWithHttpInfo(@Param("q") String q, @Param("index") String index, @Param("deleted") Boolean deleted, @Param("from") Integer from, @Param("size") Integer size, @Param("sortField") String sortField, @Param("sortOrder") String sortOrder, @Param("trackTotalHits") Boolean trackTotalHits, @Param("queryFilter") String queryFilter, @Param("postFilter") String postFilter, @Param("fetchSource") Boolean fetchSource, @Param("includeSourceFields") List<String> includeSourceFields);


  /**
   * Search entities
   * Search entities using query test. Use query params &#x60;from&#x60; and &#x60;size&#x60; for pagination. Use &#x60;sort_field&#x60; to sort the results in &#x60;sort_order&#x60;.
   * Note, this is equivalent to the other <code>searchEntitiesWithQuery</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link SearchEntitiesWithQueryQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>q - Search Query Text, Pass *text* for substring match; Pass without wildcards for exact match. &lt;br/&gt; 1. For listing all tables or topics pass q&#x3D;* &lt;br/&gt;2. For search tables or topics pass q&#x3D;*search_term* &lt;br/&gt;3. For searching field names such as search by column_name pass q&#x3D;column_names:address &lt;br/&gt;4. For searching by tag names pass q&#x3D;tags:user.email &lt;br/&gt;5. When user selects a filter pass q&#x3D;query_text AND tags:user.email AND platform:MYSQL &lt;br/&gt;6. Search with multiple values of same filter q&#x3D;tags:user.email AND tags:user.address &lt;br/&gt; logic operators such as AND and OR must be in uppercase  (required)</li>
   *   <li>index - ElasticSearch Index name, defaults to table_search_index (optional, default to table_search_index)</li>
   *   <li>deleted - Filter documents by deleted param. By default deleted is false (optional, default to false)</li>
   *   <li>from - From field to paginate the results, defaults to 0 (optional, default to 0)</li>
   *   <li>size - Size field to limit the no.of results returned, defaults to 10 (optional, default to 10)</li>
   *   <li>sortField - Sort the search results by field, available fields to sort weekly_stats , daily_stats, monthly_stats, last_updated_timestamp (optional, default to _score)</li>
   *   <li>sortOrder - Sort order asc for ascending or desc for descending, defaults to desc (optional, default to desc)</li>
   *   <li>trackTotalHits - Track Total Hits (optional, default to false)</li>
   *   <li>queryFilter - Elasticsearch query that will be combined with the query_string query generator from the &#x60;query&#x60; argument (optional)</li>
   *   <li>postFilter - Elasticsearch query that will be used as a post_filter (optional)</li>
   *   <li>fetchSource - Get document body for each hit (optional, default to true)</li>
   *   <li>includeSourceFields - Get only selected fields of the document body for each hit. Empty value will return all fields (optional)</li>
   *   </ul>
   * @return SearchResponse
   */
  @RequestLine("GET /v1/search/query?q={q}&index={index}&deleted={deleted}&from={from}&size={size}&sort_field={sortField}&sort_order={sortOrder}&track_total_hits={trackTotalHits}&query_filter={queryFilter}&post_filter={postFilter}&fetch_source={fetchSource}&include_source_fields={includeSourceFields}")
  @Headers({
  "Accept: application/json",
  })
  SearchResponse searchEntitiesWithQuery(@QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
  * Search entities
  * Search entities using query test. Use query params &#x60;from&#x60; and &#x60;size&#x60; for pagination. Use &#x60;sort_field&#x60; to sort the results in &#x60;sort_order&#x60;.
  * Note, this is equivalent to the other <code>searchEntitiesWithQuery</code> that receives the query parameters as a map,
  * but this one also exposes the Http response headers
      * @param queryParams Map of query parameters as name-value pairs
      *   <p>The following elements may be specified in the query map:</p>
      *   <ul>
          *   <li>q - Search Query Text, Pass *text* for substring match; Pass without wildcards for exact match. &lt;br/&gt; 1. For listing all tables or topics pass q&#x3D;* &lt;br/&gt;2. For search tables or topics pass q&#x3D;*search_term* &lt;br/&gt;3. For searching field names such as search by column_name pass q&#x3D;column_names:address &lt;br/&gt;4. For searching by tag names pass q&#x3D;tags:user.email &lt;br/&gt;5. When user selects a filter pass q&#x3D;query_text AND tags:user.email AND platform:MYSQL &lt;br/&gt;6. Search with multiple values of same filter q&#x3D;tags:user.email AND tags:user.address &lt;br/&gt; logic operators such as AND and OR must be in uppercase  (required)</li>
          *   <li>index - ElasticSearch Index name, defaults to table_search_index (optional, default to table_search_index)</li>
          *   <li>deleted - Filter documents by deleted param. By default deleted is false (optional, default to false)</li>
          *   <li>from - From field to paginate the results, defaults to 0 (optional, default to 0)</li>
          *   <li>size - Size field to limit the no.of results returned, defaults to 10 (optional, default to 10)</li>
          *   <li>sortField - Sort the search results by field, available fields to sort weekly_stats , daily_stats, monthly_stats, last_updated_timestamp (optional, default to _score)</li>
          *   <li>sortOrder - Sort order asc for ascending or desc for descending, defaults to desc (optional, default to desc)</li>
          *   <li>trackTotalHits - Track Total Hits (optional, default to false)</li>
          *   <li>queryFilter - Elasticsearch query that will be combined with the query_string query generator from the &#x60;query&#x60; argument (optional)</li>
          *   <li>postFilter - Elasticsearch query that will be used as a post_filter (optional)</li>
          *   <li>fetchSource - Get document body for each hit (optional, default to true)</li>
          *   <li>includeSourceFields - Get only selected fields of the document body for each hit. Empty value will return all fields (optional)</li>
      *   </ul>
          * @return SearchResponse
      */
      @RequestLine("GET /v1/search/query?q={q}&index={index}&deleted={deleted}&from={from}&size={size}&sort_field={sortField}&sort_order={sortOrder}&track_total_hits={trackTotalHits}&query_filter={queryFilter}&post_filter={postFilter}&fetch_source={fetchSource}&include_source_fields={includeSourceFields}")
      @Headers({
    "Accept: application/json",
      })
   ApiResponse<SearchResponse> searchEntitiesWithQueryWithHttpInfo(@QueryMap(encoded=true) Map<String, Object> queryParams);


   /**
   * A convenience class for generating query parameters for the
   * <code>searchEntitiesWithQuery</code> method in a fluent style.
   */
  public static class SearchEntitiesWithQueryQueryParams extends HashMap<String, Object> {
    public SearchEntitiesWithQueryQueryParams q(final String value) {
      put("q", EncodingUtils.encode(value));
      return this;
    }
    public SearchEntitiesWithQueryQueryParams index(final String value) {
      put("index", EncodingUtils.encode(value));
      return this;
    }
    public SearchEntitiesWithQueryQueryParams deleted(final Boolean value) {
      put("deleted", EncodingUtils.encode(value));
      return this;
    }
    public SearchEntitiesWithQueryQueryParams from(final Integer value) {
      put("from", EncodingUtils.encode(value));
      return this;
    }
    public SearchEntitiesWithQueryQueryParams size(final Integer value) {
      put("size", EncodingUtils.encode(value));
      return this;
    }
    public SearchEntitiesWithQueryQueryParams sortField(final String value) {
      put("sort_field", EncodingUtils.encode(value));
      return this;
    }
    public SearchEntitiesWithQueryQueryParams sortOrder(final String value) {
      put("sort_order", EncodingUtils.encode(value));
      return this;
    }
    public SearchEntitiesWithQueryQueryParams trackTotalHits(final Boolean value) {
      put("track_total_hits", EncodingUtils.encode(value));
      return this;
    }
    public SearchEntitiesWithQueryQueryParams queryFilter(final String value) {
      put("query_filter", EncodingUtils.encode(value));
      return this;
    }
    public SearchEntitiesWithQueryQueryParams postFilter(final String value) {
      put("post_filter", EncodingUtils.encode(value));
      return this;
    }
    public SearchEntitiesWithQueryQueryParams fetchSource(final Boolean value) {
      put("fetch_source", EncodingUtils.encode(value));
      return this;
    }
    public SearchEntitiesWithQueryQueryParams includeSourceFields(final List<String> value) {
      put("include_source_fields", EncodingUtils.encodeCollection(value, "multi"));
      return this;
    }
  }

  /**
   * Search entities
   * 
   * @param sourceUrl source url (optional)
   * @return SearchResponse
   */
  @RequestLine("GET /v1/search/sourceUrl?sourceUrl={sourceUrl}")
  @Headers({
    "Accept: application/json",
  })
  SearchResponse searchEntitiesWithSourceUrl(@Param("sourceUrl") String sourceUrl);

  /**
   * Search entities
   * Similar to <code>searchEntitiesWithSourceUrl</code> but it also returns the http response headers .
   * 
   * @param sourceUrl source url (optional)
   * @return A ApiResponse that wraps the response boyd and the http headers.
   */
  @RequestLine("GET /v1/search/sourceUrl?sourceUrl={sourceUrl}")
  @Headers({
    "Accept: application/json",
  })
  ApiResponse<SearchResponse> searchEntitiesWithSourceUrlWithHttpInfo(@Param("sourceUrl") String sourceUrl);


  /**
   * Search entities
   * 
   * Note, this is equivalent to the other <code>searchEntitiesWithSourceUrl</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link SearchEntitiesWithSourceUrlQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>sourceUrl - source url (optional)</li>
   *   </ul>
   * @return SearchResponse
   */
  @RequestLine("GET /v1/search/sourceUrl?sourceUrl={sourceUrl}")
  @Headers({
  "Accept: application/json",
  })
  SearchResponse searchEntitiesWithSourceUrl(@QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
  * Search entities
  * 
  * Note, this is equivalent to the other <code>searchEntitiesWithSourceUrl</code> that receives the query parameters as a map,
  * but this one also exposes the Http response headers
      * @param queryParams Map of query parameters as name-value pairs
      *   <p>The following elements may be specified in the query map:</p>
      *   <ul>
          *   <li>sourceUrl - source url (optional)</li>
      *   </ul>
          * @return SearchResponse
      */
      @RequestLine("GET /v1/search/sourceUrl?sourceUrl={sourceUrl}")
      @Headers({
    "Accept: application/json",
      })
   ApiResponse<SearchResponse> searchEntitiesWithSourceUrlWithHttpInfo(@QueryMap(encoded=true) Map<String, Object> queryParams);


   /**
   * A convenience class for generating query parameters for the
   * <code>searchEntitiesWithSourceUrl</code> method in a fluent style.
   */
  public static class SearchEntitiesWithSourceUrlQueryParams extends HashMap<String, Object> {
    public SearchEntitiesWithSourceUrlQueryParams sourceUrl(final String value) {
      put("sourceUrl", EncodingUtils.encode(value));
      return this;
    }
  }

  /**
   * Search entities
   * 
   * @param fieldName field name (optional)
   * @param fieldValue field value (optional)
   * @param index Search Index name, defaults to table_search_index (optional, default to table_search_index)
   * @return SearchResponse
   */
  @RequestLine("GET /v1/search/fieldQuery?fieldName={fieldName}&fieldValue={fieldValue}&index={index}")
  @Headers({
    "Accept: application/json",
  })
  SearchResponse searchEntitiesWithSpecificFieldAndValue(@Param("fieldName") String fieldName, @Param("fieldValue") String fieldValue, @Param("index") String index);

  /**
   * Search entities
   * Similar to <code>searchEntitiesWithSpecificFieldAndValue</code> but it also returns the http response headers .
   * 
   * @param fieldName field name (optional)
   * @param fieldValue field value (optional)
   * @param index Search Index name, defaults to table_search_index (optional, default to table_search_index)
   * @return A ApiResponse that wraps the response boyd and the http headers.
   */
  @RequestLine("GET /v1/search/fieldQuery?fieldName={fieldName}&fieldValue={fieldValue}&index={index}")
  @Headers({
    "Accept: application/json",
  })
  ApiResponse<SearchResponse> searchEntitiesWithSpecificFieldAndValueWithHttpInfo(@Param("fieldName") String fieldName, @Param("fieldValue") String fieldValue, @Param("index") String index);


  /**
   * Search entities
   * 
   * Note, this is equivalent to the other <code>searchEntitiesWithSpecificFieldAndValue</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link SearchEntitiesWithSpecificFieldAndValueQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>fieldName - field name (optional)</li>
   *   <li>fieldValue - field value (optional)</li>
   *   <li>index - Search Index name, defaults to table_search_index (optional, default to table_search_index)</li>
   *   </ul>
   * @return SearchResponse
   */
  @RequestLine("GET /v1/search/fieldQuery?fieldName={fieldName}&fieldValue={fieldValue}&index={index}")
  @Headers({
  "Accept: application/json",
  })
  SearchResponse searchEntitiesWithSpecificFieldAndValue(@QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
  * Search entities
  * 
  * Note, this is equivalent to the other <code>searchEntitiesWithSpecificFieldAndValue</code> that receives the query parameters as a map,
  * but this one also exposes the Http response headers
      * @param queryParams Map of query parameters as name-value pairs
      *   <p>The following elements may be specified in the query map:</p>
      *   <ul>
          *   <li>fieldName - field name (optional)</li>
          *   <li>fieldValue - field value (optional)</li>
          *   <li>index - Search Index name, defaults to table_search_index (optional, default to table_search_index)</li>
      *   </ul>
          * @return SearchResponse
      */
      @RequestLine("GET /v1/search/fieldQuery?fieldName={fieldName}&fieldValue={fieldValue}&index={index}")
      @Headers({
    "Accept: application/json",
      })
   ApiResponse<SearchResponse> searchEntitiesWithSpecificFieldAndValueWithHttpInfo(@QueryMap(encoded=true) Map<String, Object> queryParams);


   /**
   * A convenience class for generating query parameters for the
   * <code>searchEntitiesWithSpecificFieldAndValue</code> method in a fluent style.
   */
  public static class SearchEntitiesWithSpecificFieldAndValueQueryParams extends HashMap<String, Object> {
    public SearchEntitiesWithSpecificFieldAndValueQueryParams fieldName(final String value) {
      put("fieldName", EncodingUtils.encode(value));
      return this;
    }
    public SearchEntitiesWithSpecificFieldAndValueQueryParams fieldValue(final String value) {
      put("fieldValue", EncodingUtils.encode(value));
      return this;
    }
    public SearchEntitiesWithSpecificFieldAndValueQueryParams index(final String value) {
      put("index", EncodingUtils.encode(value));
      return this;
    }
  }
}
