/*
 * OpenMetadata Apis
 * --- title: APIs slug: /main-concepts/metadata-standard/apis ---  # APIs  OpenMetadata supports REST APIs for getting data and in and out of the metadata service. APIs are built using general best practices of REST API design. We take a schema-first approach by defining Types and Entities in JSON Schema. We implement APIs based on these schemas.  ## Overview  ### URI  Following REST API conventions are followed for Resource URIs: - Operations for an entity are available through the Resource URI as a collection `.../api/<version>/entities`.  - Plural of the entity name is used as the collection name - example `.../api/v1/users`. - Trailing forward slash is not used in the endpoint URI. Example use `.../api/v1/databases` instead of `.../api/v1/databases/`. - Resource URI for an entity instance by the entity id is `.../api/v1/entities/{id}`.  - Resource URI for an entity instance by name is `.../api/v1/entities/name/{name}`.  ### Resource Representation  - The REST API calls return a response with JSON `Content-Type` and `Content-Length` that includes the length of the response. - All responses include the Resource ID field even though the id was provided in the request to simplify the consumption    of the response at the client. - Entity names and field names use `camelCase` per Javascript naming convention. - All resources include an attribute `href` with Resource URI. All relationship fields of an entity will also    include `href` links to the related resource for easy access. - Unknown fields sent by the client in API requests are not ignored to ensure the data sent by the client is not dropped    at the server without the user being aware of it.  ## API Organization  You can find the swagger documentation [here](/swagger.html). In a nutshell:  **Data Asset APIs** - support operations related to data asset entities. - `.../api/v1/databases` - `...api/v1/tables` - `.../api/v1/metrics` - `.../api/v1/dashboards` - `.../api/v1/reports` - `.../api/v1/pipelines` - `.../api/v1/topics`  **Service APIs** - support operations related to services from which metadata is collected: - `.../api/v1/services` is the collection of all service resources. - `.../api/v1/services/databaseService` - APIs related to database services. This includes Transactional databases - MySQL, Postgres, MSSQL, Oracle, and Data Warehouses - Apache Hive BigQuery, Redshift, and Snowflake. - `.../api/v1/services/dashboardService` - APIs related to Dashboard Services. This includes Looker, Superset, and Tableau. - `.../api/v1/services/messagingService` - APIs related to Messaging Services. This includes Apache Kafka, Redpanda, - Kinesis, and others.  **Teams & Users APIs** - `.../api/v1/teams` - APIs related to team entities - `.../api/v1/users` - APIs related to user entities  **Search & Suggest APIs** - support search and suggest APIs: - `.../api/v1/search` - collection for search and suggest APIs - `.../api/v1/search/query` - search entities using query text - `.../api/v1/search/suggest` - get suggested entities used for auto-completion  **Other APIs** - `.../api/v1/tags` for APIs related to Classification and Tag entities - `../api/v1/feeds` for APIs related to Threads and Posts entities - `.../api/v1/usage` for reporting usage information of entities
 *
 * The version of the OpenAPI document: 1.2.2
 * Contact: openmetadata-dev@googlegroups.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.openmetadata.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.openmetadata.client.model.ChangeDescription;
import org.openmetadata.client.model.EntityReference;
import org.openmetadata.client.model.LifeCycle;
import org.openmetadata.client.model.Style;
import org.openmetadata.client.model.TagLabel;
import org.openmetadata.client.model.Votes;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * AppMarketPlaceDefinition
 */
@JsonPropertyOrder({
  AppMarketPlaceDefinition.JSON_PROPERTY_APP_CONFIGURATION,
  AppMarketPlaceDefinition.JSON_PROPERTY_APP_LOGO_URL,
  AppMarketPlaceDefinition.JSON_PROPERTY_APP_SCREENSHOTS,
  AppMarketPlaceDefinition.JSON_PROPERTY_APP_TYPE,
  AppMarketPlaceDefinition.JSON_PROPERTY_CHANGE_DESCRIPTION,
  AppMarketPlaceDefinition.JSON_PROPERTY_CHILDREN,
  AppMarketPlaceDefinition.JSON_PROPERTY_CLASS_NAME,
  AppMarketPlaceDefinition.JSON_PROPERTY_DATA_PRODUCTS,
  AppMarketPlaceDefinition.JSON_PROPERTY_DELETED,
  AppMarketPlaceDefinition.JSON_PROPERTY_DESCRIPTION,
  AppMarketPlaceDefinition.JSON_PROPERTY_DEVELOPER,
  AppMarketPlaceDefinition.JSON_PROPERTY_DEVELOPER_URL,
  AppMarketPlaceDefinition.JSON_PROPERTY_DISPLAY_NAME,
  AppMarketPlaceDefinition.JSON_PROPERTY_DOMAIN,
  AppMarketPlaceDefinition.JSON_PROPERTY_EXPERTS,
  AppMarketPlaceDefinition.JSON_PROPERTY_EXTENSION,
  AppMarketPlaceDefinition.JSON_PROPERTY_FEATURES,
  AppMarketPlaceDefinition.JSON_PROPERTY_FOLLOWERS,
  AppMarketPlaceDefinition.JSON_PROPERTY_FULLY_QUALIFIED_NAME,
  AppMarketPlaceDefinition.JSON_PROPERTY_HREF,
  AppMarketPlaceDefinition.JSON_PROPERTY_ID,
  AppMarketPlaceDefinition.JSON_PROPERTY_LIFE_CYCLE,
  AppMarketPlaceDefinition.JSON_PROPERTY_NAME,
  AppMarketPlaceDefinition.JSON_PROPERTY_OWNER,
  AppMarketPlaceDefinition.JSON_PROPERTY_PERMISSION,
  AppMarketPlaceDefinition.JSON_PROPERTY_PRIVACY_POLICY_URL,
  AppMarketPlaceDefinition.JSON_PROPERTY_PROVIDER,
  AppMarketPlaceDefinition.JSON_PROPERTY_REVIEWERS,
  AppMarketPlaceDefinition.JSON_PROPERTY_RUNTIME,
  AppMarketPlaceDefinition.JSON_PROPERTY_SCHEDULE_TYPE,
  AppMarketPlaceDefinition.JSON_PROPERTY_STYLE,
  AppMarketPlaceDefinition.JSON_PROPERTY_SUPPORT_EMAIL,
  AppMarketPlaceDefinition.JSON_PROPERTY_TAGS,
  AppMarketPlaceDefinition.JSON_PROPERTY_UPDATED_AT,
  AppMarketPlaceDefinition.JSON_PROPERTY_UPDATED_BY,
  AppMarketPlaceDefinition.JSON_PROPERTY_VERSION,
  AppMarketPlaceDefinition.JSON_PROPERTY_VOTES
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-20T11:35:38.398944261Z[Etc/UTC]")
public class AppMarketPlaceDefinition {
  public static final String JSON_PROPERTY_APP_CONFIGURATION = "appConfiguration";
  private Object appConfiguration;

  public static final String JSON_PROPERTY_APP_LOGO_URL = "appLogoUrl";
  private URI appLogoUrl;

  public static final String JSON_PROPERTY_APP_SCREENSHOTS = "appScreenshots";
  private Set<String> appScreenshots = null;

  /**
   * Gets or Sets appType
   */
  public enum AppTypeEnum {
    INTERNAL("internal"),
    
    EXTERNAL("external");

    private String value;

    AppTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static AppTypeEnum fromValue(String value) {
      for (AppTypeEnum b : AppTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_APP_TYPE = "appType";
  private AppTypeEnum appType;

  public static final String JSON_PROPERTY_CHANGE_DESCRIPTION = "changeDescription";
  private ChangeDescription changeDescription;

  public static final String JSON_PROPERTY_CHILDREN = "children";
  private List<EntityReference> children = null;

  public static final String JSON_PROPERTY_CLASS_NAME = "className";
  private String className;

  public static final String JSON_PROPERTY_DATA_PRODUCTS = "dataProducts";
  private List<EntityReference> dataProducts = null;

  public static final String JSON_PROPERTY_DELETED = "deleted";
  private Boolean deleted;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description;

  public static final String JSON_PROPERTY_DEVELOPER = "developer";
  private String developer;

  public static final String JSON_PROPERTY_DEVELOPER_URL = "developerUrl";
  private String developerUrl;

  public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
  private String displayName;

  public static final String JSON_PROPERTY_DOMAIN = "domain";
  private EntityReference domain;

  public static final String JSON_PROPERTY_EXPERTS = "experts";
  private List<EntityReference> experts = null;

  public static final String JSON_PROPERTY_EXTENSION = "extension";
  private Object extension;

  public static final String JSON_PROPERTY_FEATURES = "features";
  private String features;

  public static final String JSON_PROPERTY_FOLLOWERS = "followers";
  private List<EntityReference> followers = null;

  public static final String JSON_PROPERTY_FULLY_QUALIFIED_NAME = "fullyQualifiedName";
  private String fullyQualifiedName;

  public static final String JSON_PROPERTY_HREF = "href";
  private URI href;

  public static final String JSON_PROPERTY_ID = "id";
  private UUID id;

  public static final String JSON_PROPERTY_LIFE_CYCLE = "lifeCycle";
  private LifeCycle lifeCycle;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_OWNER = "owner";
  private EntityReference owner;

  /**
   * Gets or Sets permission
   */
  public enum PermissionEnum {
    ALL("All");

    private String value;

    PermissionEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PermissionEnum fromValue(String value) {
      for (PermissionEnum b : PermissionEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PERMISSION = "permission";
  private PermissionEnum permission;

  public static final String JSON_PROPERTY_PRIVACY_POLICY_URL = "privacyPolicyUrl";
  private String privacyPolicyUrl;

  /**
   * Gets or Sets provider
   */
  public enum ProviderEnum {
    SYSTEM("system"),
    
    USER("user");

    private String value;

    ProviderEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ProviderEnum fromValue(String value) {
      for (ProviderEnum b : ProviderEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PROVIDER = "provider";
  private ProviderEnum provider;

  public static final String JSON_PROPERTY_REVIEWERS = "reviewers";
  private List<EntityReference> reviewers = null;

  public static final String JSON_PROPERTY_RUNTIME = "runtime";
  private Object runtime;

  /**
   * Gets or Sets scheduleType
   */
  public enum ScheduleTypeEnum {
    LIVE("Live"),
    
    SCHEDULED("Scheduled");

    private String value;

    ScheduleTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ScheduleTypeEnum fromValue(String value) {
      for (ScheduleTypeEnum b : ScheduleTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_SCHEDULE_TYPE = "scheduleType";
  private ScheduleTypeEnum scheduleType;

  public static final String JSON_PROPERTY_STYLE = "style";
  private Style style;

  public static final String JSON_PROPERTY_SUPPORT_EMAIL = "supportEmail";
  private String supportEmail;

  public static final String JSON_PROPERTY_TAGS = "tags";
  private List<TagLabel> tags = null;

  public static final String JSON_PROPERTY_UPDATED_AT = "updatedAt";
  private Long updatedAt;

  public static final String JSON_PROPERTY_UPDATED_BY = "updatedBy";
  private String updatedBy;

  public static final String JSON_PROPERTY_VERSION = "version";
  private Double version;

  public static final String JSON_PROPERTY_VOTES = "votes";
  private Votes votes;

  public AppMarketPlaceDefinition() { 
  }

  public AppMarketPlaceDefinition appConfiguration(Object appConfiguration) {
    
    this.appConfiguration = appConfiguration;
    return this;
  }

   /**
   * Get appConfiguration
   * @return appConfiguration
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_APP_CONFIGURATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getAppConfiguration() {
    return appConfiguration;
  }


  @JsonProperty(JSON_PROPERTY_APP_CONFIGURATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAppConfiguration(Object appConfiguration) {
    this.appConfiguration = appConfiguration;
  }


  public AppMarketPlaceDefinition appLogoUrl(URI appLogoUrl) {
    
    this.appLogoUrl = appLogoUrl;
    return this;
  }

   /**
   * Get appLogoUrl
   * @return appLogoUrl
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_APP_LOGO_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public URI getAppLogoUrl() {
    return appLogoUrl;
  }


  @JsonProperty(JSON_PROPERTY_APP_LOGO_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAppLogoUrl(URI appLogoUrl) {
    this.appLogoUrl = appLogoUrl;
  }


  public AppMarketPlaceDefinition appScreenshots(Set<String> appScreenshots) {
    
    this.appScreenshots = appScreenshots;
    return this;
  }

  public AppMarketPlaceDefinition addAppScreenshotsItem(String appScreenshotsItem) {
    if (this.appScreenshots == null) {
      this.appScreenshots = new LinkedHashSet<>();
    }
    this.appScreenshots.add(appScreenshotsItem);
    return this;
  }

   /**
   * Get appScreenshots
   * @return appScreenshots
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_APP_SCREENSHOTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Set<String> getAppScreenshots() {
    return appScreenshots;
  }


  @JsonDeserialize(as = LinkedHashSet.class)
  @JsonProperty(JSON_PROPERTY_APP_SCREENSHOTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAppScreenshots(Set<String> appScreenshots) {
    this.appScreenshots = appScreenshots;
  }


  public AppMarketPlaceDefinition appType(AppTypeEnum appType) {
    
    this.appType = appType;
    return this;
  }

   /**
   * Get appType
   * @return appType
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_APP_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public AppTypeEnum getAppType() {
    return appType;
  }


  @JsonProperty(JSON_PROPERTY_APP_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAppType(AppTypeEnum appType) {
    this.appType = appType;
  }


  public AppMarketPlaceDefinition changeDescription(ChangeDescription changeDescription) {
    
    this.changeDescription = changeDescription;
    return this;
  }

   /**
   * Get changeDescription
   * @return changeDescription
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CHANGE_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ChangeDescription getChangeDescription() {
    return changeDescription;
  }


  @JsonProperty(JSON_PROPERTY_CHANGE_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChangeDescription(ChangeDescription changeDescription) {
    this.changeDescription = changeDescription;
  }


  public AppMarketPlaceDefinition children(List<EntityReference> children) {
    
    this.children = children;
    return this;
  }

  public AppMarketPlaceDefinition addChildrenItem(EntityReference childrenItem) {
    if (this.children == null) {
      this.children = new ArrayList<>();
    }
    this.children.add(childrenItem);
    return this;
  }

   /**
   * Get children
   * @return children
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CHILDREN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<EntityReference> getChildren() {
    return children;
  }


  @JsonProperty(JSON_PROPERTY_CHILDREN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChildren(List<EntityReference> children) {
    this.children = children;
  }


  public AppMarketPlaceDefinition className(String className) {
    
    this.className = className;
    return this;
  }

   /**
   * Get className
   * @return className
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_CLASS_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getClassName() {
    return className;
  }


  @JsonProperty(JSON_PROPERTY_CLASS_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setClassName(String className) {
    this.className = className;
  }


  public AppMarketPlaceDefinition dataProducts(List<EntityReference> dataProducts) {
    
    this.dataProducts = dataProducts;
    return this;
  }

  public AppMarketPlaceDefinition addDataProductsItem(EntityReference dataProductsItem) {
    if (this.dataProducts == null) {
      this.dataProducts = new ArrayList<>();
    }
    this.dataProducts.add(dataProductsItem);
    return this;
  }

   /**
   * Get dataProducts
   * @return dataProducts
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DATA_PRODUCTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<EntityReference> getDataProducts() {
    return dataProducts;
  }


  @JsonProperty(JSON_PROPERTY_DATA_PRODUCTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDataProducts(List<EntityReference> dataProducts) {
    this.dataProducts = dataProducts;
  }


  public AppMarketPlaceDefinition deleted(Boolean deleted) {
    
    this.deleted = deleted;
    return this;
  }

   /**
   * Get deleted
   * @return deleted
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DELETED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getDeleted() {
    return deleted;
  }


  @JsonProperty(JSON_PROPERTY_DELETED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDeleted(Boolean deleted) {
    this.deleted = deleted;
  }


  public AppMarketPlaceDefinition description(String description) {
    
    this.description = description;
    return this;
  }

   /**
   * Get description
   * @return description
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDescription() {
    return description;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(String description) {
    this.description = description;
  }


  public AppMarketPlaceDefinition developer(String developer) {
    
    this.developer = developer;
    return this;
  }

   /**
   * Get developer
   * @return developer
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DEVELOPER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDeveloper() {
    return developer;
  }


  @JsonProperty(JSON_PROPERTY_DEVELOPER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDeveloper(String developer) {
    this.developer = developer;
  }


  public AppMarketPlaceDefinition developerUrl(String developerUrl) {
    
    this.developerUrl = developerUrl;
    return this;
  }

   /**
   * Get developerUrl
   * @return developerUrl
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DEVELOPER_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDeveloperUrl() {
    return developerUrl;
  }


  @JsonProperty(JSON_PROPERTY_DEVELOPER_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDeveloperUrl(String developerUrl) {
    this.developerUrl = developerUrl;
  }


  public AppMarketPlaceDefinition displayName(String displayName) {
    
    this.displayName = displayName;
    return this;
  }

   /**
   * Get displayName
   * @return displayName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DISPLAY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDisplayName() {
    return displayName;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisplayName(String displayName) {
    this.displayName = displayName;
  }


  public AppMarketPlaceDefinition domain(EntityReference domain) {
    
    this.domain = domain;
    return this;
  }

   /**
   * Get domain
   * @return domain
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DOMAIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public EntityReference getDomain() {
    return domain;
  }


  @JsonProperty(JSON_PROPERTY_DOMAIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDomain(EntityReference domain) {
    this.domain = domain;
  }


  public AppMarketPlaceDefinition experts(List<EntityReference> experts) {
    
    this.experts = experts;
    return this;
  }

  public AppMarketPlaceDefinition addExpertsItem(EntityReference expertsItem) {
    if (this.experts == null) {
      this.experts = new ArrayList<>();
    }
    this.experts.add(expertsItem);
    return this;
  }

   /**
   * Get experts
   * @return experts
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_EXPERTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<EntityReference> getExperts() {
    return experts;
  }


  @JsonProperty(JSON_PROPERTY_EXPERTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExperts(List<EntityReference> experts) {
    this.experts = experts;
  }


  public AppMarketPlaceDefinition extension(Object extension) {
    
    this.extension = extension;
    return this;
  }

   /**
   * Get extension
   * @return extension
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_EXTENSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getExtension() {
    return extension;
  }


  @JsonProperty(JSON_PROPERTY_EXTENSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExtension(Object extension) {
    this.extension = extension;
  }


  public AppMarketPlaceDefinition features(String features) {
    
    this.features = features;
    return this;
  }

   /**
   * Get features
   * @return features
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_FEATURES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFeatures() {
    return features;
  }


  @JsonProperty(JSON_PROPERTY_FEATURES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFeatures(String features) {
    this.features = features;
  }


  public AppMarketPlaceDefinition followers(List<EntityReference> followers) {
    
    this.followers = followers;
    return this;
  }

  public AppMarketPlaceDefinition addFollowersItem(EntityReference followersItem) {
    if (this.followers == null) {
      this.followers = new ArrayList<>();
    }
    this.followers.add(followersItem);
    return this;
  }

   /**
   * Get followers
   * @return followers
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_FOLLOWERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<EntityReference> getFollowers() {
    return followers;
  }


  @JsonProperty(JSON_PROPERTY_FOLLOWERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFollowers(List<EntityReference> followers) {
    this.followers = followers;
  }


  public AppMarketPlaceDefinition fullyQualifiedName(String fullyQualifiedName) {
    
    this.fullyQualifiedName = fullyQualifiedName;
    return this;
  }

   /**
   * Get fullyQualifiedName
   * @return fullyQualifiedName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_FULLY_QUALIFIED_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFullyQualifiedName() {
    return fullyQualifiedName;
  }


  @JsonProperty(JSON_PROPERTY_FULLY_QUALIFIED_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFullyQualifiedName(String fullyQualifiedName) {
    this.fullyQualifiedName = fullyQualifiedName;
  }


  public AppMarketPlaceDefinition href(URI href) {
    
    this.href = href;
    return this;
  }

   /**
   * Get href
   * @return href
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_HREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public URI getHref() {
    return href;
  }


  @JsonProperty(JSON_PROPERTY_HREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHref(URI href) {
    this.href = href;
  }


  public AppMarketPlaceDefinition id(UUID id) {
    
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setId(UUID id) {
    this.id = id;
  }


  public AppMarketPlaceDefinition lifeCycle(LifeCycle lifeCycle) {
    
    this.lifeCycle = lifeCycle;
    return this;
  }

   /**
   * Get lifeCycle
   * @return lifeCycle
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_LIFE_CYCLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LifeCycle getLifeCycle() {
    return lifeCycle;
  }


  @JsonProperty(JSON_PROPERTY_LIFE_CYCLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLifeCycle(LifeCycle lifeCycle) {
    this.lifeCycle = lifeCycle;
  }


  public AppMarketPlaceDefinition name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Get name
   * @return name
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public AppMarketPlaceDefinition owner(EntityReference owner) {
    
    this.owner = owner;
    return this;
  }

   /**
   * Get owner
   * @return owner
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_OWNER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public EntityReference getOwner() {
    return owner;
  }


  @JsonProperty(JSON_PROPERTY_OWNER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOwner(EntityReference owner) {
    this.owner = owner;
  }


  public AppMarketPlaceDefinition permission(PermissionEnum permission) {
    
    this.permission = permission;
    return this;
  }

   /**
   * Get permission
   * @return permission
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_PERMISSION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public PermissionEnum getPermission() {
    return permission;
  }


  @JsonProperty(JSON_PROPERTY_PERMISSION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPermission(PermissionEnum permission) {
    this.permission = permission;
  }


  public AppMarketPlaceDefinition privacyPolicyUrl(String privacyPolicyUrl) {
    
    this.privacyPolicyUrl = privacyPolicyUrl;
    return this;
  }

   /**
   * Get privacyPolicyUrl
   * @return privacyPolicyUrl
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PRIVACY_POLICY_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPrivacyPolicyUrl() {
    return privacyPolicyUrl;
  }


  @JsonProperty(JSON_PROPERTY_PRIVACY_POLICY_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPrivacyPolicyUrl(String privacyPolicyUrl) {
    this.privacyPolicyUrl = privacyPolicyUrl;
  }


  public AppMarketPlaceDefinition provider(ProviderEnum provider) {
    
    this.provider = provider;
    return this;
  }

   /**
   * Get provider
   * @return provider
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PROVIDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ProviderEnum getProvider() {
    return provider;
  }


  @JsonProperty(JSON_PROPERTY_PROVIDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProvider(ProviderEnum provider) {
    this.provider = provider;
  }


  public AppMarketPlaceDefinition reviewers(List<EntityReference> reviewers) {
    
    this.reviewers = reviewers;
    return this;
  }

  public AppMarketPlaceDefinition addReviewersItem(EntityReference reviewersItem) {
    if (this.reviewers == null) {
      this.reviewers = new ArrayList<>();
    }
    this.reviewers.add(reviewersItem);
    return this;
  }

   /**
   * Get reviewers
   * @return reviewers
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_REVIEWERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<EntityReference> getReviewers() {
    return reviewers;
  }


  @JsonProperty(JSON_PROPERTY_REVIEWERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReviewers(List<EntityReference> reviewers) {
    this.reviewers = reviewers;
  }


  public AppMarketPlaceDefinition runtime(Object runtime) {
    
    this.runtime = runtime;
    return this;
  }

   /**
   * Get runtime
   * @return runtime
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_RUNTIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getRuntime() {
    return runtime;
  }


  @JsonProperty(JSON_PROPERTY_RUNTIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRuntime(Object runtime) {
    this.runtime = runtime;
  }


  public AppMarketPlaceDefinition scheduleType(ScheduleTypeEnum scheduleType) {
    
    this.scheduleType = scheduleType;
    return this;
  }

   /**
   * Get scheduleType
   * @return scheduleType
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_SCHEDULE_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public ScheduleTypeEnum getScheduleType() {
    return scheduleType;
  }


  @JsonProperty(JSON_PROPERTY_SCHEDULE_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setScheduleType(ScheduleTypeEnum scheduleType) {
    this.scheduleType = scheduleType;
  }


  public AppMarketPlaceDefinition style(Style style) {
    
    this.style = style;
    return this;
  }

   /**
   * Get style
   * @return style
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_STYLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Style getStyle() {
    return style;
  }


  @JsonProperty(JSON_PROPERTY_STYLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStyle(Style style) {
    this.style = style;
  }


  public AppMarketPlaceDefinition supportEmail(String supportEmail) {
    
    this.supportEmail = supportEmail;
    return this;
  }

   /**
   * Get supportEmail
   * @return supportEmail
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SUPPORT_EMAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSupportEmail() {
    return supportEmail;
  }


  @JsonProperty(JSON_PROPERTY_SUPPORT_EMAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSupportEmail(String supportEmail) {
    this.supportEmail = supportEmail;
  }


  public AppMarketPlaceDefinition tags(List<TagLabel> tags) {
    
    this.tags = tags;
    return this;
  }

  public AppMarketPlaceDefinition addTagsItem(TagLabel tagsItem) {
    if (this.tags == null) {
      this.tags = new ArrayList<>();
    }
    this.tags.add(tagsItem);
    return this;
  }

   /**
   * Get tags
   * @return tags
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<TagLabel> getTags() {
    return tags;
  }


  @JsonProperty(JSON_PROPERTY_TAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTags(List<TagLabel> tags) {
    this.tags = tags;
  }


  public AppMarketPlaceDefinition updatedAt(Long updatedAt) {
    
    this.updatedAt = updatedAt;
    return this;
  }

   /**
   * Get updatedAt
   * @return updatedAt
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_UPDATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getUpdatedAt() {
    return updatedAt;
  }


  @JsonProperty(JSON_PROPERTY_UPDATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUpdatedAt(Long updatedAt) {
    this.updatedAt = updatedAt;
  }


  public AppMarketPlaceDefinition updatedBy(String updatedBy) {
    
    this.updatedBy = updatedBy;
    return this;
  }

   /**
   * Get updatedBy
   * @return updatedBy
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_UPDATED_BY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getUpdatedBy() {
    return updatedBy;
  }


  @JsonProperty(JSON_PROPERTY_UPDATED_BY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUpdatedBy(String updatedBy) {
    this.updatedBy = updatedBy;
  }


  public AppMarketPlaceDefinition version(Double version) {
    
    this.version = version;
    return this;
  }

   /**
   * Get version
   * @return version
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getVersion() {
    return version;
  }


  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVersion(Double version) {
    this.version = version;
  }


  public AppMarketPlaceDefinition votes(Votes votes) {
    
    this.votes = votes;
    return this;
  }

   /**
   * Get votes
   * @return votes
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_VOTES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Votes getVotes() {
    return votes;
  }


  @JsonProperty(JSON_PROPERTY_VOTES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVotes(Votes votes) {
    this.votes = votes;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AppMarketPlaceDefinition appMarketPlaceDefinition = (AppMarketPlaceDefinition) o;
    return Objects.equals(this.appConfiguration, appMarketPlaceDefinition.appConfiguration) &&
        Objects.equals(this.appLogoUrl, appMarketPlaceDefinition.appLogoUrl) &&
        Objects.equals(this.appScreenshots, appMarketPlaceDefinition.appScreenshots) &&
        Objects.equals(this.appType, appMarketPlaceDefinition.appType) &&
        Objects.equals(this.changeDescription, appMarketPlaceDefinition.changeDescription) &&
        Objects.equals(this.children, appMarketPlaceDefinition.children) &&
        Objects.equals(this.className, appMarketPlaceDefinition.className) &&
        Objects.equals(this.dataProducts, appMarketPlaceDefinition.dataProducts) &&
        Objects.equals(this.deleted, appMarketPlaceDefinition.deleted) &&
        Objects.equals(this.description, appMarketPlaceDefinition.description) &&
        Objects.equals(this.developer, appMarketPlaceDefinition.developer) &&
        Objects.equals(this.developerUrl, appMarketPlaceDefinition.developerUrl) &&
        Objects.equals(this.displayName, appMarketPlaceDefinition.displayName) &&
        Objects.equals(this.domain, appMarketPlaceDefinition.domain) &&
        Objects.equals(this.experts, appMarketPlaceDefinition.experts) &&
        Objects.equals(this.extension, appMarketPlaceDefinition.extension) &&
        Objects.equals(this.features, appMarketPlaceDefinition.features) &&
        Objects.equals(this.followers, appMarketPlaceDefinition.followers) &&
        Objects.equals(this.fullyQualifiedName, appMarketPlaceDefinition.fullyQualifiedName) &&
        Objects.equals(this.href, appMarketPlaceDefinition.href) &&
        Objects.equals(this.id, appMarketPlaceDefinition.id) &&
        Objects.equals(this.lifeCycle, appMarketPlaceDefinition.lifeCycle) &&
        Objects.equals(this.name, appMarketPlaceDefinition.name) &&
        Objects.equals(this.owner, appMarketPlaceDefinition.owner) &&
        Objects.equals(this.permission, appMarketPlaceDefinition.permission) &&
        Objects.equals(this.privacyPolicyUrl, appMarketPlaceDefinition.privacyPolicyUrl) &&
        Objects.equals(this.provider, appMarketPlaceDefinition.provider) &&
        Objects.equals(this.reviewers, appMarketPlaceDefinition.reviewers) &&
        Objects.equals(this.runtime, appMarketPlaceDefinition.runtime) &&
        Objects.equals(this.scheduleType, appMarketPlaceDefinition.scheduleType) &&
        Objects.equals(this.style, appMarketPlaceDefinition.style) &&
        Objects.equals(this.supportEmail, appMarketPlaceDefinition.supportEmail) &&
        Objects.equals(this.tags, appMarketPlaceDefinition.tags) &&
        Objects.equals(this.updatedAt, appMarketPlaceDefinition.updatedAt) &&
        Objects.equals(this.updatedBy, appMarketPlaceDefinition.updatedBy) &&
        Objects.equals(this.version, appMarketPlaceDefinition.version) &&
        Objects.equals(this.votes, appMarketPlaceDefinition.votes);
  }

  @Override
  public int hashCode() {
    return Objects.hash(appConfiguration, appLogoUrl, appScreenshots, appType, changeDescription, children, className, dataProducts, deleted, description, developer, developerUrl, displayName, domain, experts, extension, features, followers, fullyQualifiedName, href, id, lifeCycle, name, owner, permission, privacyPolicyUrl, provider, reviewers, runtime, scheduleType, style, supportEmail, tags, updatedAt, updatedBy, version, votes);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AppMarketPlaceDefinition {\n");
    sb.append("    appConfiguration: ").append(toIndentedString(appConfiguration)).append("\n");
    sb.append("    appLogoUrl: ").append(toIndentedString(appLogoUrl)).append("\n");
    sb.append("    appScreenshots: ").append(toIndentedString(appScreenshots)).append("\n");
    sb.append("    appType: ").append(toIndentedString(appType)).append("\n");
    sb.append("    changeDescription: ").append(toIndentedString(changeDescription)).append("\n");
    sb.append("    children: ").append(toIndentedString(children)).append("\n");
    sb.append("    className: ").append(toIndentedString(className)).append("\n");
    sb.append("    dataProducts: ").append(toIndentedString(dataProducts)).append("\n");
    sb.append("    deleted: ").append(toIndentedString(deleted)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    developer: ").append(toIndentedString(developer)).append("\n");
    sb.append("    developerUrl: ").append(toIndentedString(developerUrl)).append("\n");
    sb.append("    displayName: ").append(toIndentedString(displayName)).append("\n");
    sb.append("    domain: ").append(toIndentedString(domain)).append("\n");
    sb.append("    experts: ").append(toIndentedString(experts)).append("\n");
    sb.append("    extension: ").append(toIndentedString(extension)).append("\n");
    sb.append("    features: ").append(toIndentedString(features)).append("\n");
    sb.append("    followers: ").append(toIndentedString(followers)).append("\n");
    sb.append("    fullyQualifiedName: ").append(toIndentedString(fullyQualifiedName)).append("\n");
    sb.append("    href: ").append(toIndentedString(href)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    lifeCycle: ").append(toIndentedString(lifeCycle)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    owner: ").append(toIndentedString(owner)).append("\n");
    sb.append("    permission: ").append(toIndentedString(permission)).append("\n");
    sb.append("    privacyPolicyUrl: ").append(toIndentedString(privacyPolicyUrl)).append("\n");
    sb.append("    provider: ").append(toIndentedString(provider)).append("\n");
    sb.append("    reviewers: ").append(toIndentedString(reviewers)).append("\n");
    sb.append("    runtime: ").append(toIndentedString(runtime)).append("\n");
    sb.append("    scheduleType: ").append(toIndentedString(scheduleType)).append("\n");
    sb.append("    style: ").append(toIndentedString(style)).append("\n");
    sb.append("    supportEmail: ").append(toIndentedString(supportEmail)).append("\n");
    sb.append("    tags: ").append(toIndentedString(tags)).append("\n");
    sb.append("    updatedAt: ").append(toIndentedString(updatedAt)).append("\n");
    sb.append("    updatedBy: ").append(toIndentedString(updatedBy)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    votes: ").append(toIndentedString(votes)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

