/*
 * OpenMetadata Apis
 * --- title: APIs slug: /main-concepts/metadata-standard/apis ---  # APIs  OpenMetadata supports REST APIs for getting data and in and out of the metadata service. APIs are built using general best practices of REST API design. We take a schema-first approach by defining Types and Entities in JSON Schema. We implement APIs based on these schemas.  ## Overview  ### URI  Following REST API conventions are followed for Resource URIs: - Operations for an entity are available through the Resource URI as a collection `.../api/<version>/entities`.  - Plural of the entity name is used as the collection name - example `.../api/v1/users`. - Trailing forward slash is not used in the endpoint URI. Example use `.../api/v1/databases` instead of `.../api/v1/databases/`. - Resource URI for an entity instance by the entity id is `.../api/v1/entities/{id}`.  - Resource URI for an entity instance by name is `.../api/v1/entities/name/{name}`.  ### Resource Representation  - The REST API calls return a response with JSON `Content-Type` and `Content-Length` that includes the length of the response. - All responses include the Resource ID field even though the id was provided in the request to simplify the consumption    of the response at the client. - Entity names and field names use `camelCase` per Javascript naming convention. - All resources include an attribute `href` with Resource URI. All relationship fields of an entity will also    include `href` links to the related resource for easy access. - Unknown fields sent by the client in API requests are not ignored to ensure the data sent by the client is not dropped    at the server without the user being aware of it.  ## API Organization  You can find the swagger documentation [here](/swagger.html). In a nutshell:  **Data Asset APIs** - support operations related to data asset entities. - `.../api/v1/databases` - `...api/v1/tables` - `.../api/v1/metrics` - `.../api/v1/dashboards` - `.../api/v1/reports` - `.../api/v1/pipelines` - `.../api/v1/topics`  **Service APIs** - support operations related to services from which metadata is collected: - `.../api/v1/services` is the collection of all service resources. - `.../api/v1/services/databaseService` - APIs related to database services. This includes Transactional databases - MySQL, Postgres, MSSQL, Oracle, and Data Warehouses - Apache Hive BigQuery, Redshift, and Snowflake. - `.../api/v1/services/dashboardService` - APIs related to Dashboard Services. This includes Looker, Superset, and Tableau. - `.../api/v1/services/messagingService` - APIs related to Messaging Services. This includes Apache Kafka, Redpanda, - Kinesis, and others.  **Teams & Users APIs** - `.../api/v1/teams` - APIs related to team entities - `.../api/v1/users` - APIs related to user entities  **Search & Suggest APIs** - support search and suggest APIs: - `.../api/v1/search` - collection for search and suggest APIs - `.../api/v1/search/query` - search entities using query text - `.../api/v1/search/suggest` - get suggested entities used for auto-completion  **Other APIs** - `.../api/v1/tags` for APIs related to Classification and Tag entities - `../api/v1/feeds` for APIs related to Threads and Posts entities - `.../api/v1/usage` for reporting usage information of entities
 *
 * The version of the OpenAPI document: 1.2.2
 * Contact: openmetadata-dev@googlegroups.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.openmetadata.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.openmetadata.client.model.ColumnProfile;
import org.openmetadata.client.model.CustomMetric;
import org.openmetadata.client.model.TagLabel;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * Column
 */
@JsonPropertyOrder({
  Column.JSON_PROPERTY_ARRAY_DATA_TYPE,
  Column.JSON_PROPERTY_CHILDREN,
  Column.JSON_PROPERTY_CONSTRAINT,
  Column.JSON_PROPERTY_CUSTOM_METRICS,
  Column.JSON_PROPERTY_DATA_LENGTH,
  Column.JSON_PROPERTY_DATA_TYPE,
  Column.JSON_PROPERTY_DATA_TYPE_DISPLAY,
  Column.JSON_PROPERTY_DESCRIPTION,
  Column.JSON_PROPERTY_DISPLAY_NAME,
  Column.JSON_PROPERTY_FULLY_QUALIFIED_NAME,
  Column.JSON_PROPERTY_JSON_SCHEMA,
  Column.JSON_PROPERTY_NAME,
  Column.JSON_PROPERTY_ORDINAL_POSITION,
  Column.JSON_PROPERTY_PRECISION,
  Column.JSON_PROPERTY_PROFILE,
  Column.JSON_PROPERTY_SCALE,
  Column.JSON_PROPERTY_TAGS
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-20T11:35:38.398944261Z[Etc/UTC]")
public class Column {
  /**
   * Gets or Sets arrayDataType
   */
  public enum ArrayDataTypeEnum {
    NUMBER("NUMBER"),
    
    TINYINT("TINYINT"),
    
    SMALLINT("SMALLINT"),
    
    INT("INT"),
    
    BIGINT("BIGINT"),
    
    BYTEINT("BYTEINT"),
    
    BYTES("BYTES"),
    
    FLOAT("FLOAT"),
    
    DOUBLE("DOUBLE"),
    
    DECIMAL("DECIMAL"),
    
    NUMERIC("NUMERIC"),
    
    TIMESTAMP("TIMESTAMP"),
    
    TIMESTAMPZ("TIMESTAMPZ"),
    
    TIME("TIME"),
    
    DATE("DATE"),
    
    DATETIME("DATETIME"),
    
    INTERVAL("INTERVAL"),
    
    STRING("STRING"),
    
    MEDIUMTEXT("MEDIUMTEXT"),
    
    TEXT("TEXT"),
    
    CHAR("CHAR"),
    
    LONG("LONG"),
    
    VARCHAR("VARCHAR"),
    
    BOOLEAN("BOOLEAN"),
    
    BINARY("BINARY"),
    
    VARBINARY("VARBINARY"),
    
    ARRAY("ARRAY"),
    
    BLOB("BLOB"),
    
    LONGBLOB("LONGBLOB"),
    
    MEDIUMBLOB("MEDIUMBLOB"),
    
    MAP("MAP"),
    
    STRUCT("STRUCT"),
    
    UNION("UNION"),
    
    SET("SET"),
    
    GEOGRAPHY("GEOGRAPHY"),
    
    ENUM("ENUM"),
    
    JSON("JSON"),
    
    UUID("UUID"),
    
    VARIANT("VARIANT"),
    
    GEOMETRY("GEOMETRY"),
    
    BYTEA("BYTEA"),
    
    AGGREGATEFUNCTION("AGGREGATEFUNCTION"),
    
    ERROR("ERROR"),
    
    FIXED("FIXED"),
    
    RECORD("RECORD"),
    
    NULL("NULL"),
    
    SUPER("SUPER"),
    
    HLLSKETCH("HLLSKETCH"),
    
    PG_LSN("PG_LSN"),
    
    PG_SNAPSHOT("PG_SNAPSHOT"),
    
    TSQUERY("TSQUERY"),
    
    TXID_SNAPSHOT("TXID_SNAPSHOT"),
    
    XML("XML"),
    
    MACADDR("MACADDR"),
    
    TSVECTOR("TSVECTOR"),
    
    UNKNOWN("UNKNOWN"),
    
    CIDR("CIDR"),
    
    INET("INET"),
    
    CLOB("CLOB"),
    
    ROWID("ROWID"),
    
    LOWCARDINALITY("LOWCARDINALITY"),
    
    YEAR("YEAR"),
    
    POINT("POINT"),
    
    POLYGON("POLYGON"),
    
    TUPLE("TUPLE"),
    
    SPATIAL("SPATIAL"),
    
    TABLE("TABLE"),
    
    NTEXT("NTEXT"),
    
    IMAGE("IMAGE"),
    
    IPV4("IPV4"),
    
    IPV6("IPV6"),
    
    DATETIMERANGE("DATETIMERANGE");

    private String value;

    ArrayDataTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ArrayDataTypeEnum fromValue(String value) {
      for (ArrayDataTypeEnum b : ArrayDataTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_ARRAY_DATA_TYPE = "arrayDataType";
  private ArrayDataTypeEnum arrayDataType;

  public static final String JSON_PROPERTY_CHILDREN = "children";
  private List<Column> children = null;

  /**
   * Gets or Sets constraint
   */
  public enum ConstraintEnum {
    NULL("NULL"),
    
    NOT_NULL("NOT_NULL"),
    
    UNIQUE("UNIQUE"),
    
    PRIMARY_KEY("PRIMARY_KEY");

    private String value;

    ConstraintEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ConstraintEnum fromValue(String value) {
      for (ConstraintEnum b : ConstraintEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_CONSTRAINT = "constraint";
  private ConstraintEnum constraint;

  public static final String JSON_PROPERTY_CUSTOM_METRICS = "customMetrics";
  private List<CustomMetric> customMetrics = null;

  public static final String JSON_PROPERTY_DATA_LENGTH = "dataLength";
  private Integer dataLength;

  /**
   * Gets or Sets dataType
   */
  public enum DataTypeEnum {
    NUMBER("NUMBER"),
    
    TINYINT("TINYINT"),
    
    SMALLINT("SMALLINT"),
    
    INT("INT"),
    
    BIGINT("BIGINT"),
    
    BYTEINT("BYTEINT"),
    
    BYTES("BYTES"),
    
    FLOAT("FLOAT"),
    
    DOUBLE("DOUBLE"),
    
    DECIMAL("DECIMAL"),
    
    NUMERIC("NUMERIC"),
    
    TIMESTAMP("TIMESTAMP"),
    
    TIMESTAMPZ("TIMESTAMPZ"),
    
    TIME("TIME"),
    
    DATE("DATE"),
    
    DATETIME("DATETIME"),
    
    INTERVAL("INTERVAL"),
    
    STRING("STRING"),
    
    MEDIUMTEXT("MEDIUMTEXT"),
    
    TEXT("TEXT"),
    
    CHAR("CHAR"),
    
    LONG("LONG"),
    
    VARCHAR("VARCHAR"),
    
    BOOLEAN("BOOLEAN"),
    
    BINARY("BINARY"),
    
    VARBINARY("VARBINARY"),
    
    ARRAY("ARRAY"),
    
    BLOB("BLOB"),
    
    LONGBLOB("LONGBLOB"),
    
    MEDIUMBLOB("MEDIUMBLOB"),
    
    MAP("MAP"),
    
    STRUCT("STRUCT"),
    
    UNION("UNION"),
    
    SET("SET"),
    
    GEOGRAPHY("GEOGRAPHY"),
    
    ENUM("ENUM"),
    
    JSON("JSON"),
    
    UUID("UUID"),
    
    VARIANT("VARIANT"),
    
    GEOMETRY("GEOMETRY"),
    
    BYTEA("BYTEA"),
    
    AGGREGATEFUNCTION("AGGREGATEFUNCTION"),
    
    ERROR("ERROR"),
    
    FIXED("FIXED"),
    
    RECORD("RECORD"),
    
    NULL("NULL"),
    
    SUPER("SUPER"),
    
    HLLSKETCH("HLLSKETCH"),
    
    PG_LSN("PG_LSN"),
    
    PG_SNAPSHOT("PG_SNAPSHOT"),
    
    TSQUERY("TSQUERY"),
    
    TXID_SNAPSHOT("TXID_SNAPSHOT"),
    
    XML("XML"),
    
    MACADDR("MACADDR"),
    
    TSVECTOR("TSVECTOR"),
    
    UNKNOWN("UNKNOWN"),
    
    CIDR("CIDR"),
    
    INET("INET"),
    
    CLOB("CLOB"),
    
    ROWID("ROWID"),
    
    LOWCARDINALITY("LOWCARDINALITY"),
    
    YEAR("YEAR"),
    
    POINT("POINT"),
    
    POLYGON("POLYGON"),
    
    TUPLE("TUPLE"),
    
    SPATIAL("SPATIAL"),
    
    TABLE("TABLE"),
    
    NTEXT("NTEXT"),
    
    IMAGE("IMAGE"),
    
    IPV4("IPV4"),
    
    IPV6("IPV6"),
    
    DATETIMERANGE("DATETIMERANGE");

    private String value;

    DataTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static DataTypeEnum fromValue(String value) {
      for (DataTypeEnum b : DataTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_DATA_TYPE = "dataType";
  private DataTypeEnum dataType;

  public static final String JSON_PROPERTY_DATA_TYPE_DISPLAY = "dataTypeDisplay";
  private String dataTypeDisplay;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description;

  public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
  private String displayName;

  public static final String JSON_PROPERTY_FULLY_QUALIFIED_NAME = "fullyQualifiedName";
  private String fullyQualifiedName;

  public static final String JSON_PROPERTY_JSON_SCHEMA = "jsonSchema";
  private String jsonSchema;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_ORDINAL_POSITION = "ordinalPosition";
  private Integer ordinalPosition;

  public static final String JSON_PROPERTY_PRECISION = "precision";
  private Integer precision;

  public static final String JSON_PROPERTY_PROFILE = "profile";
  private ColumnProfile profile;

  public static final String JSON_PROPERTY_SCALE = "scale";
  private Integer scale;

  public static final String JSON_PROPERTY_TAGS = "tags";
  private List<TagLabel> tags = null;

  public Column() { 
  }

  public Column arrayDataType(ArrayDataTypeEnum arrayDataType) {
    
    this.arrayDataType = arrayDataType;
    return this;
  }

   /**
   * Get arrayDataType
   * @return arrayDataType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ARRAY_DATA_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ArrayDataTypeEnum getArrayDataType() {
    return arrayDataType;
  }


  @JsonProperty(JSON_PROPERTY_ARRAY_DATA_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setArrayDataType(ArrayDataTypeEnum arrayDataType) {
    this.arrayDataType = arrayDataType;
  }


  public Column children(List<Column> children) {
    
    this.children = children;
    return this;
  }

  public Column addChildrenItem(Column childrenItem) {
    if (this.children == null) {
      this.children = new ArrayList<>();
    }
    this.children.add(childrenItem);
    return this;
  }

   /**
   * Get children
   * @return children
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CHILDREN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Column> getChildren() {
    return children;
  }


  @JsonProperty(JSON_PROPERTY_CHILDREN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChildren(List<Column> children) {
    this.children = children;
  }


  public Column constraint(ConstraintEnum constraint) {
    
    this.constraint = constraint;
    return this;
  }

   /**
   * Get constraint
   * @return constraint
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CONSTRAINT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ConstraintEnum getConstraint() {
    return constraint;
  }


  @JsonProperty(JSON_PROPERTY_CONSTRAINT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setConstraint(ConstraintEnum constraint) {
    this.constraint = constraint;
  }


  public Column customMetrics(List<CustomMetric> customMetrics) {
    
    this.customMetrics = customMetrics;
    return this;
  }

  public Column addCustomMetricsItem(CustomMetric customMetricsItem) {
    if (this.customMetrics == null) {
      this.customMetrics = new ArrayList<>();
    }
    this.customMetrics.add(customMetricsItem);
    return this;
  }

   /**
   * Get customMetrics
   * @return customMetrics
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CUSTOM_METRICS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<CustomMetric> getCustomMetrics() {
    return customMetrics;
  }


  @JsonProperty(JSON_PROPERTY_CUSTOM_METRICS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCustomMetrics(List<CustomMetric> customMetrics) {
    this.customMetrics = customMetrics;
  }


  public Column dataLength(Integer dataLength) {
    
    this.dataLength = dataLength;
    return this;
  }

   /**
   * Get dataLength
   * @return dataLength
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DATA_LENGTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getDataLength() {
    return dataLength;
  }


  @JsonProperty(JSON_PROPERTY_DATA_LENGTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDataLength(Integer dataLength) {
    this.dataLength = dataLength;
  }


  public Column dataType(DataTypeEnum dataType) {
    
    this.dataType = dataType;
    return this;
  }

   /**
   * Get dataType
   * @return dataType
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_DATA_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public DataTypeEnum getDataType() {
    return dataType;
  }


  @JsonProperty(JSON_PROPERTY_DATA_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDataType(DataTypeEnum dataType) {
    this.dataType = dataType;
  }


  public Column dataTypeDisplay(String dataTypeDisplay) {
    
    this.dataTypeDisplay = dataTypeDisplay;
    return this;
  }

   /**
   * Get dataTypeDisplay
   * @return dataTypeDisplay
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DATA_TYPE_DISPLAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDataTypeDisplay() {
    return dataTypeDisplay;
  }


  @JsonProperty(JSON_PROPERTY_DATA_TYPE_DISPLAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDataTypeDisplay(String dataTypeDisplay) {
    this.dataTypeDisplay = dataTypeDisplay;
  }


  public Column description(String description) {
    
    this.description = description;
    return this;
  }

   /**
   * Get description
   * @return description
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDescription() {
    return description;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(String description) {
    this.description = description;
  }


  public Column displayName(String displayName) {
    
    this.displayName = displayName;
    return this;
  }

   /**
   * Get displayName
   * @return displayName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DISPLAY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDisplayName() {
    return displayName;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisplayName(String displayName) {
    this.displayName = displayName;
  }


  public Column fullyQualifiedName(String fullyQualifiedName) {
    
    this.fullyQualifiedName = fullyQualifiedName;
    return this;
  }

   /**
   * Get fullyQualifiedName
   * @return fullyQualifiedName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_FULLY_QUALIFIED_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFullyQualifiedName() {
    return fullyQualifiedName;
  }


  @JsonProperty(JSON_PROPERTY_FULLY_QUALIFIED_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFullyQualifiedName(String fullyQualifiedName) {
    this.fullyQualifiedName = fullyQualifiedName;
  }


  public Column jsonSchema(String jsonSchema) {
    
    this.jsonSchema = jsonSchema;
    return this;
  }

   /**
   * Get jsonSchema
   * @return jsonSchema
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_JSON_SCHEMA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getJsonSchema() {
    return jsonSchema;
  }


  @JsonProperty(JSON_PROPERTY_JSON_SCHEMA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setJsonSchema(String jsonSchema) {
    this.jsonSchema = jsonSchema;
  }


  public Column name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Get name
   * @return name
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public Column ordinalPosition(Integer ordinalPosition) {
    
    this.ordinalPosition = ordinalPosition;
    return this;
  }

   /**
   * Get ordinalPosition
   * @return ordinalPosition
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ORDINAL_POSITION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getOrdinalPosition() {
    return ordinalPosition;
  }


  @JsonProperty(JSON_PROPERTY_ORDINAL_POSITION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOrdinalPosition(Integer ordinalPosition) {
    this.ordinalPosition = ordinalPosition;
  }


  public Column precision(Integer precision) {
    
    this.precision = precision;
    return this;
  }

   /**
   * Get precision
   * @return precision
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PRECISION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getPrecision() {
    return precision;
  }


  @JsonProperty(JSON_PROPERTY_PRECISION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPrecision(Integer precision) {
    this.precision = precision;
  }


  public Column profile(ColumnProfile profile) {
    
    this.profile = profile;
    return this;
  }

   /**
   * Get profile
   * @return profile
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PROFILE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ColumnProfile getProfile() {
    return profile;
  }


  @JsonProperty(JSON_PROPERTY_PROFILE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProfile(ColumnProfile profile) {
    this.profile = profile;
  }


  public Column scale(Integer scale) {
    
    this.scale = scale;
    return this;
  }

   /**
   * Get scale
   * @return scale
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SCALE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getScale() {
    return scale;
  }


  @JsonProperty(JSON_PROPERTY_SCALE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setScale(Integer scale) {
    this.scale = scale;
  }


  public Column tags(List<TagLabel> tags) {
    
    this.tags = tags;
    return this;
  }

  public Column addTagsItem(TagLabel tagsItem) {
    if (this.tags == null) {
      this.tags = new ArrayList<>();
    }
    this.tags.add(tagsItem);
    return this;
  }

   /**
   * Get tags
   * @return tags
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<TagLabel> getTags() {
    return tags;
  }


  @JsonProperty(JSON_PROPERTY_TAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTags(List<TagLabel> tags) {
    this.tags = tags;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Column column = (Column) o;
    return Objects.equals(this.arrayDataType, column.arrayDataType) &&
        Objects.equals(this.children, column.children) &&
        Objects.equals(this.constraint, column.constraint) &&
        Objects.equals(this.customMetrics, column.customMetrics) &&
        Objects.equals(this.dataLength, column.dataLength) &&
        Objects.equals(this.dataType, column.dataType) &&
        Objects.equals(this.dataTypeDisplay, column.dataTypeDisplay) &&
        Objects.equals(this.description, column.description) &&
        Objects.equals(this.displayName, column.displayName) &&
        Objects.equals(this.fullyQualifiedName, column.fullyQualifiedName) &&
        Objects.equals(this.jsonSchema, column.jsonSchema) &&
        Objects.equals(this.name, column.name) &&
        Objects.equals(this.ordinalPosition, column.ordinalPosition) &&
        Objects.equals(this.precision, column.precision) &&
        Objects.equals(this.profile, column.profile) &&
        Objects.equals(this.scale, column.scale) &&
        Objects.equals(this.tags, column.tags);
  }

  @Override
  public int hashCode() {
    return Objects.hash(arrayDataType, children, constraint, customMetrics, dataLength, dataType, dataTypeDisplay, description, displayName, fullyQualifiedName, jsonSchema, name, ordinalPosition, precision, profile, scale, tags);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Column {\n");
    sb.append("    arrayDataType: ").append(toIndentedString(arrayDataType)).append("\n");
    sb.append("    children: ").append(toIndentedString(children)).append("\n");
    sb.append("    constraint: ").append(toIndentedString(constraint)).append("\n");
    sb.append("    customMetrics: ").append(toIndentedString(customMetrics)).append("\n");
    sb.append("    dataLength: ").append(toIndentedString(dataLength)).append("\n");
    sb.append("    dataType: ").append(toIndentedString(dataType)).append("\n");
    sb.append("    dataTypeDisplay: ").append(toIndentedString(dataTypeDisplay)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    displayName: ").append(toIndentedString(displayName)).append("\n");
    sb.append("    fullyQualifiedName: ").append(toIndentedString(fullyQualifiedName)).append("\n");
    sb.append("    jsonSchema: ").append(toIndentedString(jsonSchema)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    ordinalPosition: ").append(toIndentedString(ordinalPosition)).append("\n");
    sb.append("    precision: ").append(toIndentedString(precision)).append("\n");
    sb.append("    profile: ").append(toIndentedString(profile)).append("\n");
    sb.append("    scale: ").append(toIndentedString(scale)).append("\n");
    sb.append("    tags: ").append(toIndentedString(tags)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

