/*
 * OpenMetadata Apis
 * --- title: APIs slug: /main-concepts/metadata-standard/apis ---  # APIs  OpenMetadata supports REST APIs for getting data and in and out of the metadata service. APIs are built using general best practices of REST API design. We take a schema-first approach by defining Types and Entities in JSON Schema. We implement APIs based on these schemas.  ## Overview  ### URI  Following REST API conventions are followed for Resource URIs: - Operations for an entity are available through the Resource URI as a collection `.../api/<version>/entities`.  - Plural of the entity name is used as the collection name - example `.../api/v1/users`. - Trailing forward slash is not used in the endpoint URI. Example use `.../api/v1/databases` instead of `.../api/v1/databases/`. - Resource URI for an entity instance by the entity id is `.../api/v1/entities/{id}`.  - Resource URI for an entity instance by name is `.../api/v1/entities/name/{name}`.  ### Resource Representation  - The REST API calls return a response with JSON `Content-Type` and `Content-Length` that includes the length of the response. - All responses include the Resource ID field even though the id was provided in the request to simplify the consumption    of the response at the client. - Entity names and field names use `camelCase` per Javascript naming convention. - All resources include an attribute `href` with Resource URI. All relationship fields of an entity will also    include `href` links to the related resource for easy access. - Unknown fields sent by the client in API requests are not ignored to ensure the data sent by the client is not dropped    at the server without the user being aware of it.  ## API Organization  You can find the swagger documentation [here](/swagger.html). In a nutshell:  **Data Asset APIs** - support operations related to data asset entities. - `.../api/v1/databases` - `...api/v1/tables` - `.../api/v1/metrics` - `.../api/v1/dashboards` - `.../api/v1/reports` - `.../api/v1/pipelines` - `.../api/v1/topics`  **Service APIs** - support operations related to services from which metadata is collected: - `.../api/v1/services` is the collection of all service resources. - `.../api/v1/services/databaseService` - APIs related to database services. This includes Transactional databases - MySQL, Postgres, MSSQL, Oracle, and Data Warehouses - Apache Hive BigQuery, Redshift, and Snowflake. - `.../api/v1/services/dashboardService` - APIs related to Dashboard Services. This includes Looker, Superset, and Tableau. - `.../api/v1/services/messagingService` - APIs related to Messaging Services. This includes Apache Kafka, Redpanda, - Kinesis, and others.  **Teams & Users APIs** - `.../api/v1/teams` - APIs related to team entities - `.../api/v1/users` - APIs related to user entities  **Search & Suggest APIs** - support search and suggest APIs: - `.../api/v1/search` - collection for search and suggest APIs - `.../api/v1/search/query` - search entities using query text - `.../api/v1/search/suggest` - get suggested entities used for auto-completion  **Other APIs** - `.../api/v1/tags` for APIs related to Classification and Tag entities - `../api/v1/feeds` for APIs related to Threads and Posts entities - `.../api/v1/usage` for reporting usage information of entities
 *
 * The version of the OpenAPI document: 1.2.2
 * Contact: openmetadata-dev@googlegroups.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.openmetadata.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.openmetadata.client.model.CustomMetricProfile;
import org.openmetadata.client.model.Histogram;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * ColumnProfile
 */
@JsonPropertyOrder({
  ColumnProfile.JSON_PROPERTY_CUSTOM_METRICS_PROFILE,
  ColumnProfile.JSON_PROPERTY_DISTINCT_COUNT,
  ColumnProfile.JSON_PROPERTY_DISTINCT_PROPORTION,
  ColumnProfile.JSON_PROPERTY_DUPLICATE_COUNT,
  ColumnProfile.JSON_PROPERTY_FIRST_QUARTILE,
  ColumnProfile.JSON_PROPERTY_HISTOGRAM,
  ColumnProfile.JSON_PROPERTY_INTER_QUARTILE_RANGE,
  ColumnProfile.JSON_PROPERTY_MAX,
  ColumnProfile.JSON_PROPERTY_MAX_LENGTH,
  ColumnProfile.JSON_PROPERTY_MEAN,
  ColumnProfile.JSON_PROPERTY_MEDIAN,
  ColumnProfile.JSON_PROPERTY_MIN,
  ColumnProfile.JSON_PROPERTY_MIN_LENGTH,
  ColumnProfile.JSON_PROPERTY_MISSING_COUNT,
  ColumnProfile.JSON_PROPERTY_MISSING_PERCENTAGE,
  ColumnProfile.JSON_PROPERTY_NAME,
  ColumnProfile.JSON_PROPERTY_NON_PARAMETRIC_SKEW,
  ColumnProfile.JSON_PROPERTY_NULL_COUNT,
  ColumnProfile.JSON_PROPERTY_NULL_PROPORTION,
  ColumnProfile.JSON_PROPERTY_STDDEV,
  ColumnProfile.JSON_PROPERTY_SUM,
  ColumnProfile.JSON_PROPERTY_THIRD_QUARTILE,
  ColumnProfile.JSON_PROPERTY_TIMESTAMP,
  ColumnProfile.JSON_PROPERTY_UNIQUE_COUNT,
  ColumnProfile.JSON_PROPERTY_UNIQUE_PROPORTION,
  ColumnProfile.JSON_PROPERTY_VALID_COUNT,
  ColumnProfile.JSON_PROPERTY_VALUES_COUNT,
  ColumnProfile.JSON_PROPERTY_VALUES_PERCENTAGE,
  ColumnProfile.JSON_PROPERTY_VARIANCE
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-20T11:35:38.398944261Z[Etc/UTC]")
public class ColumnProfile {
  public static final String JSON_PROPERTY_CUSTOM_METRICS_PROFILE = "customMetricsProfile";
  private List<CustomMetricProfile> customMetricsProfile = null;

  public static final String JSON_PROPERTY_DISTINCT_COUNT = "distinctCount";
  private Double distinctCount;

  public static final String JSON_PROPERTY_DISTINCT_PROPORTION = "distinctProportion";
  private Double distinctProportion;

  public static final String JSON_PROPERTY_DUPLICATE_COUNT = "duplicateCount";
  private Double duplicateCount;

  public static final String JSON_PROPERTY_FIRST_QUARTILE = "firstQuartile";
  private Double firstQuartile;

  public static final String JSON_PROPERTY_HISTOGRAM = "histogram";
  private Histogram histogram;

  public static final String JSON_PROPERTY_INTER_QUARTILE_RANGE = "interQuartileRange";
  private Double interQuartileRange;

  public static final String JSON_PROPERTY_MAX = "max";
  private Object max;

  public static final String JSON_PROPERTY_MAX_LENGTH = "maxLength";
  private Double maxLength;

  public static final String JSON_PROPERTY_MEAN = "mean";
  private Double mean;

  public static final String JSON_PROPERTY_MEDIAN = "median";
  private Double median;

  public static final String JSON_PROPERTY_MIN = "min";
  private Object min;

  public static final String JSON_PROPERTY_MIN_LENGTH = "minLength";
  private Double minLength;

  public static final String JSON_PROPERTY_MISSING_COUNT = "missingCount";
  private Double missingCount;

  public static final String JSON_PROPERTY_MISSING_PERCENTAGE = "missingPercentage";
  private Double missingPercentage;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_NON_PARAMETRIC_SKEW = "nonParametricSkew";
  private Double nonParametricSkew;

  public static final String JSON_PROPERTY_NULL_COUNT = "nullCount";
  private Double nullCount;

  public static final String JSON_PROPERTY_NULL_PROPORTION = "nullProportion";
  private Double nullProportion;

  public static final String JSON_PROPERTY_STDDEV = "stddev";
  private Double stddev;

  public static final String JSON_PROPERTY_SUM = "sum";
  private Double sum;

  public static final String JSON_PROPERTY_THIRD_QUARTILE = "thirdQuartile";
  private Double thirdQuartile;

  public static final String JSON_PROPERTY_TIMESTAMP = "timestamp";
  private Long timestamp;

  public static final String JSON_PROPERTY_UNIQUE_COUNT = "uniqueCount";
  private Double uniqueCount;

  public static final String JSON_PROPERTY_UNIQUE_PROPORTION = "uniqueProportion";
  private Double uniqueProportion;

  public static final String JSON_PROPERTY_VALID_COUNT = "validCount";
  private Double validCount;

  public static final String JSON_PROPERTY_VALUES_COUNT = "valuesCount";
  private Double valuesCount;

  public static final String JSON_PROPERTY_VALUES_PERCENTAGE = "valuesPercentage";
  private Double valuesPercentage;

  public static final String JSON_PROPERTY_VARIANCE = "variance";
  private Double variance;

  public ColumnProfile() { 
  }

  public ColumnProfile customMetricsProfile(List<CustomMetricProfile> customMetricsProfile) {
    
    this.customMetricsProfile = customMetricsProfile;
    return this;
  }

  public ColumnProfile addCustomMetricsProfileItem(CustomMetricProfile customMetricsProfileItem) {
    if (this.customMetricsProfile == null) {
      this.customMetricsProfile = new ArrayList<>();
    }
    this.customMetricsProfile.add(customMetricsProfileItem);
    return this;
  }

   /**
   * Get customMetricsProfile
   * @return customMetricsProfile
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CUSTOM_METRICS_PROFILE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<CustomMetricProfile> getCustomMetricsProfile() {
    return customMetricsProfile;
  }


  @JsonProperty(JSON_PROPERTY_CUSTOM_METRICS_PROFILE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCustomMetricsProfile(List<CustomMetricProfile> customMetricsProfile) {
    this.customMetricsProfile = customMetricsProfile;
  }


  public ColumnProfile distinctCount(Double distinctCount) {
    
    this.distinctCount = distinctCount;
    return this;
  }

   /**
   * Get distinctCount
   * @return distinctCount
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DISTINCT_COUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getDistinctCount() {
    return distinctCount;
  }


  @JsonProperty(JSON_PROPERTY_DISTINCT_COUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDistinctCount(Double distinctCount) {
    this.distinctCount = distinctCount;
  }


  public ColumnProfile distinctProportion(Double distinctProportion) {
    
    this.distinctProportion = distinctProportion;
    return this;
  }

   /**
   * Get distinctProportion
   * @return distinctProportion
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DISTINCT_PROPORTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getDistinctProportion() {
    return distinctProportion;
  }


  @JsonProperty(JSON_PROPERTY_DISTINCT_PROPORTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDistinctProportion(Double distinctProportion) {
    this.distinctProportion = distinctProportion;
  }


  public ColumnProfile duplicateCount(Double duplicateCount) {
    
    this.duplicateCount = duplicateCount;
    return this;
  }

   /**
   * Get duplicateCount
   * @return duplicateCount
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DUPLICATE_COUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getDuplicateCount() {
    return duplicateCount;
  }


  @JsonProperty(JSON_PROPERTY_DUPLICATE_COUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDuplicateCount(Double duplicateCount) {
    this.duplicateCount = duplicateCount;
  }


  public ColumnProfile firstQuartile(Double firstQuartile) {
    
    this.firstQuartile = firstQuartile;
    return this;
  }

   /**
   * Get firstQuartile
   * @return firstQuartile
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_FIRST_QUARTILE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getFirstQuartile() {
    return firstQuartile;
  }


  @JsonProperty(JSON_PROPERTY_FIRST_QUARTILE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFirstQuartile(Double firstQuartile) {
    this.firstQuartile = firstQuartile;
  }


  public ColumnProfile histogram(Histogram histogram) {
    
    this.histogram = histogram;
    return this;
  }

   /**
   * Get histogram
   * @return histogram
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_HISTOGRAM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Histogram getHistogram() {
    return histogram;
  }


  @JsonProperty(JSON_PROPERTY_HISTOGRAM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHistogram(Histogram histogram) {
    this.histogram = histogram;
  }


  public ColumnProfile interQuartileRange(Double interQuartileRange) {
    
    this.interQuartileRange = interQuartileRange;
    return this;
  }

   /**
   * Get interQuartileRange
   * @return interQuartileRange
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_INTER_QUARTILE_RANGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getInterQuartileRange() {
    return interQuartileRange;
  }


  @JsonProperty(JSON_PROPERTY_INTER_QUARTILE_RANGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInterQuartileRange(Double interQuartileRange) {
    this.interQuartileRange = interQuartileRange;
  }


  public ColumnProfile max(Object max) {
    
    this.max = max;
    return this;
  }

   /**
   * Get max
   * @return max
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MAX)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getMax() {
    return max;
  }


  @JsonProperty(JSON_PROPERTY_MAX)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMax(Object max) {
    this.max = max;
  }


  public ColumnProfile maxLength(Double maxLength) {
    
    this.maxLength = maxLength;
    return this;
  }

   /**
   * Get maxLength
   * @return maxLength
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MAX_LENGTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getMaxLength() {
    return maxLength;
  }


  @JsonProperty(JSON_PROPERTY_MAX_LENGTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaxLength(Double maxLength) {
    this.maxLength = maxLength;
  }


  public ColumnProfile mean(Double mean) {
    
    this.mean = mean;
    return this;
  }

   /**
   * Get mean
   * @return mean
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MEAN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getMean() {
    return mean;
  }


  @JsonProperty(JSON_PROPERTY_MEAN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMean(Double mean) {
    this.mean = mean;
  }


  public ColumnProfile median(Double median) {
    
    this.median = median;
    return this;
  }

   /**
   * Get median
   * @return median
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MEDIAN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getMedian() {
    return median;
  }


  @JsonProperty(JSON_PROPERTY_MEDIAN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMedian(Double median) {
    this.median = median;
  }


  public ColumnProfile min(Object min) {
    
    this.min = min;
    return this;
  }

   /**
   * Get min
   * @return min
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getMin() {
    return min;
  }


  @JsonProperty(JSON_PROPERTY_MIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMin(Object min) {
    this.min = min;
  }


  public ColumnProfile minLength(Double minLength) {
    
    this.minLength = minLength;
    return this;
  }

   /**
   * Get minLength
   * @return minLength
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MIN_LENGTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getMinLength() {
    return minLength;
  }


  @JsonProperty(JSON_PROPERTY_MIN_LENGTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMinLength(Double minLength) {
    this.minLength = minLength;
  }


  public ColumnProfile missingCount(Double missingCount) {
    
    this.missingCount = missingCount;
    return this;
  }

   /**
   * Get missingCount
   * @return missingCount
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MISSING_COUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getMissingCount() {
    return missingCount;
  }


  @JsonProperty(JSON_PROPERTY_MISSING_COUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMissingCount(Double missingCount) {
    this.missingCount = missingCount;
  }


  public ColumnProfile missingPercentage(Double missingPercentage) {
    
    this.missingPercentage = missingPercentage;
    return this;
  }

   /**
   * Get missingPercentage
   * @return missingPercentage
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MISSING_PERCENTAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getMissingPercentage() {
    return missingPercentage;
  }


  @JsonProperty(JSON_PROPERTY_MISSING_PERCENTAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMissingPercentage(Double missingPercentage) {
    this.missingPercentage = missingPercentage;
  }


  public ColumnProfile name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Get name
   * @return name
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public ColumnProfile nonParametricSkew(Double nonParametricSkew) {
    
    this.nonParametricSkew = nonParametricSkew;
    return this;
  }

   /**
   * Get nonParametricSkew
   * @return nonParametricSkew
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_NON_PARAMETRIC_SKEW)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getNonParametricSkew() {
    return nonParametricSkew;
  }


  @JsonProperty(JSON_PROPERTY_NON_PARAMETRIC_SKEW)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNonParametricSkew(Double nonParametricSkew) {
    this.nonParametricSkew = nonParametricSkew;
  }


  public ColumnProfile nullCount(Double nullCount) {
    
    this.nullCount = nullCount;
    return this;
  }

   /**
   * Get nullCount
   * @return nullCount
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_NULL_COUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getNullCount() {
    return nullCount;
  }


  @JsonProperty(JSON_PROPERTY_NULL_COUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNullCount(Double nullCount) {
    this.nullCount = nullCount;
  }


  public ColumnProfile nullProportion(Double nullProportion) {
    
    this.nullProportion = nullProportion;
    return this;
  }

   /**
   * Get nullProportion
   * @return nullProportion
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_NULL_PROPORTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getNullProportion() {
    return nullProportion;
  }


  @JsonProperty(JSON_PROPERTY_NULL_PROPORTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNullProportion(Double nullProportion) {
    this.nullProportion = nullProportion;
  }


  public ColumnProfile stddev(Double stddev) {
    
    this.stddev = stddev;
    return this;
  }

   /**
   * Get stddev
   * @return stddev
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_STDDEV)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getStddev() {
    return stddev;
  }


  @JsonProperty(JSON_PROPERTY_STDDEV)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStddev(Double stddev) {
    this.stddev = stddev;
  }


  public ColumnProfile sum(Double sum) {
    
    this.sum = sum;
    return this;
  }

   /**
   * Get sum
   * @return sum
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SUM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getSum() {
    return sum;
  }


  @JsonProperty(JSON_PROPERTY_SUM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSum(Double sum) {
    this.sum = sum;
  }


  public ColumnProfile thirdQuartile(Double thirdQuartile) {
    
    this.thirdQuartile = thirdQuartile;
    return this;
  }

   /**
   * Get thirdQuartile
   * @return thirdQuartile
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_THIRD_QUARTILE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getThirdQuartile() {
    return thirdQuartile;
  }


  @JsonProperty(JSON_PROPERTY_THIRD_QUARTILE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setThirdQuartile(Double thirdQuartile) {
    this.thirdQuartile = thirdQuartile;
  }


  public ColumnProfile timestamp(Long timestamp) {
    
    this.timestamp = timestamp;
    return this;
  }

   /**
   * Get timestamp
   * @return timestamp
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_TIMESTAMP)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Long getTimestamp() {
    return timestamp;
  }


  @JsonProperty(JSON_PROPERTY_TIMESTAMP)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTimestamp(Long timestamp) {
    this.timestamp = timestamp;
  }


  public ColumnProfile uniqueCount(Double uniqueCount) {
    
    this.uniqueCount = uniqueCount;
    return this;
  }

   /**
   * Get uniqueCount
   * @return uniqueCount
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_UNIQUE_COUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getUniqueCount() {
    return uniqueCount;
  }


  @JsonProperty(JSON_PROPERTY_UNIQUE_COUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUniqueCount(Double uniqueCount) {
    this.uniqueCount = uniqueCount;
  }


  public ColumnProfile uniqueProportion(Double uniqueProportion) {
    
    this.uniqueProportion = uniqueProportion;
    return this;
  }

   /**
   * Get uniqueProportion
   * @return uniqueProportion
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_UNIQUE_PROPORTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getUniqueProportion() {
    return uniqueProportion;
  }


  @JsonProperty(JSON_PROPERTY_UNIQUE_PROPORTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUniqueProportion(Double uniqueProportion) {
    this.uniqueProportion = uniqueProportion;
  }


  public ColumnProfile validCount(Double validCount) {
    
    this.validCount = validCount;
    return this;
  }

   /**
   * Get validCount
   * @return validCount
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_VALID_COUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getValidCount() {
    return validCount;
  }


  @JsonProperty(JSON_PROPERTY_VALID_COUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setValidCount(Double validCount) {
    this.validCount = validCount;
  }


  public ColumnProfile valuesCount(Double valuesCount) {
    
    this.valuesCount = valuesCount;
    return this;
  }

   /**
   * Get valuesCount
   * @return valuesCount
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_VALUES_COUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getValuesCount() {
    return valuesCount;
  }


  @JsonProperty(JSON_PROPERTY_VALUES_COUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setValuesCount(Double valuesCount) {
    this.valuesCount = valuesCount;
  }


  public ColumnProfile valuesPercentage(Double valuesPercentage) {
    
    this.valuesPercentage = valuesPercentage;
    return this;
  }

   /**
   * Get valuesPercentage
   * @return valuesPercentage
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_VALUES_PERCENTAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getValuesPercentage() {
    return valuesPercentage;
  }


  @JsonProperty(JSON_PROPERTY_VALUES_PERCENTAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setValuesPercentage(Double valuesPercentage) {
    this.valuesPercentage = valuesPercentage;
  }


  public ColumnProfile variance(Double variance) {
    
    this.variance = variance;
    return this;
  }

   /**
   * Get variance
   * @return variance
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_VARIANCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getVariance() {
    return variance;
  }


  @JsonProperty(JSON_PROPERTY_VARIANCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVariance(Double variance) {
    this.variance = variance;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ColumnProfile columnProfile = (ColumnProfile) o;
    return Objects.equals(this.customMetricsProfile, columnProfile.customMetricsProfile) &&
        Objects.equals(this.distinctCount, columnProfile.distinctCount) &&
        Objects.equals(this.distinctProportion, columnProfile.distinctProportion) &&
        Objects.equals(this.duplicateCount, columnProfile.duplicateCount) &&
        Objects.equals(this.firstQuartile, columnProfile.firstQuartile) &&
        Objects.equals(this.histogram, columnProfile.histogram) &&
        Objects.equals(this.interQuartileRange, columnProfile.interQuartileRange) &&
        Objects.equals(this.max, columnProfile.max) &&
        Objects.equals(this.maxLength, columnProfile.maxLength) &&
        Objects.equals(this.mean, columnProfile.mean) &&
        Objects.equals(this.median, columnProfile.median) &&
        Objects.equals(this.min, columnProfile.min) &&
        Objects.equals(this.minLength, columnProfile.minLength) &&
        Objects.equals(this.missingCount, columnProfile.missingCount) &&
        Objects.equals(this.missingPercentage, columnProfile.missingPercentage) &&
        Objects.equals(this.name, columnProfile.name) &&
        Objects.equals(this.nonParametricSkew, columnProfile.nonParametricSkew) &&
        Objects.equals(this.nullCount, columnProfile.nullCount) &&
        Objects.equals(this.nullProportion, columnProfile.nullProportion) &&
        Objects.equals(this.stddev, columnProfile.stddev) &&
        Objects.equals(this.sum, columnProfile.sum) &&
        Objects.equals(this.thirdQuartile, columnProfile.thirdQuartile) &&
        Objects.equals(this.timestamp, columnProfile.timestamp) &&
        Objects.equals(this.uniqueCount, columnProfile.uniqueCount) &&
        Objects.equals(this.uniqueProportion, columnProfile.uniqueProportion) &&
        Objects.equals(this.validCount, columnProfile.validCount) &&
        Objects.equals(this.valuesCount, columnProfile.valuesCount) &&
        Objects.equals(this.valuesPercentage, columnProfile.valuesPercentage) &&
        Objects.equals(this.variance, columnProfile.variance);
  }

  @Override
  public int hashCode() {
    return Objects.hash(customMetricsProfile, distinctCount, distinctProportion, duplicateCount, firstQuartile, histogram, interQuartileRange, max, maxLength, mean, median, min, minLength, missingCount, missingPercentage, name, nonParametricSkew, nullCount, nullProportion, stddev, sum, thirdQuartile, timestamp, uniqueCount, uniqueProportion, validCount, valuesCount, valuesPercentage, variance);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ColumnProfile {\n");
    sb.append("    customMetricsProfile: ").append(toIndentedString(customMetricsProfile)).append("\n");
    sb.append("    distinctCount: ").append(toIndentedString(distinctCount)).append("\n");
    sb.append("    distinctProportion: ").append(toIndentedString(distinctProportion)).append("\n");
    sb.append("    duplicateCount: ").append(toIndentedString(duplicateCount)).append("\n");
    sb.append("    firstQuartile: ").append(toIndentedString(firstQuartile)).append("\n");
    sb.append("    histogram: ").append(toIndentedString(histogram)).append("\n");
    sb.append("    interQuartileRange: ").append(toIndentedString(interQuartileRange)).append("\n");
    sb.append("    max: ").append(toIndentedString(max)).append("\n");
    sb.append("    maxLength: ").append(toIndentedString(maxLength)).append("\n");
    sb.append("    mean: ").append(toIndentedString(mean)).append("\n");
    sb.append("    median: ").append(toIndentedString(median)).append("\n");
    sb.append("    min: ").append(toIndentedString(min)).append("\n");
    sb.append("    minLength: ").append(toIndentedString(minLength)).append("\n");
    sb.append("    missingCount: ").append(toIndentedString(missingCount)).append("\n");
    sb.append("    missingPercentage: ").append(toIndentedString(missingPercentage)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    nonParametricSkew: ").append(toIndentedString(nonParametricSkew)).append("\n");
    sb.append("    nullCount: ").append(toIndentedString(nullCount)).append("\n");
    sb.append("    nullProportion: ").append(toIndentedString(nullProportion)).append("\n");
    sb.append("    stddev: ").append(toIndentedString(stddev)).append("\n");
    sb.append("    sum: ").append(toIndentedString(sum)).append("\n");
    sb.append("    thirdQuartile: ").append(toIndentedString(thirdQuartile)).append("\n");
    sb.append("    timestamp: ").append(toIndentedString(timestamp)).append("\n");
    sb.append("    uniqueCount: ").append(toIndentedString(uniqueCount)).append("\n");
    sb.append("    uniqueProportion: ").append(toIndentedString(uniqueProportion)).append("\n");
    sb.append("    validCount: ").append(toIndentedString(validCount)).append("\n");
    sb.append("    valuesCount: ").append(toIndentedString(valuesCount)).append("\n");
    sb.append("    valuesPercentage: ").append(toIndentedString(valuesPercentage)).append("\n");
    sb.append("    variance: ").append(toIndentedString(variance)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

