/*
 * OpenMetadata Apis
 * --- title: APIs slug: /main-concepts/metadata-standard/apis ---  # APIs  OpenMetadata supports REST APIs for getting data and in and out of the metadata service. APIs are built using general best practices of REST API design. We take a schema-first approach by defining Types and Entities in JSON Schema. We implement APIs based on these schemas.  ## Overview  ### URI  Following REST API conventions are followed for Resource URIs: - Operations for an entity are available through the Resource URI as a collection `.../api/<version>/entities`.  - Plural of the entity name is used as the collection name - example `.../api/v1/users`. - Trailing forward slash is not used in the endpoint URI. Example use `.../api/v1/databases` instead of `.../api/v1/databases/`. - Resource URI for an entity instance by the entity id is `.../api/v1/entities/{id}`.  - Resource URI for an entity instance by name is `.../api/v1/entities/name/{name}`.  ### Resource Representation  - The REST API calls return a response with JSON `Content-Type` and `Content-Length` that includes the length of the response. - All responses include the Resource ID field even though the id was provided in the request to simplify the consumption    of the response at the client. - Entity names and field names use `camelCase` per Javascript naming convention. - All resources include an attribute `href` with Resource URI. All relationship fields of an entity will also    include `href` links to the related resource for easy access. - Unknown fields sent by the client in API requests are not ignored to ensure the data sent by the client is not dropped    at the server without the user being aware of it.  ## API Organization  You can find the swagger documentation [here](/swagger.html). In a nutshell:  **Data Asset APIs** - support operations related to data asset entities. - `.../api/v1/databases` - `...api/v1/tables` - `.../api/v1/metrics` - `.../api/v1/dashboards` - `.../api/v1/reports` - `.../api/v1/pipelines` - `.../api/v1/topics`  **Service APIs** - support operations related to services from which metadata is collected: - `.../api/v1/services` is the collection of all service resources. - `.../api/v1/services/databaseService` - APIs related to database services. This includes Transactional databases - MySQL, Postgres, MSSQL, Oracle, and Data Warehouses - Apache Hive BigQuery, Redshift, and Snowflake. - `.../api/v1/services/dashboardService` - APIs related to Dashboard Services. This includes Looker, Superset, and Tableau. - `.../api/v1/services/messagingService` - APIs related to Messaging Services. This includes Apache Kafka, Redpanda, - Kinesis, and others.  **Teams & Users APIs** - `.../api/v1/teams` - APIs related to team entities - `.../api/v1/users` - APIs related to user entities  **Search & Suggest APIs** - support search and suggest APIs: - `.../api/v1/search` - collection for search and suggest APIs - `.../api/v1/search/query` - search entities using query text - `.../api/v1/search/suggest` - get suggested entities used for auto-completion  **Other APIs** - `.../api/v1/tags` for APIs related to Classification and Tag entities - `../api/v1/feeds` for APIs related to Threads and Posts entities - `.../api/v1/usage` for reporting usage information of entities
 *
 * The version of the OpenAPI document: 1.2.2
 * Contact: openmetadata-dev@googlegroups.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.openmetadata.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.openmetadata.client.model.EntityReference;
import org.openmetadata.client.model.LifeCycle;
import org.openmetadata.client.model.TagLabel;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * CreateAppMarketPlaceDefinitionReq
 */
@JsonPropertyOrder({
  CreateAppMarketPlaceDefinitionReq.JSON_PROPERTY_APP_CONFIGURATION,
  CreateAppMarketPlaceDefinitionReq.JSON_PROPERTY_APP_LOGO_URL,
  CreateAppMarketPlaceDefinitionReq.JSON_PROPERTY_APP_SCREENSHOTS,
  CreateAppMarketPlaceDefinitionReq.JSON_PROPERTY_APP_TYPE,
  CreateAppMarketPlaceDefinitionReq.JSON_PROPERTY_CLASS_NAME,
  CreateAppMarketPlaceDefinitionReq.JSON_PROPERTY_DATA_PRODUCTS,
  CreateAppMarketPlaceDefinitionReq.JSON_PROPERTY_DESCRIPTION,
  CreateAppMarketPlaceDefinitionReq.JSON_PROPERTY_DEVELOPER,
  CreateAppMarketPlaceDefinitionReq.JSON_PROPERTY_DEVELOPER_URL,
  CreateAppMarketPlaceDefinitionReq.JSON_PROPERTY_DISPLAY_NAME,
  CreateAppMarketPlaceDefinitionReq.JSON_PROPERTY_DOMAIN,
  CreateAppMarketPlaceDefinitionReq.JSON_PROPERTY_EXTENSION,
  CreateAppMarketPlaceDefinitionReq.JSON_PROPERTY_FEATURES,
  CreateAppMarketPlaceDefinitionReq.JSON_PROPERTY_LIFE_CYCLE,
  CreateAppMarketPlaceDefinitionReq.JSON_PROPERTY_NAME,
  CreateAppMarketPlaceDefinitionReq.JSON_PROPERTY_OWNER,
  CreateAppMarketPlaceDefinitionReq.JSON_PROPERTY_PERMISSION,
  CreateAppMarketPlaceDefinitionReq.JSON_PROPERTY_PRIVACY_POLICY_URL,
  CreateAppMarketPlaceDefinitionReq.JSON_PROPERTY_RUNTIME,
  CreateAppMarketPlaceDefinitionReq.JSON_PROPERTY_SCHEDULE_TYPE,
  CreateAppMarketPlaceDefinitionReq.JSON_PROPERTY_SUPPORT_EMAIL,
  CreateAppMarketPlaceDefinitionReq.JSON_PROPERTY_TAGS
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-20T11:35:38.398944261Z[Etc/UTC]")
public class CreateAppMarketPlaceDefinitionReq {
  public static final String JSON_PROPERTY_APP_CONFIGURATION = "appConfiguration";
  private Object appConfiguration;

  public static final String JSON_PROPERTY_APP_LOGO_URL = "appLogoUrl";
  private URI appLogoUrl;

  public static final String JSON_PROPERTY_APP_SCREENSHOTS = "appScreenshots";
  private Set<String> appScreenshots = null;

  /**
   * Gets or Sets appType
   */
  public enum AppTypeEnum {
    INTERNAL("internal"),
    
    EXTERNAL("external");

    private String value;

    AppTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static AppTypeEnum fromValue(String value) {
      for (AppTypeEnum b : AppTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_APP_TYPE = "appType";
  private AppTypeEnum appType;

  public static final String JSON_PROPERTY_CLASS_NAME = "className";
  private String className;

  public static final String JSON_PROPERTY_DATA_PRODUCTS = "dataProducts";
  private List<String> dataProducts = null;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description;

  public static final String JSON_PROPERTY_DEVELOPER = "developer";
  private String developer;

  public static final String JSON_PROPERTY_DEVELOPER_URL = "developerUrl";
  private String developerUrl;

  public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
  private String displayName;

  public static final String JSON_PROPERTY_DOMAIN = "domain";
  private String domain;

  public static final String JSON_PROPERTY_EXTENSION = "extension";
  private Object extension;

  public static final String JSON_PROPERTY_FEATURES = "features";
  private String features;

  public static final String JSON_PROPERTY_LIFE_CYCLE = "lifeCycle";
  private LifeCycle lifeCycle;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_OWNER = "owner";
  private EntityReference owner;

  /**
   * Gets or Sets permission
   */
  public enum PermissionEnum {
    ALL("All");

    private String value;

    PermissionEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PermissionEnum fromValue(String value) {
      for (PermissionEnum b : PermissionEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PERMISSION = "permission";
  private PermissionEnum permission;

  public static final String JSON_PROPERTY_PRIVACY_POLICY_URL = "privacyPolicyUrl";
  private String privacyPolicyUrl;

  public static final String JSON_PROPERTY_RUNTIME = "runtime";
  private Object runtime;

  /**
   * Gets or Sets scheduleType
   */
  public enum ScheduleTypeEnum {
    LIVE("Live"),
    
    SCHEDULED("Scheduled");

    private String value;

    ScheduleTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ScheduleTypeEnum fromValue(String value) {
      for (ScheduleTypeEnum b : ScheduleTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_SCHEDULE_TYPE = "scheduleType";
  private ScheduleTypeEnum scheduleType;

  public static final String JSON_PROPERTY_SUPPORT_EMAIL = "supportEmail";
  private String supportEmail;

  public static final String JSON_PROPERTY_TAGS = "tags";
  private List<TagLabel> tags = null;

  public CreateAppMarketPlaceDefinitionReq() { 
  }

  public CreateAppMarketPlaceDefinitionReq appConfiguration(Object appConfiguration) {
    
    this.appConfiguration = appConfiguration;
    return this;
  }

   /**
   * Get appConfiguration
   * @return appConfiguration
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_APP_CONFIGURATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getAppConfiguration() {
    return appConfiguration;
  }


  @JsonProperty(JSON_PROPERTY_APP_CONFIGURATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAppConfiguration(Object appConfiguration) {
    this.appConfiguration = appConfiguration;
  }


  public CreateAppMarketPlaceDefinitionReq appLogoUrl(URI appLogoUrl) {
    
    this.appLogoUrl = appLogoUrl;
    return this;
  }

   /**
   * Get appLogoUrl
   * @return appLogoUrl
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_APP_LOGO_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public URI getAppLogoUrl() {
    return appLogoUrl;
  }


  @JsonProperty(JSON_PROPERTY_APP_LOGO_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAppLogoUrl(URI appLogoUrl) {
    this.appLogoUrl = appLogoUrl;
  }


  public CreateAppMarketPlaceDefinitionReq appScreenshots(Set<String> appScreenshots) {
    
    this.appScreenshots = appScreenshots;
    return this;
  }

  public CreateAppMarketPlaceDefinitionReq addAppScreenshotsItem(String appScreenshotsItem) {
    if (this.appScreenshots == null) {
      this.appScreenshots = new LinkedHashSet<>();
    }
    this.appScreenshots.add(appScreenshotsItem);
    return this;
  }

   /**
   * Get appScreenshots
   * @return appScreenshots
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_APP_SCREENSHOTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Set<String> getAppScreenshots() {
    return appScreenshots;
  }


  @JsonDeserialize(as = LinkedHashSet.class)
  @JsonProperty(JSON_PROPERTY_APP_SCREENSHOTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAppScreenshots(Set<String> appScreenshots) {
    this.appScreenshots = appScreenshots;
  }


  public CreateAppMarketPlaceDefinitionReq appType(AppTypeEnum appType) {
    
    this.appType = appType;
    return this;
  }

   /**
   * Get appType
   * @return appType
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_APP_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public AppTypeEnum getAppType() {
    return appType;
  }


  @JsonProperty(JSON_PROPERTY_APP_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAppType(AppTypeEnum appType) {
    this.appType = appType;
  }


  public CreateAppMarketPlaceDefinitionReq className(String className) {
    
    this.className = className;
    return this;
  }

   /**
   * Get className
   * @return className
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_CLASS_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getClassName() {
    return className;
  }


  @JsonProperty(JSON_PROPERTY_CLASS_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setClassName(String className) {
    this.className = className;
  }


  public CreateAppMarketPlaceDefinitionReq dataProducts(List<String> dataProducts) {
    
    this.dataProducts = dataProducts;
    return this;
  }

  public CreateAppMarketPlaceDefinitionReq addDataProductsItem(String dataProductsItem) {
    if (this.dataProducts == null) {
      this.dataProducts = new ArrayList<>();
    }
    this.dataProducts.add(dataProductsItem);
    return this;
  }

   /**
   * Get dataProducts
   * @return dataProducts
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DATA_PRODUCTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getDataProducts() {
    return dataProducts;
  }


  @JsonProperty(JSON_PROPERTY_DATA_PRODUCTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDataProducts(List<String> dataProducts) {
    this.dataProducts = dataProducts;
  }


  public CreateAppMarketPlaceDefinitionReq description(String description) {
    
    this.description = description;
    return this;
  }

   /**
   * Get description
   * @return description
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDescription() {
    return description;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(String description) {
    this.description = description;
  }


  public CreateAppMarketPlaceDefinitionReq developer(String developer) {
    
    this.developer = developer;
    return this;
  }

   /**
   * Get developer
   * @return developer
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DEVELOPER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDeveloper() {
    return developer;
  }


  @JsonProperty(JSON_PROPERTY_DEVELOPER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDeveloper(String developer) {
    this.developer = developer;
  }


  public CreateAppMarketPlaceDefinitionReq developerUrl(String developerUrl) {
    
    this.developerUrl = developerUrl;
    return this;
  }

   /**
   * Get developerUrl
   * @return developerUrl
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DEVELOPER_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDeveloperUrl() {
    return developerUrl;
  }


  @JsonProperty(JSON_PROPERTY_DEVELOPER_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDeveloperUrl(String developerUrl) {
    this.developerUrl = developerUrl;
  }


  public CreateAppMarketPlaceDefinitionReq displayName(String displayName) {
    
    this.displayName = displayName;
    return this;
  }

   /**
   * Get displayName
   * @return displayName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DISPLAY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDisplayName() {
    return displayName;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisplayName(String displayName) {
    this.displayName = displayName;
  }


  public CreateAppMarketPlaceDefinitionReq domain(String domain) {
    
    this.domain = domain;
    return this;
  }

   /**
   * Get domain
   * @return domain
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DOMAIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDomain() {
    return domain;
  }


  @JsonProperty(JSON_PROPERTY_DOMAIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDomain(String domain) {
    this.domain = domain;
  }


  public CreateAppMarketPlaceDefinitionReq extension(Object extension) {
    
    this.extension = extension;
    return this;
  }

   /**
   * Get extension
   * @return extension
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_EXTENSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getExtension() {
    return extension;
  }


  @JsonProperty(JSON_PROPERTY_EXTENSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExtension(Object extension) {
    this.extension = extension;
  }


  public CreateAppMarketPlaceDefinitionReq features(String features) {
    
    this.features = features;
    return this;
  }

   /**
   * Get features
   * @return features
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_FEATURES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFeatures() {
    return features;
  }


  @JsonProperty(JSON_PROPERTY_FEATURES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFeatures(String features) {
    this.features = features;
  }


  public CreateAppMarketPlaceDefinitionReq lifeCycle(LifeCycle lifeCycle) {
    
    this.lifeCycle = lifeCycle;
    return this;
  }

   /**
   * Get lifeCycle
   * @return lifeCycle
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_LIFE_CYCLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LifeCycle getLifeCycle() {
    return lifeCycle;
  }


  @JsonProperty(JSON_PROPERTY_LIFE_CYCLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLifeCycle(LifeCycle lifeCycle) {
    this.lifeCycle = lifeCycle;
  }


  public CreateAppMarketPlaceDefinitionReq name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Get name
   * @return name
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public CreateAppMarketPlaceDefinitionReq owner(EntityReference owner) {
    
    this.owner = owner;
    return this;
  }

   /**
   * Get owner
   * @return owner
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_OWNER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public EntityReference getOwner() {
    return owner;
  }


  @JsonProperty(JSON_PROPERTY_OWNER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOwner(EntityReference owner) {
    this.owner = owner;
  }


  public CreateAppMarketPlaceDefinitionReq permission(PermissionEnum permission) {
    
    this.permission = permission;
    return this;
  }

   /**
   * Get permission
   * @return permission
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_PERMISSION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public PermissionEnum getPermission() {
    return permission;
  }


  @JsonProperty(JSON_PROPERTY_PERMISSION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPermission(PermissionEnum permission) {
    this.permission = permission;
  }


  public CreateAppMarketPlaceDefinitionReq privacyPolicyUrl(String privacyPolicyUrl) {
    
    this.privacyPolicyUrl = privacyPolicyUrl;
    return this;
  }

   /**
   * Get privacyPolicyUrl
   * @return privacyPolicyUrl
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PRIVACY_POLICY_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPrivacyPolicyUrl() {
    return privacyPolicyUrl;
  }


  @JsonProperty(JSON_PROPERTY_PRIVACY_POLICY_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPrivacyPolicyUrl(String privacyPolicyUrl) {
    this.privacyPolicyUrl = privacyPolicyUrl;
  }


  public CreateAppMarketPlaceDefinitionReq runtime(Object runtime) {
    
    this.runtime = runtime;
    return this;
  }

   /**
   * Get runtime
   * @return runtime
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_RUNTIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getRuntime() {
    return runtime;
  }


  @JsonProperty(JSON_PROPERTY_RUNTIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRuntime(Object runtime) {
    this.runtime = runtime;
  }


  public CreateAppMarketPlaceDefinitionReq scheduleType(ScheduleTypeEnum scheduleType) {
    
    this.scheduleType = scheduleType;
    return this;
  }

   /**
   * Get scheduleType
   * @return scheduleType
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_SCHEDULE_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public ScheduleTypeEnum getScheduleType() {
    return scheduleType;
  }


  @JsonProperty(JSON_PROPERTY_SCHEDULE_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setScheduleType(ScheduleTypeEnum scheduleType) {
    this.scheduleType = scheduleType;
  }


  public CreateAppMarketPlaceDefinitionReq supportEmail(String supportEmail) {
    
    this.supportEmail = supportEmail;
    return this;
  }

   /**
   * Get supportEmail
   * @return supportEmail
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SUPPORT_EMAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSupportEmail() {
    return supportEmail;
  }


  @JsonProperty(JSON_PROPERTY_SUPPORT_EMAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSupportEmail(String supportEmail) {
    this.supportEmail = supportEmail;
  }


  public CreateAppMarketPlaceDefinitionReq tags(List<TagLabel> tags) {
    
    this.tags = tags;
    return this;
  }

  public CreateAppMarketPlaceDefinitionReq addTagsItem(TagLabel tagsItem) {
    if (this.tags == null) {
      this.tags = new ArrayList<>();
    }
    this.tags.add(tagsItem);
    return this;
  }

   /**
   * Get tags
   * @return tags
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<TagLabel> getTags() {
    return tags;
  }


  @JsonProperty(JSON_PROPERTY_TAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTags(List<TagLabel> tags) {
    this.tags = tags;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreateAppMarketPlaceDefinitionReq createAppMarketPlaceDefinitionReq = (CreateAppMarketPlaceDefinitionReq) o;
    return Objects.equals(this.appConfiguration, createAppMarketPlaceDefinitionReq.appConfiguration) &&
        Objects.equals(this.appLogoUrl, createAppMarketPlaceDefinitionReq.appLogoUrl) &&
        Objects.equals(this.appScreenshots, createAppMarketPlaceDefinitionReq.appScreenshots) &&
        Objects.equals(this.appType, createAppMarketPlaceDefinitionReq.appType) &&
        Objects.equals(this.className, createAppMarketPlaceDefinitionReq.className) &&
        Objects.equals(this.dataProducts, createAppMarketPlaceDefinitionReq.dataProducts) &&
        Objects.equals(this.description, createAppMarketPlaceDefinitionReq.description) &&
        Objects.equals(this.developer, createAppMarketPlaceDefinitionReq.developer) &&
        Objects.equals(this.developerUrl, createAppMarketPlaceDefinitionReq.developerUrl) &&
        Objects.equals(this.displayName, createAppMarketPlaceDefinitionReq.displayName) &&
        Objects.equals(this.domain, createAppMarketPlaceDefinitionReq.domain) &&
        Objects.equals(this.extension, createAppMarketPlaceDefinitionReq.extension) &&
        Objects.equals(this.features, createAppMarketPlaceDefinitionReq.features) &&
        Objects.equals(this.lifeCycle, createAppMarketPlaceDefinitionReq.lifeCycle) &&
        Objects.equals(this.name, createAppMarketPlaceDefinitionReq.name) &&
        Objects.equals(this.owner, createAppMarketPlaceDefinitionReq.owner) &&
        Objects.equals(this.permission, createAppMarketPlaceDefinitionReq.permission) &&
        Objects.equals(this.privacyPolicyUrl, createAppMarketPlaceDefinitionReq.privacyPolicyUrl) &&
        Objects.equals(this.runtime, createAppMarketPlaceDefinitionReq.runtime) &&
        Objects.equals(this.scheduleType, createAppMarketPlaceDefinitionReq.scheduleType) &&
        Objects.equals(this.supportEmail, createAppMarketPlaceDefinitionReq.supportEmail) &&
        Objects.equals(this.tags, createAppMarketPlaceDefinitionReq.tags);
  }

  @Override
  public int hashCode() {
    return Objects.hash(appConfiguration, appLogoUrl, appScreenshots, appType, className, dataProducts, description, developer, developerUrl, displayName, domain, extension, features, lifeCycle, name, owner, permission, privacyPolicyUrl, runtime, scheduleType, supportEmail, tags);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateAppMarketPlaceDefinitionReq {\n");
    sb.append("    appConfiguration: ").append(toIndentedString(appConfiguration)).append("\n");
    sb.append("    appLogoUrl: ").append(toIndentedString(appLogoUrl)).append("\n");
    sb.append("    appScreenshots: ").append(toIndentedString(appScreenshots)).append("\n");
    sb.append("    appType: ").append(toIndentedString(appType)).append("\n");
    sb.append("    className: ").append(toIndentedString(className)).append("\n");
    sb.append("    dataProducts: ").append(toIndentedString(dataProducts)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    developer: ").append(toIndentedString(developer)).append("\n");
    sb.append("    developerUrl: ").append(toIndentedString(developerUrl)).append("\n");
    sb.append("    displayName: ").append(toIndentedString(displayName)).append("\n");
    sb.append("    domain: ").append(toIndentedString(domain)).append("\n");
    sb.append("    extension: ").append(toIndentedString(extension)).append("\n");
    sb.append("    features: ").append(toIndentedString(features)).append("\n");
    sb.append("    lifeCycle: ").append(toIndentedString(lifeCycle)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    owner: ").append(toIndentedString(owner)).append("\n");
    sb.append("    permission: ").append(toIndentedString(permission)).append("\n");
    sb.append("    privacyPolicyUrl: ").append(toIndentedString(privacyPolicyUrl)).append("\n");
    sb.append("    runtime: ").append(toIndentedString(runtime)).append("\n");
    sb.append("    scheduleType: ").append(toIndentedString(scheduleType)).append("\n");
    sb.append("    supportEmail: ").append(toIndentedString(supportEmail)).append("\n");
    sb.append("    tags: ").append(toIndentedString(tags)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

