/*
 * OpenMetadata Apis
 * --- title: APIs slug: /main-concepts/metadata-standard/apis ---  # APIs  OpenMetadata supports REST APIs for getting data and in and out of the metadata service. APIs are built using general best practices of REST API design. We take a schema-first approach by defining Types and Entities in JSON Schema. We implement APIs based on these schemas.  ## Overview  ### URI  Following REST API conventions are followed for Resource URIs: - Operations for an entity are available through the Resource URI as a collection `.../api/<version>/entities`.  - Plural of the entity name is used as the collection name - example `.../api/v1/users`. - Trailing forward slash is not used in the endpoint URI. Example use `.../api/v1/databases` instead of `.../api/v1/databases/`. - Resource URI for an entity instance by the entity id is `.../api/v1/entities/{id}`.  - Resource URI for an entity instance by name is `.../api/v1/entities/name/{name}`.  ### Resource Representation  - The REST API calls return a response with JSON `Content-Type` and `Content-Length` that includes the length of the response. - All responses include the Resource ID field even though the id was provided in the request to simplify the consumption    of the response at the client. - Entity names and field names use `camelCase` per Javascript naming convention. - All resources include an attribute `href` with Resource URI. All relationship fields of an entity will also    include `href` links to the related resource for easy access. - Unknown fields sent by the client in API requests are not ignored to ensure the data sent by the client is not dropped    at the server without the user being aware of it.  ## API Organization  You can find the swagger documentation [here](/swagger.html). In a nutshell:  **Data Asset APIs** - support operations related to data asset entities. - `.../api/v1/databases` - `...api/v1/tables` - `.../api/v1/metrics` - `.../api/v1/dashboards` - `.../api/v1/reports` - `.../api/v1/pipelines` - `.../api/v1/topics`  **Service APIs** - support operations related to services from which metadata is collected: - `.../api/v1/services` is the collection of all service resources. - `.../api/v1/services/databaseService` - APIs related to database services. This includes Transactional databases - MySQL, Postgres, MSSQL, Oracle, and Data Warehouses - Apache Hive BigQuery, Redshift, and Snowflake. - `.../api/v1/services/dashboardService` - APIs related to Dashboard Services. This includes Looker, Superset, and Tableau. - `.../api/v1/services/messagingService` - APIs related to Messaging Services. This includes Apache Kafka, Redpanda, - Kinesis, and others.  **Teams & Users APIs** - `.../api/v1/teams` - APIs related to team entities - `.../api/v1/users` - APIs related to user entities  **Search & Suggest APIs** - support search and suggest APIs: - `.../api/v1/search` - collection for search and suggest APIs - `.../api/v1/search/query` - search entities using query text - `.../api/v1/search/suggest` - get suggested entities used for auto-completion  **Other APIs** - `.../api/v1/tags` for APIs related to Classification and Tag entities - `../api/v1/feeds` for APIs related to Threads and Posts entities - `.../api/v1/usage` for reporting usage information of entities
 *
 * The version of the OpenAPI document: 1.2.2
 * Contact: openmetadata-dev@googlegroups.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.openmetadata.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.openmetadata.client.model.DashboardConnection;
import org.openmetadata.client.model.EntityReference;
import org.openmetadata.client.model.LifeCycle;
import org.openmetadata.client.model.TagLabel;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * CreateDashboardService
 */
@JsonPropertyOrder({
  CreateDashboardService.JSON_PROPERTY_CONNECTION,
  CreateDashboardService.JSON_PROPERTY_DATA_PRODUCTS,
  CreateDashboardService.JSON_PROPERTY_DESCRIPTION,
  CreateDashboardService.JSON_PROPERTY_DISPLAY_NAME,
  CreateDashboardService.JSON_PROPERTY_DOMAIN,
  CreateDashboardService.JSON_PROPERTY_EXTENSION,
  CreateDashboardService.JSON_PROPERTY_LIFE_CYCLE,
  CreateDashboardService.JSON_PROPERTY_NAME,
  CreateDashboardService.JSON_PROPERTY_OWNER,
  CreateDashboardService.JSON_PROPERTY_SERVICE_TYPE,
  CreateDashboardService.JSON_PROPERTY_TAGS
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-20T11:35:38.398944261Z[Etc/UTC]")
public class CreateDashboardService {
  public static final String JSON_PROPERTY_CONNECTION = "connection";
  private DashboardConnection connection;

  public static final String JSON_PROPERTY_DATA_PRODUCTS = "dataProducts";
  private List<String> dataProducts = null;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description;

  public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
  private String displayName;

  public static final String JSON_PROPERTY_DOMAIN = "domain";
  private String domain;

  public static final String JSON_PROPERTY_EXTENSION = "extension";
  private Object extension;

  public static final String JSON_PROPERTY_LIFE_CYCLE = "lifeCycle";
  private LifeCycle lifeCycle;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_OWNER = "owner";
  private EntityReference owner;

  /**
   * Gets or Sets serviceType
   */
  public enum ServiceTypeEnum {
    SUPERSET("Superset"),
    
    LOOKER("Looker"),
    
    TABLEAU("Tableau"),
    
    REDASH("Redash"),
    
    METABASE("Metabase"),
    
    POWERBI("PowerBI"),
    
    MODE("Mode"),
    
    CUSTOMDASHBOARD("CustomDashboard"),
    
    DOMODASHBOARD("DomoDashboard"),
    
    QUICKSIGHT("QuickSight"),
    
    QLIKSENSE("QlikSense"),
    
    LIGHTDASH("Lightdash");

    private String value;

    ServiceTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ServiceTypeEnum fromValue(String value) {
      for (ServiceTypeEnum b : ServiceTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_SERVICE_TYPE = "serviceType";
  private ServiceTypeEnum serviceType;

  public static final String JSON_PROPERTY_TAGS = "tags";
  private List<TagLabel> tags = null;

  public CreateDashboardService() { 
  }

  public CreateDashboardService connection(DashboardConnection connection) {
    
    this.connection = connection;
    return this;
  }

   /**
   * Get connection
   * @return connection
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CONNECTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public DashboardConnection getConnection() {
    return connection;
  }


  @JsonProperty(JSON_PROPERTY_CONNECTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setConnection(DashboardConnection connection) {
    this.connection = connection;
  }


  public CreateDashboardService dataProducts(List<String> dataProducts) {
    
    this.dataProducts = dataProducts;
    return this;
  }

  public CreateDashboardService addDataProductsItem(String dataProductsItem) {
    if (this.dataProducts == null) {
      this.dataProducts = new ArrayList<>();
    }
    this.dataProducts.add(dataProductsItem);
    return this;
  }

   /**
   * Get dataProducts
   * @return dataProducts
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DATA_PRODUCTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getDataProducts() {
    return dataProducts;
  }


  @JsonProperty(JSON_PROPERTY_DATA_PRODUCTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDataProducts(List<String> dataProducts) {
    this.dataProducts = dataProducts;
  }


  public CreateDashboardService description(String description) {
    
    this.description = description;
    return this;
  }

   /**
   * Get description
   * @return description
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDescription() {
    return description;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(String description) {
    this.description = description;
  }


  public CreateDashboardService displayName(String displayName) {
    
    this.displayName = displayName;
    return this;
  }

   /**
   * Get displayName
   * @return displayName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DISPLAY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDisplayName() {
    return displayName;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisplayName(String displayName) {
    this.displayName = displayName;
  }


  public CreateDashboardService domain(String domain) {
    
    this.domain = domain;
    return this;
  }

   /**
   * Get domain
   * @return domain
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DOMAIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDomain() {
    return domain;
  }


  @JsonProperty(JSON_PROPERTY_DOMAIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDomain(String domain) {
    this.domain = domain;
  }


  public CreateDashboardService extension(Object extension) {
    
    this.extension = extension;
    return this;
  }

   /**
   * Get extension
   * @return extension
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_EXTENSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getExtension() {
    return extension;
  }


  @JsonProperty(JSON_PROPERTY_EXTENSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExtension(Object extension) {
    this.extension = extension;
  }


  public CreateDashboardService lifeCycle(LifeCycle lifeCycle) {
    
    this.lifeCycle = lifeCycle;
    return this;
  }

   /**
   * Get lifeCycle
   * @return lifeCycle
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_LIFE_CYCLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LifeCycle getLifeCycle() {
    return lifeCycle;
  }


  @JsonProperty(JSON_PROPERTY_LIFE_CYCLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLifeCycle(LifeCycle lifeCycle) {
    this.lifeCycle = lifeCycle;
  }


  public CreateDashboardService name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Get name
   * @return name
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public CreateDashboardService owner(EntityReference owner) {
    
    this.owner = owner;
    return this;
  }

   /**
   * Get owner
   * @return owner
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_OWNER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public EntityReference getOwner() {
    return owner;
  }


  @JsonProperty(JSON_PROPERTY_OWNER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOwner(EntityReference owner) {
    this.owner = owner;
  }


  public CreateDashboardService serviceType(ServiceTypeEnum serviceType) {
    
    this.serviceType = serviceType;
    return this;
  }

   /**
   * Get serviceType
   * @return serviceType
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_SERVICE_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public ServiceTypeEnum getServiceType() {
    return serviceType;
  }


  @JsonProperty(JSON_PROPERTY_SERVICE_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setServiceType(ServiceTypeEnum serviceType) {
    this.serviceType = serviceType;
  }


  public CreateDashboardService tags(List<TagLabel> tags) {
    
    this.tags = tags;
    return this;
  }

  public CreateDashboardService addTagsItem(TagLabel tagsItem) {
    if (this.tags == null) {
      this.tags = new ArrayList<>();
    }
    this.tags.add(tagsItem);
    return this;
  }

   /**
   * Get tags
   * @return tags
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<TagLabel> getTags() {
    return tags;
  }


  @JsonProperty(JSON_PROPERTY_TAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTags(List<TagLabel> tags) {
    this.tags = tags;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreateDashboardService createDashboardService = (CreateDashboardService) o;
    return Objects.equals(this.connection, createDashboardService.connection) &&
        Objects.equals(this.dataProducts, createDashboardService.dataProducts) &&
        Objects.equals(this.description, createDashboardService.description) &&
        Objects.equals(this.displayName, createDashboardService.displayName) &&
        Objects.equals(this.domain, createDashboardService.domain) &&
        Objects.equals(this.extension, createDashboardService.extension) &&
        Objects.equals(this.lifeCycle, createDashboardService.lifeCycle) &&
        Objects.equals(this.name, createDashboardService.name) &&
        Objects.equals(this.owner, createDashboardService.owner) &&
        Objects.equals(this.serviceType, createDashboardService.serviceType) &&
        Objects.equals(this.tags, createDashboardService.tags);
  }

  @Override
  public int hashCode() {
    return Objects.hash(connection, dataProducts, description, displayName, domain, extension, lifeCycle, name, owner, serviceType, tags);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateDashboardService {\n");
    sb.append("    connection: ").append(toIndentedString(connection)).append("\n");
    sb.append("    dataProducts: ").append(toIndentedString(dataProducts)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    displayName: ").append(toIndentedString(displayName)).append("\n");
    sb.append("    domain: ").append(toIndentedString(domain)).append("\n");
    sb.append("    extension: ").append(toIndentedString(extension)).append("\n");
    sb.append("    lifeCycle: ").append(toIndentedString(lifeCycle)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    owner: ").append(toIndentedString(owner)).append("\n");
    sb.append("    serviceType: ").append(toIndentedString(serviceType)).append("\n");
    sb.append("    tags: ").append(toIndentedString(tags)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

