/*
 * OpenMetadata Apis
 * --- title: APIs slug: /main-concepts/metadata-standard/apis ---  # APIs  OpenMetadata supports REST APIs for getting data and in and out of the metadata service. APIs are built using general best practices of REST API design. We take a schema-first approach by defining Types and Entities in JSON Schema. We implement APIs based on these schemas.  ## Overview  ### URI  Following REST API conventions are followed for Resource URIs: - Operations for an entity are available through the Resource URI as a collection `.../api/<version>/entities`.  - Plural of the entity name is used as the collection name - example `.../api/v1/users`. - Trailing forward slash is not used in the endpoint URI. Example use `.../api/v1/databases` instead of `.../api/v1/databases/`. - Resource URI for an entity instance by the entity id is `.../api/v1/entities/{id}`.  - Resource URI for an entity instance by name is `.../api/v1/entities/name/{name}`.  ### Resource Representation  - The REST API calls return a response with JSON `Content-Type` and `Content-Length` that includes the length of the response. - All responses include the Resource ID field even though the id was provided in the request to simplify the consumption    of the response at the client. - Entity names and field names use `camelCase` per Javascript naming convention. - All resources include an attribute `href` with Resource URI. All relationship fields of an entity will also    include `href` links to the related resource for easy access. - Unknown fields sent by the client in API requests are not ignored to ensure the data sent by the client is not dropped    at the server without the user being aware of it.  ## API Organization  You can find the swagger documentation [here](/swagger.html). In a nutshell:  **Data Asset APIs** - support operations related to data asset entities. - `.../api/v1/databases` - `...api/v1/tables` - `.../api/v1/metrics` - `.../api/v1/dashboards` - `.../api/v1/reports` - `.../api/v1/pipelines` - `.../api/v1/topics`  **Service APIs** - support operations related to services from which metadata is collected: - `.../api/v1/services` is the collection of all service resources. - `.../api/v1/services/databaseService` - APIs related to database services. This includes Transactional databases - MySQL, Postgres, MSSQL, Oracle, and Data Warehouses - Apache Hive BigQuery, Redshift, and Snowflake. - `.../api/v1/services/dashboardService` - APIs related to Dashboard Services. This includes Looker, Superset, and Tableau. - `.../api/v1/services/messagingService` - APIs related to Messaging Services. This includes Apache Kafka, Redpanda, - Kinesis, and others.  **Teams & Users APIs** - `.../api/v1/teams` - APIs related to team entities - `.../api/v1/users` - APIs related to user entities  **Search & Suggest APIs** - support search and suggest APIs: - `.../api/v1/search` - collection for search and suggest APIs - `.../api/v1/search/query` - search entities using query text - `.../api/v1/search/suggest` - get suggested entities used for auto-completion  **Other APIs** - `.../api/v1/tags` for APIs related to Classification and Tag entities - `../api/v1/feeds` for APIs related to Threads and Posts entities - `.../api/v1/usage` for reporting usage information of entities
 *
 * The version of the OpenAPI document: 1.2.2
 * Contact: openmetadata-dev@googlegroups.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.openmetadata.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.openmetadata.client.model.EntityReference;
import org.openmetadata.client.model.LifeCycle;
import org.openmetadata.client.model.Style;
import org.openmetadata.client.model.TagLabel;
import org.openmetadata.client.model.TermReference;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * CreateGlossaryTerm
 */
@JsonPropertyOrder({
  CreateGlossaryTerm.JSON_PROPERTY_DATA_PRODUCTS,
  CreateGlossaryTerm.JSON_PROPERTY_DESCRIPTION,
  CreateGlossaryTerm.JSON_PROPERTY_DISPLAY_NAME,
  CreateGlossaryTerm.JSON_PROPERTY_DOMAIN,
  CreateGlossaryTerm.JSON_PROPERTY_EXTENSION,
  CreateGlossaryTerm.JSON_PROPERTY_GLOSSARY,
  CreateGlossaryTerm.JSON_PROPERTY_LIFE_CYCLE,
  CreateGlossaryTerm.JSON_PROPERTY_MUTUALLY_EXCLUSIVE,
  CreateGlossaryTerm.JSON_PROPERTY_NAME,
  CreateGlossaryTerm.JSON_PROPERTY_OWNER,
  CreateGlossaryTerm.JSON_PROPERTY_PARENT,
  CreateGlossaryTerm.JSON_PROPERTY_PROVIDER,
  CreateGlossaryTerm.JSON_PROPERTY_REFERENCES,
  CreateGlossaryTerm.JSON_PROPERTY_RELATED_TERMS,
  CreateGlossaryTerm.JSON_PROPERTY_REVIEWERS,
  CreateGlossaryTerm.JSON_PROPERTY_STYLE,
  CreateGlossaryTerm.JSON_PROPERTY_SYNONYMS,
  CreateGlossaryTerm.JSON_PROPERTY_TAGS
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-20T11:35:38.398944261Z[Etc/UTC]")
public class CreateGlossaryTerm {
  public static final String JSON_PROPERTY_DATA_PRODUCTS = "dataProducts";
  private List<String> dataProducts = null;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description;

  public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
  private String displayName;

  public static final String JSON_PROPERTY_DOMAIN = "domain";
  private String domain;

  public static final String JSON_PROPERTY_EXTENSION = "extension";
  private Object extension;

  public static final String JSON_PROPERTY_GLOSSARY = "glossary";
  private String glossary;

  public static final String JSON_PROPERTY_LIFE_CYCLE = "lifeCycle";
  private LifeCycle lifeCycle;

  public static final String JSON_PROPERTY_MUTUALLY_EXCLUSIVE = "mutuallyExclusive";
  private Boolean mutuallyExclusive;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_OWNER = "owner";
  private EntityReference owner;

  public static final String JSON_PROPERTY_PARENT = "parent";
  private String parent;

  /**
   * Gets or Sets provider
   */
  public enum ProviderEnum {
    SYSTEM("system"),
    
    USER("user");

    private String value;

    ProviderEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ProviderEnum fromValue(String value) {
      for (ProviderEnum b : ProviderEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PROVIDER = "provider";
  private ProviderEnum provider;

  public static final String JSON_PROPERTY_REFERENCES = "references";
  private List<TermReference> references = null;

  public static final String JSON_PROPERTY_RELATED_TERMS = "relatedTerms";
  private List<String> relatedTerms = null;

  public static final String JSON_PROPERTY_REVIEWERS = "reviewers";
  private List<String> reviewers = null;

  public static final String JSON_PROPERTY_STYLE = "style";
  private Style style;

  public static final String JSON_PROPERTY_SYNONYMS = "synonyms";
  private List<String> synonyms = null;

  public static final String JSON_PROPERTY_TAGS = "tags";
  private List<TagLabel> tags = null;

  public CreateGlossaryTerm() { 
  }

  public CreateGlossaryTerm dataProducts(List<String> dataProducts) {
    
    this.dataProducts = dataProducts;
    return this;
  }

  public CreateGlossaryTerm addDataProductsItem(String dataProductsItem) {
    if (this.dataProducts == null) {
      this.dataProducts = new ArrayList<>();
    }
    this.dataProducts.add(dataProductsItem);
    return this;
  }

   /**
   * Get dataProducts
   * @return dataProducts
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DATA_PRODUCTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getDataProducts() {
    return dataProducts;
  }


  @JsonProperty(JSON_PROPERTY_DATA_PRODUCTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDataProducts(List<String> dataProducts) {
    this.dataProducts = dataProducts;
  }


  public CreateGlossaryTerm description(String description) {
    
    this.description = description;
    return this;
  }

   /**
   * Get description
   * @return description
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getDescription() {
    return description;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDescription(String description) {
    this.description = description;
  }


  public CreateGlossaryTerm displayName(String displayName) {
    
    this.displayName = displayName;
    return this;
  }

   /**
   * Get displayName
   * @return displayName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DISPLAY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDisplayName() {
    return displayName;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisplayName(String displayName) {
    this.displayName = displayName;
  }


  public CreateGlossaryTerm domain(String domain) {
    
    this.domain = domain;
    return this;
  }

   /**
   * Get domain
   * @return domain
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DOMAIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDomain() {
    return domain;
  }


  @JsonProperty(JSON_PROPERTY_DOMAIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDomain(String domain) {
    this.domain = domain;
  }


  public CreateGlossaryTerm extension(Object extension) {
    
    this.extension = extension;
    return this;
  }

   /**
   * Get extension
   * @return extension
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_EXTENSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getExtension() {
    return extension;
  }


  @JsonProperty(JSON_PROPERTY_EXTENSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExtension(Object extension) {
    this.extension = extension;
  }


  public CreateGlossaryTerm glossary(String glossary) {
    
    this.glossary = glossary;
    return this;
  }

   /**
   * Get glossary
   * @return glossary
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_GLOSSARY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getGlossary() {
    return glossary;
  }


  @JsonProperty(JSON_PROPERTY_GLOSSARY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setGlossary(String glossary) {
    this.glossary = glossary;
  }


  public CreateGlossaryTerm lifeCycle(LifeCycle lifeCycle) {
    
    this.lifeCycle = lifeCycle;
    return this;
  }

   /**
   * Get lifeCycle
   * @return lifeCycle
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_LIFE_CYCLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LifeCycle getLifeCycle() {
    return lifeCycle;
  }


  @JsonProperty(JSON_PROPERTY_LIFE_CYCLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLifeCycle(LifeCycle lifeCycle) {
    this.lifeCycle = lifeCycle;
  }


  public CreateGlossaryTerm mutuallyExclusive(Boolean mutuallyExclusive) {
    
    this.mutuallyExclusive = mutuallyExclusive;
    return this;
  }

   /**
   * Get mutuallyExclusive
   * @return mutuallyExclusive
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MUTUALLY_EXCLUSIVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getMutuallyExclusive() {
    return mutuallyExclusive;
  }


  @JsonProperty(JSON_PROPERTY_MUTUALLY_EXCLUSIVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMutuallyExclusive(Boolean mutuallyExclusive) {
    this.mutuallyExclusive = mutuallyExclusive;
  }


  public CreateGlossaryTerm name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Get name
   * @return name
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public CreateGlossaryTerm owner(EntityReference owner) {
    
    this.owner = owner;
    return this;
  }

   /**
   * Get owner
   * @return owner
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_OWNER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public EntityReference getOwner() {
    return owner;
  }


  @JsonProperty(JSON_PROPERTY_OWNER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOwner(EntityReference owner) {
    this.owner = owner;
  }


  public CreateGlossaryTerm parent(String parent) {
    
    this.parent = parent;
    return this;
  }

   /**
   * Get parent
   * @return parent
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PARENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getParent() {
    return parent;
  }


  @JsonProperty(JSON_PROPERTY_PARENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setParent(String parent) {
    this.parent = parent;
  }


  public CreateGlossaryTerm provider(ProviderEnum provider) {
    
    this.provider = provider;
    return this;
  }

   /**
   * Get provider
   * @return provider
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PROVIDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ProviderEnum getProvider() {
    return provider;
  }


  @JsonProperty(JSON_PROPERTY_PROVIDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProvider(ProviderEnum provider) {
    this.provider = provider;
  }


  public CreateGlossaryTerm references(List<TermReference> references) {
    
    this.references = references;
    return this;
  }

  public CreateGlossaryTerm addReferencesItem(TermReference referencesItem) {
    if (this.references == null) {
      this.references = new ArrayList<>();
    }
    this.references.add(referencesItem);
    return this;
  }

   /**
   * Get references
   * @return references
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_REFERENCES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<TermReference> getReferences() {
    return references;
  }


  @JsonProperty(JSON_PROPERTY_REFERENCES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReferences(List<TermReference> references) {
    this.references = references;
  }


  public CreateGlossaryTerm relatedTerms(List<String> relatedTerms) {
    
    this.relatedTerms = relatedTerms;
    return this;
  }

  public CreateGlossaryTerm addRelatedTermsItem(String relatedTermsItem) {
    if (this.relatedTerms == null) {
      this.relatedTerms = new ArrayList<>();
    }
    this.relatedTerms.add(relatedTermsItem);
    return this;
  }

   /**
   * Get relatedTerms
   * @return relatedTerms
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_RELATED_TERMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getRelatedTerms() {
    return relatedTerms;
  }


  @JsonProperty(JSON_PROPERTY_RELATED_TERMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRelatedTerms(List<String> relatedTerms) {
    this.relatedTerms = relatedTerms;
  }


  public CreateGlossaryTerm reviewers(List<String> reviewers) {
    
    this.reviewers = reviewers;
    return this;
  }

  public CreateGlossaryTerm addReviewersItem(String reviewersItem) {
    if (this.reviewers == null) {
      this.reviewers = new ArrayList<>();
    }
    this.reviewers.add(reviewersItem);
    return this;
  }

   /**
   * Get reviewers
   * @return reviewers
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_REVIEWERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getReviewers() {
    return reviewers;
  }


  @JsonProperty(JSON_PROPERTY_REVIEWERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReviewers(List<String> reviewers) {
    this.reviewers = reviewers;
  }


  public CreateGlossaryTerm style(Style style) {
    
    this.style = style;
    return this;
  }

   /**
   * Get style
   * @return style
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_STYLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Style getStyle() {
    return style;
  }


  @JsonProperty(JSON_PROPERTY_STYLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStyle(Style style) {
    this.style = style;
  }


  public CreateGlossaryTerm synonyms(List<String> synonyms) {
    
    this.synonyms = synonyms;
    return this;
  }

  public CreateGlossaryTerm addSynonymsItem(String synonymsItem) {
    if (this.synonyms == null) {
      this.synonyms = new ArrayList<>();
    }
    this.synonyms.add(synonymsItem);
    return this;
  }

   /**
   * Get synonyms
   * @return synonyms
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SYNONYMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getSynonyms() {
    return synonyms;
  }


  @JsonProperty(JSON_PROPERTY_SYNONYMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSynonyms(List<String> synonyms) {
    this.synonyms = synonyms;
  }


  public CreateGlossaryTerm tags(List<TagLabel> tags) {
    
    this.tags = tags;
    return this;
  }

  public CreateGlossaryTerm addTagsItem(TagLabel tagsItem) {
    if (this.tags == null) {
      this.tags = new ArrayList<>();
    }
    this.tags.add(tagsItem);
    return this;
  }

   /**
   * Get tags
   * @return tags
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<TagLabel> getTags() {
    return tags;
  }


  @JsonProperty(JSON_PROPERTY_TAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTags(List<TagLabel> tags) {
    this.tags = tags;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreateGlossaryTerm createGlossaryTerm = (CreateGlossaryTerm) o;
    return Objects.equals(this.dataProducts, createGlossaryTerm.dataProducts) &&
        Objects.equals(this.description, createGlossaryTerm.description) &&
        Objects.equals(this.displayName, createGlossaryTerm.displayName) &&
        Objects.equals(this.domain, createGlossaryTerm.domain) &&
        Objects.equals(this.extension, createGlossaryTerm.extension) &&
        Objects.equals(this.glossary, createGlossaryTerm.glossary) &&
        Objects.equals(this.lifeCycle, createGlossaryTerm.lifeCycle) &&
        Objects.equals(this.mutuallyExclusive, createGlossaryTerm.mutuallyExclusive) &&
        Objects.equals(this.name, createGlossaryTerm.name) &&
        Objects.equals(this.owner, createGlossaryTerm.owner) &&
        Objects.equals(this.parent, createGlossaryTerm.parent) &&
        Objects.equals(this.provider, createGlossaryTerm.provider) &&
        Objects.equals(this.references, createGlossaryTerm.references) &&
        Objects.equals(this.relatedTerms, createGlossaryTerm.relatedTerms) &&
        Objects.equals(this.reviewers, createGlossaryTerm.reviewers) &&
        Objects.equals(this.style, createGlossaryTerm.style) &&
        Objects.equals(this.synonyms, createGlossaryTerm.synonyms) &&
        Objects.equals(this.tags, createGlossaryTerm.tags);
  }

  @Override
  public int hashCode() {
    return Objects.hash(dataProducts, description, displayName, domain, extension, glossary, lifeCycle, mutuallyExclusive, name, owner, parent, provider, references, relatedTerms, reviewers, style, synonyms, tags);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateGlossaryTerm {\n");
    sb.append("    dataProducts: ").append(toIndentedString(dataProducts)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    displayName: ").append(toIndentedString(displayName)).append("\n");
    sb.append("    domain: ").append(toIndentedString(domain)).append("\n");
    sb.append("    extension: ").append(toIndentedString(extension)).append("\n");
    sb.append("    glossary: ").append(toIndentedString(glossary)).append("\n");
    sb.append("    lifeCycle: ").append(toIndentedString(lifeCycle)).append("\n");
    sb.append("    mutuallyExclusive: ").append(toIndentedString(mutuallyExclusive)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    owner: ").append(toIndentedString(owner)).append("\n");
    sb.append("    parent: ").append(toIndentedString(parent)).append("\n");
    sb.append("    provider: ").append(toIndentedString(provider)).append("\n");
    sb.append("    references: ").append(toIndentedString(references)).append("\n");
    sb.append("    relatedTerms: ").append(toIndentedString(relatedTerms)).append("\n");
    sb.append("    reviewers: ").append(toIndentedString(reviewers)).append("\n");
    sb.append("    style: ").append(toIndentedString(style)).append("\n");
    sb.append("    synonyms: ").append(toIndentedString(synonyms)).append("\n");
    sb.append("    tags: ").append(toIndentedString(tags)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

