/*
 * OpenMetadata Apis
 * --- title: APIs slug: /main-concepts/metadata-standard/apis ---  # APIs  OpenMetadata supports REST APIs for getting data and in and out of the metadata service. APIs are built using general best practices of REST API design. We take a schema-first approach by defining Types and Entities in JSON Schema. We implement APIs based on these schemas.  ## Overview  ### URI  Following REST API conventions are followed for Resource URIs: - Operations for an entity are available through the Resource URI as a collection `.../api/<version>/entities`.  - Plural of the entity name is used as the collection name - example `.../api/v1/users`. - Trailing forward slash is not used in the endpoint URI. Example use `.../api/v1/databases` instead of `.../api/v1/databases/`. - Resource URI for an entity instance by the entity id is `.../api/v1/entities/{id}`.  - Resource URI for an entity instance by name is `.../api/v1/entities/name/{name}`.  ### Resource Representation  - The REST API calls return a response with JSON `Content-Type` and `Content-Length` that includes the length of the response. - All responses include the Resource ID field even though the id was provided in the request to simplify the consumption    of the response at the client. - Entity names and field names use `camelCase` per Javascript naming convention. - All resources include an attribute `href` with Resource URI. All relationship fields of an entity will also    include `href` links to the related resource for easy access. - Unknown fields sent by the client in API requests are not ignored to ensure the data sent by the client is not dropped    at the server without the user being aware of it.  ## API Organization  You can find the swagger documentation [here](/swagger.html). In a nutshell:  **Data Asset APIs** - support operations related to data asset entities. - `.../api/v1/databases` - `...api/v1/tables` - `.../api/v1/metrics` - `.../api/v1/dashboards` - `.../api/v1/reports` - `.../api/v1/pipelines` - `.../api/v1/topics`  **Service APIs** - support operations related to services from which metadata is collected: - `.../api/v1/services` is the collection of all service resources. - `.../api/v1/services/databaseService` - APIs related to database services. This includes Transactional databases - MySQL, Postgres, MSSQL, Oracle, and Data Warehouses - Apache Hive BigQuery, Redshift, and Snowflake. - `.../api/v1/services/dashboardService` - APIs related to Dashboard Services. This includes Looker, Superset, and Tableau. - `.../api/v1/services/messagingService` - APIs related to Messaging Services. This includes Apache Kafka, Redpanda, - Kinesis, and others.  **Teams & Users APIs** - `.../api/v1/teams` - APIs related to team entities - `.../api/v1/users` - APIs related to user entities  **Search & Suggest APIs** - support search and suggest APIs: - `.../api/v1/search` - collection for search and suggest APIs - `.../api/v1/search/query` - search entities using query text - `.../api/v1/search/suggest` - get suggested entities used for auto-completion  **Other APIs** - `.../api/v1/tags` for APIs related to Classification and Tag entities - `../api/v1/feeds` for APIs related to Threads and Posts entities - `.../api/v1/usage` for reporting usage information of entities
 *
 * The version of the OpenAPI document: 1.2.2
 * Contact: openmetadata-dev@googlegroups.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.openmetadata.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.openmetadata.client.model.EntityReference;
import org.openmetadata.client.model.LifeCycle;
import org.openmetadata.client.model.TagLabel;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * CreateQuery
 */
@JsonPropertyOrder({
  CreateQuery.JSON_PROPERTY_DATA_PRODUCTS,
  CreateQuery.JSON_PROPERTY_DESCRIPTION,
  CreateQuery.JSON_PROPERTY_DISPLAY_NAME,
  CreateQuery.JSON_PROPERTY_DOMAIN,
  CreateQuery.JSON_PROPERTY_DURATION,
  CreateQuery.JSON_PROPERTY_EXCLUDE_USAGE,
  CreateQuery.JSON_PROPERTY_EXTENSION,
  CreateQuery.JSON_PROPERTY_LIFE_CYCLE,
  CreateQuery.JSON_PROPERTY_NAME,
  CreateQuery.JSON_PROPERTY_OWNER,
  CreateQuery.JSON_PROPERTY_PROCESSED_LINEAGE,
  CreateQuery.JSON_PROPERTY_QUERY,
  CreateQuery.JSON_PROPERTY_QUERY_DATE,
  CreateQuery.JSON_PROPERTY_QUERY_USED_IN,
  CreateQuery.JSON_PROPERTY_QUERY_TYPE,
  CreateQuery.JSON_PROPERTY_SERVICE,
  CreateQuery.JSON_PROPERTY_TAGS,
  CreateQuery.JSON_PROPERTY_TRIGGERED_BY,
  CreateQuery.JSON_PROPERTY_USED_BY,
  CreateQuery.JSON_PROPERTY_USERS
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-20T11:35:38.398944261Z[Etc/UTC]")
public class CreateQuery {
  public static final String JSON_PROPERTY_DATA_PRODUCTS = "dataProducts";
  private List<String> dataProducts = null;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description;

  public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
  private String displayName;

  public static final String JSON_PROPERTY_DOMAIN = "domain";
  private String domain;

  public static final String JSON_PROPERTY_DURATION = "duration";
  private Double duration;

  public static final String JSON_PROPERTY_EXCLUDE_USAGE = "exclude_usage";
  private Boolean excludeUsage;

  public static final String JSON_PROPERTY_EXTENSION = "extension";
  private Object extension;

  public static final String JSON_PROPERTY_LIFE_CYCLE = "lifeCycle";
  private LifeCycle lifeCycle;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_OWNER = "owner";
  private EntityReference owner;

  public static final String JSON_PROPERTY_PROCESSED_LINEAGE = "processedLineage";
  private Boolean processedLineage;

  public static final String JSON_PROPERTY_QUERY = "query";
  private String query;

  public static final String JSON_PROPERTY_QUERY_DATE = "queryDate";
  private Long queryDate;

  public static final String JSON_PROPERTY_QUERY_USED_IN = "queryUsedIn";
  private List<EntityReference> queryUsedIn = null;

  public static final String JSON_PROPERTY_QUERY_TYPE = "query_type";
  private String queryType;

  public static final String JSON_PROPERTY_SERVICE = "service";
  private String service;

  public static final String JSON_PROPERTY_TAGS = "tags";
  private List<TagLabel> tags = null;

  public static final String JSON_PROPERTY_TRIGGERED_BY = "triggeredBy";
  private EntityReference triggeredBy;

  public static final String JSON_PROPERTY_USED_BY = "usedBy";
  private Set<String> usedBy = null;

  public static final String JSON_PROPERTY_USERS = "users";
  private List<String> users = null;

  public CreateQuery() { 
  }

  public CreateQuery dataProducts(List<String> dataProducts) {
    
    this.dataProducts = dataProducts;
    return this;
  }

  public CreateQuery addDataProductsItem(String dataProductsItem) {
    if (this.dataProducts == null) {
      this.dataProducts = new ArrayList<>();
    }
    this.dataProducts.add(dataProductsItem);
    return this;
  }

   /**
   * Get dataProducts
   * @return dataProducts
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DATA_PRODUCTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getDataProducts() {
    return dataProducts;
  }


  @JsonProperty(JSON_PROPERTY_DATA_PRODUCTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDataProducts(List<String> dataProducts) {
    this.dataProducts = dataProducts;
  }


  public CreateQuery description(String description) {
    
    this.description = description;
    return this;
  }

   /**
   * Get description
   * @return description
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDescription() {
    return description;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(String description) {
    this.description = description;
  }


  public CreateQuery displayName(String displayName) {
    
    this.displayName = displayName;
    return this;
  }

   /**
   * Get displayName
   * @return displayName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DISPLAY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDisplayName() {
    return displayName;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisplayName(String displayName) {
    this.displayName = displayName;
  }


  public CreateQuery domain(String domain) {
    
    this.domain = domain;
    return this;
  }

   /**
   * Get domain
   * @return domain
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DOMAIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDomain() {
    return domain;
  }


  @JsonProperty(JSON_PROPERTY_DOMAIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDomain(String domain) {
    this.domain = domain;
  }


  public CreateQuery duration(Double duration) {
    
    this.duration = duration;
    return this;
  }

   /**
   * Get duration
   * @return duration
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DURATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getDuration() {
    return duration;
  }


  @JsonProperty(JSON_PROPERTY_DURATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDuration(Double duration) {
    this.duration = duration;
  }


  public CreateQuery excludeUsage(Boolean excludeUsage) {
    
    this.excludeUsage = excludeUsage;
    return this;
  }

   /**
   * Get excludeUsage
   * @return excludeUsage
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_EXCLUDE_USAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getExcludeUsage() {
    return excludeUsage;
  }


  @JsonProperty(JSON_PROPERTY_EXCLUDE_USAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExcludeUsage(Boolean excludeUsage) {
    this.excludeUsage = excludeUsage;
  }


  public CreateQuery extension(Object extension) {
    
    this.extension = extension;
    return this;
  }

   /**
   * Get extension
   * @return extension
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_EXTENSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getExtension() {
    return extension;
  }


  @JsonProperty(JSON_PROPERTY_EXTENSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExtension(Object extension) {
    this.extension = extension;
  }


  public CreateQuery lifeCycle(LifeCycle lifeCycle) {
    
    this.lifeCycle = lifeCycle;
    return this;
  }

   /**
   * Get lifeCycle
   * @return lifeCycle
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_LIFE_CYCLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LifeCycle getLifeCycle() {
    return lifeCycle;
  }


  @JsonProperty(JSON_PROPERTY_LIFE_CYCLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLifeCycle(LifeCycle lifeCycle) {
    this.lifeCycle = lifeCycle;
  }


  public CreateQuery name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Get name
   * @return name
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(String name) {
    this.name = name;
  }


  public CreateQuery owner(EntityReference owner) {
    
    this.owner = owner;
    return this;
  }

   /**
   * Get owner
   * @return owner
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_OWNER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public EntityReference getOwner() {
    return owner;
  }


  @JsonProperty(JSON_PROPERTY_OWNER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOwner(EntityReference owner) {
    this.owner = owner;
  }


  public CreateQuery processedLineage(Boolean processedLineage) {
    
    this.processedLineage = processedLineage;
    return this;
  }

   /**
   * Get processedLineage
   * @return processedLineage
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PROCESSED_LINEAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getProcessedLineage() {
    return processedLineage;
  }


  @JsonProperty(JSON_PROPERTY_PROCESSED_LINEAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessedLineage(Boolean processedLineage) {
    this.processedLineage = processedLineage;
  }


  public CreateQuery query(String query) {
    
    this.query = query;
    return this;
  }

   /**
   * Get query
   * @return query
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_QUERY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getQuery() {
    return query;
  }


  @JsonProperty(JSON_PROPERTY_QUERY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setQuery(String query) {
    this.query = query;
  }


  public CreateQuery queryDate(Long queryDate) {
    
    this.queryDate = queryDate;
    return this;
  }

   /**
   * Get queryDate
   * @return queryDate
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_QUERY_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getQueryDate() {
    return queryDate;
  }


  @JsonProperty(JSON_PROPERTY_QUERY_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setQueryDate(Long queryDate) {
    this.queryDate = queryDate;
  }


  public CreateQuery queryUsedIn(List<EntityReference> queryUsedIn) {
    
    this.queryUsedIn = queryUsedIn;
    return this;
  }

  public CreateQuery addQueryUsedInItem(EntityReference queryUsedInItem) {
    if (this.queryUsedIn == null) {
      this.queryUsedIn = new ArrayList<>();
    }
    this.queryUsedIn.add(queryUsedInItem);
    return this;
  }

   /**
   * Get queryUsedIn
   * @return queryUsedIn
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_QUERY_USED_IN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<EntityReference> getQueryUsedIn() {
    return queryUsedIn;
  }


  @JsonProperty(JSON_PROPERTY_QUERY_USED_IN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setQueryUsedIn(List<EntityReference> queryUsedIn) {
    this.queryUsedIn = queryUsedIn;
  }


  public CreateQuery queryType(String queryType) {
    
    this.queryType = queryType;
    return this;
  }

   /**
   * Get queryType
   * @return queryType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_QUERY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getQueryType() {
    return queryType;
  }


  @JsonProperty(JSON_PROPERTY_QUERY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setQueryType(String queryType) {
    this.queryType = queryType;
  }


  public CreateQuery service(String service) {
    
    this.service = service;
    return this;
  }

   /**
   * Get service
   * @return service
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_SERVICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getService() {
    return service;
  }


  @JsonProperty(JSON_PROPERTY_SERVICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setService(String service) {
    this.service = service;
  }


  public CreateQuery tags(List<TagLabel> tags) {
    
    this.tags = tags;
    return this;
  }

  public CreateQuery addTagsItem(TagLabel tagsItem) {
    if (this.tags == null) {
      this.tags = new ArrayList<>();
    }
    this.tags.add(tagsItem);
    return this;
  }

   /**
   * Get tags
   * @return tags
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<TagLabel> getTags() {
    return tags;
  }


  @JsonProperty(JSON_PROPERTY_TAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTags(List<TagLabel> tags) {
    this.tags = tags;
  }


  public CreateQuery triggeredBy(EntityReference triggeredBy) {
    
    this.triggeredBy = triggeredBy;
    return this;
  }

   /**
   * Get triggeredBy
   * @return triggeredBy
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TRIGGERED_BY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public EntityReference getTriggeredBy() {
    return triggeredBy;
  }


  @JsonProperty(JSON_PROPERTY_TRIGGERED_BY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTriggeredBy(EntityReference triggeredBy) {
    this.triggeredBy = triggeredBy;
  }


  public CreateQuery usedBy(Set<String> usedBy) {
    
    this.usedBy = usedBy;
    return this;
  }

  public CreateQuery addUsedByItem(String usedByItem) {
    if (this.usedBy == null) {
      this.usedBy = new LinkedHashSet<>();
    }
    this.usedBy.add(usedByItem);
    return this;
  }

   /**
   * Get usedBy
   * @return usedBy
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_USED_BY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Set<String> getUsedBy() {
    return usedBy;
  }


  @JsonDeserialize(as = LinkedHashSet.class)
  @JsonProperty(JSON_PROPERTY_USED_BY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUsedBy(Set<String> usedBy) {
    this.usedBy = usedBy;
  }


  public CreateQuery users(List<String> users) {
    
    this.users = users;
    return this;
  }

  public CreateQuery addUsersItem(String usersItem) {
    if (this.users == null) {
      this.users = new ArrayList<>();
    }
    this.users.add(usersItem);
    return this;
  }

   /**
   * Get users
   * @return users
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_USERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getUsers() {
    return users;
  }


  @JsonProperty(JSON_PROPERTY_USERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUsers(List<String> users) {
    this.users = users;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreateQuery createQuery = (CreateQuery) o;
    return Objects.equals(this.dataProducts, createQuery.dataProducts) &&
        Objects.equals(this.description, createQuery.description) &&
        Objects.equals(this.displayName, createQuery.displayName) &&
        Objects.equals(this.domain, createQuery.domain) &&
        Objects.equals(this.duration, createQuery.duration) &&
        Objects.equals(this.excludeUsage, createQuery.excludeUsage) &&
        Objects.equals(this.extension, createQuery.extension) &&
        Objects.equals(this.lifeCycle, createQuery.lifeCycle) &&
        Objects.equals(this.name, createQuery.name) &&
        Objects.equals(this.owner, createQuery.owner) &&
        Objects.equals(this.processedLineage, createQuery.processedLineage) &&
        Objects.equals(this.query, createQuery.query) &&
        Objects.equals(this.queryDate, createQuery.queryDate) &&
        Objects.equals(this.queryUsedIn, createQuery.queryUsedIn) &&
        Objects.equals(this.queryType, createQuery.queryType) &&
        Objects.equals(this.service, createQuery.service) &&
        Objects.equals(this.tags, createQuery.tags) &&
        Objects.equals(this.triggeredBy, createQuery.triggeredBy) &&
        Objects.equals(this.usedBy, createQuery.usedBy) &&
        Objects.equals(this.users, createQuery.users);
  }

  @Override
  public int hashCode() {
    return Objects.hash(dataProducts, description, displayName, domain, duration, excludeUsage, extension, lifeCycle, name, owner, processedLineage, query, queryDate, queryUsedIn, queryType, service, tags, triggeredBy, usedBy, users);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateQuery {\n");
    sb.append("    dataProducts: ").append(toIndentedString(dataProducts)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    displayName: ").append(toIndentedString(displayName)).append("\n");
    sb.append("    domain: ").append(toIndentedString(domain)).append("\n");
    sb.append("    duration: ").append(toIndentedString(duration)).append("\n");
    sb.append("    excludeUsage: ").append(toIndentedString(excludeUsage)).append("\n");
    sb.append("    extension: ").append(toIndentedString(extension)).append("\n");
    sb.append("    lifeCycle: ").append(toIndentedString(lifeCycle)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    owner: ").append(toIndentedString(owner)).append("\n");
    sb.append("    processedLineage: ").append(toIndentedString(processedLineage)).append("\n");
    sb.append("    query: ").append(toIndentedString(query)).append("\n");
    sb.append("    queryDate: ").append(toIndentedString(queryDate)).append("\n");
    sb.append("    queryUsedIn: ").append(toIndentedString(queryUsedIn)).append("\n");
    sb.append("    queryType: ").append(toIndentedString(queryType)).append("\n");
    sb.append("    service: ").append(toIndentedString(service)).append("\n");
    sb.append("    tags: ").append(toIndentedString(tags)).append("\n");
    sb.append("    triggeredBy: ").append(toIndentedString(triggeredBy)).append("\n");
    sb.append("    usedBy: ").append(toIndentedString(usedBy)).append("\n");
    sb.append("    users: ").append(toIndentedString(users)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

