/*
 * OpenMetadata Apis
 * --- title: APIs slug: /main-concepts/metadata-standard/apis ---  # APIs  OpenMetadata supports REST APIs for getting data and in and out of the metadata service. APIs are built using general best practices of REST API design. We take a schema-first approach by defining Types and Entities in JSON Schema. We implement APIs based on these schemas.  ## Overview  ### URI  Following REST API conventions are followed for Resource URIs: - Operations for an entity are available through the Resource URI as a collection `.../api/<version>/entities`.  - Plural of the entity name is used as the collection name - example `.../api/v1/users`. - Trailing forward slash is not used in the endpoint URI. Example use `.../api/v1/databases` instead of `.../api/v1/databases/`. - Resource URI for an entity instance by the entity id is `.../api/v1/entities/{id}`.  - Resource URI for an entity instance by name is `.../api/v1/entities/name/{name}`.  ### Resource Representation  - The REST API calls return a response with JSON `Content-Type` and `Content-Length` that includes the length of the response. - All responses include the Resource ID field even though the id was provided in the request to simplify the consumption    of the response at the client. - Entity names and field names use `camelCase` per Javascript naming convention. - All resources include an attribute `href` with Resource URI. All relationship fields of an entity will also    include `href` links to the related resource for easy access. - Unknown fields sent by the client in API requests are not ignored to ensure the data sent by the client is not dropped    at the server without the user being aware of it.  ## API Organization  You can find the swagger documentation [here](/swagger.html). In a nutshell:  **Data Asset APIs** - support operations related to data asset entities. - `.../api/v1/databases` - `...api/v1/tables` - `.../api/v1/metrics` - `.../api/v1/dashboards` - `.../api/v1/reports` - `.../api/v1/pipelines` - `.../api/v1/topics`  **Service APIs** - support operations related to services from which metadata is collected: - `.../api/v1/services` is the collection of all service resources. - `.../api/v1/services/databaseService` - APIs related to database services. This includes Transactional databases - MySQL, Postgres, MSSQL, Oracle, and Data Warehouses - Apache Hive BigQuery, Redshift, and Snowflake. - `.../api/v1/services/dashboardService` - APIs related to Dashboard Services. This includes Looker, Superset, and Tableau. - `.../api/v1/services/messagingService` - APIs related to Messaging Services. This includes Apache Kafka, Redpanda, - Kinesis, and others.  **Teams & Users APIs** - `.../api/v1/teams` - APIs related to team entities - `.../api/v1/users` - APIs related to user entities  **Search & Suggest APIs** - support search and suggest APIs: - `.../api/v1/search` - collection for search and suggest APIs - `.../api/v1/search/query` - search entities using query text - `.../api/v1/search/suggest` - get suggested entities used for auto-completion  **Other APIs** - `.../api/v1/tags` for APIs related to Classification and Tag entities - `../api/v1/feeds` for APIs related to Threads and Posts entities - `.../api/v1/usage` for reporting usage information of entities
 *
 * The version of the OpenAPI document: 1.2.2
 * Contact: openmetadata-dev@googlegroups.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.openmetadata.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.openmetadata.client.model.Column;
import org.openmetadata.client.model.EntityReference;
import org.openmetadata.client.model.LifeCycle;
import org.openmetadata.client.model.TableConstraint;
import org.openmetadata.client.model.TablePartition;
import org.openmetadata.client.model.TableProfilerConfig;
import org.openmetadata.client.model.TagLabel;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * CreateTable
 */
@JsonPropertyOrder({
  CreateTable.JSON_PROPERTY_COLUMNS,
  CreateTable.JSON_PROPERTY_DATA_PRODUCTS,
  CreateTable.JSON_PROPERTY_DATABASE_SCHEMA,
  CreateTable.JSON_PROPERTY_DESCRIPTION,
  CreateTable.JSON_PROPERTY_DISPLAY_NAME,
  CreateTable.JSON_PROPERTY_DOMAIN,
  CreateTable.JSON_PROPERTY_EXTENSION,
  CreateTable.JSON_PROPERTY_FILE_FORMAT,
  CreateTable.JSON_PROPERTY_LIFE_CYCLE,
  CreateTable.JSON_PROPERTY_NAME,
  CreateTable.JSON_PROPERTY_OWNER,
  CreateTable.JSON_PROPERTY_RETENTION_PERIOD,
  CreateTable.JSON_PROPERTY_SOURCE_URL,
  CreateTable.JSON_PROPERTY_TABLE_CONSTRAINTS,
  CreateTable.JSON_PROPERTY_TABLE_PARTITION,
  CreateTable.JSON_PROPERTY_TABLE_PROFILER_CONFIG,
  CreateTable.JSON_PROPERTY_TABLE_TYPE,
  CreateTable.JSON_PROPERTY_TAGS,
  CreateTable.JSON_PROPERTY_VIEW_DEFINITION
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-20T11:35:38.398944261Z[Etc/UTC]")
public class CreateTable {
  public static final String JSON_PROPERTY_COLUMNS = "columns";
  private List<Column> columns = new ArrayList<>();

  public static final String JSON_PROPERTY_DATA_PRODUCTS = "dataProducts";
  private List<String> dataProducts = null;

  public static final String JSON_PROPERTY_DATABASE_SCHEMA = "databaseSchema";
  private String databaseSchema;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description;

  public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
  private String displayName;

  public static final String JSON_PROPERTY_DOMAIN = "domain";
  private String domain;

  public static final String JSON_PROPERTY_EXTENSION = "extension";
  private Object extension;

  /**
   * Gets or Sets fileFormat
   */
  public enum FileFormatEnum {
    CSV("csv"),
    
    TSV("tsv"),
    
    AVRO("avro"),
    
    PARQUET("parquet"),
    
    JSON("json"),
    
    JSON_GZ("json.gz"),
    
    JSON_ZIP("json.zip");

    private String value;

    FileFormatEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static FileFormatEnum fromValue(String value) {
      for (FileFormatEnum b : FileFormatEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_FILE_FORMAT = "fileFormat";
  private FileFormatEnum fileFormat;

  public static final String JSON_PROPERTY_LIFE_CYCLE = "lifeCycle";
  private LifeCycle lifeCycle;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_OWNER = "owner";
  private EntityReference owner;

  public static final String JSON_PROPERTY_RETENTION_PERIOD = "retentionPeriod";
  private String retentionPeriod;

  public static final String JSON_PROPERTY_SOURCE_URL = "sourceUrl";
  private String sourceUrl;

  public static final String JSON_PROPERTY_TABLE_CONSTRAINTS = "tableConstraints";
  private List<TableConstraint> tableConstraints = null;

  public static final String JSON_PROPERTY_TABLE_PARTITION = "tablePartition";
  private TablePartition tablePartition;

  public static final String JSON_PROPERTY_TABLE_PROFILER_CONFIG = "tableProfilerConfig";
  private TableProfilerConfig tableProfilerConfig;

  /**
   * Gets or Sets tableType
   */
  public enum TableTypeEnum {
    REGULAR("Regular"),
    
    EXTERNAL("External"),
    
    VIEW("View"),
    
    SECUREVIEW("SecureView"),
    
    MATERIALIZEDVIEW("MaterializedView"),
    
    ICEBERG("Iceberg"),
    
    LOCAL("Local"),
    
    PARTITIONED("Partitioned"),
    
    FOREIGN("Foreign"),
    
    TRANSIENT("Transient");

    private String value;

    TableTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TableTypeEnum fromValue(String value) {
      for (TableTypeEnum b : TableTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TABLE_TYPE = "tableType";
  private TableTypeEnum tableType;

  public static final String JSON_PROPERTY_TAGS = "tags";
  private List<TagLabel> tags = null;

  public static final String JSON_PROPERTY_VIEW_DEFINITION = "viewDefinition";
  private String viewDefinition;

  public CreateTable() { 
  }

  public CreateTable columns(List<Column> columns) {
    
    this.columns = columns;
    return this;
  }

  public CreateTable addColumnsItem(Column columnsItem) {
    this.columns.add(columnsItem);
    return this;
  }

   /**
   * Get columns
   * @return columns
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_COLUMNS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<Column> getColumns() {
    return columns;
  }


  @JsonProperty(JSON_PROPERTY_COLUMNS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setColumns(List<Column> columns) {
    this.columns = columns;
  }


  public CreateTable dataProducts(List<String> dataProducts) {
    
    this.dataProducts = dataProducts;
    return this;
  }

  public CreateTable addDataProductsItem(String dataProductsItem) {
    if (this.dataProducts == null) {
      this.dataProducts = new ArrayList<>();
    }
    this.dataProducts.add(dataProductsItem);
    return this;
  }

   /**
   * Get dataProducts
   * @return dataProducts
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DATA_PRODUCTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getDataProducts() {
    return dataProducts;
  }


  @JsonProperty(JSON_PROPERTY_DATA_PRODUCTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDataProducts(List<String> dataProducts) {
    this.dataProducts = dataProducts;
  }


  public CreateTable databaseSchema(String databaseSchema) {
    
    this.databaseSchema = databaseSchema;
    return this;
  }

   /**
   * Get databaseSchema
   * @return databaseSchema
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_DATABASE_SCHEMA)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getDatabaseSchema() {
    return databaseSchema;
  }


  @JsonProperty(JSON_PROPERTY_DATABASE_SCHEMA)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDatabaseSchema(String databaseSchema) {
    this.databaseSchema = databaseSchema;
  }


  public CreateTable description(String description) {
    
    this.description = description;
    return this;
  }

   /**
   * Get description
   * @return description
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDescription() {
    return description;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(String description) {
    this.description = description;
  }


  public CreateTable displayName(String displayName) {
    
    this.displayName = displayName;
    return this;
  }

   /**
   * Get displayName
   * @return displayName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DISPLAY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDisplayName() {
    return displayName;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisplayName(String displayName) {
    this.displayName = displayName;
  }


  public CreateTable domain(String domain) {
    
    this.domain = domain;
    return this;
  }

   /**
   * Get domain
   * @return domain
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DOMAIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDomain() {
    return domain;
  }


  @JsonProperty(JSON_PROPERTY_DOMAIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDomain(String domain) {
    this.domain = domain;
  }


  public CreateTable extension(Object extension) {
    
    this.extension = extension;
    return this;
  }

   /**
   * Get extension
   * @return extension
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_EXTENSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getExtension() {
    return extension;
  }


  @JsonProperty(JSON_PROPERTY_EXTENSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExtension(Object extension) {
    this.extension = extension;
  }


  public CreateTable fileFormat(FileFormatEnum fileFormat) {
    
    this.fileFormat = fileFormat;
    return this;
  }

   /**
   * Get fileFormat
   * @return fileFormat
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_FILE_FORMAT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public FileFormatEnum getFileFormat() {
    return fileFormat;
  }


  @JsonProperty(JSON_PROPERTY_FILE_FORMAT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFileFormat(FileFormatEnum fileFormat) {
    this.fileFormat = fileFormat;
  }


  public CreateTable lifeCycle(LifeCycle lifeCycle) {
    
    this.lifeCycle = lifeCycle;
    return this;
  }

   /**
   * Get lifeCycle
   * @return lifeCycle
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_LIFE_CYCLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LifeCycle getLifeCycle() {
    return lifeCycle;
  }


  @JsonProperty(JSON_PROPERTY_LIFE_CYCLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLifeCycle(LifeCycle lifeCycle) {
    this.lifeCycle = lifeCycle;
  }


  public CreateTable name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Get name
   * @return name
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public CreateTable owner(EntityReference owner) {
    
    this.owner = owner;
    return this;
  }

   /**
   * Get owner
   * @return owner
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_OWNER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public EntityReference getOwner() {
    return owner;
  }


  @JsonProperty(JSON_PROPERTY_OWNER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOwner(EntityReference owner) {
    this.owner = owner;
  }


  public CreateTable retentionPeriod(String retentionPeriod) {
    
    this.retentionPeriod = retentionPeriod;
    return this;
  }

   /**
   * Get retentionPeriod
   * @return retentionPeriod
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_RETENTION_PERIOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRetentionPeriod() {
    return retentionPeriod;
  }


  @JsonProperty(JSON_PROPERTY_RETENTION_PERIOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRetentionPeriod(String retentionPeriod) {
    this.retentionPeriod = retentionPeriod;
  }


  public CreateTable sourceUrl(String sourceUrl) {
    
    this.sourceUrl = sourceUrl;
    return this;
  }

   /**
   * Get sourceUrl
   * @return sourceUrl
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SOURCE_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSourceUrl() {
    return sourceUrl;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceUrl(String sourceUrl) {
    this.sourceUrl = sourceUrl;
  }


  public CreateTable tableConstraints(List<TableConstraint> tableConstraints) {
    
    this.tableConstraints = tableConstraints;
    return this;
  }

  public CreateTable addTableConstraintsItem(TableConstraint tableConstraintsItem) {
    if (this.tableConstraints == null) {
      this.tableConstraints = new ArrayList<>();
    }
    this.tableConstraints.add(tableConstraintsItem);
    return this;
  }

   /**
   * Get tableConstraints
   * @return tableConstraints
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TABLE_CONSTRAINTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<TableConstraint> getTableConstraints() {
    return tableConstraints;
  }


  @JsonProperty(JSON_PROPERTY_TABLE_CONSTRAINTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTableConstraints(List<TableConstraint> tableConstraints) {
    this.tableConstraints = tableConstraints;
  }


  public CreateTable tablePartition(TablePartition tablePartition) {
    
    this.tablePartition = tablePartition;
    return this;
  }

   /**
   * Get tablePartition
   * @return tablePartition
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TABLE_PARTITION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TablePartition getTablePartition() {
    return tablePartition;
  }


  @JsonProperty(JSON_PROPERTY_TABLE_PARTITION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTablePartition(TablePartition tablePartition) {
    this.tablePartition = tablePartition;
  }


  public CreateTable tableProfilerConfig(TableProfilerConfig tableProfilerConfig) {
    
    this.tableProfilerConfig = tableProfilerConfig;
    return this;
  }

   /**
   * Get tableProfilerConfig
   * @return tableProfilerConfig
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TABLE_PROFILER_CONFIG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TableProfilerConfig getTableProfilerConfig() {
    return tableProfilerConfig;
  }


  @JsonProperty(JSON_PROPERTY_TABLE_PROFILER_CONFIG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTableProfilerConfig(TableProfilerConfig tableProfilerConfig) {
    this.tableProfilerConfig = tableProfilerConfig;
  }


  public CreateTable tableType(TableTypeEnum tableType) {
    
    this.tableType = tableType;
    return this;
  }

   /**
   * Get tableType
   * @return tableType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TABLE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TableTypeEnum getTableType() {
    return tableType;
  }


  @JsonProperty(JSON_PROPERTY_TABLE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTableType(TableTypeEnum tableType) {
    this.tableType = tableType;
  }


  public CreateTable tags(List<TagLabel> tags) {
    
    this.tags = tags;
    return this;
  }

  public CreateTable addTagsItem(TagLabel tagsItem) {
    if (this.tags == null) {
      this.tags = new ArrayList<>();
    }
    this.tags.add(tagsItem);
    return this;
  }

   /**
   * Get tags
   * @return tags
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<TagLabel> getTags() {
    return tags;
  }


  @JsonProperty(JSON_PROPERTY_TAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTags(List<TagLabel> tags) {
    this.tags = tags;
  }


  public CreateTable viewDefinition(String viewDefinition) {
    
    this.viewDefinition = viewDefinition;
    return this;
  }

   /**
   * Get viewDefinition
   * @return viewDefinition
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_VIEW_DEFINITION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getViewDefinition() {
    return viewDefinition;
  }


  @JsonProperty(JSON_PROPERTY_VIEW_DEFINITION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setViewDefinition(String viewDefinition) {
    this.viewDefinition = viewDefinition;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreateTable createTable = (CreateTable) o;
    return Objects.equals(this.columns, createTable.columns) &&
        Objects.equals(this.dataProducts, createTable.dataProducts) &&
        Objects.equals(this.databaseSchema, createTable.databaseSchema) &&
        Objects.equals(this.description, createTable.description) &&
        Objects.equals(this.displayName, createTable.displayName) &&
        Objects.equals(this.domain, createTable.domain) &&
        Objects.equals(this.extension, createTable.extension) &&
        Objects.equals(this.fileFormat, createTable.fileFormat) &&
        Objects.equals(this.lifeCycle, createTable.lifeCycle) &&
        Objects.equals(this.name, createTable.name) &&
        Objects.equals(this.owner, createTable.owner) &&
        Objects.equals(this.retentionPeriod, createTable.retentionPeriod) &&
        Objects.equals(this.sourceUrl, createTable.sourceUrl) &&
        Objects.equals(this.tableConstraints, createTable.tableConstraints) &&
        Objects.equals(this.tablePartition, createTable.tablePartition) &&
        Objects.equals(this.tableProfilerConfig, createTable.tableProfilerConfig) &&
        Objects.equals(this.tableType, createTable.tableType) &&
        Objects.equals(this.tags, createTable.tags) &&
        Objects.equals(this.viewDefinition, createTable.viewDefinition);
  }

  @Override
  public int hashCode() {
    return Objects.hash(columns, dataProducts, databaseSchema, description, displayName, domain, extension, fileFormat, lifeCycle, name, owner, retentionPeriod, sourceUrl, tableConstraints, tablePartition, tableProfilerConfig, tableType, tags, viewDefinition);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateTable {\n");
    sb.append("    columns: ").append(toIndentedString(columns)).append("\n");
    sb.append("    dataProducts: ").append(toIndentedString(dataProducts)).append("\n");
    sb.append("    databaseSchema: ").append(toIndentedString(databaseSchema)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    displayName: ").append(toIndentedString(displayName)).append("\n");
    sb.append("    domain: ").append(toIndentedString(domain)).append("\n");
    sb.append("    extension: ").append(toIndentedString(extension)).append("\n");
    sb.append("    fileFormat: ").append(toIndentedString(fileFormat)).append("\n");
    sb.append("    lifeCycle: ").append(toIndentedString(lifeCycle)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    owner: ").append(toIndentedString(owner)).append("\n");
    sb.append("    retentionPeriod: ").append(toIndentedString(retentionPeriod)).append("\n");
    sb.append("    sourceUrl: ").append(toIndentedString(sourceUrl)).append("\n");
    sb.append("    tableConstraints: ").append(toIndentedString(tableConstraints)).append("\n");
    sb.append("    tablePartition: ").append(toIndentedString(tablePartition)).append("\n");
    sb.append("    tableProfilerConfig: ").append(toIndentedString(tableProfilerConfig)).append("\n");
    sb.append("    tableType: ").append(toIndentedString(tableType)).append("\n");
    sb.append("    tags: ").append(toIndentedString(tags)).append("\n");
    sb.append("    viewDefinition: ").append(toIndentedString(viewDefinition)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

