/*
 * OpenMetadata Apis
 * --- title: APIs slug: /main-concepts/metadata-standard/apis ---  # APIs  OpenMetadata supports REST APIs for getting data and in and out of the metadata service. APIs are built using general best practices of REST API design. We take a schema-first approach by defining Types and Entities in JSON Schema. We implement APIs based on these schemas.  ## Overview  ### URI  Following REST API conventions are followed for Resource URIs: - Operations for an entity are available through the Resource URI as a collection `.../api/<version>/entities`.  - Plural of the entity name is used as the collection name - example `.../api/v1/users`. - Trailing forward slash is not used in the endpoint URI. Example use `.../api/v1/databases` instead of `.../api/v1/databases/`. - Resource URI for an entity instance by the entity id is `.../api/v1/entities/{id}`.  - Resource URI for an entity instance by name is `.../api/v1/entities/name/{name}`.  ### Resource Representation  - The REST API calls return a response with JSON `Content-Type` and `Content-Length` that includes the length of the response. - All responses include the Resource ID field even though the id was provided in the request to simplify the consumption    of the response at the client. - Entity names and field names use `camelCase` per Javascript naming convention. - All resources include an attribute `href` with Resource URI. All relationship fields of an entity will also    include `href` links to the related resource for easy access. - Unknown fields sent by the client in API requests are not ignored to ensure the data sent by the client is not dropped    at the server without the user being aware of it.  ## API Organization  You can find the swagger documentation [here](/swagger.html). In a nutshell:  **Data Asset APIs** - support operations related to data asset entities. - `.../api/v1/databases` - `...api/v1/tables` - `.../api/v1/metrics` - `.../api/v1/dashboards` - `.../api/v1/reports` - `.../api/v1/pipelines` - `.../api/v1/topics`  **Service APIs** - support operations related to services from which metadata is collected: - `.../api/v1/services` is the collection of all service resources. - `.../api/v1/services/databaseService` - APIs related to database services. This includes Transactional databases - MySQL, Postgres, MSSQL, Oracle, and Data Warehouses - Apache Hive BigQuery, Redshift, and Snowflake. - `.../api/v1/services/dashboardService` - APIs related to Dashboard Services. This includes Looker, Superset, and Tableau. - `.../api/v1/services/messagingService` - APIs related to Messaging Services. This includes Apache Kafka, Redpanda, - Kinesis, and others.  **Teams & Users APIs** - `.../api/v1/teams` - APIs related to team entities - `.../api/v1/users` - APIs related to user entities  **Search & Suggest APIs** - support search and suggest APIs: - `.../api/v1/search` - collection for search and suggest APIs - `.../api/v1/search/query` - search entities using query text - `.../api/v1/search/suggest` - get suggested entities used for auto-completion  **Other APIs** - `.../api/v1/tags` for APIs related to Classification and Tag entities - `../api/v1/feeds` for APIs related to Threads and Posts entities - `.../api/v1/usage` for reporting usage information of entities
 *
 * The version of the OpenAPI document: 1.2.2
 * Contact: openmetadata-dev@googlegroups.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.openmetadata.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.openmetadata.client.model.EntityReference;
import org.openmetadata.client.model.LifeCycle;
import org.openmetadata.client.model.TagLabel;
import org.openmetadata.client.model.TestCaseParameter;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * CreateTestDefinition
 */
@JsonPropertyOrder({
  CreateTestDefinition.JSON_PROPERTY_DATA_PRODUCTS,
  CreateTestDefinition.JSON_PROPERTY_DESCRIPTION,
  CreateTestDefinition.JSON_PROPERTY_DISPLAY_NAME,
  CreateTestDefinition.JSON_PROPERTY_DOMAIN,
  CreateTestDefinition.JSON_PROPERTY_ENTITY_TYPE,
  CreateTestDefinition.JSON_PROPERTY_EXTENSION,
  CreateTestDefinition.JSON_PROPERTY_LIFE_CYCLE,
  CreateTestDefinition.JSON_PROPERTY_NAME,
  CreateTestDefinition.JSON_PROPERTY_OWNER,
  CreateTestDefinition.JSON_PROPERTY_PARAMETER_DEFINITION,
  CreateTestDefinition.JSON_PROPERTY_SUPPORTED_DATA_TYPES,
  CreateTestDefinition.JSON_PROPERTY_TAGS,
  CreateTestDefinition.JSON_PROPERTY_TEST_PLATFORMS
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-20T11:35:38.398944261Z[Etc/UTC]")
public class CreateTestDefinition {
  public static final String JSON_PROPERTY_DATA_PRODUCTS = "dataProducts";
  private List<String> dataProducts = null;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description;

  public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
  private String displayName;

  public static final String JSON_PROPERTY_DOMAIN = "domain";
  private String domain;

  /**
   * Gets or Sets entityType
   */
  public enum EntityTypeEnum {
    TABLE("TABLE"),
    
    COLUMN("COLUMN");

    private String value;

    EntityTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static EntityTypeEnum fromValue(String value) {
      for (EntityTypeEnum b : EntityTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_ENTITY_TYPE = "entityType";
  private EntityTypeEnum entityType;

  public static final String JSON_PROPERTY_EXTENSION = "extension";
  private Object extension;

  public static final String JSON_PROPERTY_LIFE_CYCLE = "lifeCycle";
  private LifeCycle lifeCycle;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_OWNER = "owner";
  private EntityReference owner;

  public static final String JSON_PROPERTY_PARAMETER_DEFINITION = "parameterDefinition";
  private List<TestCaseParameter> parameterDefinition = null;

  /**
   * Gets or Sets supportedDataTypes
   */
  public enum SupportedDataTypesEnum {
    NUMBER("NUMBER"),
    
    TINYINT("TINYINT"),
    
    SMALLINT("SMALLINT"),
    
    INT("INT"),
    
    BIGINT("BIGINT"),
    
    BYTEINT("BYTEINT"),
    
    BYTES("BYTES"),
    
    FLOAT("FLOAT"),
    
    DOUBLE("DOUBLE"),
    
    DECIMAL("DECIMAL"),
    
    NUMERIC("NUMERIC"),
    
    TIMESTAMP("TIMESTAMP"),
    
    TIMESTAMPZ("TIMESTAMPZ"),
    
    TIME("TIME"),
    
    DATE("DATE"),
    
    DATETIME("DATETIME"),
    
    INTERVAL("INTERVAL"),
    
    STRING("STRING"),
    
    MEDIUMTEXT("MEDIUMTEXT"),
    
    TEXT("TEXT"),
    
    CHAR("CHAR"),
    
    LONG("LONG"),
    
    VARCHAR("VARCHAR"),
    
    BOOLEAN("BOOLEAN"),
    
    BINARY("BINARY"),
    
    VARBINARY("VARBINARY"),
    
    ARRAY("ARRAY"),
    
    BLOB("BLOB"),
    
    LONGBLOB("LONGBLOB"),
    
    MEDIUMBLOB("MEDIUMBLOB"),
    
    MAP("MAP"),
    
    STRUCT("STRUCT"),
    
    UNION("UNION"),
    
    SET("SET"),
    
    GEOGRAPHY("GEOGRAPHY"),
    
    ENUM("ENUM"),
    
    JSON("JSON"),
    
    UUID("UUID"),
    
    VARIANT("VARIANT"),
    
    GEOMETRY("GEOMETRY"),
    
    BYTEA("BYTEA"),
    
    AGGREGATEFUNCTION("AGGREGATEFUNCTION"),
    
    ERROR("ERROR"),
    
    FIXED("FIXED"),
    
    RECORD("RECORD"),
    
    NULL("NULL"),
    
    SUPER("SUPER"),
    
    HLLSKETCH("HLLSKETCH"),
    
    PG_LSN("PG_LSN"),
    
    PG_SNAPSHOT("PG_SNAPSHOT"),
    
    TSQUERY("TSQUERY"),
    
    TXID_SNAPSHOT("TXID_SNAPSHOT"),
    
    XML("XML"),
    
    MACADDR("MACADDR"),
    
    TSVECTOR("TSVECTOR"),
    
    UNKNOWN("UNKNOWN"),
    
    CIDR("CIDR"),
    
    INET("INET"),
    
    CLOB("CLOB"),
    
    ROWID("ROWID"),
    
    LOWCARDINALITY("LOWCARDINALITY"),
    
    YEAR("YEAR"),
    
    POINT("POINT"),
    
    POLYGON("POLYGON"),
    
    TUPLE("TUPLE"),
    
    SPATIAL("SPATIAL"),
    
    TABLE("TABLE"),
    
    NTEXT("NTEXT"),
    
    IMAGE("IMAGE"),
    
    IPV4("IPV4"),
    
    IPV6("IPV6"),
    
    DATETIMERANGE("DATETIMERANGE");

    private String value;

    SupportedDataTypesEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static SupportedDataTypesEnum fromValue(String value) {
      for (SupportedDataTypesEnum b : SupportedDataTypesEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_SUPPORTED_DATA_TYPES = "supportedDataTypes";
  private List<SupportedDataTypesEnum> supportedDataTypes = null;

  public static final String JSON_PROPERTY_TAGS = "tags";
  private List<TagLabel> tags = null;

  /**
   * Gets or Sets testPlatforms
   */
  public enum TestPlatformsEnum {
    OPENMETADATA("OpenMetadata"),
    
    GREATEXPECTATIONS("GreatExpectations"),
    
    DBT("DBT"),
    
    DEEQU("Deequ"),
    
    SODA("Soda"),
    
    OTHER("Other");

    private String value;

    TestPlatformsEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TestPlatformsEnum fromValue(String value) {
      for (TestPlatformsEnum b : TestPlatformsEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TEST_PLATFORMS = "testPlatforms";
  private List<TestPlatformsEnum> testPlatforms = new ArrayList<>();

  public CreateTestDefinition() { 
  }

  public CreateTestDefinition dataProducts(List<String> dataProducts) {
    
    this.dataProducts = dataProducts;
    return this;
  }

  public CreateTestDefinition addDataProductsItem(String dataProductsItem) {
    if (this.dataProducts == null) {
      this.dataProducts = new ArrayList<>();
    }
    this.dataProducts.add(dataProductsItem);
    return this;
  }

   /**
   * Get dataProducts
   * @return dataProducts
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DATA_PRODUCTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getDataProducts() {
    return dataProducts;
  }


  @JsonProperty(JSON_PROPERTY_DATA_PRODUCTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDataProducts(List<String> dataProducts) {
    this.dataProducts = dataProducts;
  }


  public CreateTestDefinition description(String description) {
    
    this.description = description;
    return this;
  }

   /**
   * Get description
   * @return description
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getDescription() {
    return description;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDescription(String description) {
    this.description = description;
  }


  public CreateTestDefinition displayName(String displayName) {
    
    this.displayName = displayName;
    return this;
  }

   /**
   * Get displayName
   * @return displayName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DISPLAY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDisplayName() {
    return displayName;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisplayName(String displayName) {
    this.displayName = displayName;
  }


  public CreateTestDefinition domain(String domain) {
    
    this.domain = domain;
    return this;
  }

   /**
   * Get domain
   * @return domain
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DOMAIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDomain() {
    return domain;
  }


  @JsonProperty(JSON_PROPERTY_DOMAIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDomain(String domain) {
    this.domain = domain;
  }


  public CreateTestDefinition entityType(EntityTypeEnum entityType) {
    
    this.entityType = entityType;
    return this;
  }

   /**
   * Get entityType
   * @return entityType
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_ENTITY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public EntityTypeEnum getEntityType() {
    return entityType;
  }


  @JsonProperty(JSON_PROPERTY_ENTITY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEntityType(EntityTypeEnum entityType) {
    this.entityType = entityType;
  }


  public CreateTestDefinition extension(Object extension) {
    
    this.extension = extension;
    return this;
  }

   /**
   * Get extension
   * @return extension
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_EXTENSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getExtension() {
    return extension;
  }


  @JsonProperty(JSON_PROPERTY_EXTENSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExtension(Object extension) {
    this.extension = extension;
  }


  public CreateTestDefinition lifeCycle(LifeCycle lifeCycle) {
    
    this.lifeCycle = lifeCycle;
    return this;
  }

   /**
   * Get lifeCycle
   * @return lifeCycle
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_LIFE_CYCLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LifeCycle getLifeCycle() {
    return lifeCycle;
  }


  @JsonProperty(JSON_PROPERTY_LIFE_CYCLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLifeCycle(LifeCycle lifeCycle) {
    this.lifeCycle = lifeCycle;
  }


  public CreateTestDefinition name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Get name
   * @return name
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public CreateTestDefinition owner(EntityReference owner) {
    
    this.owner = owner;
    return this;
  }

   /**
   * Get owner
   * @return owner
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_OWNER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public EntityReference getOwner() {
    return owner;
  }


  @JsonProperty(JSON_PROPERTY_OWNER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOwner(EntityReference owner) {
    this.owner = owner;
  }


  public CreateTestDefinition parameterDefinition(List<TestCaseParameter> parameterDefinition) {
    
    this.parameterDefinition = parameterDefinition;
    return this;
  }

  public CreateTestDefinition addParameterDefinitionItem(TestCaseParameter parameterDefinitionItem) {
    if (this.parameterDefinition == null) {
      this.parameterDefinition = new ArrayList<>();
    }
    this.parameterDefinition.add(parameterDefinitionItem);
    return this;
  }

   /**
   * Get parameterDefinition
   * @return parameterDefinition
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PARAMETER_DEFINITION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<TestCaseParameter> getParameterDefinition() {
    return parameterDefinition;
  }


  @JsonProperty(JSON_PROPERTY_PARAMETER_DEFINITION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setParameterDefinition(List<TestCaseParameter> parameterDefinition) {
    this.parameterDefinition = parameterDefinition;
  }


  public CreateTestDefinition supportedDataTypes(List<SupportedDataTypesEnum> supportedDataTypes) {
    
    this.supportedDataTypes = supportedDataTypes;
    return this;
  }

  public CreateTestDefinition addSupportedDataTypesItem(SupportedDataTypesEnum supportedDataTypesItem) {
    if (this.supportedDataTypes == null) {
      this.supportedDataTypes = new ArrayList<>();
    }
    this.supportedDataTypes.add(supportedDataTypesItem);
    return this;
  }

   /**
   * Get supportedDataTypes
   * @return supportedDataTypes
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SUPPORTED_DATA_TYPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SupportedDataTypesEnum> getSupportedDataTypes() {
    return supportedDataTypes;
  }


  @JsonProperty(JSON_PROPERTY_SUPPORTED_DATA_TYPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSupportedDataTypes(List<SupportedDataTypesEnum> supportedDataTypes) {
    this.supportedDataTypes = supportedDataTypes;
  }


  public CreateTestDefinition tags(List<TagLabel> tags) {
    
    this.tags = tags;
    return this;
  }

  public CreateTestDefinition addTagsItem(TagLabel tagsItem) {
    if (this.tags == null) {
      this.tags = new ArrayList<>();
    }
    this.tags.add(tagsItem);
    return this;
  }

   /**
   * Get tags
   * @return tags
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<TagLabel> getTags() {
    return tags;
  }


  @JsonProperty(JSON_PROPERTY_TAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTags(List<TagLabel> tags) {
    this.tags = tags;
  }


  public CreateTestDefinition testPlatforms(List<TestPlatformsEnum> testPlatforms) {
    
    this.testPlatforms = testPlatforms;
    return this;
  }

  public CreateTestDefinition addTestPlatformsItem(TestPlatformsEnum testPlatformsItem) {
    this.testPlatforms.add(testPlatformsItem);
    return this;
  }

   /**
   * Get testPlatforms
   * @return testPlatforms
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_TEST_PLATFORMS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<TestPlatformsEnum> getTestPlatforms() {
    return testPlatforms;
  }


  @JsonProperty(JSON_PROPERTY_TEST_PLATFORMS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTestPlatforms(List<TestPlatformsEnum> testPlatforms) {
    this.testPlatforms = testPlatforms;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreateTestDefinition createTestDefinition = (CreateTestDefinition) o;
    return Objects.equals(this.dataProducts, createTestDefinition.dataProducts) &&
        Objects.equals(this.description, createTestDefinition.description) &&
        Objects.equals(this.displayName, createTestDefinition.displayName) &&
        Objects.equals(this.domain, createTestDefinition.domain) &&
        Objects.equals(this.entityType, createTestDefinition.entityType) &&
        Objects.equals(this.extension, createTestDefinition.extension) &&
        Objects.equals(this.lifeCycle, createTestDefinition.lifeCycle) &&
        Objects.equals(this.name, createTestDefinition.name) &&
        Objects.equals(this.owner, createTestDefinition.owner) &&
        Objects.equals(this.parameterDefinition, createTestDefinition.parameterDefinition) &&
        Objects.equals(this.supportedDataTypes, createTestDefinition.supportedDataTypes) &&
        Objects.equals(this.tags, createTestDefinition.tags) &&
        Objects.equals(this.testPlatforms, createTestDefinition.testPlatforms);
  }

  @Override
  public int hashCode() {
    return Objects.hash(dataProducts, description, displayName, domain, entityType, extension, lifeCycle, name, owner, parameterDefinition, supportedDataTypes, tags, testPlatforms);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateTestDefinition {\n");
    sb.append("    dataProducts: ").append(toIndentedString(dataProducts)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    displayName: ").append(toIndentedString(displayName)).append("\n");
    sb.append("    domain: ").append(toIndentedString(domain)).append("\n");
    sb.append("    entityType: ").append(toIndentedString(entityType)).append("\n");
    sb.append("    extension: ").append(toIndentedString(extension)).append("\n");
    sb.append("    lifeCycle: ").append(toIndentedString(lifeCycle)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    owner: ").append(toIndentedString(owner)).append("\n");
    sb.append("    parameterDefinition: ").append(toIndentedString(parameterDefinition)).append("\n");
    sb.append("    supportedDataTypes: ").append(toIndentedString(supportedDataTypes)).append("\n");
    sb.append("    tags: ").append(toIndentedString(tags)).append("\n");
    sb.append("    testPlatforms: ").append(toIndentedString(testPlatforms)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

