/*
 * OpenMetadata Apis
 * --- title: APIs slug: /main-concepts/metadata-standard/apis ---  # APIs  OpenMetadata supports REST APIs for getting data and in and out of the metadata service. APIs are built using general best practices of REST API design. We take a schema-first approach by defining Types and Entities in JSON Schema. We implement APIs based on these schemas.  ## Overview  ### URI  Following REST API conventions are followed for Resource URIs: - Operations for an entity are available through the Resource URI as a collection `.../api/<version>/entities`.  - Plural of the entity name is used as the collection name - example `.../api/v1/users`. - Trailing forward slash is not used in the endpoint URI. Example use `.../api/v1/databases` instead of `.../api/v1/databases/`. - Resource URI for an entity instance by the entity id is `.../api/v1/entities/{id}`.  - Resource URI for an entity instance by name is `.../api/v1/entities/name/{name}`.  ### Resource Representation  - The REST API calls return a response with JSON `Content-Type` and `Content-Length` that includes the length of the response. - All responses include the Resource ID field even though the id was provided in the request to simplify the consumption    of the response at the client. - Entity names and field names use `camelCase` per Javascript naming convention. - All resources include an attribute `href` with Resource URI. All relationship fields of an entity will also    include `href` links to the related resource for easy access. - Unknown fields sent by the client in API requests are not ignored to ensure the data sent by the client is not dropped    at the server without the user being aware of it.  ## API Organization  You can find the swagger documentation [here](/swagger.html). In a nutshell:  **Data Asset APIs** - support operations related to data asset entities. - `.../api/v1/databases` - `...api/v1/tables` - `.../api/v1/metrics` - `.../api/v1/dashboards` - `.../api/v1/reports` - `.../api/v1/pipelines` - `.../api/v1/topics`  **Service APIs** - support operations related to services from which metadata is collected: - `.../api/v1/services` is the collection of all service resources. - `.../api/v1/services/databaseService` - APIs related to database services. This includes Transactional databases - MySQL, Postgres, MSSQL, Oracle, and Data Warehouses - Apache Hive BigQuery, Redshift, and Snowflake. - `.../api/v1/services/dashboardService` - APIs related to Dashboard Services. This includes Looker, Superset, and Tableau. - `.../api/v1/services/messagingService` - APIs related to Messaging Services. This includes Apache Kafka, Redpanda, - Kinesis, and others.  **Teams & Users APIs** - `.../api/v1/teams` - APIs related to team entities - `.../api/v1/users` - APIs related to user entities  **Search & Suggest APIs** - support search and suggest APIs: - `.../api/v1/search` - collection for search and suggest APIs - `.../api/v1/search/query` - search entities using query text - `.../api/v1/search/suggest` - get suggested entities used for auto-completion  **Other APIs** - `.../api/v1/tags` for APIs related to Classification and Tag entities - `../api/v1/feeds` for APIs related to Threads and Posts entities - `.../api/v1/usage` for reporting usage information of entities
 *
 * The version of the OpenAPI document: 1.2.2
 * Contact: openmetadata-dev@googlegroups.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.openmetadata.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.openmetadata.client.model.AnnouncementDetails;
import org.openmetadata.client.model.CreateTaskDetails;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * CreateThread
 */
@JsonPropertyOrder({
  CreateThread.JSON_PROPERTY_ABOUT,
  CreateThread.JSON_PROPERTY_ADDRESSED_TO,
  CreateThread.JSON_PROPERTY_ANNOUNCEMENT_DETAILS,
  CreateThread.JSON_PROPERTY_FROM,
  CreateThread.JSON_PROPERTY_MESSAGE,
  CreateThread.JSON_PROPERTY_TASK_DETAILS,
  CreateThread.JSON_PROPERTY_TYPE
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-20T11:35:38.398944261Z[Etc/UTC]")
public class CreateThread {
  public static final String JSON_PROPERTY_ABOUT = "about";
  private String about;

  public static final String JSON_PROPERTY_ADDRESSED_TO = "addressedTo";
  private String addressedTo;

  public static final String JSON_PROPERTY_ANNOUNCEMENT_DETAILS = "announcementDetails";
  private AnnouncementDetails announcementDetails;

  public static final String JSON_PROPERTY_FROM = "from";
  private String from;

  public static final String JSON_PROPERTY_MESSAGE = "message";
  private String message;

  public static final String JSON_PROPERTY_TASK_DETAILS = "taskDetails";
  private CreateTaskDetails taskDetails;

  /**
   * Gets or Sets type
   */
  public enum TypeEnum {
    CONVERSATION("Conversation"),
    
    TASK("Task"),
    
    ANNOUNCEMENT("Announcement");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public CreateThread() { 
  }

  public CreateThread about(String about) {
    
    this.about = about;
    return this;
  }

   /**
   * Get about
   * @return about
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_ABOUT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getAbout() {
    return about;
  }


  @JsonProperty(JSON_PROPERTY_ABOUT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAbout(String about) {
    this.about = about;
  }


  public CreateThread addressedTo(String addressedTo) {
    
    this.addressedTo = addressedTo;
    return this;
  }

   /**
   * Get addressedTo
   * @return addressedTo
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ADDRESSED_TO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAddressedTo() {
    return addressedTo;
  }


  @JsonProperty(JSON_PROPERTY_ADDRESSED_TO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAddressedTo(String addressedTo) {
    this.addressedTo = addressedTo;
  }


  public CreateThread announcementDetails(AnnouncementDetails announcementDetails) {
    
    this.announcementDetails = announcementDetails;
    return this;
  }

   /**
   * Get announcementDetails
   * @return announcementDetails
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ANNOUNCEMENT_DETAILS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AnnouncementDetails getAnnouncementDetails() {
    return announcementDetails;
  }


  @JsonProperty(JSON_PROPERTY_ANNOUNCEMENT_DETAILS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAnnouncementDetails(AnnouncementDetails announcementDetails) {
    this.announcementDetails = announcementDetails;
  }


  public CreateThread from(String from) {
    
    this.from = from;
    return this;
  }

   /**
   * Get from
   * @return from
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_FROM)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getFrom() {
    return from;
  }


  @JsonProperty(JSON_PROPERTY_FROM)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setFrom(String from) {
    this.from = from;
  }


  public CreateThread message(String message) {
    
    this.message = message;
    return this;
  }

   /**
   * Get message
   * @return message
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getMessage() {
    return message;
  }


  @JsonProperty(JSON_PROPERTY_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMessage(String message) {
    this.message = message;
  }


  public CreateThread taskDetails(CreateTaskDetails taskDetails) {
    
    this.taskDetails = taskDetails;
    return this;
  }

   /**
   * Get taskDetails
   * @return taskDetails
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TASK_DETAILS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CreateTaskDetails getTaskDetails() {
    return taskDetails;
  }


  @JsonProperty(JSON_PROPERTY_TASK_DETAILS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTaskDetails(CreateTaskDetails taskDetails) {
    this.taskDetails = taskDetails;
  }


  public CreateThread type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * Get type
   * @return type
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreateThread createThread = (CreateThread) o;
    return Objects.equals(this.about, createThread.about) &&
        Objects.equals(this.addressedTo, createThread.addressedTo) &&
        Objects.equals(this.announcementDetails, createThread.announcementDetails) &&
        Objects.equals(this.from, createThread.from) &&
        Objects.equals(this.message, createThread.message) &&
        Objects.equals(this.taskDetails, createThread.taskDetails) &&
        Objects.equals(this.type, createThread.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(about, addressedTo, announcementDetails, from, message, taskDetails, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateThread {\n");
    sb.append("    about: ").append(toIndentedString(about)).append("\n");
    sb.append("    addressedTo: ").append(toIndentedString(addressedTo)).append("\n");
    sb.append("    announcementDetails: ").append(toIndentedString(announcementDetails)).append("\n");
    sb.append("    from: ").append(toIndentedString(from)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    taskDetails: ").append(toIndentedString(taskDetails)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

