/*
 * OpenMetadata Apis
 * --- title: APIs slug: /main-concepts/metadata-standard/apis ---  # APIs  OpenMetadata supports REST APIs for getting data and in and out of the metadata service. APIs are built using general best practices of REST API design. We take a schema-first approach by defining Types and Entities in JSON Schema. We implement APIs based on these schemas.  ## Overview  ### URI  Following REST API conventions are followed for Resource URIs: - Operations for an entity are available through the Resource URI as a collection `.../api/<version>/entities`.  - Plural of the entity name is used as the collection name - example `.../api/v1/users`. - Trailing forward slash is not used in the endpoint URI. Example use `.../api/v1/databases` instead of `.../api/v1/databases/`. - Resource URI for an entity instance by the entity id is `.../api/v1/entities/{id}`.  - Resource URI for an entity instance by name is `.../api/v1/entities/name/{name}`.  ### Resource Representation  - The REST API calls return a response with JSON `Content-Type` and `Content-Length` that includes the length of the response. - All responses include the Resource ID field even though the id was provided in the request to simplify the consumption    of the response at the client. - Entity names and field names use `camelCase` per Javascript naming convention. - All resources include an attribute `href` with Resource URI. All relationship fields of an entity will also    include `href` links to the related resource for easy access. - Unknown fields sent by the client in API requests are not ignored to ensure the data sent by the client is not dropped    at the server without the user being aware of it.  ## API Organization  You can find the swagger documentation [here](/swagger.html). In a nutshell:  **Data Asset APIs** - support operations related to data asset entities. - `.../api/v1/databases` - `...api/v1/tables` - `.../api/v1/metrics` - `.../api/v1/dashboards` - `.../api/v1/reports` - `.../api/v1/pipelines` - `.../api/v1/topics`  **Service APIs** - support operations related to services from which metadata is collected: - `.../api/v1/services` is the collection of all service resources. - `.../api/v1/services/databaseService` - APIs related to database services. This includes Transactional databases - MySQL, Postgres, MSSQL, Oracle, and Data Warehouses - Apache Hive BigQuery, Redshift, and Snowflake. - `.../api/v1/services/dashboardService` - APIs related to Dashboard Services. This includes Looker, Superset, and Tableau. - `.../api/v1/services/messagingService` - APIs related to Messaging Services. This includes Apache Kafka, Redpanda, - Kinesis, and others.  **Teams & Users APIs** - `.../api/v1/teams` - APIs related to team entities - `.../api/v1/users` - APIs related to user entities  **Search & Suggest APIs** - support search and suggest APIs: - `.../api/v1/search` - collection for search and suggest APIs - `.../api/v1/search/query` - search entities using query text - `.../api/v1/search/suggest` - get suggested entities used for auto-completion  **Other APIs** - `.../api/v1/tags` for APIs related to Classification and Tag entities - `../api/v1/feeds` for APIs related to Threads and Posts entities - `.../api/v1/usage` for reporting usage information of entities
 *
 * The version of the OpenAPI document: 1.2.2
 * Contact: openmetadata-dev@googlegroups.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.openmetadata.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.openmetadata.client.model.EntityReference;
import org.openmetadata.client.model.LifeCycle;
import org.openmetadata.client.model.MessageSchema;
import org.openmetadata.client.model.TagLabel;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * CreateTopic
 */
@JsonPropertyOrder({
  CreateTopic.JSON_PROPERTY_CLEANUP_POLICIES,
  CreateTopic.JSON_PROPERTY_DATA_PRODUCTS,
  CreateTopic.JSON_PROPERTY_DESCRIPTION,
  CreateTopic.JSON_PROPERTY_DISPLAY_NAME,
  CreateTopic.JSON_PROPERTY_DOMAIN,
  CreateTopic.JSON_PROPERTY_EXTENSION,
  CreateTopic.JSON_PROPERTY_LIFE_CYCLE,
  CreateTopic.JSON_PROPERTY_MAXIMUM_MESSAGE_SIZE,
  CreateTopic.JSON_PROPERTY_MESSAGE_SCHEMA,
  CreateTopic.JSON_PROPERTY_MINIMUM_IN_SYNC_REPLICAS,
  CreateTopic.JSON_PROPERTY_NAME,
  CreateTopic.JSON_PROPERTY_OWNER,
  CreateTopic.JSON_PROPERTY_PARTITIONS,
  CreateTopic.JSON_PROPERTY_REPLICATION_FACTOR,
  CreateTopic.JSON_PROPERTY_RETENTION_SIZE,
  CreateTopic.JSON_PROPERTY_RETENTION_TIME,
  CreateTopic.JSON_PROPERTY_SERVICE,
  CreateTopic.JSON_PROPERTY_SOURCE_URL,
  CreateTopic.JSON_PROPERTY_TAGS,
  CreateTopic.JSON_PROPERTY_TOPIC_CONFIG
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-20T11:35:38.398944261Z[Etc/UTC]")
public class CreateTopic {
  /**
   * Gets or Sets cleanupPolicies
   */
  public enum CleanupPoliciesEnum {
    DELETE("delete"),
    
    COMPACT("compact");

    private String value;

    CleanupPoliciesEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static CleanupPoliciesEnum fromValue(String value) {
      for (CleanupPoliciesEnum b : CleanupPoliciesEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_CLEANUP_POLICIES = "cleanupPolicies";
  private List<CleanupPoliciesEnum> cleanupPolicies = null;

  public static final String JSON_PROPERTY_DATA_PRODUCTS = "dataProducts";
  private List<String> dataProducts = null;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description;

  public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
  private String displayName;

  public static final String JSON_PROPERTY_DOMAIN = "domain";
  private String domain;

  public static final String JSON_PROPERTY_EXTENSION = "extension";
  private Object extension;

  public static final String JSON_PROPERTY_LIFE_CYCLE = "lifeCycle";
  private LifeCycle lifeCycle;

  public static final String JSON_PROPERTY_MAXIMUM_MESSAGE_SIZE = "maximumMessageSize";
  private Integer maximumMessageSize;

  public static final String JSON_PROPERTY_MESSAGE_SCHEMA = "messageSchema";
  private MessageSchema messageSchema;

  public static final String JSON_PROPERTY_MINIMUM_IN_SYNC_REPLICAS = "minimumInSyncReplicas";
  private Integer minimumInSyncReplicas;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_OWNER = "owner";
  private EntityReference owner;

  public static final String JSON_PROPERTY_PARTITIONS = "partitions";
  private Integer partitions;

  public static final String JSON_PROPERTY_REPLICATION_FACTOR = "replicationFactor";
  private Integer replicationFactor;

  public static final String JSON_PROPERTY_RETENTION_SIZE = "retentionSize";
  private Double retentionSize;

  public static final String JSON_PROPERTY_RETENTION_TIME = "retentionTime";
  private Double retentionTime;

  public static final String JSON_PROPERTY_SERVICE = "service";
  private String service;

  public static final String JSON_PROPERTY_SOURCE_URL = "sourceUrl";
  private String sourceUrl;

  public static final String JSON_PROPERTY_TAGS = "tags";
  private List<TagLabel> tags = null;

  public static final String JSON_PROPERTY_TOPIC_CONFIG = "topicConfig";
  private Object topicConfig;

  public CreateTopic() { 
  }

  public CreateTopic cleanupPolicies(List<CleanupPoliciesEnum> cleanupPolicies) {
    
    this.cleanupPolicies = cleanupPolicies;
    return this;
  }

  public CreateTopic addCleanupPoliciesItem(CleanupPoliciesEnum cleanupPoliciesItem) {
    if (this.cleanupPolicies == null) {
      this.cleanupPolicies = new ArrayList<>();
    }
    this.cleanupPolicies.add(cleanupPoliciesItem);
    return this;
  }

   /**
   * Get cleanupPolicies
   * @return cleanupPolicies
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CLEANUP_POLICIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<CleanupPoliciesEnum> getCleanupPolicies() {
    return cleanupPolicies;
  }


  @JsonProperty(JSON_PROPERTY_CLEANUP_POLICIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCleanupPolicies(List<CleanupPoliciesEnum> cleanupPolicies) {
    this.cleanupPolicies = cleanupPolicies;
  }


  public CreateTopic dataProducts(List<String> dataProducts) {
    
    this.dataProducts = dataProducts;
    return this;
  }

  public CreateTopic addDataProductsItem(String dataProductsItem) {
    if (this.dataProducts == null) {
      this.dataProducts = new ArrayList<>();
    }
    this.dataProducts.add(dataProductsItem);
    return this;
  }

   /**
   * Get dataProducts
   * @return dataProducts
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DATA_PRODUCTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getDataProducts() {
    return dataProducts;
  }


  @JsonProperty(JSON_PROPERTY_DATA_PRODUCTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDataProducts(List<String> dataProducts) {
    this.dataProducts = dataProducts;
  }


  public CreateTopic description(String description) {
    
    this.description = description;
    return this;
  }

   /**
   * Get description
   * @return description
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDescription() {
    return description;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(String description) {
    this.description = description;
  }


  public CreateTopic displayName(String displayName) {
    
    this.displayName = displayName;
    return this;
  }

   /**
   * Get displayName
   * @return displayName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DISPLAY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDisplayName() {
    return displayName;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisplayName(String displayName) {
    this.displayName = displayName;
  }


  public CreateTopic domain(String domain) {
    
    this.domain = domain;
    return this;
  }

   /**
   * Get domain
   * @return domain
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DOMAIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDomain() {
    return domain;
  }


  @JsonProperty(JSON_PROPERTY_DOMAIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDomain(String domain) {
    this.domain = domain;
  }


  public CreateTopic extension(Object extension) {
    
    this.extension = extension;
    return this;
  }

   /**
   * Get extension
   * @return extension
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_EXTENSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getExtension() {
    return extension;
  }


  @JsonProperty(JSON_PROPERTY_EXTENSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExtension(Object extension) {
    this.extension = extension;
  }


  public CreateTopic lifeCycle(LifeCycle lifeCycle) {
    
    this.lifeCycle = lifeCycle;
    return this;
  }

   /**
   * Get lifeCycle
   * @return lifeCycle
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_LIFE_CYCLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LifeCycle getLifeCycle() {
    return lifeCycle;
  }


  @JsonProperty(JSON_PROPERTY_LIFE_CYCLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLifeCycle(LifeCycle lifeCycle) {
    this.lifeCycle = lifeCycle;
  }


  public CreateTopic maximumMessageSize(Integer maximumMessageSize) {
    
    this.maximumMessageSize = maximumMessageSize;
    return this;
  }

   /**
   * Get maximumMessageSize
   * @return maximumMessageSize
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MAXIMUM_MESSAGE_SIZE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMaximumMessageSize() {
    return maximumMessageSize;
  }


  @JsonProperty(JSON_PROPERTY_MAXIMUM_MESSAGE_SIZE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaximumMessageSize(Integer maximumMessageSize) {
    this.maximumMessageSize = maximumMessageSize;
  }


  public CreateTopic messageSchema(MessageSchema messageSchema) {
    
    this.messageSchema = messageSchema;
    return this;
  }

   /**
   * Get messageSchema
   * @return messageSchema
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MESSAGE_SCHEMA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MessageSchema getMessageSchema() {
    return messageSchema;
  }


  @JsonProperty(JSON_PROPERTY_MESSAGE_SCHEMA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMessageSchema(MessageSchema messageSchema) {
    this.messageSchema = messageSchema;
  }


  public CreateTopic minimumInSyncReplicas(Integer minimumInSyncReplicas) {
    
    this.minimumInSyncReplicas = minimumInSyncReplicas;
    return this;
  }

   /**
   * Get minimumInSyncReplicas
   * @return minimumInSyncReplicas
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MINIMUM_IN_SYNC_REPLICAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMinimumInSyncReplicas() {
    return minimumInSyncReplicas;
  }


  @JsonProperty(JSON_PROPERTY_MINIMUM_IN_SYNC_REPLICAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMinimumInSyncReplicas(Integer minimumInSyncReplicas) {
    this.minimumInSyncReplicas = minimumInSyncReplicas;
  }


  public CreateTopic name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Get name
   * @return name
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public CreateTopic owner(EntityReference owner) {
    
    this.owner = owner;
    return this;
  }

   /**
   * Get owner
   * @return owner
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_OWNER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public EntityReference getOwner() {
    return owner;
  }


  @JsonProperty(JSON_PROPERTY_OWNER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOwner(EntityReference owner) {
    this.owner = owner;
  }


  public CreateTopic partitions(Integer partitions) {
    
    this.partitions = partitions;
    return this;
  }

   /**
   * Get partitions
   * @return partitions
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_PARTITIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getPartitions() {
    return partitions;
  }


  @JsonProperty(JSON_PROPERTY_PARTITIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPartitions(Integer partitions) {
    this.partitions = partitions;
  }


  public CreateTopic replicationFactor(Integer replicationFactor) {
    
    this.replicationFactor = replicationFactor;
    return this;
  }

   /**
   * Get replicationFactor
   * @return replicationFactor
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_REPLICATION_FACTOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getReplicationFactor() {
    return replicationFactor;
  }


  @JsonProperty(JSON_PROPERTY_REPLICATION_FACTOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReplicationFactor(Integer replicationFactor) {
    this.replicationFactor = replicationFactor;
  }


  public CreateTopic retentionSize(Double retentionSize) {
    
    this.retentionSize = retentionSize;
    return this;
  }

   /**
   * Get retentionSize
   * @return retentionSize
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_RETENTION_SIZE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getRetentionSize() {
    return retentionSize;
  }


  @JsonProperty(JSON_PROPERTY_RETENTION_SIZE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRetentionSize(Double retentionSize) {
    this.retentionSize = retentionSize;
  }


  public CreateTopic retentionTime(Double retentionTime) {
    
    this.retentionTime = retentionTime;
    return this;
  }

   /**
   * Get retentionTime
   * @return retentionTime
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_RETENTION_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getRetentionTime() {
    return retentionTime;
  }


  @JsonProperty(JSON_PROPERTY_RETENTION_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRetentionTime(Double retentionTime) {
    this.retentionTime = retentionTime;
  }


  public CreateTopic service(String service) {
    
    this.service = service;
    return this;
  }

   /**
   * Get service
   * @return service
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_SERVICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getService() {
    return service;
  }


  @JsonProperty(JSON_PROPERTY_SERVICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setService(String service) {
    this.service = service;
  }


  public CreateTopic sourceUrl(String sourceUrl) {
    
    this.sourceUrl = sourceUrl;
    return this;
  }

   /**
   * Get sourceUrl
   * @return sourceUrl
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SOURCE_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSourceUrl() {
    return sourceUrl;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceUrl(String sourceUrl) {
    this.sourceUrl = sourceUrl;
  }


  public CreateTopic tags(List<TagLabel> tags) {
    
    this.tags = tags;
    return this;
  }

  public CreateTopic addTagsItem(TagLabel tagsItem) {
    if (this.tags == null) {
      this.tags = new ArrayList<>();
    }
    this.tags.add(tagsItem);
    return this;
  }

   /**
   * Get tags
   * @return tags
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<TagLabel> getTags() {
    return tags;
  }


  @JsonProperty(JSON_PROPERTY_TAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTags(List<TagLabel> tags) {
    this.tags = tags;
  }


  public CreateTopic topicConfig(Object topicConfig) {
    
    this.topicConfig = topicConfig;
    return this;
  }

   /**
   * Get topicConfig
   * @return topicConfig
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TOPIC_CONFIG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getTopicConfig() {
    return topicConfig;
  }


  @JsonProperty(JSON_PROPERTY_TOPIC_CONFIG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTopicConfig(Object topicConfig) {
    this.topicConfig = topicConfig;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreateTopic createTopic = (CreateTopic) o;
    return Objects.equals(this.cleanupPolicies, createTopic.cleanupPolicies) &&
        Objects.equals(this.dataProducts, createTopic.dataProducts) &&
        Objects.equals(this.description, createTopic.description) &&
        Objects.equals(this.displayName, createTopic.displayName) &&
        Objects.equals(this.domain, createTopic.domain) &&
        Objects.equals(this.extension, createTopic.extension) &&
        Objects.equals(this.lifeCycle, createTopic.lifeCycle) &&
        Objects.equals(this.maximumMessageSize, createTopic.maximumMessageSize) &&
        Objects.equals(this.messageSchema, createTopic.messageSchema) &&
        Objects.equals(this.minimumInSyncReplicas, createTopic.minimumInSyncReplicas) &&
        Objects.equals(this.name, createTopic.name) &&
        Objects.equals(this.owner, createTopic.owner) &&
        Objects.equals(this.partitions, createTopic.partitions) &&
        Objects.equals(this.replicationFactor, createTopic.replicationFactor) &&
        Objects.equals(this.retentionSize, createTopic.retentionSize) &&
        Objects.equals(this.retentionTime, createTopic.retentionTime) &&
        Objects.equals(this.service, createTopic.service) &&
        Objects.equals(this.sourceUrl, createTopic.sourceUrl) &&
        Objects.equals(this.tags, createTopic.tags) &&
        Objects.equals(this.topicConfig, createTopic.topicConfig);
  }

  @Override
  public int hashCode() {
    return Objects.hash(cleanupPolicies, dataProducts, description, displayName, domain, extension, lifeCycle, maximumMessageSize, messageSchema, minimumInSyncReplicas, name, owner, partitions, replicationFactor, retentionSize, retentionTime, service, sourceUrl, tags, topicConfig);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateTopic {\n");
    sb.append("    cleanupPolicies: ").append(toIndentedString(cleanupPolicies)).append("\n");
    sb.append("    dataProducts: ").append(toIndentedString(dataProducts)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    displayName: ").append(toIndentedString(displayName)).append("\n");
    sb.append("    domain: ").append(toIndentedString(domain)).append("\n");
    sb.append("    extension: ").append(toIndentedString(extension)).append("\n");
    sb.append("    lifeCycle: ").append(toIndentedString(lifeCycle)).append("\n");
    sb.append("    maximumMessageSize: ").append(toIndentedString(maximumMessageSize)).append("\n");
    sb.append("    messageSchema: ").append(toIndentedString(messageSchema)).append("\n");
    sb.append("    minimumInSyncReplicas: ").append(toIndentedString(minimumInSyncReplicas)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    owner: ").append(toIndentedString(owner)).append("\n");
    sb.append("    partitions: ").append(toIndentedString(partitions)).append("\n");
    sb.append("    replicationFactor: ").append(toIndentedString(replicationFactor)).append("\n");
    sb.append("    retentionSize: ").append(toIndentedString(retentionSize)).append("\n");
    sb.append("    retentionTime: ").append(toIndentedString(retentionTime)).append("\n");
    sb.append("    service: ").append(toIndentedString(service)).append("\n");
    sb.append("    sourceUrl: ").append(toIndentedString(sourceUrl)).append("\n");
    sb.append("    tags: ").append(toIndentedString(tags)).append("\n");
    sb.append("    topicConfig: ").append(toIndentedString(topicConfig)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

