/*
 * OpenMetadata Apis
 * --- title: APIs slug: /main-concepts/metadata-standard/apis ---  # APIs  OpenMetadata supports REST APIs for getting data and in and out of the metadata service. APIs are built using general best practices of REST API design. We take a schema-first approach by defining Types and Entities in JSON Schema. We implement APIs based on these schemas.  ## Overview  ### URI  Following REST API conventions are followed for Resource URIs: - Operations for an entity are available through the Resource URI as a collection `.../api/<version>/entities`.  - Plural of the entity name is used as the collection name - example `.../api/v1/users`. - Trailing forward slash is not used in the endpoint URI. Example use `.../api/v1/databases` instead of `.../api/v1/databases/`. - Resource URI for an entity instance by the entity id is `.../api/v1/entities/{id}`.  - Resource URI for an entity instance by name is `.../api/v1/entities/name/{name}`.  ### Resource Representation  - The REST API calls return a response with JSON `Content-Type` and `Content-Length` that includes the length of the response. - All responses include the Resource ID field even though the id was provided in the request to simplify the consumption    of the response at the client. - Entity names and field names use `camelCase` per Javascript naming convention. - All resources include an attribute `href` with Resource URI. All relationship fields of an entity will also    include `href` links to the related resource for easy access. - Unknown fields sent by the client in API requests are not ignored to ensure the data sent by the client is not dropped    at the server without the user being aware of it.  ## API Organization  You can find the swagger documentation [here](/swagger.html). In a nutshell:  **Data Asset APIs** - support operations related to data asset entities. - `.../api/v1/databases` - `...api/v1/tables` - `.../api/v1/metrics` - `.../api/v1/dashboards` - `.../api/v1/reports` - `.../api/v1/pipelines` - `.../api/v1/topics`  **Service APIs** - support operations related to services from which metadata is collected: - `.../api/v1/services` is the collection of all service resources. - `.../api/v1/services/databaseService` - APIs related to database services. This includes Transactional databases - MySQL, Postgres, MSSQL, Oracle, and Data Warehouses - Apache Hive BigQuery, Redshift, and Snowflake. - `.../api/v1/services/dashboardService` - APIs related to Dashboard Services. This includes Looker, Superset, and Tableau. - `.../api/v1/services/messagingService` - APIs related to Messaging Services. This includes Apache Kafka, Redpanda, - Kinesis, and others.  **Teams & Users APIs** - `.../api/v1/teams` - APIs related to team entities - `.../api/v1/users` - APIs related to user entities  **Search & Suggest APIs** - support search and suggest APIs: - `.../api/v1/search` - collection for search and suggest APIs - `.../api/v1/search/query` - search entities using query text - `.../api/v1/search/suggest` - get suggested entities used for auto-completion  **Other APIs** - `.../api/v1/tags` for APIs related to Classification and Tag entities - `../api/v1/feeds` for APIs related to Threads and Posts entities - `.../api/v1/usage` for reporting usage information of entities
 *
 * The version of the OpenAPI document: 1.2.2
 * Contact: openmetadata-dev@googlegroups.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.openmetadata.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.openmetadata.client.model.AuthenticationMechanism;
import org.openmetadata.client.model.EntityReference;
import org.openmetadata.client.model.LifeCycle;
import org.openmetadata.client.model.Profile;
import org.openmetadata.client.model.TagLabel;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * CreateUser
 */
@JsonPropertyOrder({
  CreateUser.JSON_PROPERTY_AUTHENTICATION_MECHANISM,
  CreateUser.JSON_PROPERTY_BOT_NAME,
  CreateUser.JSON_PROPERTY_CONFIRM_PASSWORD,
  CreateUser.JSON_PROPERTY_CREATE_PASSWORD_TYPE,
  CreateUser.JSON_PROPERTY_DATA_PRODUCTS,
  CreateUser.JSON_PROPERTY_DEFAULT_PERSONA,
  CreateUser.JSON_PROPERTY_DESCRIPTION,
  CreateUser.JSON_PROPERTY_DISPLAY_NAME,
  CreateUser.JSON_PROPERTY_DOMAIN,
  CreateUser.JSON_PROPERTY_EMAIL,
  CreateUser.JSON_PROPERTY_EXTENSION,
  CreateUser.JSON_PROPERTY_IS_ADMIN,
  CreateUser.JSON_PROPERTY_IS_BOT,
  CreateUser.JSON_PROPERTY_LIFE_CYCLE,
  CreateUser.JSON_PROPERTY_NAME,
  CreateUser.JSON_PROPERTY_OWNER,
  CreateUser.JSON_PROPERTY_PASSWORD,
  CreateUser.JSON_PROPERTY_PERSONAS,
  CreateUser.JSON_PROPERTY_PROFILE,
  CreateUser.JSON_PROPERTY_ROLES,
  CreateUser.JSON_PROPERTY_TAGS,
  CreateUser.JSON_PROPERTY_TEAMS,
  CreateUser.JSON_PROPERTY_TIMEZONE
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-20T11:35:38.398944261Z[Etc/UTC]")
public class CreateUser {
  public static final String JSON_PROPERTY_AUTHENTICATION_MECHANISM = "authenticationMechanism";
  private AuthenticationMechanism authenticationMechanism;

  public static final String JSON_PROPERTY_BOT_NAME = "botName";
  private String botName;

  public static final String JSON_PROPERTY_CONFIRM_PASSWORD = "confirmPassword";
  private String confirmPassword;

  /**
   * Gets or Sets createPasswordType
   */
  public enum CreatePasswordTypeEnum {
    ADMIN_CREATE("ADMIN_CREATE"),
    
    USER_CREATE("USER_CREATE");

    private String value;

    CreatePasswordTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static CreatePasswordTypeEnum fromValue(String value) {
      for (CreatePasswordTypeEnum b : CreatePasswordTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_CREATE_PASSWORD_TYPE = "createPasswordType";
  private CreatePasswordTypeEnum createPasswordType;

  public static final String JSON_PROPERTY_DATA_PRODUCTS = "dataProducts";
  private List<String> dataProducts = null;

  public static final String JSON_PROPERTY_DEFAULT_PERSONA = "defaultPersona";
  private EntityReference defaultPersona;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description;

  public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
  private String displayName;

  public static final String JSON_PROPERTY_DOMAIN = "domain";
  private String domain;

  public static final String JSON_PROPERTY_EMAIL = "email";
  private String email;

  public static final String JSON_PROPERTY_EXTENSION = "extension";
  private Object extension;

  public static final String JSON_PROPERTY_IS_ADMIN = "isAdmin";
  private Boolean isAdmin;

  public static final String JSON_PROPERTY_IS_BOT = "isBot";
  private Boolean isBot;

  public static final String JSON_PROPERTY_LIFE_CYCLE = "lifeCycle";
  private LifeCycle lifeCycle;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_OWNER = "owner";
  private EntityReference owner;

  public static final String JSON_PROPERTY_PASSWORD = "password";
  private String password;

  public static final String JSON_PROPERTY_PERSONAS = "personas";
  private List<EntityReference> personas = null;

  public static final String JSON_PROPERTY_PROFILE = "profile";
  private Profile profile;

  public static final String JSON_PROPERTY_ROLES = "roles";
  private List<UUID> roles = null;

  public static final String JSON_PROPERTY_TAGS = "tags";
  private List<TagLabel> tags = null;

  public static final String JSON_PROPERTY_TEAMS = "teams";
  private List<UUID> teams = null;

  public static final String JSON_PROPERTY_TIMEZONE = "timezone";
  private String timezone;

  public CreateUser() { 
  }

  public CreateUser authenticationMechanism(AuthenticationMechanism authenticationMechanism) {
    
    this.authenticationMechanism = authenticationMechanism;
    return this;
  }

   /**
   * Get authenticationMechanism
   * @return authenticationMechanism
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_AUTHENTICATION_MECHANISM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AuthenticationMechanism getAuthenticationMechanism() {
    return authenticationMechanism;
  }


  @JsonProperty(JSON_PROPERTY_AUTHENTICATION_MECHANISM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAuthenticationMechanism(AuthenticationMechanism authenticationMechanism) {
    this.authenticationMechanism = authenticationMechanism;
  }


  public CreateUser botName(String botName) {
    
    this.botName = botName;
    return this;
  }

   /**
   * Get botName
   * @return botName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_BOT_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBotName() {
    return botName;
  }


  @JsonProperty(JSON_PROPERTY_BOT_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBotName(String botName) {
    this.botName = botName;
  }


  public CreateUser confirmPassword(String confirmPassword) {
    
    this.confirmPassword = confirmPassword;
    return this;
  }

   /**
   * Get confirmPassword
   * @return confirmPassword
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CONFIRM_PASSWORD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getConfirmPassword() {
    return confirmPassword;
  }


  @JsonProperty(JSON_PROPERTY_CONFIRM_PASSWORD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setConfirmPassword(String confirmPassword) {
    this.confirmPassword = confirmPassword;
  }


  public CreateUser createPasswordType(CreatePasswordTypeEnum createPasswordType) {
    
    this.createPasswordType = createPasswordType;
    return this;
  }

   /**
   * Get createPasswordType
   * @return createPasswordType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CREATE_PASSWORD_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CreatePasswordTypeEnum getCreatePasswordType() {
    return createPasswordType;
  }


  @JsonProperty(JSON_PROPERTY_CREATE_PASSWORD_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreatePasswordType(CreatePasswordTypeEnum createPasswordType) {
    this.createPasswordType = createPasswordType;
  }


  public CreateUser dataProducts(List<String> dataProducts) {
    
    this.dataProducts = dataProducts;
    return this;
  }

  public CreateUser addDataProductsItem(String dataProductsItem) {
    if (this.dataProducts == null) {
      this.dataProducts = new ArrayList<>();
    }
    this.dataProducts.add(dataProductsItem);
    return this;
  }

   /**
   * Get dataProducts
   * @return dataProducts
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DATA_PRODUCTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getDataProducts() {
    return dataProducts;
  }


  @JsonProperty(JSON_PROPERTY_DATA_PRODUCTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDataProducts(List<String> dataProducts) {
    this.dataProducts = dataProducts;
  }


  public CreateUser defaultPersona(EntityReference defaultPersona) {
    
    this.defaultPersona = defaultPersona;
    return this;
  }

   /**
   * Get defaultPersona
   * @return defaultPersona
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DEFAULT_PERSONA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public EntityReference getDefaultPersona() {
    return defaultPersona;
  }


  @JsonProperty(JSON_PROPERTY_DEFAULT_PERSONA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDefaultPersona(EntityReference defaultPersona) {
    this.defaultPersona = defaultPersona;
  }


  public CreateUser description(String description) {
    
    this.description = description;
    return this;
  }

   /**
   * Get description
   * @return description
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDescription() {
    return description;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(String description) {
    this.description = description;
  }


  public CreateUser displayName(String displayName) {
    
    this.displayName = displayName;
    return this;
  }

   /**
   * Get displayName
   * @return displayName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DISPLAY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDisplayName() {
    return displayName;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisplayName(String displayName) {
    this.displayName = displayName;
  }


  public CreateUser domain(String domain) {
    
    this.domain = domain;
    return this;
  }

   /**
   * Get domain
   * @return domain
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DOMAIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDomain() {
    return domain;
  }


  @JsonProperty(JSON_PROPERTY_DOMAIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDomain(String domain) {
    this.domain = domain;
  }


  public CreateUser email(String email) {
    
    this.email = email;
    return this;
  }

   /**
   * Get email
   * @return email
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_EMAIL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getEmail() {
    return email;
  }


  @JsonProperty(JSON_PROPERTY_EMAIL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEmail(String email) {
    this.email = email;
  }


  public CreateUser extension(Object extension) {
    
    this.extension = extension;
    return this;
  }

   /**
   * Get extension
   * @return extension
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_EXTENSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getExtension() {
    return extension;
  }


  @JsonProperty(JSON_PROPERTY_EXTENSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExtension(Object extension) {
    this.extension = extension;
  }


  public CreateUser isAdmin(Boolean isAdmin) {
    
    this.isAdmin = isAdmin;
    return this;
  }

   /**
   * Get isAdmin
   * @return isAdmin
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_IS_ADMIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIsAdmin() {
    return isAdmin;
  }


  @JsonProperty(JSON_PROPERTY_IS_ADMIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIsAdmin(Boolean isAdmin) {
    this.isAdmin = isAdmin;
  }


  public CreateUser isBot(Boolean isBot) {
    
    this.isBot = isBot;
    return this;
  }

   /**
   * Get isBot
   * @return isBot
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_IS_BOT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIsBot() {
    return isBot;
  }


  @JsonProperty(JSON_PROPERTY_IS_BOT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIsBot(Boolean isBot) {
    this.isBot = isBot;
  }


  public CreateUser lifeCycle(LifeCycle lifeCycle) {
    
    this.lifeCycle = lifeCycle;
    return this;
  }

   /**
   * Get lifeCycle
   * @return lifeCycle
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_LIFE_CYCLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LifeCycle getLifeCycle() {
    return lifeCycle;
  }


  @JsonProperty(JSON_PROPERTY_LIFE_CYCLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLifeCycle(LifeCycle lifeCycle) {
    this.lifeCycle = lifeCycle;
  }


  public CreateUser name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Get name
   * @return name
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public CreateUser owner(EntityReference owner) {
    
    this.owner = owner;
    return this;
  }

   /**
   * Get owner
   * @return owner
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_OWNER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public EntityReference getOwner() {
    return owner;
  }


  @JsonProperty(JSON_PROPERTY_OWNER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOwner(EntityReference owner) {
    this.owner = owner;
  }


  public CreateUser password(String password) {
    
    this.password = password;
    return this;
  }

   /**
   * Get password
   * @return password
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PASSWORD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPassword() {
    return password;
  }


  @JsonProperty(JSON_PROPERTY_PASSWORD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPassword(String password) {
    this.password = password;
  }


  public CreateUser personas(List<EntityReference> personas) {
    
    this.personas = personas;
    return this;
  }

  public CreateUser addPersonasItem(EntityReference personasItem) {
    if (this.personas == null) {
      this.personas = new ArrayList<>();
    }
    this.personas.add(personasItem);
    return this;
  }

   /**
   * Get personas
   * @return personas
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PERSONAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<EntityReference> getPersonas() {
    return personas;
  }


  @JsonProperty(JSON_PROPERTY_PERSONAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPersonas(List<EntityReference> personas) {
    this.personas = personas;
  }


  public CreateUser profile(Profile profile) {
    
    this.profile = profile;
    return this;
  }

   /**
   * Get profile
   * @return profile
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PROFILE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Profile getProfile() {
    return profile;
  }


  @JsonProperty(JSON_PROPERTY_PROFILE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProfile(Profile profile) {
    this.profile = profile;
  }


  public CreateUser roles(List<UUID> roles) {
    
    this.roles = roles;
    return this;
  }

  public CreateUser addRolesItem(UUID rolesItem) {
    if (this.roles == null) {
      this.roles = new ArrayList<>();
    }
    this.roles.add(rolesItem);
    return this;
  }

   /**
   * Get roles
   * @return roles
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ROLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<UUID> getRoles() {
    return roles;
  }


  @JsonProperty(JSON_PROPERTY_ROLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoles(List<UUID> roles) {
    this.roles = roles;
  }


  public CreateUser tags(List<TagLabel> tags) {
    
    this.tags = tags;
    return this;
  }

  public CreateUser addTagsItem(TagLabel tagsItem) {
    if (this.tags == null) {
      this.tags = new ArrayList<>();
    }
    this.tags.add(tagsItem);
    return this;
  }

   /**
   * Get tags
   * @return tags
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<TagLabel> getTags() {
    return tags;
  }


  @JsonProperty(JSON_PROPERTY_TAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTags(List<TagLabel> tags) {
    this.tags = tags;
  }


  public CreateUser teams(List<UUID> teams) {
    
    this.teams = teams;
    return this;
  }

  public CreateUser addTeamsItem(UUID teamsItem) {
    if (this.teams == null) {
      this.teams = new ArrayList<>();
    }
    this.teams.add(teamsItem);
    return this;
  }

   /**
   * Get teams
   * @return teams
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TEAMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<UUID> getTeams() {
    return teams;
  }


  @JsonProperty(JSON_PROPERTY_TEAMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTeams(List<UUID> teams) {
    this.teams = teams;
  }


  public CreateUser timezone(String timezone) {
    
    this.timezone = timezone;
    return this;
  }

   /**
   * Get timezone
   * @return timezone
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TIMEZONE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTimezone() {
    return timezone;
  }


  @JsonProperty(JSON_PROPERTY_TIMEZONE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTimezone(String timezone) {
    this.timezone = timezone;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreateUser createUser = (CreateUser) o;
    return Objects.equals(this.authenticationMechanism, createUser.authenticationMechanism) &&
        Objects.equals(this.botName, createUser.botName) &&
        Objects.equals(this.confirmPassword, createUser.confirmPassword) &&
        Objects.equals(this.createPasswordType, createUser.createPasswordType) &&
        Objects.equals(this.dataProducts, createUser.dataProducts) &&
        Objects.equals(this.defaultPersona, createUser.defaultPersona) &&
        Objects.equals(this.description, createUser.description) &&
        Objects.equals(this.displayName, createUser.displayName) &&
        Objects.equals(this.domain, createUser.domain) &&
        Objects.equals(this.email, createUser.email) &&
        Objects.equals(this.extension, createUser.extension) &&
        Objects.equals(this.isAdmin, createUser.isAdmin) &&
        Objects.equals(this.isBot, createUser.isBot) &&
        Objects.equals(this.lifeCycle, createUser.lifeCycle) &&
        Objects.equals(this.name, createUser.name) &&
        Objects.equals(this.owner, createUser.owner) &&
        Objects.equals(this.password, createUser.password) &&
        Objects.equals(this.personas, createUser.personas) &&
        Objects.equals(this.profile, createUser.profile) &&
        Objects.equals(this.roles, createUser.roles) &&
        Objects.equals(this.tags, createUser.tags) &&
        Objects.equals(this.teams, createUser.teams) &&
        Objects.equals(this.timezone, createUser.timezone);
  }

  @Override
  public int hashCode() {
    return Objects.hash(authenticationMechanism, botName, confirmPassword, createPasswordType, dataProducts, defaultPersona, description, displayName, domain, email, extension, isAdmin, isBot, lifeCycle, name, owner, password, personas, profile, roles, tags, teams, timezone);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateUser {\n");
    sb.append("    authenticationMechanism: ").append(toIndentedString(authenticationMechanism)).append("\n");
    sb.append("    botName: ").append(toIndentedString(botName)).append("\n");
    sb.append("    confirmPassword: ").append(toIndentedString(confirmPassword)).append("\n");
    sb.append("    createPasswordType: ").append(toIndentedString(createPasswordType)).append("\n");
    sb.append("    dataProducts: ").append(toIndentedString(dataProducts)).append("\n");
    sb.append("    defaultPersona: ").append(toIndentedString(defaultPersona)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    displayName: ").append(toIndentedString(displayName)).append("\n");
    sb.append("    domain: ").append(toIndentedString(domain)).append("\n");
    sb.append("    email: ").append(toIndentedString(email)).append("\n");
    sb.append("    extension: ").append(toIndentedString(extension)).append("\n");
    sb.append("    isAdmin: ").append(toIndentedString(isAdmin)).append("\n");
    sb.append("    isBot: ").append(toIndentedString(isBot)).append("\n");
    sb.append("    lifeCycle: ").append(toIndentedString(lifeCycle)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    owner: ").append(toIndentedString(owner)).append("\n");
    sb.append("    password: ").append(toIndentedString(password)).append("\n");
    sb.append("    personas: ").append(toIndentedString(personas)).append("\n");
    sb.append("    profile: ").append(toIndentedString(profile)).append("\n");
    sb.append("    roles: ").append(toIndentedString(roles)).append("\n");
    sb.append("    tags: ").append(toIndentedString(tags)).append("\n");
    sb.append("    teams: ").append(toIndentedString(teams)).append("\n");
    sb.append("    timezone: ").append(toIndentedString(timezone)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

