/*
 * OpenMetadata Apis
 * --- title: APIs slug: /main-concepts/metadata-standard/apis ---  # APIs  OpenMetadata supports REST APIs for getting data and in and out of the metadata service. APIs are built using general best practices of REST API design. We take a schema-first approach by defining Types and Entities in JSON Schema. We implement APIs based on these schemas.  ## Overview  ### URI  Following REST API conventions are followed for Resource URIs: - Operations for an entity are available through the Resource URI as a collection `.../api/<version>/entities`.  - Plural of the entity name is used as the collection name - example `.../api/v1/users`. - Trailing forward slash is not used in the endpoint URI. Example use `.../api/v1/databases` instead of `.../api/v1/databases/`. - Resource URI for an entity instance by the entity id is `.../api/v1/entities/{id}`.  - Resource URI for an entity instance by name is `.../api/v1/entities/name/{name}`.  ### Resource Representation  - The REST API calls return a response with JSON `Content-Type` and `Content-Length` that includes the length of the response. - All responses include the Resource ID field even though the id was provided in the request to simplify the consumption    of the response at the client. - Entity names and field names use `camelCase` per Javascript naming convention. - All resources include an attribute `href` with Resource URI. All relationship fields of an entity will also    include `href` links to the related resource for easy access. - Unknown fields sent by the client in API requests are not ignored to ensure the data sent by the client is not dropped    at the server without the user being aware of it.  ## API Organization  You can find the swagger documentation [here](/swagger.html). In a nutshell:  **Data Asset APIs** - support operations related to data asset entities. - `.../api/v1/databases` - `...api/v1/tables` - `.../api/v1/metrics` - `.../api/v1/dashboards` - `.../api/v1/reports` - `.../api/v1/pipelines` - `.../api/v1/topics`  **Service APIs** - support operations related to services from which metadata is collected: - `.../api/v1/services` is the collection of all service resources. - `.../api/v1/services/databaseService` - APIs related to database services. This includes Transactional databases - MySQL, Postgres, MSSQL, Oracle, and Data Warehouses - Apache Hive BigQuery, Redshift, and Snowflake. - `.../api/v1/services/dashboardService` - APIs related to Dashboard Services. This includes Looker, Superset, and Tableau. - `.../api/v1/services/messagingService` - APIs related to Messaging Services. This includes Apache Kafka, Redpanda, - Kinesis, and others.  **Teams & Users APIs** - `.../api/v1/teams` - APIs related to team entities - `.../api/v1/users` - APIs related to user entities  **Search & Suggest APIs** - support search and suggest APIs: - `.../api/v1/search` - collection for search and suggest APIs - `.../api/v1/search/query` - search entities using query text - `.../api/v1/search/suggest` - get suggested entities used for auto-completion  **Other APIs** - `.../api/v1/tags` for APIs related to Classification and Tag entities - `../api/v1/feeds` for APIs related to Threads and Posts entities - `.../api/v1/usage` for reporting usage information of entities
 *
 * The version of the OpenAPI document: 1.2.2
 * Contact: openmetadata-dev@googlegroups.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.openmetadata.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * CsvImportResult
 */
@JsonPropertyOrder({
  CsvImportResult.JSON_PROPERTY_ABORT_REASON,
  CsvImportResult.JSON_PROPERTY_DRY_RUN,
  CsvImportResult.JSON_PROPERTY_IMPORT_RESULTS_CSV,
  CsvImportResult.JSON_PROPERTY_NUMBER_OF_ROWS_FAILED,
  CsvImportResult.JSON_PROPERTY_NUMBER_OF_ROWS_PASSED,
  CsvImportResult.JSON_PROPERTY_NUMBER_OF_ROWS_PROCESSED,
  CsvImportResult.JSON_PROPERTY_STATUS
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-20T11:35:38.398944261Z[Etc/UTC]")
public class CsvImportResult {
  public static final String JSON_PROPERTY_ABORT_REASON = "abortReason";
  private String abortReason;

  public static final String JSON_PROPERTY_DRY_RUN = "dryRun";
  private Boolean dryRun;

  public static final String JSON_PROPERTY_IMPORT_RESULTS_CSV = "importResultsCsv";
  private String importResultsCsv;

  public static final String JSON_PROPERTY_NUMBER_OF_ROWS_FAILED = "numberOfRowsFailed";
  private Integer numberOfRowsFailed;

  public static final String JSON_PROPERTY_NUMBER_OF_ROWS_PASSED = "numberOfRowsPassed";
  private Integer numberOfRowsPassed;

  public static final String JSON_PROPERTY_NUMBER_OF_ROWS_PROCESSED = "numberOfRowsProcessed";
  private Integer numberOfRowsProcessed;

  /**
   * Gets or Sets status
   */
  public enum StatusEnum {
    SUCCESS("success"),
    
    FAILURE("failure"),
    
    ABORTED("aborted"),
    
    PARTIALSUCCESS("partialSuccess");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_STATUS = "status";
  private StatusEnum status;

  public CsvImportResult() { 
  }

  public CsvImportResult abortReason(String abortReason) {
    
    this.abortReason = abortReason;
    return this;
  }

   /**
   * Get abortReason
   * @return abortReason
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ABORT_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAbortReason() {
    return abortReason;
  }


  @JsonProperty(JSON_PROPERTY_ABORT_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAbortReason(String abortReason) {
    this.abortReason = abortReason;
  }


  public CsvImportResult dryRun(Boolean dryRun) {
    
    this.dryRun = dryRun;
    return this;
  }

   /**
   * Get dryRun
   * @return dryRun
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DRY_RUN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getDryRun() {
    return dryRun;
  }


  @JsonProperty(JSON_PROPERTY_DRY_RUN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDryRun(Boolean dryRun) {
    this.dryRun = dryRun;
  }


  public CsvImportResult importResultsCsv(String importResultsCsv) {
    
    this.importResultsCsv = importResultsCsv;
    return this;
  }

   /**
   * Get importResultsCsv
   * @return importResultsCsv
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_IMPORT_RESULTS_CSV)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getImportResultsCsv() {
    return importResultsCsv;
  }


  @JsonProperty(JSON_PROPERTY_IMPORT_RESULTS_CSV)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setImportResultsCsv(String importResultsCsv) {
    this.importResultsCsv = importResultsCsv;
  }


  public CsvImportResult numberOfRowsFailed(Integer numberOfRowsFailed) {
    
    this.numberOfRowsFailed = numberOfRowsFailed;
    return this;
  }

   /**
   * Get numberOfRowsFailed
   * @return numberOfRowsFailed
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_NUMBER_OF_ROWS_FAILED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getNumberOfRowsFailed() {
    return numberOfRowsFailed;
  }


  @JsonProperty(JSON_PROPERTY_NUMBER_OF_ROWS_FAILED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNumberOfRowsFailed(Integer numberOfRowsFailed) {
    this.numberOfRowsFailed = numberOfRowsFailed;
  }


  public CsvImportResult numberOfRowsPassed(Integer numberOfRowsPassed) {
    
    this.numberOfRowsPassed = numberOfRowsPassed;
    return this;
  }

   /**
   * Get numberOfRowsPassed
   * @return numberOfRowsPassed
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_NUMBER_OF_ROWS_PASSED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getNumberOfRowsPassed() {
    return numberOfRowsPassed;
  }


  @JsonProperty(JSON_PROPERTY_NUMBER_OF_ROWS_PASSED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNumberOfRowsPassed(Integer numberOfRowsPassed) {
    this.numberOfRowsPassed = numberOfRowsPassed;
  }


  public CsvImportResult numberOfRowsProcessed(Integer numberOfRowsProcessed) {
    
    this.numberOfRowsProcessed = numberOfRowsProcessed;
    return this;
  }

   /**
   * Get numberOfRowsProcessed
   * @return numberOfRowsProcessed
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_NUMBER_OF_ROWS_PROCESSED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getNumberOfRowsProcessed() {
    return numberOfRowsProcessed;
  }


  @JsonProperty(JSON_PROPERTY_NUMBER_OF_ROWS_PROCESSED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNumberOfRowsProcessed(Integer numberOfRowsProcessed) {
    this.numberOfRowsProcessed = numberOfRowsProcessed;
  }


  public CsvImportResult status(StatusEnum status) {
    
    this.status = status;
    return this;
  }

   /**
   * Get status
   * @return status
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public StatusEnum getStatus() {
    return status;
  }


  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStatus(StatusEnum status) {
    this.status = status;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CsvImportResult csvImportResult = (CsvImportResult) o;
    return Objects.equals(this.abortReason, csvImportResult.abortReason) &&
        Objects.equals(this.dryRun, csvImportResult.dryRun) &&
        Objects.equals(this.importResultsCsv, csvImportResult.importResultsCsv) &&
        Objects.equals(this.numberOfRowsFailed, csvImportResult.numberOfRowsFailed) &&
        Objects.equals(this.numberOfRowsPassed, csvImportResult.numberOfRowsPassed) &&
        Objects.equals(this.numberOfRowsProcessed, csvImportResult.numberOfRowsProcessed) &&
        Objects.equals(this.status, csvImportResult.status);
  }

  @Override
  public int hashCode() {
    return Objects.hash(abortReason, dryRun, importResultsCsv, numberOfRowsFailed, numberOfRowsPassed, numberOfRowsProcessed, status);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CsvImportResult {\n");
    sb.append("    abortReason: ").append(toIndentedString(abortReason)).append("\n");
    sb.append("    dryRun: ").append(toIndentedString(dryRun)).append("\n");
    sb.append("    importResultsCsv: ").append(toIndentedString(importResultsCsv)).append("\n");
    sb.append("    numberOfRowsFailed: ").append(toIndentedString(numberOfRowsFailed)).append("\n");
    sb.append("    numberOfRowsPassed: ").append(toIndentedString(numberOfRowsPassed)).append("\n");
    sb.append("    numberOfRowsProcessed: ").append(toIndentedString(numberOfRowsProcessed)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

