/*
 * OpenMetadata Apis
 * --- title: APIs slug: /main-concepts/metadata-standard/apis ---  # APIs  OpenMetadata supports REST APIs for getting data and in and out of the metadata service. APIs are built using general best practices of REST API design. We take a schema-first approach by defining Types and Entities in JSON Schema. We implement APIs based on these schemas.  ## Overview  ### URI  Following REST API conventions are followed for Resource URIs: - Operations for an entity are available through the Resource URI as a collection `.../api/<version>/entities`.  - Plural of the entity name is used as the collection name - example `.../api/v1/users`. - Trailing forward slash is not used in the endpoint URI. Example use `.../api/v1/databases` instead of `.../api/v1/databases/`. - Resource URI for an entity instance by the entity id is `.../api/v1/entities/{id}`.  - Resource URI for an entity instance by name is `.../api/v1/entities/name/{name}`.  ### Resource Representation  - The REST API calls return a response with JSON `Content-Type` and `Content-Length` that includes the length of the response. - All responses include the Resource ID field even though the id was provided in the request to simplify the consumption    of the response at the client. - Entity names and field names use `camelCase` per Javascript naming convention. - All resources include an attribute `href` with Resource URI. All relationship fields of an entity will also    include `href` links to the related resource for easy access. - Unknown fields sent by the client in API requests are not ignored to ensure the data sent by the client is not dropped    at the server without the user being aware of it.  ## API Organization  You can find the swagger documentation [here](/swagger.html). In a nutshell:  **Data Asset APIs** - support operations related to data asset entities. - `.../api/v1/databases` - `...api/v1/tables` - `.../api/v1/metrics` - `.../api/v1/dashboards` - `.../api/v1/reports` - `.../api/v1/pipelines` - `.../api/v1/topics`  **Service APIs** - support operations related to services from which metadata is collected: - `.../api/v1/services` is the collection of all service resources. - `.../api/v1/services/databaseService` - APIs related to database services. This includes Transactional databases - MySQL, Postgres, MSSQL, Oracle, and Data Warehouses - Apache Hive BigQuery, Redshift, and Snowflake. - `.../api/v1/services/dashboardService` - APIs related to Dashboard Services. This includes Looker, Superset, and Tableau. - `.../api/v1/services/messagingService` - APIs related to Messaging Services. This includes Apache Kafka, Redpanda, - Kinesis, and others.  **Teams & Users APIs** - `.../api/v1/teams` - APIs related to team entities - `.../api/v1/users` - APIs related to user entities  **Search & Suggest APIs** - support search and suggest APIs: - `.../api/v1/search` - collection for search and suggest APIs - `.../api/v1/search/query` - search entities using query text - `.../api/v1/search/suggest` - get suggested entities used for auto-completion  **Other APIs** - `.../api/v1/tags` for APIs related to Classification and Tag entities - `../api/v1/feeds` for APIs related to Threads and Posts entities - `.../api/v1/usage` for reporting usage information of entities
 *
 * The version of the OpenAPI document: 1.2.2
 * Contact: openmetadata-dev@googlegroups.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.openmetadata.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import org.openmetadata.client.model.Column;
import org.openmetadata.client.model.EntityReference;
import org.openmetadata.client.model.TagLabel;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * DataModel
 */
@JsonPropertyOrder({
  DataModel.JSON_PROPERTY_COLUMNS,
  DataModel.JSON_PROPERTY_DESCRIPTION,
  DataModel.JSON_PROPERTY_GENERATED_AT,
  DataModel.JSON_PROPERTY_MODEL_TYPE,
  DataModel.JSON_PROPERTY_OWNER,
  DataModel.JSON_PROPERTY_PATH,
  DataModel.JSON_PROPERTY_RAW_SQL,
  DataModel.JSON_PROPERTY_RESOURCE_TYPE,
  DataModel.JSON_PROPERTY_SQL,
  DataModel.JSON_PROPERTY_TAGS,
  DataModel.JSON_PROPERTY_UPSTREAM
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-20T11:35:38.398944261Z[Etc/UTC]")
public class DataModel {
  public static final String JSON_PROPERTY_COLUMNS = "columns";
  private List<Column> columns = null;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description;

  public static final String JSON_PROPERTY_GENERATED_AT = "generatedAt";
  private OffsetDateTime generatedAt;

  /**
   * Gets or Sets modelType
   */
  public enum ModelTypeEnum {
    DBT("DBT");

    private String value;

    ModelTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ModelTypeEnum fromValue(String value) {
      for (ModelTypeEnum b : ModelTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_MODEL_TYPE = "modelType";
  private ModelTypeEnum modelType;

  public static final String JSON_PROPERTY_OWNER = "owner";
  private EntityReference owner;

  public static final String JSON_PROPERTY_PATH = "path";
  private String path;

  public static final String JSON_PROPERTY_RAW_SQL = "rawSql";
  private String rawSql;

  public static final String JSON_PROPERTY_RESOURCE_TYPE = "resourceType";
  private String resourceType;

  public static final String JSON_PROPERTY_SQL = "sql";
  private String sql;

  public static final String JSON_PROPERTY_TAGS = "tags";
  private List<TagLabel> tags = null;

  public static final String JSON_PROPERTY_UPSTREAM = "upstream";
  private List<String> upstream = null;

  public DataModel() { 
  }

  public DataModel columns(List<Column> columns) {
    
    this.columns = columns;
    return this;
  }

  public DataModel addColumnsItem(Column columnsItem) {
    if (this.columns == null) {
      this.columns = new ArrayList<>();
    }
    this.columns.add(columnsItem);
    return this;
  }

   /**
   * Get columns
   * @return columns
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_COLUMNS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Column> getColumns() {
    return columns;
  }


  @JsonProperty(JSON_PROPERTY_COLUMNS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setColumns(List<Column> columns) {
    this.columns = columns;
  }


  public DataModel description(String description) {
    
    this.description = description;
    return this;
  }

   /**
   * Get description
   * @return description
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDescription() {
    return description;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(String description) {
    this.description = description;
  }


  public DataModel generatedAt(OffsetDateTime generatedAt) {
    
    this.generatedAt = generatedAt;
    return this;
  }

   /**
   * Get generatedAt
   * @return generatedAt
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_GENERATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getGeneratedAt() {
    return generatedAt;
  }


  @JsonProperty(JSON_PROPERTY_GENERATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGeneratedAt(OffsetDateTime generatedAt) {
    this.generatedAt = generatedAt;
  }


  public DataModel modelType(ModelTypeEnum modelType) {
    
    this.modelType = modelType;
    return this;
  }

   /**
   * Get modelType
   * @return modelType
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_MODEL_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public ModelTypeEnum getModelType() {
    return modelType;
  }


  @JsonProperty(JSON_PROPERTY_MODEL_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setModelType(ModelTypeEnum modelType) {
    this.modelType = modelType;
  }


  public DataModel owner(EntityReference owner) {
    
    this.owner = owner;
    return this;
  }

   /**
   * Get owner
   * @return owner
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_OWNER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public EntityReference getOwner() {
    return owner;
  }


  @JsonProperty(JSON_PROPERTY_OWNER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOwner(EntityReference owner) {
    this.owner = owner;
  }


  public DataModel path(String path) {
    
    this.path = path;
    return this;
  }

   /**
   * Get path
   * @return path
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PATH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPath() {
    return path;
  }


  @JsonProperty(JSON_PROPERTY_PATH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPath(String path) {
    this.path = path;
  }


  public DataModel rawSql(String rawSql) {
    
    this.rawSql = rawSql;
    return this;
  }

   /**
   * Get rawSql
   * @return rawSql
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_RAW_SQL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRawSql() {
    return rawSql;
  }


  @JsonProperty(JSON_PROPERTY_RAW_SQL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRawSql(String rawSql) {
    this.rawSql = rawSql;
  }


  public DataModel resourceType(String resourceType) {
    
    this.resourceType = resourceType;
    return this;
  }

   /**
   * Get resourceType
   * @return resourceType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_RESOURCE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getResourceType() {
    return resourceType;
  }


  @JsonProperty(JSON_PROPERTY_RESOURCE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setResourceType(String resourceType) {
    this.resourceType = resourceType;
  }


  public DataModel sql(String sql) {
    
    this.sql = sql;
    return this;
  }

   /**
   * Get sql
   * @return sql
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_SQL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSql() {
    return sql;
  }


  @JsonProperty(JSON_PROPERTY_SQL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSql(String sql) {
    this.sql = sql;
  }


  public DataModel tags(List<TagLabel> tags) {
    
    this.tags = tags;
    return this;
  }

  public DataModel addTagsItem(TagLabel tagsItem) {
    if (this.tags == null) {
      this.tags = new ArrayList<>();
    }
    this.tags.add(tagsItem);
    return this;
  }

   /**
   * Get tags
   * @return tags
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<TagLabel> getTags() {
    return tags;
  }


  @JsonProperty(JSON_PROPERTY_TAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTags(List<TagLabel> tags) {
    this.tags = tags;
  }


  public DataModel upstream(List<String> upstream) {
    
    this.upstream = upstream;
    return this;
  }

  public DataModel addUpstreamItem(String upstreamItem) {
    if (this.upstream == null) {
      this.upstream = new ArrayList<>();
    }
    this.upstream.add(upstreamItem);
    return this;
  }

   /**
   * Get upstream
   * @return upstream
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_UPSTREAM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getUpstream() {
    return upstream;
  }


  @JsonProperty(JSON_PROPERTY_UPSTREAM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUpstream(List<String> upstream) {
    this.upstream = upstream;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DataModel dataModel = (DataModel) o;
    return Objects.equals(this.columns, dataModel.columns) &&
        Objects.equals(this.description, dataModel.description) &&
        Objects.equals(this.generatedAt, dataModel.generatedAt) &&
        Objects.equals(this.modelType, dataModel.modelType) &&
        Objects.equals(this.owner, dataModel.owner) &&
        Objects.equals(this.path, dataModel.path) &&
        Objects.equals(this.rawSql, dataModel.rawSql) &&
        Objects.equals(this.resourceType, dataModel.resourceType) &&
        Objects.equals(this.sql, dataModel.sql) &&
        Objects.equals(this.tags, dataModel.tags) &&
        Objects.equals(this.upstream, dataModel.upstream);
  }

  @Override
  public int hashCode() {
    return Objects.hash(columns, description, generatedAt, modelType, owner, path, rawSql, resourceType, sql, tags, upstream);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DataModel {\n");
    sb.append("    columns: ").append(toIndentedString(columns)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    generatedAt: ").append(toIndentedString(generatedAt)).append("\n");
    sb.append("    modelType: ").append(toIndentedString(modelType)).append("\n");
    sb.append("    owner: ").append(toIndentedString(owner)).append("\n");
    sb.append("    path: ").append(toIndentedString(path)).append("\n");
    sb.append("    rawSql: ").append(toIndentedString(rawSql)).append("\n");
    sb.append("    resourceType: ").append(toIndentedString(resourceType)).append("\n");
    sb.append("    sql: ").append(toIndentedString(sql)).append("\n");
    sb.append("    tags: ").append(toIndentedString(tags)).append("\n");
    sb.append("    upstream: ").append(toIndentedString(upstream)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

