/*
 * OpenMetadata Apis
 * --- title: APIs slug: /main-concepts/metadata-standard/apis ---  # APIs  OpenMetadata supports REST APIs for getting data and in and out of the metadata service. APIs are built using general best practices of REST API design. We take a schema-first approach by defining Types and Entities in JSON Schema. We implement APIs based on these schemas.  ## Overview  ### URI  Following REST API conventions are followed for Resource URIs: - Operations for an entity are available through the Resource URI as a collection `.../api/<version>/entities`.  - Plural of the entity name is used as the collection name - example `.../api/v1/users`. - Trailing forward slash is not used in the endpoint URI. Example use `.../api/v1/databases` instead of `.../api/v1/databases/`. - Resource URI for an entity instance by the entity id is `.../api/v1/entities/{id}`.  - Resource URI for an entity instance by name is `.../api/v1/entities/name/{name}`.  ### Resource Representation  - The REST API calls return a response with JSON `Content-Type` and `Content-Length` that includes the length of the response. - All responses include the Resource ID field even though the id was provided in the request to simplify the consumption    of the response at the client. - Entity names and field names use `camelCase` per Javascript naming convention. - All resources include an attribute `href` with Resource URI. All relationship fields of an entity will also    include `href` links to the related resource for easy access. - Unknown fields sent by the client in API requests are not ignored to ensure the data sent by the client is not dropped    at the server without the user being aware of it.  ## API Organization  You can find the swagger documentation [here](/swagger.html). In a nutshell:  **Data Asset APIs** - support operations related to data asset entities. - `.../api/v1/databases` - `...api/v1/tables` - `.../api/v1/metrics` - `.../api/v1/dashboards` - `.../api/v1/reports` - `.../api/v1/pipelines` - `.../api/v1/topics`  **Service APIs** - support operations related to services from which metadata is collected: - `.../api/v1/services` is the collection of all service resources. - `.../api/v1/services/databaseService` - APIs related to database services. This includes Transactional databases - MySQL, Postgres, MSSQL, Oracle, and Data Warehouses - Apache Hive BigQuery, Redshift, and Snowflake. - `.../api/v1/services/dashboardService` - APIs related to Dashboard Services. This includes Looker, Superset, and Tableau. - `.../api/v1/services/messagingService` - APIs related to Messaging Services. This includes Apache Kafka, Redpanda, - Kinesis, and others.  **Teams & Users APIs** - `.../api/v1/teams` - APIs related to team entities - `.../api/v1/users` - APIs related to user entities  **Search & Suggest APIs** - support search and suggest APIs: - `.../api/v1/search` - collection for search and suggest APIs - `.../api/v1/search/query` - search entities using query text - `.../api/v1/search/suggest` - get suggested entities used for auto-completion  **Other APIs** - `.../api/v1/tags` for APIs related to Classification and Tag entities - `../api/v1/feeds` for APIs related to Threads and Posts entities - `.../api/v1/usage` for reporting usage information of entities
 *
 * The version of the OpenAPI document: 1.2.2
 * Contact: openmetadata-dev@googlegroups.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.openmetadata.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.openmetadata.client.model.ToXContentFragment;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * DocumentField
 */
@JsonPropertyOrder({
  DocumentField.JSON_PROPERTY_IGNORED_VALUES,
  DocumentField.JSON_PROPERTY_IGNORED_VALUES_WRITER,
  DocumentField.JSON_PROPERTY_NAME,
  DocumentField.JSON_PROPERTY_VALID_VALUES_WRITER,
  DocumentField.JSON_PROPERTY_VALUE,
  DocumentField.JSON_PROPERTY_VALUES
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-20T11:35:38.398944261Z[Etc/UTC]")
public class DocumentField {
  public static final String JSON_PROPERTY_IGNORED_VALUES = "ignoredValues";
  private List<Object> ignoredValues = null;

  public static final String JSON_PROPERTY_IGNORED_VALUES_WRITER = "ignoredValuesWriter";
  private ToXContentFragment ignoredValuesWriter;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_VALID_VALUES_WRITER = "validValuesWriter";
  private ToXContentFragment validValuesWriter;

  public static final String JSON_PROPERTY_VALUE = "value";
  private Object value;

  public static final String JSON_PROPERTY_VALUES = "values";
  private List<Object> values = null;

  public DocumentField() { 
  }

  public DocumentField ignoredValues(List<Object> ignoredValues) {
    
    this.ignoredValues = ignoredValues;
    return this;
  }

  public DocumentField addIgnoredValuesItem(Object ignoredValuesItem) {
    if (this.ignoredValues == null) {
      this.ignoredValues = new ArrayList<>();
    }
    this.ignoredValues.add(ignoredValuesItem);
    return this;
  }

   /**
   * Get ignoredValues
   * @return ignoredValues
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_IGNORED_VALUES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Object> getIgnoredValues() {
    return ignoredValues;
  }


  @JsonProperty(JSON_PROPERTY_IGNORED_VALUES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIgnoredValues(List<Object> ignoredValues) {
    this.ignoredValues = ignoredValues;
  }


  public DocumentField ignoredValuesWriter(ToXContentFragment ignoredValuesWriter) {
    
    this.ignoredValuesWriter = ignoredValuesWriter;
    return this;
  }

   /**
   * Get ignoredValuesWriter
   * @return ignoredValuesWriter
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_IGNORED_VALUES_WRITER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ToXContentFragment getIgnoredValuesWriter() {
    return ignoredValuesWriter;
  }


  @JsonProperty(JSON_PROPERTY_IGNORED_VALUES_WRITER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIgnoredValuesWriter(ToXContentFragment ignoredValuesWriter) {
    this.ignoredValuesWriter = ignoredValuesWriter;
  }


  public DocumentField name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Get name
   * @return name
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(String name) {
    this.name = name;
  }


  public DocumentField validValuesWriter(ToXContentFragment validValuesWriter) {
    
    this.validValuesWriter = validValuesWriter;
    return this;
  }

   /**
   * Get validValuesWriter
   * @return validValuesWriter
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_VALID_VALUES_WRITER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ToXContentFragment getValidValuesWriter() {
    return validValuesWriter;
  }


  @JsonProperty(JSON_PROPERTY_VALID_VALUES_WRITER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setValidValuesWriter(ToXContentFragment validValuesWriter) {
    this.validValuesWriter = validValuesWriter;
  }


  public DocumentField value(Object value) {
    
    this.value = value;
    return this;
  }

   /**
   * Get value
   * @return value
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getValue() {
    return value;
  }


  @JsonProperty(JSON_PROPERTY_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setValue(Object value) {
    this.value = value;
  }


  public DocumentField values(List<Object> values) {
    
    this.values = values;
    return this;
  }

  public DocumentField addValuesItem(Object valuesItem) {
    if (this.values == null) {
      this.values = new ArrayList<>();
    }
    this.values.add(valuesItem);
    return this;
  }

   /**
   * Get values
   * @return values
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_VALUES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Object> getValues() {
    return values;
  }


  @JsonProperty(JSON_PROPERTY_VALUES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setValues(List<Object> values) {
    this.values = values;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DocumentField documentField = (DocumentField) o;
    return Objects.equals(this.ignoredValues, documentField.ignoredValues) &&
        Objects.equals(this.ignoredValuesWriter, documentField.ignoredValuesWriter) &&
        Objects.equals(this.name, documentField.name) &&
        Objects.equals(this.validValuesWriter, documentField.validValuesWriter) &&
        Objects.equals(this.value, documentField.value) &&
        Objects.equals(this.values, documentField.values);
  }

  @Override
  public int hashCode() {
    return Objects.hash(ignoredValues, ignoredValuesWriter, name, validValuesWriter, value, values);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DocumentField {\n");
    sb.append("    ignoredValues: ").append(toIndentedString(ignoredValues)).append("\n");
    sb.append("    ignoredValuesWriter: ").append(toIndentedString(ignoredValuesWriter)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    validValuesWriter: ").append(toIndentedString(validValuesWriter)).append("\n");
    sb.append("    value: ").append(toIndentedString(value)).append("\n");
    sb.append("    values: ").append(toIndentedString(values)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

