/*
 * OpenMetadata Apis
 * --- title: APIs slug: /main-concepts/metadata-standard/apis ---  # APIs  OpenMetadata supports REST APIs for getting data and in and out of the metadata service. APIs are built using general best practices of REST API design. We take a schema-first approach by defining Types and Entities in JSON Schema. We implement APIs based on these schemas.  ## Overview  ### URI  Following REST API conventions are followed for Resource URIs: - Operations for an entity are available through the Resource URI as a collection `.../api/<version>/entities`.  - Plural of the entity name is used as the collection name - example `.../api/v1/users`. - Trailing forward slash is not used in the endpoint URI. Example use `.../api/v1/databases` instead of `.../api/v1/databases/`. - Resource URI for an entity instance by the entity id is `.../api/v1/entities/{id}`.  - Resource URI for an entity instance by name is `.../api/v1/entities/name/{name}`.  ### Resource Representation  - The REST API calls return a response with JSON `Content-Type` and `Content-Length` that includes the length of the response. - All responses include the Resource ID field even though the id was provided in the request to simplify the consumption    of the response at the client. - Entity names and field names use `camelCase` per Javascript naming convention. - All resources include an attribute `href` with Resource URI. All relationship fields of an entity will also    include `href` links to the related resource for easy access. - Unknown fields sent by the client in API requests are not ignored to ensure the data sent by the client is not dropped    at the server without the user being aware of it.  ## API Organization  You can find the swagger documentation [here](/swagger.html). In a nutshell:  **Data Asset APIs** - support operations related to data asset entities. - `.../api/v1/databases` - `...api/v1/tables` - `.../api/v1/metrics` - `.../api/v1/dashboards` - `.../api/v1/reports` - `.../api/v1/pipelines` - `.../api/v1/topics`  **Service APIs** - support operations related to services from which metadata is collected: - `.../api/v1/services` is the collection of all service resources. - `.../api/v1/services/databaseService` - APIs related to database services. This includes Transactional databases - MySQL, Postgres, MSSQL, Oracle, and Data Warehouses - Apache Hive BigQuery, Redshift, and Snowflake. - `.../api/v1/services/dashboardService` - APIs related to Dashboard Services. This includes Looker, Superset, and Tableau. - `.../api/v1/services/messagingService` - APIs related to Messaging Services. This includes Apache Kafka, Redpanda, - Kinesis, and others.  **Teams & Users APIs** - `.../api/v1/teams` - APIs related to team entities - `.../api/v1/users` - APIs related to user entities  **Search & Suggest APIs** - support search and suggest APIs: - `.../api/v1/search` - collection for search and suggest APIs - `.../api/v1/search/query` - search entities using query text - `.../api/v1/search/suggest` - get suggested entities used for auto-completion  **Other APIs** - `.../api/v1/tags` for APIs related to Classification and Tag entities - `../api/v1/feeds` for APIs related to Threads and Posts entities - `.../api/v1/usage` for reporting usage information of entities
 *
 * The version of the OpenAPI document: 1.2.2
 * Contact: openmetadata-dev@googlegroups.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.openmetadata.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.openmetadata.client.model.ChangeDescription;
import org.openmetadata.client.model.EntityReference;
import org.openmetadata.client.model.FilteringRules;
import org.openmetadata.client.model.LifeCycle;
import org.openmetadata.client.model.Style;
import org.openmetadata.client.model.SubscriptionStatus;
import org.openmetadata.client.model.TagLabel;
import org.openmetadata.client.model.TriggerConfig;
import org.openmetadata.client.model.Votes;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * EventSubscription
 */
@JsonPropertyOrder({
  EventSubscription.JSON_PROPERTY_ALERT_TYPE,
  EventSubscription.JSON_PROPERTY_BATCH_SIZE,
  EventSubscription.JSON_PROPERTY_CHANGE_DESCRIPTION,
  EventSubscription.JSON_PROPERTY_CHILDREN,
  EventSubscription.JSON_PROPERTY_DATA_PRODUCTS,
  EventSubscription.JSON_PROPERTY_DELETED,
  EventSubscription.JSON_PROPERTY_DESCRIPTION,
  EventSubscription.JSON_PROPERTY_DISPLAY_NAME,
  EventSubscription.JSON_PROPERTY_DOMAIN,
  EventSubscription.JSON_PROPERTY_ENABLED,
  EventSubscription.JSON_PROPERTY_EXPERTS,
  EventSubscription.JSON_PROPERTY_EXTENSION,
  EventSubscription.JSON_PROPERTY_FILTERING_RULES,
  EventSubscription.JSON_PROPERTY_FOLLOWERS,
  EventSubscription.JSON_PROPERTY_FULLY_QUALIFIED_NAME,
  EventSubscription.JSON_PROPERTY_HREF,
  EventSubscription.JSON_PROPERTY_ID,
  EventSubscription.JSON_PROPERTY_LIFE_CYCLE,
  EventSubscription.JSON_PROPERTY_NAME,
  EventSubscription.JSON_PROPERTY_OWNER,
  EventSubscription.JSON_PROPERTY_PROVIDER,
  EventSubscription.JSON_PROPERTY_READ_TIMEOUT,
  EventSubscription.JSON_PROPERTY_REVIEWERS,
  EventSubscription.JSON_PROPERTY_STATUS_DETAILS,
  EventSubscription.JSON_PROPERTY_STYLE,
  EventSubscription.JSON_PROPERTY_SUBSCRIPTION_CONFIG,
  EventSubscription.JSON_PROPERTY_SUBSCRIPTION_TYPE,
  EventSubscription.JSON_PROPERTY_TAGS,
  EventSubscription.JSON_PROPERTY_TIMEOUT,
  EventSubscription.JSON_PROPERTY_TRIGGER,
  EventSubscription.JSON_PROPERTY_UPDATED_AT,
  EventSubscription.JSON_PROPERTY_UPDATED_BY,
  EventSubscription.JSON_PROPERTY_VERSION,
  EventSubscription.JSON_PROPERTY_VOTES
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-20T11:35:38.398944261Z[Etc/UTC]")
public class EventSubscription {
  /**
   * Gets or Sets alertType
   */
  public enum AlertTypeEnum {
    CHANGEEVENT("ChangeEvent"),
    
    DATAINSIGHTREPORT("DataInsightReport"),
    
    TASK_CONVERSATION_ANNOUNCEMENT("Task/Conversation/Announcement");

    private String value;

    AlertTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static AlertTypeEnum fromValue(String value) {
      for (AlertTypeEnum b : AlertTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_ALERT_TYPE = "alertType";
  private AlertTypeEnum alertType;

  public static final String JSON_PROPERTY_BATCH_SIZE = "batchSize";
  private Integer batchSize;

  public static final String JSON_PROPERTY_CHANGE_DESCRIPTION = "changeDescription";
  private ChangeDescription changeDescription;

  public static final String JSON_PROPERTY_CHILDREN = "children";
  private List<EntityReference> children = null;

  public static final String JSON_PROPERTY_DATA_PRODUCTS = "dataProducts";
  private List<EntityReference> dataProducts = null;

  public static final String JSON_PROPERTY_DELETED = "deleted";
  private Boolean deleted;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description;

  public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
  private String displayName;

  public static final String JSON_PROPERTY_DOMAIN = "domain";
  private EntityReference domain;

  public static final String JSON_PROPERTY_ENABLED = "enabled";
  private Boolean enabled;

  public static final String JSON_PROPERTY_EXPERTS = "experts";
  private List<EntityReference> experts = null;

  public static final String JSON_PROPERTY_EXTENSION = "extension";
  private Object extension;

  public static final String JSON_PROPERTY_FILTERING_RULES = "filteringRules";
  private FilteringRules filteringRules;

  public static final String JSON_PROPERTY_FOLLOWERS = "followers";
  private List<EntityReference> followers = null;

  public static final String JSON_PROPERTY_FULLY_QUALIFIED_NAME = "fullyQualifiedName";
  private String fullyQualifiedName;

  public static final String JSON_PROPERTY_HREF = "href";
  private URI href;

  public static final String JSON_PROPERTY_ID = "id";
  private UUID id;

  public static final String JSON_PROPERTY_LIFE_CYCLE = "lifeCycle";
  private LifeCycle lifeCycle;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_OWNER = "owner";
  private EntityReference owner;

  /**
   * Gets or Sets provider
   */
  public enum ProviderEnum {
    SYSTEM("system"),
    
    USER("user");

    private String value;

    ProviderEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ProviderEnum fromValue(String value) {
      for (ProviderEnum b : ProviderEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PROVIDER = "provider";
  private ProviderEnum provider;

  public static final String JSON_PROPERTY_READ_TIMEOUT = "readTimeout";
  private Integer readTimeout;

  public static final String JSON_PROPERTY_REVIEWERS = "reviewers";
  private List<EntityReference> reviewers = null;

  public static final String JSON_PROPERTY_STATUS_DETAILS = "statusDetails";
  private SubscriptionStatus statusDetails;

  public static final String JSON_PROPERTY_STYLE = "style";
  private Style style;

  public static final String JSON_PROPERTY_SUBSCRIPTION_CONFIG = "subscriptionConfig";
  private Object subscriptionConfig;

  /**
   * Gets or Sets subscriptionType
   */
  public enum SubscriptionTypeEnum {
    GENERICWEBHOOK("GenericWebhook"),
    
    SLACKWEBHOOK("SlackWebhook"),
    
    MSTEAMSWEBHOOK("MsTeamsWebhook"),
    
    GCHATWEBHOOK("GChatWebhook"),
    
    EMAIL("Email"),
    
    ACTIVITYFEED("ActivityFeed"),
    
    DATAINSIGHT("DataInsight");

    private String value;

    SubscriptionTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static SubscriptionTypeEnum fromValue(String value) {
      for (SubscriptionTypeEnum b : SubscriptionTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_SUBSCRIPTION_TYPE = "subscriptionType";
  private SubscriptionTypeEnum subscriptionType;

  public static final String JSON_PROPERTY_TAGS = "tags";
  private List<TagLabel> tags = null;

  public static final String JSON_PROPERTY_TIMEOUT = "timeout";
  private Integer timeout;

  public static final String JSON_PROPERTY_TRIGGER = "trigger";
  private TriggerConfig trigger;

  public static final String JSON_PROPERTY_UPDATED_AT = "updatedAt";
  private Long updatedAt;

  public static final String JSON_PROPERTY_UPDATED_BY = "updatedBy";
  private String updatedBy;

  public static final String JSON_PROPERTY_VERSION = "version";
  private Double version;

  public static final String JSON_PROPERTY_VOTES = "votes";
  private Votes votes;

  public EventSubscription() { 
  }

  public EventSubscription alertType(AlertTypeEnum alertType) {
    
    this.alertType = alertType;
    return this;
  }

   /**
   * Get alertType
   * @return alertType
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_ALERT_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public AlertTypeEnum getAlertType() {
    return alertType;
  }


  @JsonProperty(JSON_PROPERTY_ALERT_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAlertType(AlertTypeEnum alertType) {
    this.alertType = alertType;
  }


  public EventSubscription batchSize(Integer batchSize) {
    
    this.batchSize = batchSize;
    return this;
  }

   /**
   * Get batchSize
   * @return batchSize
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_BATCH_SIZE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getBatchSize() {
    return batchSize;
  }


  @JsonProperty(JSON_PROPERTY_BATCH_SIZE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBatchSize(Integer batchSize) {
    this.batchSize = batchSize;
  }


  public EventSubscription changeDescription(ChangeDescription changeDescription) {
    
    this.changeDescription = changeDescription;
    return this;
  }

   /**
   * Get changeDescription
   * @return changeDescription
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CHANGE_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ChangeDescription getChangeDescription() {
    return changeDescription;
  }


  @JsonProperty(JSON_PROPERTY_CHANGE_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChangeDescription(ChangeDescription changeDescription) {
    this.changeDescription = changeDescription;
  }


  public EventSubscription children(List<EntityReference> children) {
    
    this.children = children;
    return this;
  }

  public EventSubscription addChildrenItem(EntityReference childrenItem) {
    if (this.children == null) {
      this.children = new ArrayList<>();
    }
    this.children.add(childrenItem);
    return this;
  }

   /**
   * Get children
   * @return children
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CHILDREN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<EntityReference> getChildren() {
    return children;
  }


  @JsonProperty(JSON_PROPERTY_CHILDREN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChildren(List<EntityReference> children) {
    this.children = children;
  }


  public EventSubscription dataProducts(List<EntityReference> dataProducts) {
    
    this.dataProducts = dataProducts;
    return this;
  }

  public EventSubscription addDataProductsItem(EntityReference dataProductsItem) {
    if (this.dataProducts == null) {
      this.dataProducts = new ArrayList<>();
    }
    this.dataProducts.add(dataProductsItem);
    return this;
  }

   /**
   * Get dataProducts
   * @return dataProducts
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DATA_PRODUCTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<EntityReference> getDataProducts() {
    return dataProducts;
  }


  @JsonProperty(JSON_PROPERTY_DATA_PRODUCTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDataProducts(List<EntityReference> dataProducts) {
    this.dataProducts = dataProducts;
  }


  public EventSubscription deleted(Boolean deleted) {
    
    this.deleted = deleted;
    return this;
  }

   /**
   * Get deleted
   * @return deleted
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DELETED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getDeleted() {
    return deleted;
  }


  @JsonProperty(JSON_PROPERTY_DELETED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDeleted(Boolean deleted) {
    this.deleted = deleted;
  }


  public EventSubscription description(String description) {
    
    this.description = description;
    return this;
  }

   /**
   * Get description
   * @return description
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDescription() {
    return description;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(String description) {
    this.description = description;
  }


  public EventSubscription displayName(String displayName) {
    
    this.displayName = displayName;
    return this;
  }

   /**
   * Get displayName
   * @return displayName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DISPLAY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDisplayName() {
    return displayName;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisplayName(String displayName) {
    this.displayName = displayName;
  }


  public EventSubscription domain(EntityReference domain) {
    
    this.domain = domain;
    return this;
  }

   /**
   * Get domain
   * @return domain
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DOMAIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public EntityReference getDomain() {
    return domain;
  }


  @JsonProperty(JSON_PROPERTY_DOMAIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDomain(EntityReference domain) {
    this.domain = domain;
  }


  public EventSubscription enabled(Boolean enabled) {
    
    this.enabled = enabled;
    return this;
  }

   /**
   * Get enabled
   * @return enabled
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ENABLED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getEnabled() {
    return enabled;
  }


  @JsonProperty(JSON_PROPERTY_ENABLED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEnabled(Boolean enabled) {
    this.enabled = enabled;
  }


  public EventSubscription experts(List<EntityReference> experts) {
    
    this.experts = experts;
    return this;
  }

  public EventSubscription addExpertsItem(EntityReference expertsItem) {
    if (this.experts == null) {
      this.experts = new ArrayList<>();
    }
    this.experts.add(expertsItem);
    return this;
  }

   /**
   * Get experts
   * @return experts
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_EXPERTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<EntityReference> getExperts() {
    return experts;
  }


  @JsonProperty(JSON_PROPERTY_EXPERTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExperts(List<EntityReference> experts) {
    this.experts = experts;
  }


  public EventSubscription extension(Object extension) {
    
    this.extension = extension;
    return this;
  }

   /**
   * Get extension
   * @return extension
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_EXTENSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getExtension() {
    return extension;
  }


  @JsonProperty(JSON_PROPERTY_EXTENSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExtension(Object extension) {
    this.extension = extension;
  }


  public EventSubscription filteringRules(FilteringRules filteringRules) {
    
    this.filteringRules = filteringRules;
    return this;
  }

   /**
   * Get filteringRules
   * @return filteringRules
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_FILTERING_RULES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public FilteringRules getFilteringRules() {
    return filteringRules;
  }


  @JsonProperty(JSON_PROPERTY_FILTERING_RULES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFilteringRules(FilteringRules filteringRules) {
    this.filteringRules = filteringRules;
  }


  public EventSubscription followers(List<EntityReference> followers) {
    
    this.followers = followers;
    return this;
  }

  public EventSubscription addFollowersItem(EntityReference followersItem) {
    if (this.followers == null) {
      this.followers = new ArrayList<>();
    }
    this.followers.add(followersItem);
    return this;
  }

   /**
   * Get followers
   * @return followers
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_FOLLOWERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<EntityReference> getFollowers() {
    return followers;
  }


  @JsonProperty(JSON_PROPERTY_FOLLOWERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFollowers(List<EntityReference> followers) {
    this.followers = followers;
  }


  public EventSubscription fullyQualifiedName(String fullyQualifiedName) {
    
    this.fullyQualifiedName = fullyQualifiedName;
    return this;
  }

   /**
   * Get fullyQualifiedName
   * @return fullyQualifiedName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_FULLY_QUALIFIED_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFullyQualifiedName() {
    return fullyQualifiedName;
  }


  @JsonProperty(JSON_PROPERTY_FULLY_QUALIFIED_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFullyQualifiedName(String fullyQualifiedName) {
    this.fullyQualifiedName = fullyQualifiedName;
  }


  public EventSubscription href(URI href) {
    
    this.href = href;
    return this;
  }

   /**
   * Get href
   * @return href
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_HREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public URI getHref() {
    return href;
  }


  @JsonProperty(JSON_PROPERTY_HREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHref(URI href) {
    this.href = href;
  }


  public EventSubscription id(UUID id) {
    
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setId(UUID id) {
    this.id = id;
  }


  public EventSubscription lifeCycle(LifeCycle lifeCycle) {
    
    this.lifeCycle = lifeCycle;
    return this;
  }

   /**
   * Get lifeCycle
   * @return lifeCycle
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_LIFE_CYCLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LifeCycle getLifeCycle() {
    return lifeCycle;
  }


  @JsonProperty(JSON_PROPERTY_LIFE_CYCLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLifeCycle(LifeCycle lifeCycle) {
    this.lifeCycle = lifeCycle;
  }


  public EventSubscription name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Get name
   * @return name
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public EventSubscription owner(EntityReference owner) {
    
    this.owner = owner;
    return this;
  }

   /**
   * Get owner
   * @return owner
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_OWNER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public EntityReference getOwner() {
    return owner;
  }


  @JsonProperty(JSON_PROPERTY_OWNER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOwner(EntityReference owner) {
    this.owner = owner;
  }


  public EventSubscription provider(ProviderEnum provider) {
    
    this.provider = provider;
    return this;
  }

   /**
   * Get provider
   * @return provider
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PROVIDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ProviderEnum getProvider() {
    return provider;
  }


  @JsonProperty(JSON_PROPERTY_PROVIDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProvider(ProviderEnum provider) {
    this.provider = provider;
  }


  public EventSubscription readTimeout(Integer readTimeout) {
    
    this.readTimeout = readTimeout;
    return this;
  }

   /**
   * Get readTimeout
   * @return readTimeout
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_READ_TIMEOUT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getReadTimeout() {
    return readTimeout;
  }


  @JsonProperty(JSON_PROPERTY_READ_TIMEOUT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReadTimeout(Integer readTimeout) {
    this.readTimeout = readTimeout;
  }


  public EventSubscription reviewers(List<EntityReference> reviewers) {
    
    this.reviewers = reviewers;
    return this;
  }

  public EventSubscription addReviewersItem(EntityReference reviewersItem) {
    if (this.reviewers == null) {
      this.reviewers = new ArrayList<>();
    }
    this.reviewers.add(reviewersItem);
    return this;
  }

   /**
   * Get reviewers
   * @return reviewers
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_REVIEWERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<EntityReference> getReviewers() {
    return reviewers;
  }


  @JsonProperty(JSON_PROPERTY_REVIEWERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReviewers(List<EntityReference> reviewers) {
    this.reviewers = reviewers;
  }


  public EventSubscription statusDetails(SubscriptionStatus statusDetails) {
    
    this.statusDetails = statusDetails;
    return this;
  }

   /**
   * Get statusDetails
   * @return statusDetails
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_STATUS_DETAILS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SubscriptionStatus getStatusDetails() {
    return statusDetails;
  }


  @JsonProperty(JSON_PROPERTY_STATUS_DETAILS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStatusDetails(SubscriptionStatus statusDetails) {
    this.statusDetails = statusDetails;
  }


  public EventSubscription style(Style style) {
    
    this.style = style;
    return this;
  }

   /**
   * Get style
   * @return style
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_STYLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Style getStyle() {
    return style;
  }


  @JsonProperty(JSON_PROPERTY_STYLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStyle(Style style) {
    this.style = style;
  }


  public EventSubscription subscriptionConfig(Object subscriptionConfig) {
    
    this.subscriptionConfig = subscriptionConfig;
    return this;
  }

   /**
   * Get subscriptionConfig
   * @return subscriptionConfig
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SUBSCRIPTION_CONFIG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getSubscriptionConfig() {
    return subscriptionConfig;
  }


  @JsonProperty(JSON_PROPERTY_SUBSCRIPTION_CONFIG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubscriptionConfig(Object subscriptionConfig) {
    this.subscriptionConfig = subscriptionConfig;
  }


  public EventSubscription subscriptionType(SubscriptionTypeEnum subscriptionType) {
    
    this.subscriptionType = subscriptionType;
    return this;
  }

   /**
   * Get subscriptionType
   * @return subscriptionType
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_SUBSCRIPTION_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public SubscriptionTypeEnum getSubscriptionType() {
    return subscriptionType;
  }


  @JsonProperty(JSON_PROPERTY_SUBSCRIPTION_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSubscriptionType(SubscriptionTypeEnum subscriptionType) {
    this.subscriptionType = subscriptionType;
  }


  public EventSubscription tags(List<TagLabel> tags) {
    
    this.tags = tags;
    return this;
  }

  public EventSubscription addTagsItem(TagLabel tagsItem) {
    if (this.tags == null) {
      this.tags = new ArrayList<>();
    }
    this.tags.add(tagsItem);
    return this;
  }

   /**
   * Get tags
   * @return tags
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<TagLabel> getTags() {
    return tags;
  }


  @JsonProperty(JSON_PROPERTY_TAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTags(List<TagLabel> tags) {
    this.tags = tags;
  }


  public EventSubscription timeout(Integer timeout) {
    
    this.timeout = timeout;
    return this;
  }

   /**
   * Get timeout
   * @return timeout
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TIMEOUT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getTimeout() {
    return timeout;
  }


  @JsonProperty(JSON_PROPERTY_TIMEOUT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTimeout(Integer timeout) {
    this.timeout = timeout;
  }


  public EventSubscription trigger(TriggerConfig trigger) {
    
    this.trigger = trigger;
    return this;
  }

   /**
   * Get trigger
   * @return trigger
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TRIGGER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TriggerConfig getTrigger() {
    return trigger;
  }


  @JsonProperty(JSON_PROPERTY_TRIGGER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTrigger(TriggerConfig trigger) {
    this.trigger = trigger;
  }


  public EventSubscription updatedAt(Long updatedAt) {
    
    this.updatedAt = updatedAt;
    return this;
  }

   /**
   * Get updatedAt
   * @return updatedAt
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_UPDATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getUpdatedAt() {
    return updatedAt;
  }


  @JsonProperty(JSON_PROPERTY_UPDATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUpdatedAt(Long updatedAt) {
    this.updatedAt = updatedAt;
  }


  public EventSubscription updatedBy(String updatedBy) {
    
    this.updatedBy = updatedBy;
    return this;
  }

   /**
   * Get updatedBy
   * @return updatedBy
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_UPDATED_BY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getUpdatedBy() {
    return updatedBy;
  }


  @JsonProperty(JSON_PROPERTY_UPDATED_BY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUpdatedBy(String updatedBy) {
    this.updatedBy = updatedBy;
  }


  public EventSubscription version(Double version) {
    
    this.version = version;
    return this;
  }

   /**
   * Get version
   * @return version
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getVersion() {
    return version;
  }


  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVersion(Double version) {
    this.version = version;
  }


  public EventSubscription votes(Votes votes) {
    
    this.votes = votes;
    return this;
  }

   /**
   * Get votes
   * @return votes
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_VOTES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Votes getVotes() {
    return votes;
  }


  @JsonProperty(JSON_PROPERTY_VOTES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVotes(Votes votes) {
    this.votes = votes;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    EventSubscription eventSubscription = (EventSubscription) o;
    return Objects.equals(this.alertType, eventSubscription.alertType) &&
        Objects.equals(this.batchSize, eventSubscription.batchSize) &&
        Objects.equals(this.changeDescription, eventSubscription.changeDescription) &&
        Objects.equals(this.children, eventSubscription.children) &&
        Objects.equals(this.dataProducts, eventSubscription.dataProducts) &&
        Objects.equals(this.deleted, eventSubscription.deleted) &&
        Objects.equals(this.description, eventSubscription.description) &&
        Objects.equals(this.displayName, eventSubscription.displayName) &&
        Objects.equals(this.domain, eventSubscription.domain) &&
        Objects.equals(this.enabled, eventSubscription.enabled) &&
        Objects.equals(this.experts, eventSubscription.experts) &&
        Objects.equals(this.extension, eventSubscription.extension) &&
        Objects.equals(this.filteringRules, eventSubscription.filteringRules) &&
        Objects.equals(this.followers, eventSubscription.followers) &&
        Objects.equals(this.fullyQualifiedName, eventSubscription.fullyQualifiedName) &&
        Objects.equals(this.href, eventSubscription.href) &&
        Objects.equals(this.id, eventSubscription.id) &&
        Objects.equals(this.lifeCycle, eventSubscription.lifeCycle) &&
        Objects.equals(this.name, eventSubscription.name) &&
        Objects.equals(this.owner, eventSubscription.owner) &&
        Objects.equals(this.provider, eventSubscription.provider) &&
        Objects.equals(this.readTimeout, eventSubscription.readTimeout) &&
        Objects.equals(this.reviewers, eventSubscription.reviewers) &&
        Objects.equals(this.statusDetails, eventSubscription.statusDetails) &&
        Objects.equals(this.style, eventSubscription.style) &&
        Objects.equals(this.subscriptionConfig, eventSubscription.subscriptionConfig) &&
        Objects.equals(this.subscriptionType, eventSubscription.subscriptionType) &&
        Objects.equals(this.tags, eventSubscription.tags) &&
        Objects.equals(this.timeout, eventSubscription.timeout) &&
        Objects.equals(this.trigger, eventSubscription.trigger) &&
        Objects.equals(this.updatedAt, eventSubscription.updatedAt) &&
        Objects.equals(this.updatedBy, eventSubscription.updatedBy) &&
        Objects.equals(this.version, eventSubscription.version) &&
        Objects.equals(this.votes, eventSubscription.votes);
  }

  @Override
  public int hashCode() {
    return Objects.hash(alertType, batchSize, changeDescription, children, dataProducts, deleted, description, displayName, domain, enabled, experts, extension, filteringRules, followers, fullyQualifiedName, href, id, lifeCycle, name, owner, provider, readTimeout, reviewers, statusDetails, style, subscriptionConfig, subscriptionType, tags, timeout, trigger, updatedAt, updatedBy, version, votes);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class EventSubscription {\n");
    sb.append("    alertType: ").append(toIndentedString(alertType)).append("\n");
    sb.append("    batchSize: ").append(toIndentedString(batchSize)).append("\n");
    sb.append("    changeDescription: ").append(toIndentedString(changeDescription)).append("\n");
    sb.append("    children: ").append(toIndentedString(children)).append("\n");
    sb.append("    dataProducts: ").append(toIndentedString(dataProducts)).append("\n");
    sb.append("    deleted: ").append(toIndentedString(deleted)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    displayName: ").append(toIndentedString(displayName)).append("\n");
    sb.append("    domain: ").append(toIndentedString(domain)).append("\n");
    sb.append("    enabled: ").append(toIndentedString(enabled)).append("\n");
    sb.append("    experts: ").append(toIndentedString(experts)).append("\n");
    sb.append("    extension: ").append(toIndentedString(extension)).append("\n");
    sb.append("    filteringRules: ").append(toIndentedString(filteringRules)).append("\n");
    sb.append("    followers: ").append(toIndentedString(followers)).append("\n");
    sb.append("    fullyQualifiedName: ").append(toIndentedString(fullyQualifiedName)).append("\n");
    sb.append("    href: ").append(toIndentedString(href)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    lifeCycle: ").append(toIndentedString(lifeCycle)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    owner: ").append(toIndentedString(owner)).append("\n");
    sb.append("    provider: ").append(toIndentedString(provider)).append("\n");
    sb.append("    readTimeout: ").append(toIndentedString(readTimeout)).append("\n");
    sb.append("    reviewers: ").append(toIndentedString(reviewers)).append("\n");
    sb.append("    statusDetails: ").append(toIndentedString(statusDetails)).append("\n");
    sb.append("    style: ").append(toIndentedString(style)).append("\n");
    sb.append("    subscriptionConfig: ").append(toIndentedString(subscriptionConfig)).append("\n");
    sb.append("    subscriptionType: ").append(toIndentedString(subscriptionType)).append("\n");
    sb.append("    tags: ").append(toIndentedString(tags)).append("\n");
    sb.append("    timeout: ").append(toIndentedString(timeout)).append("\n");
    sb.append("    trigger: ").append(toIndentedString(trigger)).append("\n");
    sb.append("    updatedAt: ").append(toIndentedString(updatedAt)).append("\n");
    sb.append("    updatedBy: ").append(toIndentedString(updatedBy)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    votes: ").append(toIndentedString(votes)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

