/*
 * OpenMetadata Apis
 * --- title: APIs slug: /main-concepts/metadata-standard/apis ---  # APIs  OpenMetadata supports REST APIs for getting data and in and out of the metadata service. APIs are built using general best practices of REST API design. We take a schema-first approach by defining Types and Entities in JSON Schema. We implement APIs based on these schemas.  ## Overview  ### URI  Following REST API conventions are followed for Resource URIs: - Operations for an entity are available through the Resource URI as a collection `.../api/<version>/entities`.  - Plural of the entity name is used as the collection name - example `.../api/v1/users`. - Trailing forward slash is not used in the endpoint URI. Example use `.../api/v1/databases` instead of `.../api/v1/databases/`. - Resource URI for an entity instance by the entity id is `.../api/v1/entities/{id}`.  - Resource URI for an entity instance by name is `.../api/v1/entities/name/{name}`.  ### Resource Representation  - The REST API calls return a response with JSON `Content-Type` and `Content-Length` that includes the length of the response. - All responses include the Resource ID field even though the id was provided in the request to simplify the consumption    of the response at the client. - Entity names and field names use `camelCase` per Javascript naming convention. - All resources include an attribute `href` with Resource URI. All relationship fields of an entity will also    include `href` links to the related resource for easy access. - Unknown fields sent by the client in API requests are not ignored to ensure the data sent by the client is not dropped    at the server without the user being aware of it.  ## API Organization  You can find the swagger documentation [here](/swagger.html). In a nutshell:  **Data Asset APIs** - support operations related to data asset entities. - `.../api/v1/databases` - `...api/v1/tables` - `.../api/v1/metrics` - `.../api/v1/dashboards` - `.../api/v1/reports` - `.../api/v1/pipelines` - `.../api/v1/topics`  **Service APIs** - support operations related to services from which metadata is collected: - `.../api/v1/services` is the collection of all service resources. - `.../api/v1/services/databaseService` - APIs related to database services. This includes Transactional databases - MySQL, Postgres, MSSQL, Oracle, and Data Warehouses - Apache Hive BigQuery, Redshift, and Snowflake. - `.../api/v1/services/dashboardService` - APIs related to Dashboard Services. This includes Looker, Superset, and Tableau. - `.../api/v1/services/messagingService` - APIs related to Messaging Services. This includes Apache Kafka, Redpanda, - Kinesis, and others.  **Teams & Users APIs** - `.../api/v1/teams` - APIs related to team entities - `.../api/v1/users` - APIs related to user entities  **Search & Suggest APIs** - support search and suggest APIs: - `.../api/v1/search` - collection for search and suggest APIs - `.../api/v1/search/query` - search entities using query text - `.../api/v1/search/suggest` - get suggested entities used for auto-completion  **Other APIs** - `.../api/v1/tags` for APIs related to Classification and Tag entities - `../api/v1/feeds` for APIs related to Threads and Posts entities - `.../api/v1/usage` for reporting usage information of entities
 *
 * The version of the OpenAPI document: 1.2.2
 * Contact: openmetadata-dev@googlegroups.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.openmetadata.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.net.URI;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * ImageList
 */
@JsonPropertyOrder({
  ImageList.JSON_PROPERTY_IMAGE,
  ImageList.JSON_PROPERTY_IMAGE192,
  ImageList.JSON_PROPERTY_IMAGE24,
  ImageList.JSON_PROPERTY_IMAGE32,
  ImageList.JSON_PROPERTY_IMAGE48,
  ImageList.JSON_PROPERTY_IMAGE512,
  ImageList.JSON_PROPERTY_IMAGE72
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-20T11:35:38.398944261Z[Etc/UTC]")
public class ImageList {
  public static final String JSON_PROPERTY_IMAGE = "image";
  private URI image;

  public static final String JSON_PROPERTY_IMAGE192 = "image192";
  private URI image192;

  public static final String JSON_PROPERTY_IMAGE24 = "image24";
  private URI image24;

  public static final String JSON_PROPERTY_IMAGE32 = "image32";
  private URI image32;

  public static final String JSON_PROPERTY_IMAGE48 = "image48";
  private URI image48;

  public static final String JSON_PROPERTY_IMAGE512 = "image512";
  private URI image512;

  public static final String JSON_PROPERTY_IMAGE72 = "image72";
  private URI image72;

  public ImageList() { 
  }

  public ImageList image(URI image) {
    
    this.image = image;
    return this;
  }

   /**
   * Get image
   * @return image
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_IMAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public URI getImage() {
    return image;
  }


  @JsonProperty(JSON_PROPERTY_IMAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setImage(URI image) {
    this.image = image;
  }


  public ImageList image192(URI image192) {
    
    this.image192 = image192;
    return this;
  }

   /**
   * Get image192
   * @return image192
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_IMAGE192)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public URI getImage192() {
    return image192;
  }


  @JsonProperty(JSON_PROPERTY_IMAGE192)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setImage192(URI image192) {
    this.image192 = image192;
  }


  public ImageList image24(URI image24) {
    
    this.image24 = image24;
    return this;
  }

   /**
   * Get image24
   * @return image24
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_IMAGE24)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public URI getImage24() {
    return image24;
  }


  @JsonProperty(JSON_PROPERTY_IMAGE24)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setImage24(URI image24) {
    this.image24 = image24;
  }


  public ImageList image32(URI image32) {
    
    this.image32 = image32;
    return this;
  }

   /**
   * Get image32
   * @return image32
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_IMAGE32)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public URI getImage32() {
    return image32;
  }


  @JsonProperty(JSON_PROPERTY_IMAGE32)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setImage32(URI image32) {
    this.image32 = image32;
  }


  public ImageList image48(URI image48) {
    
    this.image48 = image48;
    return this;
  }

   /**
   * Get image48
   * @return image48
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_IMAGE48)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public URI getImage48() {
    return image48;
  }


  @JsonProperty(JSON_PROPERTY_IMAGE48)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setImage48(URI image48) {
    this.image48 = image48;
  }


  public ImageList image512(URI image512) {
    
    this.image512 = image512;
    return this;
  }

   /**
   * Get image512
   * @return image512
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_IMAGE512)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public URI getImage512() {
    return image512;
  }


  @JsonProperty(JSON_PROPERTY_IMAGE512)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setImage512(URI image512) {
    this.image512 = image512;
  }


  public ImageList image72(URI image72) {
    
    this.image72 = image72;
    return this;
  }

   /**
   * Get image72
   * @return image72
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_IMAGE72)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public URI getImage72() {
    return image72;
  }


  @JsonProperty(JSON_PROPERTY_IMAGE72)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setImage72(URI image72) {
    this.image72 = image72;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ImageList imageList = (ImageList) o;
    return Objects.equals(this.image, imageList.image) &&
        Objects.equals(this.image192, imageList.image192) &&
        Objects.equals(this.image24, imageList.image24) &&
        Objects.equals(this.image32, imageList.image32) &&
        Objects.equals(this.image48, imageList.image48) &&
        Objects.equals(this.image512, imageList.image512) &&
        Objects.equals(this.image72, imageList.image72);
  }

  @Override
  public int hashCode() {
    return Objects.hash(image, image192, image24, image32, image48, image512, image72);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ImageList {\n");
    sb.append("    image: ").append(toIndentedString(image)).append("\n");
    sb.append("    image192: ").append(toIndentedString(image192)).append("\n");
    sb.append("    image24: ").append(toIndentedString(image24)).append("\n");
    sb.append("    image32: ").append(toIndentedString(image32)).append("\n");
    sb.append("    image48: ").append(toIndentedString(image48)).append("\n");
    sb.append("    image512: ").append(toIndentedString(image512)).append("\n");
    sb.append("    image72: ").append(toIndentedString(image72)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

