/*
 * OpenMetadata Apis
 * --- title: APIs slug: /main-concepts/metadata-standard/apis ---  # APIs  OpenMetadata supports REST APIs for getting data and in and out of the metadata service. APIs are built using general best practices of REST API design. We take a schema-first approach by defining Types and Entities in JSON Schema. We implement APIs based on these schemas.  ## Overview  ### URI  Following REST API conventions are followed for Resource URIs: - Operations for an entity are available through the Resource URI as a collection `.../api/<version>/entities`.  - Plural of the entity name is used as the collection name - example `.../api/v1/users`. - Trailing forward slash is not used in the endpoint URI. Example use `.../api/v1/databases` instead of `.../api/v1/databases/`. - Resource URI for an entity instance by the entity id is `.../api/v1/entities/{id}`.  - Resource URI for an entity instance by name is `.../api/v1/entities/name/{name}`.  ### Resource Representation  - The REST API calls return a response with JSON `Content-Type` and `Content-Length` that includes the length of the response. - All responses include the Resource ID field even though the id was provided in the request to simplify the consumption    of the response at the client. - Entity names and field names use `camelCase` per Javascript naming convention. - All resources include an attribute `href` with Resource URI. All relationship fields of an entity will also    include `href` links to the related resource for easy access. - Unknown fields sent by the client in API requests are not ignored to ensure the data sent by the client is not dropped    at the server without the user being aware of it.  ## API Organization  You can find the swagger documentation [here](/swagger.html). In a nutshell:  **Data Asset APIs** - support operations related to data asset entities. - `.../api/v1/databases` - `...api/v1/tables` - `.../api/v1/metrics` - `.../api/v1/dashboards` - `.../api/v1/reports` - `.../api/v1/pipelines` - `.../api/v1/topics`  **Service APIs** - support operations related to services from which metadata is collected: - `.../api/v1/services` is the collection of all service resources. - `.../api/v1/services/databaseService` - APIs related to database services. This includes Transactional databases - MySQL, Postgres, MSSQL, Oracle, and Data Warehouses - Apache Hive BigQuery, Redshift, and Snowflake. - `.../api/v1/services/dashboardService` - APIs related to Dashboard Services. This includes Looker, Superset, and Tableau. - `.../api/v1/services/messagingService` - APIs related to Messaging Services. This includes Apache Kafka, Redpanda, - Kinesis, and others.  **Teams & Users APIs** - `.../api/v1/teams` - APIs related to team entities - `.../api/v1/users` - APIs related to user entities  **Search & Suggest APIs** - support search and suggest APIs: - `.../api/v1/search` - collection for search and suggest APIs - `.../api/v1/search/query` - search entities using query text - `.../api/v1/search/suggest` - get suggested entities used for auto-completion  **Other APIs** - `.../api/v1/tags` for APIs related to Classification and Tag entities - `../api/v1/feeds` for APIs related to Threads and Posts entities - `.../api/v1/usage` for reporting usage information of entities
 *
 * The version of the OpenAPI document: 1.2.2
 * Contact: openmetadata-dev@googlegroups.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.openmetadata.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.openmetadata.client.model.ColumnLineage;
import org.openmetadata.client.model.EntityReference;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * LineageDetails
 */
@JsonPropertyOrder({
  LineageDetails.JSON_PROPERTY_COLUMNS_LINEAGE,
  LineageDetails.JSON_PROPERTY_DESCRIPTION,
  LineageDetails.JSON_PROPERTY_PIPELINE,
  LineageDetails.JSON_PROPERTY_SOURCE,
  LineageDetails.JSON_PROPERTY_SQL_QUERY
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-20T11:35:38.398944261Z[Etc/UTC]")
public class LineageDetails {
  public static final String JSON_PROPERTY_COLUMNS_LINEAGE = "columnsLineage";
  private List<ColumnLineage> columnsLineage = null;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description;

  public static final String JSON_PROPERTY_PIPELINE = "pipeline";
  private EntityReference pipeline;

  /**
   * Gets or Sets source
   */
  public enum SourceEnum {
    MANUAL("Manual"),
    
    VIEWLINEAGE("ViewLineage"),
    
    QUERYLINEAGE("QueryLineage"),
    
    PIPELINELINEAGE("PipelineLineage"),
    
    DASHBOARDLINEAGE("DashboardLineage"),
    
    DBTLINEAGE("DbtLineage");

    private String value;

    SourceEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static SourceEnum fromValue(String value) {
      for (SourceEnum b : SourceEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_SOURCE = "source";
  private SourceEnum source;

  public static final String JSON_PROPERTY_SQL_QUERY = "sqlQuery";
  private String sqlQuery;

  public LineageDetails() { 
  }

  public LineageDetails columnsLineage(List<ColumnLineage> columnsLineage) {
    
    this.columnsLineage = columnsLineage;
    return this;
  }

  public LineageDetails addColumnsLineageItem(ColumnLineage columnsLineageItem) {
    if (this.columnsLineage == null) {
      this.columnsLineage = new ArrayList<>();
    }
    this.columnsLineage.add(columnsLineageItem);
    return this;
  }

   /**
   * Get columnsLineage
   * @return columnsLineage
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_COLUMNS_LINEAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ColumnLineage> getColumnsLineage() {
    return columnsLineage;
  }


  @JsonProperty(JSON_PROPERTY_COLUMNS_LINEAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setColumnsLineage(List<ColumnLineage> columnsLineage) {
    this.columnsLineage = columnsLineage;
  }


  public LineageDetails description(String description) {
    
    this.description = description;
    return this;
  }

   /**
   * Get description
   * @return description
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDescription() {
    return description;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(String description) {
    this.description = description;
  }


  public LineageDetails pipeline(EntityReference pipeline) {
    
    this.pipeline = pipeline;
    return this;
  }

   /**
   * Get pipeline
   * @return pipeline
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PIPELINE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public EntityReference getPipeline() {
    return pipeline;
  }


  @JsonProperty(JSON_PROPERTY_PIPELINE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPipeline(EntityReference pipeline) {
    this.pipeline = pipeline;
  }


  public LineageDetails source(SourceEnum source) {
    
    this.source = source;
    return this;
  }

   /**
   * Get source
   * @return source
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SourceEnum getSource() {
    return source;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSource(SourceEnum source) {
    this.source = source;
  }


  public LineageDetails sqlQuery(String sqlQuery) {
    
    this.sqlQuery = sqlQuery;
    return this;
  }

   /**
   * Get sqlQuery
   * @return sqlQuery
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SQL_QUERY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSqlQuery() {
    return sqlQuery;
  }


  @JsonProperty(JSON_PROPERTY_SQL_QUERY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSqlQuery(String sqlQuery) {
    this.sqlQuery = sqlQuery;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LineageDetails lineageDetails = (LineageDetails) o;
    return Objects.equals(this.columnsLineage, lineageDetails.columnsLineage) &&
        Objects.equals(this.description, lineageDetails.description) &&
        Objects.equals(this.pipeline, lineageDetails.pipeline) &&
        Objects.equals(this.source, lineageDetails.source) &&
        Objects.equals(this.sqlQuery, lineageDetails.sqlQuery);
  }

  @Override
  public int hashCode() {
    return Objects.hash(columnsLineage, description, pipeline, source, sqlQuery);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class LineageDetails {\n");
    sb.append("    columnsLineage: ").append(toIndentedString(columnsLineage)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    pipeline: ").append(toIndentedString(pipeline)).append("\n");
    sb.append("    source: ").append(toIndentedString(source)).append("\n");
    sb.append("    sqlQuery: ").append(toIndentedString(sqlQuery)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

