/*
 * OpenMetadata Apis
 * --- title: APIs slug: /main-concepts/metadata-standard/apis ---  # APIs  OpenMetadata supports REST APIs for getting data and in and out of the metadata service. APIs are built using general best practices of REST API design. We take a schema-first approach by defining Types and Entities in JSON Schema. We implement APIs based on these schemas.  ## Overview  ### URI  Following REST API conventions are followed for Resource URIs: - Operations for an entity are available through the Resource URI as a collection `.../api/<version>/entities`.  - Plural of the entity name is used as the collection name - example `.../api/v1/users`. - Trailing forward slash is not used in the endpoint URI. Example use `.../api/v1/databases` instead of `.../api/v1/databases/`. - Resource URI for an entity instance by the entity id is `.../api/v1/entities/{id}`.  - Resource URI for an entity instance by name is `.../api/v1/entities/name/{name}`.  ### Resource Representation  - The REST API calls return a response with JSON `Content-Type` and `Content-Length` that includes the length of the response. - All responses include the Resource ID field even though the id was provided in the request to simplify the consumption    of the response at the client. - Entity names and field names use `camelCase` per Javascript naming convention. - All resources include an attribute `href` with Resource URI. All relationship fields of an entity will also    include `href` links to the related resource for easy access. - Unknown fields sent by the client in API requests are not ignored to ensure the data sent by the client is not dropped    at the server without the user being aware of it.  ## API Organization  You can find the swagger documentation [here](/swagger.html). In a nutshell:  **Data Asset APIs** - support operations related to data asset entities. - `.../api/v1/databases` - `...api/v1/tables` - `.../api/v1/metrics` - `.../api/v1/dashboards` - `.../api/v1/reports` - `.../api/v1/pipelines` - `.../api/v1/topics`  **Service APIs** - support operations related to services from which metadata is collected: - `.../api/v1/services` is the collection of all service resources. - `.../api/v1/services/databaseService` - APIs related to database services. This includes Transactional databases - MySQL, Postgres, MSSQL, Oracle, and Data Warehouses - Apache Hive BigQuery, Redshift, and Snowflake. - `.../api/v1/services/dashboardService` - APIs related to Dashboard Services. This includes Looker, Superset, and Tableau. - `.../api/v1/services/messagingService` - APIs related to Messaging Services. This includes Apache Kafka, Redpanda, - Kinesis, and others.  **Teams & Users APIs** - `.../api/v1/teams` - APIs related to team entities - `.../api/v1/users` - APIs related to user entities  **Search & Suggest APIs** - support search and suggest APIs: - `.../api/v1/search` - collection for search and suggest APIs - `.../api/v1/search/query` - search entities using query text - `.../api/v1/search/suggest` - get suggested entities used for auto-completion  **Other APIs** - `.../api/v1/tags` for APIs related to Classification and Tag entities - `../api/v1/feeds` for APIs related to Threads and Posts entities - `.../api/v1/usage` for reporting usage information of entities
 *
 * The version of the OpenAPI document: 1.2.2
 * Contact: openmetadata-dev@googlegroups.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.openmetadata.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.openmetadata.client.model.ElasticsSearch;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * OpenMetadataConnection
 */
@JsonPropertyOrder({
  OpenMetadataConnection.JSON_PROPERTY_API_VERSION,
  OpenMetadataConnection.JSON_PROPERTY_AUTH_PROVIDER,
  OpenMetadataConnection.JSON_PROPERTY_CLUSTER_NAME,
  OpenMetadataConnection.JSON_PROPERTY_ELASTICS_SEARCH,
  OpenMetadataConnection.JSON_PROPERTY_ENABLE_VERSION_VALIDATION,
  OpenMetadataConnection.JSON_PROPERTY_EXTRA_HEADERS,
  OpenMetadataConnection.JSON_PROPERTY_FORCE_ENTITY_OVERWRITING,
  OpenMetadataConnection.JSON_PROPERTY_HOST_PORT,
  OpenMetadataConnection.JSON_PROPERTY_INCLUDE_DASHBOARDS,
  OpenMetadataConnection.JSON_PROPERTY_INCLUDE_DATABASE_SERVICES,
  OpenMetadataConnection.JSON_PROPERTY_INCLUDE_GLOSSARY_TERMS,
  OpenMetadataConnection.JSON_PROPERTY_INCLUDE_MESSAGING_SERVICES,
  OpenMetadataConnection.JSON_PROPERTY_INCLUDE_ML_MODELS,
  OpenMetadataConnection.JSON_PROPERTY_INCLUDE_PIPELINE_SERVICES,
  OpenMetadataConnection.JSON_PROPERTY_INCLUDE_PIPELINES,
  OpenMetadataConnection.JSON_PROPERTY_INCLUDE_POLICY,
  OpenMetadataConnection.JSON_PROPERTY_INCLUDE_TABLES,
  OpenMetadataConnection.JSON_PROPERTY_INCLUDE_TAGS,
  OpenMetadataConnection.JSON_PROPERTY_INCLUDE_TEAMS,
  OpenMetadataConnection.JSON_PROPERTY_INCLUDE_TOPICS,
  OpenMetadataConnection.JSON_PROPERTY_INCLUDE_USERS,
  OpenMetadataConnection.JSON_PROPERTY_LIMIT_RECORDS,
  OpenMetadataConnection.JSON_PROPERTY_SECRETS_MANAGER_LOADER,
  OpenMetadataConnection.JSON_PROPERTY_SECRETS_MANAGER_PROVIDER,
  OpenMetadataConnection.JSON_PROPERTY_SECURITY_CONFIG,
  OpenMetadataConnection.JSON_PROPERTY_SSL_CONFIG,
  OpenMetadataConnection.JSON_PROPERTY_STORE_SERVICE_CONNECTION,
  OpenMetadataConnection.JSON_PROPERTY_SUPPORTS_DATA_INSIGHT_EXTRACTION,
  OpenMetadataConnection.JSON_PROPERTY_SUPPORTS_ELASTIC_SEARCH_REINDEXING_EXTRACTION,
  OpenMetadataConnection.JSON_PROPERTY_TYPE,
  OpenMetadataConnection.JSON_PROPERTY_VERIFY_S_S_L
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-20T11:35:38.398944261Z[Etc/UTC]")
public class OpenMetadataConnection {
  public static final String JSON_PROPERTY_API_VERSION = "apiVersion";
  private String apiVersion;

  /**
   * Gets or Sets authProvider
   */
  public enum AuthProviderEnum {
    NO_AUTH("no-auth"),
    
    BASIC("basic"),
    
    AZURE("azure"),
    
    GOOGLE("google"),
    
    OKTA("okta"),
    
    AUTH0("auth0"),
    
    AWS_COGNITO("aws-cognito"),
    
    CUSTOM_OIDC("custom-oidc"),
    
    LDAP("ldap"),
    
    SAML("saml"),
    
    OPENMETADATA("openmetadata");

    private String value;

    AuthProviderEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static AuthProviderEnum fromValue(String value) {
      for (AuthProviderEnum b : AuthProviderEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_AUTH_PROVIDER = "authProvider";
  private AuthProviderEnum authProvider;

  public static final String JSON_PROPERTY_CLUSTER_NAME = "clusterName";
  private String clusterName;

  public static final String JSON_PROPERTY_ELASTICS_SEARCH = "elasticsSearch";
  private ElasticsSearch elasticsSearch;

  public static final String JSON_PROPERTY_ENABLE_VERSION_VALIDATION = "enableVersionValidation";
  private Boolean enableVersionValidation;

  public static final String JSON_PROPERTY_EXTRA_HEADERS = "extraHeaders";
  private Object extraHeaders;

  public static final String JSON_PROPERTY_FORCE_ENTITY_OVERWRITING = "forceEntityOverwriting";
  private Boolean forceEntityOverwriting;

  public static final String JSON_PROPERTY_HOST_PORT = "hostPort";
  private String hostPort;

  public static final String JSON_PROPERTY_INCLUDE_DASHBOARDS = "includeDashboards";
  private Boolean includeDashboards;

  public static final String JSON_PROPERTY_INCLUDE_DATABASE_SERVICES = "includeDatabaseServices";
  private Boolean includeDatabaseServices;

  public static final String JSON_PROPERTY_INCLUDE_GLOSSARY_TERMS = "includeGlossaryTerms";
  private Boolean includeGlossaryTerms;

  public static final String JSON_PROPERTY_INCLUDE_MESSAGING_SERVICES = "includeMessagingServices";
  private Boolean includeMessagingServices;

  public static final String JSON_PROPERTY_INCLUDE_ML_MODELS = "includeMlModels";
  private Boolean includeMlModels;

  public static final String JSON_PROPERTY_INCLUDE_PIPELINE_SERVICES = "includePipelineServices";
  private Boolean includePipelineServices;

  public static final String JSON_PROPERTY_INCLUDE_PIPELINES = "includePipelines";
  private Boolean includePipelines;

  public static final String JSON_PROPERTY_INCLUDE_POLICY = "includePolicy";
  private Boolean includePolicy;

  public static final String JSON_PROPERTY_INCLUDE_TABLES = "includeTables";
  private Boolean includeTables;

  public static final String JSON_PROPERTY_INCLUDE_TAGS = "includeTags";
  private Boolean includeTags;

  public static final String JSON_PROPERTY_INCLUDE_TEAMS = "includeTeams";
  private Boolean includeTeams;

  public static final String JSON_PROPERTY_INCLUDE_TOPICS = "includeTopics";
  private Boolean includeTopics;

  public static final String JSON_PROPERTY_INCLUDE_USERS = "includeUsers";
  private Boolean includeUsers;

  public static final String JSON_PROPERTY_LIMIT_RECORDS = "limitRecords";
  private Integer limitRecords;

  /**
   * Gets or Sets secretsManagerLoader
   */
  public enum SecretsManagerLoaderEnum {
    NOOP("noop"),
    
    AIRFLOW("airflow"),
    
    ENV("env");

    private String value;

    SecretsManagerLoaderEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static SecretsManagerLoaderEnum fromValue(String value) {
      for (SecretsManagerLoaderEnum b : SecretsManagerLoaderEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_SECRETS_MANAGER_LOADER = "secretsManagerLoader";
  private SecretsManagerLoaderEnum secretsManagerLoader;

  /**
   * Gets or Sets secretsManagerProvider
   */
  public enum SecretsManagerProviderEnum {
    NOOP("noop"),
    
    MANAGED_AWS("managed-aws"),
    
    AWS("aws"),
    
    MANAGED_AWS_SSM("managed-aws-ssm"),
    
    AWS_SSM("aws-ssm"),
    
    IN_MEMORY("in-memory");

    private String value;

    SecretsManagerProviderEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static SecretsManagerProviderEnum fromValue(String value) {
      for (SecretsManagerProviderEnum b : SecretsManagerProviderEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_SECRETS_MANAGER_PROVIDER = "secretsManagerProvider";
  private SecretsManagerProviderEnum secretsManagerProvider;

  public static final String JSON_PROPERTY_SECURITY_CONFIG = "securityConfig";
  private Object securityConfig;

  public static final String JSON_PROPERTY_SSL_CONFIG = "sslConfig";
  private Object sslConfig;

  public static final String JSON_PROPERTY_STORE_SERVICE_CONNECTION = "storeServiceConnection";
  private Boolean storeServiceConnection;

  public static final String JSON_PROPERTY_SUPPORTS_DATA_INSIGHT_EXTRACTION = "supportsDataInsightExtraction";
  private Boolean supportsDataInsightExtraction;

  public static final String JSON_PROPERTY_SUPPORTS_ELASTIC_SEARCH_REINDEXING_EXTRACTION = "supportsElasticSearchReindexingExtraction";
  private Boolean supportsElasticSearchReindexingExtraction;

  /**
   * Gets or Sets type
   */
  public enum TypeEnum {
    OPENMETADATA("OpenMetadata");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  /**
   * Gets or Sets verifySSL
   */
  public enum VerifySSLEnum {
    NO_SSL("no-ssl"),
    
    IGNORE("ignore"),
    
    VALIDATE("validate");

    private String value;

    VerifySSLEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static VerifySSLEnum fromValue(String value) {
      for (VerifySSLEnum b : VerifySSLEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_VERIFY_S_S_L = "verifySSL";
  private VerifySSLEnum verifySSL;

  public OpenMetadataConnection() { 
  }

  public OpenMetadataConnection apiVersion(String apiVersion) {
    
    this.apiVersion = apiVersion;
    return this;
  }

   /**
   * Get apiVersion
   * @return apiVersion
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_API_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getApiVersion() {
    return apiVersion;
  }


  @JsonProperty(JSON_PROPERTY_API_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setApiVersion(String apiVersion) {
    this.apiVersion = apiVersion;
  }


  public OpenMetadataConnection authProvider(AuthProviderEnum authProvider) {
    
    this.authProvider = authProvider;
    return this;
  }

   /**
   * Get authProvider
   * @return authProvider
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_AUTH_PROVIDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AuthProviderEnum getAuthProvider() {
    return authProvider;
  }


  @JsonProperty(JSON_PROPERTY_AUTH_PROVIDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAuthProvider(AuthProviderEnum authProvider) {
    this.authProvider = authProvider;
  }


  public OpenMetadataConnection clusterName(String clusterName) {
    
    this.clusterName = clusterName;
    return this;
  }

   /**
   * Get clusterName
   * @return clusterName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CLUSTER_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getClusterName() {
    return clusterName;
  }


  @JsonProperty(JSON_PROPERTY_CLUSTER_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setClusterName(String clusterName) {
    this.clusterName = clusterName;
  }


  public OpenMetadataConnection elasticsSearch(ElasticsSearch elasticsSearch) {
    
    this.elasticsSearch = elasticsSearch;
    return this;
  }

   /**
   * Get elasticsSearch
   * @return elasticsSearch
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ELASTICS_SEARCH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ElasticsSearch getElasticsSearch() {
    return elasticsSearch;
  }


  @JsonProperty(JSON_PROPERTY_ELASTICS_SEARCH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setElasticsSearch(ElasticsSearch elasticsSearch) {
    this.elasticsSearch = elasticsSearch;
  }


  public OpenMetadataConnection enableVersionValidation(Boolean enableVersionValidation) {
    
    this.enableVersionValidation = enableVersionValidation;
    return this;
  }

   /**
   * Get enableVersionValidation
   * @return enableVersionValidation
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ENABLE_VERSION_VALIDATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getEnableVersionValidation() {
    return enableVersionValidation;
  }


  @JsonProperty(JSON_PROPERTY_ENABLE_VERSION_VALIDATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEnableVersionValidation(Boolean enableVersionValidation) {
    this.enableVersionValidation = enableVersionValidation;
  }


  public OpenMetadataConnection extraHeaders(Object extraHeaders) {
    
    this.extraHeaders = extraHeaders;
    return this;
  }

   /**
   * Get extraHeaders
   * @return extraHeaders
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_EXTRA_HEADERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getExtraHeaders() {
    return extraHeaders;
  }


  @JsonProperty(JSON_PROPERTY_EXTRA_HEADERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExtraHeaders(Object extraHeaders) {
    this.extraHeaders = extraHeaders;
  }


  public OpenMetadataConnection forceEntityOverwriting(Boolean forceEntityOverwriting) {
    
    this.forceEntityOverwriting = forceEntityOverwriting;
    return this;
  }

   /**
   * Get forceEntityOverwriting
   * @return forceEntityOverwriting
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_FORCE_ENTITY_OVERWRITING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getForceEntityOverwriting() {
    return forceEntityOverwriting;
  }


  @JsonProperty(JSON_PROPERTY_FORCE_ENTITY_OVERWRITING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setForceEntityOverwriting(Boolean forceEntityOverwriting) {
    this.forceEntityOverwriting = forceEntityOverwriting;
  }


  public OpenMetadataConnection hostPort(String hostPort) {
    
    this.hostPort = hostPort;
    return this;
  }

   /**
   * Get hostPort
   * @return hostPort
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_HOST_PORT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getHostPort() {
    return hostPort;
  }


  @JsonProperty(JSON_PROPERTY_HOST_PORT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setHostPort(String hostPort) {
    this.hostPort = hostPort;
  }


  public OpenMetadataConnection includeDashboards(Boolean includeDashboards) {
    
    this.includeDashboards = includeDashboards;
    return this;
  }

   /**
   * Get includeDashboards
   * @return includeDashboards
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_INCLUDE_DASHBOARDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeDashboards() {
    return includeDashboards;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_DASHBOARDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeDashboards(Boolean includeDashboards) {
    this.includeDashboards = includeDashboards;
  }


  public OpenMetadataConnection includeDatabaseServices(Boolean includeDatabaseServices) {
    
    this.includeDatabaseServices = includeDatabaseServices;
    return this;
  }

   /**
   * Get includeDatabaseServices
   * @return includeDatabaseServices
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_INCLUDE_DATABASE_SERVICES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeDatabaseServices() {
    return includeDatabaseServices;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_DATABASE_SERVICES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeDatabaseServices(Boolean includeDatabaseServices) {
    this.includeDatabaseServices = includeDatabaseServices;
  }


  public OpenMetadataConnection includeGlossaryTerms(Boolean includeGlossaryTerms) {
    
    this.includeGlossaryTerms = includeGlossaryTerms;
    return this;
  }

   /**
   * Get includeGlossaryTerms
   * @return includeGlossaryTerms
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_INCLUDE_GLOSSARY_TERMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeGlossaryTerms() {
    return includeGlossaryTerms;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_GLOSSARY_TERMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeGlossaryTerms(Boolean includeGlossaryTerms) {
    this.includeGlossaryTerms = includeGlossaryTerms;
  }


  public OpenMetadataConnection includeMessagingServices(Boolean includeMessagingServices) {
    
    this.includeMessagingServices = includeMessagingServices;
    return this;
  }

   /**
   * Get includeMessagingServices
   * @return includeMessagingServices
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_INCLUDE_MESSAGING_SERVICES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeMessagingServices() {
    return includeMessagingServices;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_MESSAGING_SERVICES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeMessagingServices(Boolean includeMessagingServices) {
    this.includeMessagingServices = includeMessagingServices;
  }


  public OpenMetadataConnection includeMlModels(Boolean includeMlModels) {
    
    this.includeMlModels = includeMlModels;
    return this;
  }

   /**
   * Get includeMlModels
   * @return includeMlModels
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_INCLUDE_ML_MODELS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeMlModels() {
    return includeMlModels;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_ML_MODELS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeMlModels(Boolean includeMlModels) {
    this.includeMlModels = includeMlModels;
  }


  public OpenMetadataConnection includePipelineServices(Boolean includePipelineServices) {
    
    this.includePipelineServices = includePipelineServices;
    return this;
  }

   /**
   * Get includePipelineServices
   * @return includePipelineServices
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_INCLUDE_PIPELINE_SERVICES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludePipelineServices() {
    return includePipelineServices;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_PIPELINE_SERVICES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludePipelineServices(Boolean includePipelineServices) {
    this.includePipelineServices = includePipelineServices;
  }


  public OpenMetadataConnection includePipelines(Boolean includePipelines) {
    
    this.includePipelines = includePipelines;
    return this;
  }

   /**
   * Get includePipelines
   * @return includePipelines
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_INCLUDE_PIPELINES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludePipelines() {
    return includePipelines;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_PIPELINES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludePipelines(Boolean includePipelines) {
    this.includePipelines = includePipelines;
  }


  public OpenMetadataConnection includePolicy(Boolean includePolicy) {
    
    this.includePolicy = includePolicy;
    return this;
  }

   /**
   * Get includePolicy
   * @return includePolicy
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_INCLUDE_POLICY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludePolicy() {
    return includePolicy;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_POLICY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludePolicy(Boolean includePolicy) {
    this.includePolicy = includePolicy;
  }


  public OpenMetadataConnection includeTables(Boolean includeTables) {
    
    this.includeTables = includeTables;
    return this;
  }

   /**
   * Get includeTables
   * @return includeTables
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_INCLUDE_TABLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeTables() {
    return includeTables;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_TABLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeTables(Boolean includeTables) {
    this.includeTables = includeTables;
  }


  public OpenMetadataConnection includeTags(Boolean includeTags) {
    
    this.includeTags = includeTags;
    return this;
  }

   /**
   * Get includeTags
   * @return includeTags
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_INCLUDE_TAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeTags() {
    return includeTags;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_TAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeTags(Boolean includeTags) {
    this.includeTags = includeTags;
  }


  public OpenMetadataConnection includeTeams(Boolean includeTeams) {
    
    this.includeTeams = includeTeams;
    return this;
  }

   /**
   * Get includeTeams
   * @return includeTeams
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_INCLUDE_TEAMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeTeams() {
    return includeTeams;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_TEAMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeTeams(Boolean includeTeams) {
    this.includeTeams = includeTeams;
  }


  public OpenMetadataConnection includeTopics(Boolean includeTopics) {
    
    this.includeTopics = includeTopics;
    return this;
  }

   /**
   * Get includeTopics
   * @return includeTopics
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_INCLUDE_TOPICS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeTopics() {
    return includeTopics;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_TOPICS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeTopics(Boolean includeTopics) {
    this.includeTopics = includeTopics;
  }


  public OpenMetadataConnection includeUsers(Boolean includeUsers) {
    
    this.includeUsers = includeUsers;
    return this;
  }

   /**
   * Get includeUsers
   * @return includeUsers
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_INCLUDE_USERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeUsers() {
    return includeUsers;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_USERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeUsers(Boolean includeUsers) {
    this.includeUsers = includeUsers;
  }


  public OpenMetadataConnection limitRecords(Integer limitRecords) {
    
    this.limitRecords = limitRecords;
    return this;
  }

   /**
   * Get limitRecords
   * @return limitRecords
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_LIMIT_RECORDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getLimitRecords() {
    return limitRecords;
  }


  @JsonProperty(JSON_PROPERTY_LIMIT_RECORDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLimitRecords(Integer limitRecords) {
    this.limitRecords = limitRecords;
  }


  public OpenMetadataConnection secretsManagerLoader(SecretsManagerLoaderEnum secretsManagerLoader) {
    
    this.secretsManagerLoader = secretsManagerLoader;
    return this;
  }

   /**
   * Get secretsManagerLoader
   * @return secretsManagerLoader
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SECRETS_MANAGER_LOADER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SecretsManagerLoaderEnum getSecretsManagerLoader() {
    return secretsManagerLoader;
  }


  @JsonProperty(JSON_PROPERTY_SECRETS_MANAGER_LOADER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSecretsManagerLoader(SecretsManagerLoaderEnum secretsManagerLoader) {
    this.secretsManagerLoader = secretsManagerLoader;
  }


  public OpenMetadataConnection secretsManagerProvider(SecretsManagerProviderEnum secretsManagerProvider) {
    
    this.secretsManagerProvider = secretsManagerProvider;
    return this;
  }

   /**
   * Get secretsManagerProvider
   * @return secretsManagerProvider
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SECRETS_MANAGER_PROVIDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SecretsManagerProviderEnum getSecretsManagerProvider() {
    return secretsManagerProvider;
  }


  @JsonProperty(JSON_PROPERTY_SECRETS_MANAGER_PROVIDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSecretsManagerProvider(SecretsManagerProviderEnum secretsManagerProvider) {
    this.secretsManagerProvider = secretsManagerProvider;
  }


  public OpenMetadataConnection securityConfig(Object securityConfig) {
    
    this.securityConfig = securityConfig;
    return this;
  }

   /**
   * Get securityConfig
   * @return securityConfig
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SECURITY_CONFIG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getSecurityConfig() {
    return securityConfig;
  }


  @JsonProperty(JSON_PROPERTY_SECURITY_CONFIG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSecurityConfig(Object securityConfig) {
    this.securityConfig = securityConfig;
  }


  public OpenMetadataConnection sslConfig(Object sslConfig) {
    
    this.sslConfig = sslConfig;
    return this;
  }

   /**
   * Get sslConfig
   * @return sslConfig
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SSL_CONFIG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getSslConfig() {
    return sslConfig;
  }


  @JsonProperty(JSON_PROPERTY_SSL_CONFIG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSslConfig(Object sslConfig) {
    this.sslConfig = sslConfig;
  }


  public OpenMetadataConnection storeServiceConnection(Boolean storeServiceConnection) {
    
    this.storeServiceConnection = storeServiceConnection;
    return this;
  }

   /**
   * Get storeServiceConnection
   * @return storeServiceConnection
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_STORE_SERVICE_CONNECTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getStoreServiceConnection() {
    return storeServiceConnection;
  }


  @JsonProperty(JSON_PROPERTY_STORE_SERVICE_CONNECTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStoreServiceConnection(Boolean storeServiceConnection) {
    this.storeServiceConnection = storeServiceConnection;
  }


  public OpenMetadataConnection supportsDataInsightExtraction(Boolean supportsDataInsightExtraction) {
    
    this.supportsDataInsightExtraction = supportsDataInsightExtraction;
    return this;
  }

   /**
   * Get supportsDataInsightExtraction
   * @return supportsDataInsightExtraction
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SUPPORTS_DATA_INSIGHT_EXTRACTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSupportsDataInsightExtraction() {
    return supportsDataInsightExtraction;
  }


  @JsonProperty(JSON_PROPERTY_SUPPORTS_DATA_INSIGHT_EXTRACTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSupportsDataInsightExtraction(Boolean supportsDataInsightExtraction) {
    this.supportsDataInsightExtraction = supportsDataInsightExtraction;
  }


  public OpenMetadataConnection supportsElasticSearchReindexingExtraction(Boolean supportsElasticSearchReindexingExtraction) {
    
    this.supportsElasticSearchReindexingExtraction = supportsElasticSearchReindexingExtraction;
    return this;
  }

   /**
   * Get supportsElasticSearchReindexingExtraction
   * @return supportsElasticSearchReindexingExtraction
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SUPPORTS_ELASTIC_SEARCH_REINDEXING_EXTRACTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSupportsElasticSearchReindexingExtraction() {
    return supportsElasticSearchReindexingExtraction;
  }


  @JsonProperty(JSON_PROPERTY_SUPPORTS_ELASTIC_SEARCH_REINDEXING_EXTRACTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSupportsElasticSearchReindexingExtraction(Boolean supportsElasticSearchReindexingExtraction) {
    this.supportsElasticSearchReindexingExtraction = supportsElasticSearchReindexingExtraction;
  }


  public OpenMetadataConnection type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * Get type
   * @return type
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public OpenMetadataConnection verifySSL(VerifySSLEnum verifySSL) {
    
    this.verifySSL = verifySSL;
    return this;
  }

   /**
   * Get verifySSL
   * @return verifySSL
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_VERIFY_S_S_L)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public VerifySSLEnum getVerifySSL() {
    return verifySSL;
  }


  @JsonProperty(JSON_PROPERTY_VERIFY_S_S_L)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVerifySSL(VerifySSLEnum verifySSL) {
    this.verifySSL = verifySSL;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OpenMetadataConnection openMetadataConnection = (OpenMetadataConnection) o;
    return Objects.equals(this.apiVersion, openMetadataConnection.apiVersion) &&
        Objects.equals(this.authProvider, openMetadataConnection.authProvider) &&
        Objects.equals(this.clusterName, openMetadataConnection.clusterName) &&
        Objects.equals(this.elasticsSearch, openMetadataConnection.elasticsSearch) &&
        Objects.equals(this.enableVersionValidation, openMetadataConnection.enableVersionValidation) &&
        Objects.equals(this.extraHeaders, openMetadataConnection.extraHeaders) &&
        Objects.equals(this.forceEntityOverwriting, openMetadataConnection.forceEntityOverwriting) &&
        Objects.equals(this.hostPort, openMetadataConnection.hostPort) &&
        Objects.equals(this.includeDashboards, openMetadataConnection.includeDashboards) &&
        Objects.equals(this.includeDatabaseServices, openMetadataConnection.includeDatabaseServices) &&
        Objects.equals(this.includeGlossaryTerms, openMetadataConnection.includeGlossaryTerms) &&
        Objects.equals(this.includeMessagingServices, openMetadataConnection.includeMessagingServices) &&
        Objects.equals(this.includeMlModels, openMetadataConnection.includeMlModels) &&
        Objects.equals(this.includePipelineServices, openMetadataConnection.includePipelineServices) &&
        Objects.equals(this.includePipelines, openMetadataConnection.includePipelines) &&
        Objects.equals(this.includePolicy, openMetadataConnection.includePolicy) &&
        Objects.equals(this.includeTables, openMetadataConnection.includeTables) &&
        Objects.equals(this.includeTags, openMetadataConnection.includeTags) &&
        Objects.equals(this.includeTeams, openMetadataConnection.includeTeams) &&
        Objects.equals(this.includeTopics, openMetadataConnection.includeTopics) &&
        Objects.equals(this.includeUsers, openMetadataConnection.includeUsers) &&
        Objects.equals(this.limitRecords, openMetadataConnection.limitRecords) &&
        Objects.equals(this.secretsManagerLoader, openMetadataConnection.secretsManagerLoader) &&
        Objects.equals(this.secretsManagerProvider, openMetadataConnection.secretsManagerProvider) &&
        Objects.equals(this.securityConfig, openMetadataConnection.securityConfig) &&
        Objects.equals(this.sslConfig, openMetadataConnection.sslConfig) &&
        Objects.equals(this.storeServiceConnection, openMetadataConnection.storeServiceConnection) &&
        Objects.equals(this.supportsDataInsightExtraction, openMetadataConnection.supportsDataInsightExtraction) &&
        Objects.equals(this.supportsElasticSearchReindexingExtraction, openMetadataConnection.supportsElasticSearchReindexingExtraction) &&
        Objects.equals(this.type, openMetadataConnection.type) &&
        Objects.equals(this.verifySSL, openMetadataConnection.verifySSL);
  }

  @Override
  public int hashCode() {
    return Objects.hash(apiVersion, authProvider, clusterName, elasticsSearch, enableVersionValidation, extraHeaders, forceEntityOverwriting, hostPort, includeDashboards, includeDatabaseServices, includeGlossaryTerms, includeMessagingServices, includeMlModels, includePipelineServices, includePipelines, includePolicy, includeTables, includeTags, includeTeams, includeTopics, includeUsers, limitRecords, secretsManagerLoader, secretsManagerProvider, securityConfig, sslConfig, storeServiceConnection, supportsDataInsightExtraction, supportsElasticSearchReindexingExtraction, type, verifySSL);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OpenMetadataConnection {\n");
    sb.append("    apiVersion: ").append(toIndentedString(apiVersion)).append("\n");
    sb.append("    authProvider: ").append(toIndentedString(authProvider)).append("\n");
    sb.append("    clusterName: ").append(toIndentedString(clusterName)).append("\n");
    sb.append("    elasticsSearch: ").append(toIndentedString(elasticsSearch)).append("\n");
    sb.append("    enableVersionValidation: ").append(toIndentedString(enableVersionValidation)).append("\n");
    sb.append("    extraHeaders: ").append(toIndentedString(extraHeaders)).append("\n");
    sb.append("    forceEntityOverwriting: ").append(toIndentedString(forceEntityOverwriting)).append("\n");
    sb.append("    hostPort: ").append(toIndentedString(hostPort)).append("\n");
    sb.append("    includeDashboards: ").append(toIndentedString(includeDashboards)).append("\n");
    sb.append("    includeDatabaseServices: ").append(toIndentedString(includeDatabaseServices)).append("\n");
    sb.append("    includeGlossaryTerms: ").append(toIndentedString(includeGlossaryTerms)).append("\n");
    sb.append("    includeMessagingServices: ").append(toIndentedString(includeMessagingServices)).append("\n");
    sb.append("    includeMlModels: ").append(toIndentedString(includeMlModels)).append("\n");
    sb.append("    includePipelineServices: ").append(toIndentedString(includePipelineServices)).append("\n");
    sb.append("    includePipelines: ").append(toIndentedString(includePipelines)).append("\n");
    sb.append("    includePolicy: ").append(toIndentedString(includePolicy)).append("\n");
    sb.append("    includeTables: ").append(toIndentedString(includeTables)).append("\n");
    sb.append("    includeTags: ").append(toIndentedString(includeTags)).append("\n");
    sb.append("    includeTeams: ").append(toIndentedString(includeTeams)).append("\n");
    sb.append("    includeTopics: ").append(toIndentedString(includeTopics)).append("\n");
    sb.append("    includeUsers: ").append(toIndentedString(includeUsers)).append("\n");
    sb.append("    limitRecords: ").append(toIndentedString(limitRecords)).append("\n");
    sb.append("    secretsManagerLoader: ").append(toIndentedString(secretsManagerLoader)).append("\n");
    sb.append("    secretsManagerProvider: ").append(toIndentedString(secretsManagerProvider)).append("\n");
    sb.append("    securityConfig: ").append(toIndentedString(securityConfig)).append("\n");
    sb.append("    sslConfig: ").append(toIndentedString(sslConfig)).append("\n");
    sb.append("    storeServiceConnection: ").append(toIndentedString(storeServiceConnection)).append("\n");
    sb.append("    supportsDataInsightExtraction: ").append(toIndentedString(supportsDataInsightExtraction)).append("\n");
    sb.append("    supportsElasticSearchReindexingExtraction: ").append(toIndentedString(supportsElasticSearchReindexingExtraction)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    verifySSL: ").append(toIndentedString(verifySSL)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

