/*
 * OpenMetadata Apis
 * --- title: APIs slug: /main-concepts/metadata-standard/apis ---  # APIs  OpenMetadata supports REST APIs for getting data and in and out of the metadata service. APIs are built using general best practices of REST API design. We take a schema-first approach by defining Types and Entities in JSON Schema. We implement APIs based on these schemas.  ## Overview  ### URI  Following REST API conventions are followed for Resource URIs: - Operations for an entity are available through the Resource URI as a collection `.../api/<version>/entities`.  - Plural of the entity name is used as the collection name - example `.../api/v1/users`. - Trailing forward slash is not used in the endpoint URI. Example use `.../api/v1/databases` instead of `.../api/v1/databases/`. - Resource URI for an entity instance by the entity id is `.../api/v1/entities/{id}`.  - Resource URI for an entity instance by name is `.../api/v1/entities/name/{name}`.  ### Resource Representation  - The REST API calls return a response with JSON `Content-Type` and `Content-Length` that includes the length of the response. - All responses include the Resource ID field even though the id was provided in the request to simplify the consumption    of the response at the client. - Entity names and field names use `camelCase` per Javascript naming convention. - All resources include an attribute `href` with Resource URI. All relationship fields of an entity will also    include `href` links to the related resource for easy access. - Unknown fields sent by the client in API requests are not ignored to ensure the data sent by the client is not dropped    at the server without the user being aware of it.  ## API Organization  You can find the swagger documentation [here](/swagger.html). In a nutshell:  **Data Asset APIs** - support operations related to data asset entities. - `.../api/v1/databases` - `...api/v1/tables` - `.../api/v1/metrics` - `.../api/v1/dashboards` - `.../api/v1/reports` - `.../api/v1/pipelines` - `.../api/v1/topics`  **Service APIs** - support operations related to services from which metadata is collected: - `.../api/v1/services` is the collection of all service resources. - `.../api/v1/services/databaseService` - APIs related to database services. This includes Transactional databases - MySQL, Postgres, MSSQL, Oracle, and Data Warehouses - Apache Hive BigQuery, Redshift, and Snowflake. - `.../api/v1/services/dashboardService` - APIs related to Dashboard Services. This includes Looker, Superset, and Tableau. - `.../api/v1/services/messagingService` - APIs related to Messaging Services. This includes Apache Kafka, Redpanda, - Kinesis, and others.  **Teams & Users APIs** - `.../api/v1/teams` - APIs related to team entities - `.../api/v1/users` - APIs related to user entities  **Search & Suggest APIs** - support search and suggest APIs: - `.../api/v1/search` - collection for search and suggest APIs - `.../api/v1/search/query` - search entities using query text - `.../api/v1/search/suggest` - get suggested entities used for auto-completion  **Other APIs** - `.../api/v1/tags` for APIs related to Classification and Tag entities - `../api/v1/feeds` for APIs related to Threads and Posts entities - `.../api/v1/usage` for reporting usage information of entities
 *
 * The version of the OpenAPI document: 1.2.2
 * Contact: openmetadata-dev@googlegroups.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.openmetadata.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * PartitionProfilerConfig
 */
@JsonPropertyOrder({
  PartitionProfilerConfig.JSON_PROPERTY_ENABLE_PARTITIONING,
  PartitionProfilerConfig.JSON_PROPERTY_PARTITION_COLUMN_NAME,
  PartitionProfilerConfig.JSON_PROPERTY_PARTITION_INTEGER_RANGE_END,
  PartitionProfilerConfig.JSON_PROPERTY_PARTITION_INTEGER_RANGE_START,
  PartitionProfilerConfig.JSON_PROPERTY_PARTITION_INTERVAL,
  PartitionProfilerConfig.JSON_PROPERTY_PARTITION_INTERVAL_TYPE,
  PartitionProfilerConfig.JSON_PROPERTY_PARTITION_INTERVAL_UNIT,
  PartitionProfilerConfig.JSON_PROPERTY_PARTITION_VALUES
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-20T11:35:38.398944261Z[Etc/UTC]")
public class PartitionProfilerConfig {
  public static final String JSON_PROPERTY_ENABLE_PARTITIONING = "enablePartitioning";
  private Boolean enablePartitioning;

  public static final String JSON_PROPERTY_PARTITION_COLUMN_NAME = "partitionColumnName";
  private String partitionColumnName;

  public static final String JSON_PROPERTY_PARTITION_INTEGER_RANGE_END = "partitionIntegerRangeEnd";
  private Integer partitionIntegerRangeEnd;

  public static final String JSON_PROPERTY_PARTITION_INTEGER_RANGE_START = "partitionIntegerRangeStart";
  private Integer partitionIntegerRangeStart;

  public static final String JSON_PROPERTY_PARTITION_INTERVAL = "partitionInterval";
  private Integer partitionInterval;

  /**
   * Gets or Sets partitionIntervalType
   */
  public enum PartitionIntervalTypeEnum {
    TIME_UNIT("TIME-UNIT"),
    
    INTEGER_RANGE("INTEGER-RANGE"),
    
    INGESTION_TIME("INGESTION-TIME"),
    
    COLUMN_VALUE("COLUMN-VALUE");

    private String value;

    PartitionIntervalTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PartitionIntervalTypeEnum fromValue(String value) {
      for (PartitionIntervalTypeEnum b : PartitionIntervalTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PARTITION_INTERVAL_TYPE = "partitionIntervalType";
  private PartitionIntervalTypeEnum partitionIntervalType;

  /**
   * Gets or Sets partitionIntervalUnit
   */
  public enum PartitionIntervalUnitEnum {
    YEAR("YEAR"),
    
    MONTH("MONTH"),
    
    DAY("DAY"),
    
    HOUR("HOUR");

    private String value;

    PartitionIntervalUnitEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PartitionIntervalUnitEnum fromValue(String value) {
      for (PartitionIntervalUnitEnum b : PartitionIntervalUnitEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PARTITION_INTERVAL_UNIT = "partitionIntervalUnit";
  private PartitionIntervalUnitEnum partitionIntervalUnit;

  public static final String JSON_PROPERTY_PARTITION_VALUES = "partitionValues";
  private List<Object> partitionValues = null;

  public PartitionProfilerConfig() { 
  }

  public PartitionProfilerConfig enablePartitioning(Boolean enablePartitioning) {
    
    this.enablePartitioning = enablePartitioning;
    return this;
  }

   /**
   * Get enablePartitioning
   * @return enablePartitioning
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ENABLE_PARTITIONING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getEnablePartitioning() {
    return enablePartitioning;
  }


  @JsonProperty(JSON_PROPERTY_ENABLE_PARTITIONING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEnablePartitioning(Boolean enablePartitioning) {
    this.enablePartitioning = enablePartitioning;
  }


  public PartitionProfilerConfig partitionColumnName(String partitionColumnName) {
    
    this.partitionColumnName = partitionColumnName;
    return this;
  }

   /**
   * Get partitionColumnName
   * @return partitionColumnName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PARTITION_COLUMN_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPartitionColumnName() {
    return partitionColumnName;
  }


  @JsonProperty(JSON_PROPERTY_PARTITION_COLUMN_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPartitionColumnName(String partitionColumnName) {
    this.partitionColumnName = partitionColumnName;
  }


  public PartitionProfilerConfig partitionIntegerRangeEnd(Integer partitionIntegerRangeEnd) {
    
    this.partitionIntegerRangeEnd = partitionIntegerRangeEnd;
    return this;
  }

   /**
   * Get partitionIntegerRangeEnd
   * @return partitionIntegerRangeEnd
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PARTITION_INTEGER_RANGE_END)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getPartitionIntegerRangeEnd() {
    return partitionIntegerRangeEnd;
  }


  @JsonProperty(JSON_PROPERTY_PARTITION_INTEGER_RANGE_END)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPartitionIntegerRangeEnd(Integer partitionIntegerRangeEnd) {
    this.partitionIntegerRangeEnd = partitionIntegerRangeEnd;
  }


  public PartitionProfilerConfig partitionIntegerRangeStart(Integer partitionIntegerRangeStart) {
    
    this.partitionIntegerRangeStart = partitionIntegerRangeStart;
    return this;
  }

   /**
   * Get partitionIntegerRangeStart
   * @return partitionIntegerRangeStart
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PARTITION_INTEGER_RANGE_START)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getPartitionIntegerRangeStart() {
    return partitionIntegerRangeStart;
  }


  @JsonProperty(JSON_PROPERTY_PARTITION_INTEGER_RANGE_START)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPartitionIntegerRangeStart(Integer partitionIntegerRangeStart) {
    this.partitionIntegerRangeStart = partitionIntegerRangeStart;
  }


  public PartitionProfilerConfig partitionInterval(Integer partitionInterval) {
    
    this.partitionInterval = partitionInterval;
    return this;
  }

   /**
   * Get partitionInterval
   * @return partitionInterval
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PARTITION_INTERVAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getPartitionInterval() {
    return partitionInterval;
  }


  @JsonProperty(JSON_PROPERTY_PARTITION_INTERVAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPartitionInterval(Integer partitionInterval) {
    this.partitionInterval = partitionInterval;
  }


  public PartitionProfilerConfig partitionIntervalType(PartitionIntervalTypeEnum partitionIntervalType) {
    
    this.partitionIntervalType = partitionIntervalType;
    return this;
  }

   /**
   * Get partitionIntervalType
   * @return partitionIntervalType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PARTITION_INTERVAL_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PartitionIntervalTypeEnum getPartitionIntervalType() {
    return partitionIntervalType;
  }


  @JsonProperty(JSON_PROPERTY_PARTITION_INTERVAL_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPartitionIntervalType(PartitionIntervalTypeEnum partitionIntervalType) {
    this.partitionIntervalType = partitionIntervalType;
  }


  public PartitionProfilerConfig partitionIntervalUnit(PartitionIntervalUnitEnum partitionIntervalUnit) {
    
    this.partitionIntervalUnit = partitionIntervalUnit;
    return this;
  }

   /**
   * Get partitionIntervalUnit
   * @return partitionIntervalUnit
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PARTITION_INTERVAL_UNIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PartitionIntervalUnitEnum getPartitionIntervalUnit() {
    return partitionIntervalUnit;
  }


  @JsonProperty(JSON_PROPERTY_PARTITION_INTERVAL_UNIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPartitionIntervalUnit(PartitionIntervalUnitEnum partitionIntervalUnit) {
    this.partitionIntervalUnit = partitionIntervalUnit;
  }


  public PartitionProfilerConfig partitionValues(List<Object> partitionValues) {
    
    this.partitionValues = partitionValues;
    return this;
  }

  public PartitionProfilerConfig addPartitionValuesItem(Object partitionValuesItem) {
    if (this.partitionValues == null) {
      this.partitionValues = new ArrayList<>();
    }
    this.partitionValues.add(partitionValuesItem);
    return this;
  }

   /**
   * Get partitionValues
   * @return partitionValues
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PARTITION_VALUES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Object> getPartitionValues() {
    return partitionValues;
  }


  @JsonProperty(JSON_PROPERTY_PARTITION_VALUES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPartitionValues(List<Object> partitionValues) {
    this.partitionValues = partitionValues;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PartitionProfilerConfig partitionProfilerConfig = (PartitionProfilerConfig) o;
    return Objects.equals(this.enablePartitioning, partitionProfilerConfig.enablePartitioning) &&
        Objects.equals(this.partitionColumnName, partitionProfilerConfig.partitionColumnName) &&
        Objects.equals(this.partitionIntegerRangeEnd, partitionProfilerConfig.partitionIntegerRangeEnd) &&
        Objects.equals(this.partitionIntegerRangeStart, partitionProfilerConfig.partitionIntegerRangeStart) &&
        Objects.equals(this.partitionInterval, partitionProfilerConfig.partitionInterval) &&
        Objects.equals(this.partitionIntervalType, partitionProfilerConfig.partitionIntervalType) &&
        Objects.equals(this.partitionIntervalUnit, partitionProfilerConfig.partitionIntervalUnit) &&
        Objects.equals(this.partitionValues, partitionProfilerConfig.partitionValues);
  }

  @Override
  public int hashCode() {
    return Objects.hash(enablePartitioning, partitionColumnName, partitionIntegerRangeEnd, partitionIntegerRangeStart, partitionInterval, partitionIntervalType, partitionIntervalUnit, partitionValues);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PartitionProfilerConfig {\n");
    sb.append("    enablePartitioning: ").append(toIndentedString(enablePartitioning)).append("\n");
    sb.append("    partitionColumnName: ").append(toIndentedString(partitionColumnName)).append("\n");
    sb.append("    partitionIntegerRangeEnd: ").append(toIndentedString(partitionIntegerRangeEnd)).append("\n");
    sb.append("    partitionIntegerRangeStart: ").append(toIndentedString(partitionIntegerRangeStart)).append("\n");
    sb.append("    partitionInterval: ").append(toIndentedString(partitionInterval)).append("\n");
    sb.append("    partitionIntervalType: ").append(toIndentedString(partitionIntervalType)).append("\n");
    sb.append("    partitionIntervalUnit: ").append(toIndentedString(partitionIntervalUnit)).append("\n");
    sb.append("    partitionValues: ").append(toIndentedString(partitionValues)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

